/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.window;

import com.businessobjects.visualization.common.exceptions.VisualizationRuntimeException;
import com.businessobjects.visualization.common.internal.HashCodeHelper;
import com.businessobjects.visualization.common.internal.IXMLDelegator;
import com.businessobjects.visualization.common.internal.SerializationHelper;
import com.businessobjects.visualization.dataexchange.data.generated.XMLDataRange;
import com.businessobjects.visualization.dataexchange.definition.DatasetDescriptor;
import com.businessobjects.visualization.dataexchange.definition.MeasureValues;
import com.businessobjects.visualization.dataexchange.definition.MeasureValuesGroup;
import java.util.Iterator;

public class MeasureRange
implements IXMLDelegator {
    public static final MeasureRange FULL_RANGE = new MeasureRange(-1, -1, null);
    private final int lower_;
    private final int upper_;
    private final DatasetDescriptor dataset_;
    private int upperIndexLimit_;

    public MeasureRange(int lowerIndex, int upperIndex, DatasetDescriptor dataset) {
        this.dataset_ = dataset;
        if (this.dataset_ != null) {
            Iterator iter = this.dataset_.getValueGroupIterator();
            while (iter.hasNext()) {
                MeasureValuesGroup mvg = (MeasureValuesGroup)iter.next();
                this.upperIndexLimit_ += mvg.getMeasureValuesList().length;
            }
        }
        if (lowerIndex > upperIndex || lowerIndex >= this.upperIndexLimit_ || upperIndex != -1 && upperIndex < 0 || upperIndex > this.upperIndexLimit_) {
            throw new VisualizationRuntimeException("VIZ_00073_ERR_INVALID_PARAMETERS__", new Object[]{new Integer(lowerIndex), new Integer(upperIndex), new Integer(this.upperIndexLimit_)});
        }
        this.lower_ = lowerIndex;
        this.upper_ = upperIndex;
    }

    public MeasureRange(XMLDataRange xmlDataRange, SerializationHelper sh, DatasetDescriptor dataset) {
        this(xmlDataRange.m_a_lower, xmlDataRange.m_a_upper, dataset);
    }

    public MeasureRange(MeasureRange mr) {
        this(mr.getLower(), mr.getUpper(), mr.getDataset());
    }

    public int getLower() {
        return this.lower_;
    }

    public int getUpper() {
        return this.upper_;
    }

    public DatasetDescriptor getDataset() {
        return this.dataset_;
    }

    public boolean isMeasureInRange(MeasureValues mv) {
        if (this.equals(FULL_RANGE)) {
            return true;
        }
        Iterator iter = this.dataset_.getValueGroupIterator();
        int index = 0;
        while (iter.hasNext()) {
            MeasureValuesGroup mvg = (MeasureValuesGroup)iter.next();
            Iterator iter2 = mvg.getMeasureValuesIterator();
            while (iter2.hasNext()) {
                if (mv.equals((MeasureValues)iter2.next()) && index >= this.lower_ && index <= this.upper_) {
                    return true;
                }
                ++index;
            }
        }
        return false;
    }

    public boolean hasNext() {
        return this.upper_ >= 0 && this.upper_ < this.upperIndexLimit_ - 1;
    }

    public boolean hasPrevious() {
        return this.lower_ > 0;
    }

    public MeasureRange next() {
        if (this.hasNext()) {
            return new MeasureRange(this.lower_ + 1, this.upper_ + 1, this.dataset_);
        }
        return this;
    }

    public MeasureRange previous() {
        if (this.hasPrevious()) {
            return new MeasureRange(this.lower_ - 1, this.upper_ - 1, this.dataset_);
        }
        return this;
    }

    public int getUpperIndexLimit() {
        return this.upperIndexLimit_;
    }

    public boolean equals(Object oThat) {
        if (this == oThat) {
            return true;
        }
        if (!(oThat instanceof MeasureRange)) {
            return false;
        }
        if (this.dataset_ == null) {
            return ((MeasureRange)oThat).dataset_ == null;
        }
        return this.lower_ == ((MeasureRange)oThat).lower_ && this.upper_ == ((MeasureRange)oThat).upper_ && this.dataset_.equals(((MeasureRange)oThat).dataset_);
    }

    public int hashCode() {
        int result = 23;
        result = HashCodeHelper.hash(result, this.lower_);
        result = HashCodeHelper.hash(result, this.upper_);
        result = HashCodeHelper.hash(result, this.dataset_);
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("MeasureRange[");
        buffer.append("lower_ = ").append(this.lower_);
        buffer.append(", upper_ = ").append(this.upper_);
        buffer.append(", dataset_ = ").append(this.dataset_);
        buffer.append("]");
        return buffer.toString();
    }

    public Object getXMLDelegate() {
        XMLDataRange xmlDataRange = new XMLDataRange();
        xmlDataRange.m_a_lower = this.lower_;
        xmlDataRange.m_a_upper = this.upper_;
        return xmlDataRange;
    }
}

