/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.graphic.xml.settings.generated;

import com.businessobjects.visualization.common.internal.XmlReaderVersion;
import com.businessobjects.visualization.graphic.xml.settings.MigrationSettings;
import com.businessobjects.visualization.util.xml.Helper;
import com.businessobjects.visualization.util.xml.XmlEventType;
import com.businessobjects.visualization.util.xml.XmlException;
import com.businessobjects.visualization.util.xml.XmlWriter;

public class XMLColors {
    public String m_a_palette;
    public int m_a_alpha = -1;
    public int m_a_brightness = -1;

    public void unmarshall(XmlReaderVersion readerVersion) throws XmlException {
        this.processAttribute(readerVersion);
        while (!(readerVersion.getXmlReader().next() == XmlEventType.END_DOCUMENT || readerVersion.getXmlReader().getEventType() == XmlEventType.END_ELEMENT && readerVersion.getXmlReader().getName() != null && readerVersion.getXmlReader().getName().equals("Colors"))) {
        }
    }

    public void processAttribute(XmlReaderVersion readerVersion) throws XmlException {
        for (int i = 0; i < readerVersion.getXmlReader().getAttributeCount(); ++i) {
            String prefixName = readerVersion.getXmlReader().getAttributePrefix(i);
            String attName = readerVersion.getXmlReader().getAttributeName(i);
            String finalName = (prefixName != null ? prefixName : "") + (prefixName != null && attName != null ? ":" : "") + (attName != null ? attName : "");
            MigrationSettings.instance().manageAttribute(this, readerVersion, finalName, readerVersion.getXmlReader().getAttributeValue(i));
            if (finalName.equals("palette")) {
                this.m_a_palette = readerVersion.getXmlReader().getAttributeValue(i);
                continue;
            }
            if (finalName.equals("alpha")) {
                this.m_a_alpha = new Integer(readerVersion.getXmlReader().getAttributeValue(i));
                continue;
            }
            if (!finalName.equals("brightness")) continue;
            this.m_a_brightness = new Integer(readerVersion.getXmlReader().getAttributeValue(i));
        }
    }

    public void dump() {
        ++Helper.indent;
        Helper.print("XMLColors");
        Helper.print("palette", this.m_a_palette);
        Helper.print("alpha", this.m_a_alpha);
        Helper.print("brightness", this.m_a_brightness);
        Helper.println("XMLColors ");
        --Helper.indent;
    }

    public void marshall2(XmlWriter xw) throws XmlException {
        if (this.m_a_palette != null) {
            xw.attribute(null, "palette", this.m_a_palette);
        }
        xw.attribute((String)null, "alpha", this.m_a_alpha);
        xw.attribute((String)null, "brightness", this.m_a_brightness);
    }

    public boolean equals(Object o) {
        XMLColors obj = (XMLColors)o;
        if (this.m_a_palette == obj.m_a_palette || this.m_a_palette != null && !this.m_a_palette.equals(obj.m_a_palette)) {
            return false;
        }
        if (this.m_a_alpha != obj.m_a_alpha) {
            return false;
        }
        return this.m_a_brightness == obj.m_a_brightness;
    }
}

