/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.graphic;

import com.businessobjects.visualization.common.exceptions.VisualizationInternalException;
import com.businessobjects.visualization.common.exceptions.VisualizationRuntimeException;
import com.businessobjects.visualization.graphic.VisuColorType;
import com.businessobjects.visualization.graphic.VisuGradient;
import com.businessobjects.visualization.graphic.VisuObject;
import com.businessobjects.visualization.graphic.VisuObjectType;
import com.businessobjects.visualization.graphic.VisuRGBA;
import com.businessobjects.visualization.graphic.VisuTexture;
import java.util.ArrayList;
import org.json.JSONException;
import org.json.JSONObject;

public class VisuColor
extends VisuObject {
    private static VisuObjectType type = VisuObjectType.COLOR;
    private static VisuRGBA visuRgbaTransparent = new VisuRGBA(0, 0, 0, 255);
    public static final VisuColor TRANSPARENT = new VisuColor(VisuColorType.TRANSPARENCY);
    public static final VisuColor RED = new VisuColor(255, 0, 0, 0);
    public static final VisuColor GREEN = new VisuColor(0, 255, 0, 0);
    public static final VisuColor BLUE = new VisuColor(0, 0, 255, 0);
    public static final VisuColor YELLOW = new VisuColor(255, 255, 0, 0);
    public static final VisuColor WHITE = new VisuColor(255, 255, 255, 0);
    public static final VisuColor BLACK = new VisuColor(0, 0, 0, 0);
    public static final VisuColor PURPLE = new VisuColor(255, 0, 255, 0);
    public static final VisuColor GREY = new VisuColor(127, 127, 127, 0);
    public static final VisuColor CYAN = new VisuColor(0, 255, 255, 0);
    public static final VisuColor MARKER = new VisuColor(305419896);
    private VisuColorType colorType_;
    private VisuObject value_;

    public VisuColor(int r, int g, int b, int alpha) {
        this.colorType_ = VisuColorType.RGBA;
        this.value_ = new VisuRGBA(r, g, b, alpha);
    }

    public VisuColor(int argb) {
        this.colorType_ = VisuColorType.RGBA;
        this.value_ = new VisuRGBA(argb);
    }

    public VisuColor(VisuRGBA rgba) {
        this.colorType_ = VisuColorType.RGBA;
        this.value_ = rgba;
    }

    public VisuColor(VisuGradient gradient) {
        this.colorType_ = VisuColorType.GRADIENT;
        this.value_ = gradient;
    }

    public VisuColor(VisuTexture texture) {
        this.colorType_ = VisuColorType.TEXTURE;
        this.value_ = texture;
    }

    public VisuColor(VisuColorType colorType) {
        this.colorType_ = colorType;
        if (colorType == VisuColorType.TRANSPARENCY) {
            this.value_ = visuRgbaTransparent;
        } else if (colorType == VisuColorType.GRADIENT) {
            this.value_ = VisuObject.create(VisuObjectType.GRADIENT.value());
        } else if (colorType == VisuColorType.RGBA) {
            this.value_ = VisuObject.create(VisuObjectType.RGBA.value());
        } else {
            throw new VisualizationRuntimeException("VIZ_00115_ERR_NOT_IMPLEMENTED_CASE", new Object[]{colorType});
        }
    }

    public VisuColor(String xmlValue) {
        this.setXmlValue(xmlValue);
    }

    public VisuObjectType getType() {
        return type;
    }

    public VisuColorType getColorType() {
        return this.colorType_;
    }

    public VisuObject getValue() {
        return this.value_;
    }

    public String toString() {
        String s = this.colorType_.toString() + " " + this.value_.toString();
        return s;
    }

    protected void setXmlValue(String xmlValue) {
        this.setXmlValue(VisuColor.stringToArray(xmlValue));
    }

    protected String getXmlValue() {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(this.colorType_.value()));
        sb.append(";[");
        sb.append(this.value_.getXmlValue());
        sb.append("]");
        return sb.toString();
    }

    protected Object clone() {
        VisuColor vc = (VisuColor)super.clone();
        vc.value_ = (VisuObject)this.value_.clone();
        return vc;
    }

    public VisuColor darker() {
        if (this.colorType_ != VisuColorType.RGBA) {
            return this;
        }
        VisuRGBA rgb = (VisuRGBA)this.value_;
        if (rgb.getAlpha() == 255) {
            return this;
        }
        return new VisuColor(new VisuRGBA((int)((float)rgb.getRed() * 0.75f), (int)((float)rgb.getGreen() * 0.75f), (int)((float)rgb.getBlue() * 0.75f), rgb.getAlpha()));
    }

    public VisuColor lighter() {
        if (this.colorType_ != VisuColorType.RGBA) {
            return this;
        }
        VisuRGBA rgb = (VisuRGBA)this.value_;
        if (rgb.getAlpha() == 255) {
            return this;
        }
        return new VisuColor(new VisuRGBA(Math.min((int)((float)rgb.getRed() * 1.25f), 255), Math.min((int)((float)rgb.getGreen() * 1.25f), 255), Math.min((int)((float)rgb.getBlue() * 1.25f), 255), rgb.getAlpha()));
    }

    private void setXmlValue(String[] values) {
        if (values == null) {
            throw new VisualizationRuntimeException("VIZ_00046_ERR_VISUCOLOR___VALUES_A");
        }
        if (values.length == 0) {
            throw new VisualizationRuntimeException("VIZ_00116_ERR_VISUCOLOR_CAN_NOT_BE", new Object[]{new Integer(values.length)});
        }
        this.colorType_ = VisuColorType.fromString(values[0]);
        if (this.colorType_ == VisuColorType.RGBA) {
            this.value_ = new VisuRGBA(values[1]);
        } else if (this.colorType_ == VisuColorType.GRADIENT) {
            this.value_ = new VisuGradient(values[1]);
        } else if (this.colorType_ == VisuColorType.TEXTURE) {
            this.value_ = new VisuTexture(values[1]);
        } else if (this.colorType_ == VisuColorType.TRANSPARENCY) {
            this.value_ = visuRgbaTransparent;
        } else {
            throw new VisualizationRuntimeException("VIZ_00117_ERR_VISUCOLOR_CAN_NOT_BE", new Object[]{values[0]});
        }
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof VisuColor) {
            VisuColor vc = (VisuColor)obj;
            if (vc.value_.equals(this.value_) && this.colorType_ == vc.colorType_) {
                result = true;
            }
        }
        return result;
    }

    public int hashCode() {
        return super.hashCode();
    }

    protected boolean checkValidity(Object param) {
        ArrayList enableTypes;
        if (param != null && !(enableTypes = (ArrayList)param).contains(this.colorType_)) {
            throw new VisualizationRuntimeException("VIZ_00047_ERR_VALUE_____VALUE_____", new Object[]{this.value_});
        }
        return true;
    }

    protected JSONObject getJSONObject() {
        try {
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("type", new Integer(type.value()));
            jsonObj.put("color type", new Integer(this.colorType_.value()));
            jsonObj.put("value", this.value_.getJSONObject());
            return jsonObj;
        }
        catch (JSONException jex) {
            throw new VisualizationInternalException(jex);
        }
    }

    VisuColor(JSONObject jobj) {
        try {
            this.colorType_ = VisuColorType.fromInt(jobj.getInt("color type"));
            JSONObject valueJson = jobj.getJSONObject("value");
            this.value_ = VisuObject.createFromJSON(valueJson.toString());
        }
        catch (JSONException jex) {
            throw new VisualizationInternalException(jex);
        }
    }
}

