/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.dataexchange.utils;

import com.businessobjects.visualization.common.exceptions.VisualizationInternalException;
import com.businessobjects.visualization.dataexchange.DataHolder;
import com.businessobjects.visualization.dataexchange.callbacks.IDimensionLabelsIterator;
import com.businessobjects.visualization.dataexchange.callbacks.IMember;
import com.businessobjects.visualization.dataexchange.callbacks.IValuesGrid;
import com.businessobjects.visualization.dataexchange.consumer.DataHandler;
import com.businessobjects.visualization.dataexchange.data.DatasetAdapter;
import com.businessobjects.visualization.dataexchange.data.DimensionLabelsAdapter;
import com.businessobjects.visualization.dataexchange.data.MeasureValuesAdapter;
import com.businessobjects.visualization.dataexchange.data.MeasureValuesGroupAdapter;
import com.businessobjects.visualization.dataexchange.definition.DimensionLabels;
import com.businessobjects.visualization.dataexchange.definition.MeasureValues;
import com.businessobjects.visualization.dataexchange.definition.MeasureValuesGroup;
import java.util.ArrayList;

public class DataToHtmlRenderer {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String EMPTY_CELL = "<TD></TD>";
    private int[] rowSpanCounterList_;

    private void buildRowHeaders(StringBuffer sb, DimensionLabels[] dlList, DimensionLabelsAdapter[] dlAdapterList, int nSerieCount, String[] mvList) {
        int i;
        sb.append(LINE_SEPARATOR);
        sb.append("<TR>");
        sb.append(EMPTY_CELL);
        if (dlList != null) {
            for (i = 0; i < dlList.length; ++i) {
                sb.append("<TH class=\"dimTitle\">" + dlAdapterList[i].getTitle() + ":</TH>");
            }
        } else {
            sb.append(EMPTY_CELL);
        }
        for (i = 0; i < nSerieCount; ++i) {
            if (mvList.length > 1) {
                for (int j = 0; j < mvList.length; ++j) {
                    sb.append("<TD>");
                    sb.append(mvList[j]);
                    sb.append("</TD>");
                }
                continue;
            }
            sb.append(EMPTY_CELL);
        }
        sb.append("</TR>");
    }

    private void buildNextRowHeaderCells(StringBuffer sb, IMember[] rowMember, DimensionLabels[] dlList) {
        if (this.rowSpanCounterList_ == null) {
            this.rowSpanCounterList_ = new int[dlList.length];
        }
        sb.append(EMPTY_CELL);
        for (int i = rowMember.length - 1; i >= 0; --i) {
            int iIndexRange = rowMember[i].getIndexRange();
            if (this.rowSpanCounterList_[i] > 1) {
                int n = i;
                this.rowSpanCounterList_[n] = this.rowSpanCounterList_[n] - 1;
                continue;
            }
            if (iIndexRange > 1) {
                sb.append("<TH ROWSPAN=\"" + iIndexRange + "\" class=\"level" + rowMember[i].getLevel() + "\">");
                this.rowSpanCounterList_[i] = iIndexRange;
            } else {
                sb.append("<TD class=\"level" + rowMember[i].getLevel() + "\">");
            }
            sb.append(rowMember[i].getValue());
            if (iIndexRange > 1) {
                sb.append("</TH>");
                continue;
            }
            sb.append("</TD>");
        }
    }

    private void buildDataCells(StringBuffer sb, int rowIndex, IValuesGrid[] measureGridsArray) {
        double[][] values = new double[measureGridsArray.length][];
        for (int i = 0; i < measureGridsArray.length; ++i) {
            values[i] = measureGridsArray[i].getSerie(rowIndex, 0);
        }
        int serieLength = values[0].length;
        for (int i = 0; i < serieLength; ++i) {
            for (int j = 0; j < values.length; ++j) {
                sb.append("<TD>");
                if (values[j][i] != 1.7E308) {
                    sb.append(values[j][i]);
                } else {
                    sb.append("#NA#");
                }
                sb.append("</TD>");
            }
        }
    }

    private void buildColumnHeaders(StringBuffer sb, IDimensionLabelsIterator iter, DimensionLabels[] dlList, DimensionLabelsAdapter[] dlAdapterList, int cellGap, int defaultSpan) {
        if (iter == null) {
            return;
        }
        StringBuffer[] linesList = new StringBuffer[dlList.length];
        int[] colSpanCounterList = new int[dlList.length];
        while (iter.hasLeaves()) {
            IMember[] colMember = iter.nextLeaf();
            for (int i = 0; i < colMember.length; ++i) {
                StringBuffer sbLine = linesList[i];
                if (sbLine == null) {
                    sbLine = new StringBuffer();
                    sbLine.append(LINE_SEPARATOR);
                    sbLine.append("<TR>");
                    sbLine.append("<TH class=\"dimTitle\">" + dlAdapterList[colMember[i].getDimensionIndex()].getTitle() + ":</TH>");
                    sbLine.append(EMPTY_CELL);
                    if (cellGap > 1) {
                        for (int cellGapCount = cellGap; cellGapCount > 1; --cellGapCount) {
                            sbLine.append(EMPTY_CELL);
                        }
                    }
                    linesList[i] = sbLine;
                }
                int iIndexRange = colMember[i].getIndexRange();
                if (colSpanCounterList[i] > 1) {
                    int n = i;
                    colSpanCounterList[n] = colSpanCounterList[n] - 1;
                    continue;
                }
                if (iIndexRange > 1) {
                    sbLine.append("<TH COLSPAN=\"" + iIndexRange * defaultSpan + "\" class=\"level" + colMember[i].getLevel() + "\">");
                    colSpanCounterList[i] = iIndexRange;
                } else if (defaultSpan > 1) {
                    sbLine.append("<TH COLSPAN=\"" + defaultSpan + "\" class=\"level" + colMember[i].getLevel() + "\">");
                } else {
                    sbLine.append("<TD class=\"level" + colMember[i].getLevel() + "\">");
                }
                sbLine.append(colMember[i].getValue());
                if (iIndexRange > 1) {
                    sbLine.append("</TH>");
                    continue;
                }
                if (defaultSpan > 1) {
                    sbLine.append("</TH>");
                    continue;
                }
                sbLine.append("</TD>");
            }
        }
        for (int i = linesList.length - 1; i >= 0; --i) {
            sb.append(linesList[i]);
            sb.append("</TR>");
        }
    }

    public void format(StringBuffer sb, DataHolder database) {
        this.rowSpanCounterList_ = null;
        if (database == null || database.getDataAdapter() == null || database.getDataDescriptor() == null) {
            throw new VisualizationInternalException("Sorry, database is not properly set");
        }
        DatasetAdapter dsa = database.getDataAdapter().getDataset();
        int nAxisCount = database.getDataDescriptor().getDatasetDescriptor().getAxisList().length;
        ArrayList<IValuesGrid> measureGrids = new ArrayList<IValuesGrid>();
        if (dsa.isFlat()) {
            measureGrids.add(dsa.getValueGroupList()[0].getMeasureValuesList()[0].getGridCallback());
        } else {
            MeasureValuesGroupAdapter[] mvgList = dsa.getValueGroupList();
            for (int i = 0; i < mvgList.length; ++i) {
                MeasureValuesAdapter[] mvList = mvgList[i].getMeasureValuesList();
                for (int j = 0; j < mvList.length; ++j) {
                    measureGrids.add(mvList[j].getGridCallback());
                }
            }
        }
        IDimensionLabelsIterator rootColumnDimIter = dsa.getLabelsIterator(0, 0);
        IDimensionLabelsIterator rootRowDimIter = null;
        int cellGap = 0;
        if (nAxisCount > 1) {
            rootRowDimIter = dsa.getLabelsIterator(1, 0);
            cellGap = database.getDataDescriptor().getDatasetDescriptor().getAxisList()[1].getDimensionLabelsList().length;
        }
        ArrayList<String> measureTitles = new ArrayList<String>();
        if (dsa.isFlat()) {
            measureTitles.add("All Measures");
        } else {
            MeasureValuesGroup[] mvgDescriptorList = database.getDataDescriptor().getDatasetDescriptor().getValueGroupList();
            for (int i = 0; i < mvgDescriptorList.length; ++i) {
                MeasureValues[] mvList = mvgDescriptorList[i].getMeasureValuesList();
                for (int j = 0; j < mvList.length; ++j) {
                    measureTitles.add(DataHandler.getDataContainerAdapter(database.getDataDescriptor(), database.getDataAdapter(), mvList[j]).getTitle());
                }
            }
        }
        IValuesGrid[] measureGridsArray = measureGrids.toArray(new IValuesGrid[0]);
        sb.append("<TABLE BORDER=\"2\" CELLPADDING=\"4\">");
        this.buildColumnHeaders(sb, rootColumnDimIter, database.getDataDescriptor().getDatasetDescriptor().getAxisList()[0].getDimensionLabelsList(), database.getDataAdapter().getDataset().getAxisList()[0].getDimensionLabelsList(), cellGap, measureGrids.size());
        this.buildRowHeaders(sb, nAxisCount > 1 ? database.getDataDescriptor().getDatasetDescriptor().getAxisList()[1].getDimensionLabelsList() : null, nAxisCount > 1 ? database.getDataAdapter().getDataset().getAxisList()[1].getDimensionLabelsList() : null, measureGridsArray[0].getSerie(0, 0).length, measureTitles.toArray(new String[0]));
        int nRowCount = 0;
        if (nAxisCount > 1) {
            while (rootRowDimIter.hasLeaves()) {
                sb.append(LINE_SEPARATOR);
                sb.append("<TR>");
                this.buildNextRowHeaderCells(sb, rootRowDimIter.nextLeaf(), database.getDataDescriptor().getDatasetDescriptor().getAxisList()[1].getDimensionLabelsList());
                this.buildDataCells(sb, nRowCount, measureGridsArray);
                sb.append("</TR>");
                ++nRowCount;
            }
        } else {
            sb.append("<TR>");
            sb.append(EMPTY_CELL);
            sb.append(EMPTY_CELL);
            this.buildDataCells(sb, nRowCount, measureGridsArray);
            sb.append("</TR>");
        }
        sb.append(LINE_SEPARATOR);
        sb.append("</TABLE>");
    }
}

