/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.dataexchange;

import com.businessobjects.visualization.common.internal.HashCodeHelper;
import com.businessobjects.visualization.dataexchange.DimensionLabelsContext;
import com.businessobjects.visualization.dataexchange.MeasureValuesContext;
import java.util.Arrays;

public class DataContext {
    private final MeasureValuesContext[] measureValuesContexts_;
    private final DimensionLabelsContext[] dimensionLabelsContexts_;
    private final int[] axisIndexes_;

    public DataContext(MeasureValuesContext[] mvf, DimensionLabelsContext[] dlf, int[] axisIndexes) {
        this.measureValuesContexts_ = mvf;
        this.dimensionLabelsContexts_ = dlf;
        this.axisIndexes_ = axisIndexes;
    }

    public DataContext(MeasureValuesContext[] mvf, DimensionLabelsContext[] dlf) {
        this(mvf, dlf, null);
    }

    public MeasureValuesContext[] getMeasureValuesContexts() {
        return this.measureValuesContexts_;
    }

    public DimensionLabelsContext[] getDimensionLabelsContexts() {
        return this.dimensionLabelsContexts_;
    }

    public int[] getAxisIndexes() {
        return this.axisIndexes_;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object oThat) {
        int i;
        if (this == oThat) {
            return true;
        }
        if (!(oThat instanceof DataContext)) {
            return false;
        }
        DataContext that = (DataContext)oThat;
        if (this.measureValuesContexts_ != null) {
            if (that.measureValuesContexts_ == null) return false;
            if (this.measureValuesContexts_.length != that.measureValuesContexts_.length) return false;
            for (i = 0; i < this.measureValuesContexts_.length; ++i) {
                if (this.measureValuesContexts_[i].equals(that.measureValuesContexts_[i])) continue;
                return false;
            }
        } else if (that.measureValuesContexts_ != null) {
            return false;
        }
        if (this.dimensionLabelsContexts_ != null) {
            if (that.dimensionLabelsContexts_ == null) return false;
            if (this.dimensionLabelsContexts_.length != that.dimensionLabelsContexts_.length) return false;
            for (i = 0; i < this.dimensionLabelsContexts_.length; ++i) {
                if (this.dimensionLabelsContexts_[i].equals(that.dimensionLabelsContexts_[i])) continue;
                return false;
            }
        } else if (that.dimensionLabelsContexts_ != null) {
            return false;
        }
        if (this.axisIndexes_ != null) {
            if (that.axisIndexes_ == null) return false;
            if (this.axisIndexes_.length != that.axisIndexes_.length) return false;
            for (i = 0; i < this.axisIndexes_.length; ++i) {
                if (this.axisIndexes_[i] == that.axisIndexes_[i]) continue;
                return false;
            }
            return true;
        } else {
            if (that.axisIndexes_ == null) return true;
            return false;
        }
    }

    public int hashCode() {
        int result = 23;
        result = HashCodeHelper.hash(result, this.measureValuesContexts_);
        result = HashCodeHelper.hash(result, this.dimensionLabelsContexts_);
        result = HashCodeHelper.hash(result, this.axisIndexes_);
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("DataFilters[");
        if (this.dimensionLabelsContexts_ == null) {
            buffer.append("DLFilters_ = ").append("null");
        } else {
            buffer.append("DLFilters_ = ").append(Arrays.asList(this.dimensionLabelsContexts_).toString());
        }
        if (this.measureValuesContexts_ == null) {
            buffer.append(" MVFilters_ = ").append("null");
        } else {
            buffer.append(" MVFilters_ = ").append(Arrays.asList(this.measureValuesContexts_).toString());
        }
        buffer.append(" aIdx_ = ");
        if (this.axisIndexes_ == null) {
            buffer.append("null");
        } else {
            buffer.append("(");
            for (int i = 0; i < this.axisIndexes_.length; ++i) {
                if (i > 0) {
                    buffer.append(",");
                }
                buffer.append(this.axisIndexes_[i]);
            }
            buffer.append(")");
        }
        buffer.append("]");
        return buffer.toString();
    }

    public int getXID() {
        int result = 23;
        result = HashCodeHelper.hash(result, this.getDimensionLabelsContexts());
        MeasureValuesContext[] mvc = this.getMeasureValuesContexts();
        if (mvc != null) {
            for (int j = 0; j < mvc.length; ++j) {
                result = HashCodeHelper.hash(result, mvc[j].getValue());
                result = HashCodeHelper.hash(result, mvc[j].getMeasureValues());
            }
        }
        return result;
    }
}

