/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.AbstractHierarchicalFileConfiguration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConfigurationKey;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.PropertyConverter;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLConfiguration
extends AbstractHierarchicalFileConfiguration {
    private static final String DEFAULT_ROOT_NAME = "configuration";
    private Document document;
    private String rootElementName;
    private DocumentBuilder documentBuilder;
    private boolean validating;

    public XMLConfiguration() {
    }

    public XMLConfiguration(String fileName) throws ConfigurationException {
        this();
        this.setFileName(fileName);
        this.load();
    }

    public XMLConfiguration(File file) throws ConfigurationException {
        this();
        this.setFile(file);
        if (file.exists()) {
            this.load();
        }
    }

    public XMLConfiguration(URL url) throws ConfigurationException {
        this();
        this.setURL(url);
        this.load();
    }

    public String getRootElementName() {
        if (this.getDocument() == null) {
            return this.rootElementName == null ? DEFAULT_ROOT_NAME : this.rootElementName;
        }
        return this.getDocument().getDocumentElement().getNodeName();
    }

    public void setRootElementName(String name) {
        if (this.getDocument() != null) {
            throw new UnsupportedOperationException("The name of the root element cannot be changed when loaded from an XML document!");
        }
        this.rootElementName = name;
    }

    public DocumentBuilder getDocumentBuilder() {
        return this.documentBuilder;
    }

    public void setDocumentBuilder(DocumentBuilder documentBuilder) {
        this.documentBuilder = documentBuilder;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
    }

    public Document getDocument() {
        return this.document;
    }

    public void clear() {
        super.clear();
        this.document = null;
    }

    public void initProperties(Document document, boolean elemRefs) {
        this.constructHierarchy(this.getRoot(), document.getDocumentElement(), elemRefs);
    }

    private void constructHierarchy(HierarchicalConfiguration.Node node, Element element, boolean elemRefs) {
        this.processAttributes(node, element, elemRefs);
        StringBuffer buffer = new StringBuffer();
        NodeList list = element.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node w3cNode = list.item(i);
            if (w3cNode instanceof Element) {
                Element child = (Element)w3cNode;
                XMLNode childNode = new XMLNode(child.getTagName(), elemRefs ? child : null);
                this.constructHierarchy(childNode, child, elemRefs);
                node.addChild(childNode);
                this.handleDelimiters(node, childNode);
            } else if (w3cNode instanceof Text) {
                Text data = (Text)w3cNode;
                buffer.append(data.getData());
            }
            ++i;
        }
        String text = buffer.toString().trim();
        if (text.length() > 0 || !node.hasChildren()) {
            node.setValue(text);
        }
    }

    private void processAttributes(HierarchicalConfiguration.Node node, Element element, boolean elemRefs) {
        NamedNodeMap attributes = element.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            Node w3cNode = attributes.item(i);
            if (w3cNode instanceof Attr) {
                Attr attr = (Attr)w3cNode;
                Iterator it = PropertyConverter.split(attr.getValue(), AbstractConfiguration.getDelimiter()).iterator();
                while (it.hasNext()) {
                    XMLNode child = new XMLNode(ConfigurationKey.constructAttributeKey(attr.getName()), elemRefs ? element : null);
                    ((HierarchicalConfiguration.Node)child).setValue(it.next());
                    node.addChild(child);
                }
            }
            ++i;
        }
    }

    private void handleDelimiters(HierarchicalConfiguration.Node parent, HierarchicalConfiguration.Node child) {
        if (child.getValue() != null) {
            List values = PropertyConverter.split(child.getValue().toString(), AbstractConfiguration.getDelimiter());
            if (values.size() > 1) {
                parent.remove(child);
                Iterator it = values.iterator();
                while (it.hasNext()) {
                    XMLNode c = new XMLNode(child.getName(), null);
                    ((HierarchicalConfiguration.Node)c).setValue(it.next());
                    parent.addChild(c);
                }
            } else if (values.size() == 1) {
                child.setValue(values.get(0));
            }
        }
    }

    protected DocumentBuilder createDocumentBuilder() throws ParserConfigurationException {
        if (this.getDocumentBuilder() != null) {
            return this.getDocumentBuilder();
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(this.isValidating());
        DocumentBuilder result = factory.newDocumentBuilder();
        if (this.isValidating()) {
            result.setErrorHandler(new DefaultHandler(){

                public void error(SAXParseException ex) throws SAXException {
                    throw ex;
                }
            });
        }
        return result;
    }

    protected Document createDocument() throws ConfigurationException {
        try {
            Object builder;
            if (this.document == null) {
                builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document newDocument = ((DocumentBuilder)builder).newDocument();
                Element rootElem = newDocument.createElement(this.getRootElementName());
                newDocument.appendChild(rootElem);
                this.document = newDocument;
            }
            builder = new XMLBuilderVisitor(this.document);
            ((XMLBuilderVisitor)builder).processDocument(this.getRoot());
            return this.document;
        }
        catch (DOMException domEx) {
            throw new ConfigurationException(domEx);
        }
        catch (ParserConfigurationException pex) {
            throw new ConfigurationException(pex);
        }
    }

    protected HierarchicalConfiguration.Node createNode(String name) {
        return new XMLNode(name, null);
    }

    public void load(InputStream in) throws ConfigurationException {
        this.load(new InputSource(in));
    }

    public void load(Reader in) throws ConfigurationException {
        this.load(new InputSource(in));
    }

    private void load(InputSource source) throws ConfigurationException {
        try {
            URL sourceURL = this.getDelegate().getURL();
            if (sourceURL != null) {
                source.setSystemId(sourceURL.toString());
            }
            DocumentBuilder builder = this.createDocumentBuilder();
            Document newDocument = builder.parse(source);
            Document oldDocument = this.document;
            this.document = null;
            this.initProperties(newDocument, oldDocument == null);
            this.document = oldDocument == null ? newDocument : oldDocument;
        }
        catch (Exception e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
    }

    public void save(Writer writer) throws ConfigurationException {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            DOMSource source = new DOMSource(this.createDocument());
            StreamResult result = new StreamResult(writer);
            transformer.setOutputProperty("indent", "yes");
            if (this.getEncoding() != null) {
                transformer.setOutputProperty("encoding", this.getEncoding());
            }
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
    }

    public Object clone() {
        XMLConfiguration copy = (XMLConfiguration)super.clone();
        copy.document = null;
        copy.setDelegate(this.createDelegate());
        copy.getRoot().visit(new HierarchicalConfiguration.NodeVisitor(){

            public void visitBeforeChildren(HierarchicalConfiguration.Node node, ConfigurationKey key) {
                node.setReference(null);
            }
        }, null);
        return copy;
    }

    protected AbstractHierarchicalFileConfiguration.FileConfigurationDelegate createDelegate() {
        return new XMLFileConfigurationDelegate();
    }

    private class XMLFileConfigurationDelegate
    extends AbstractHierarchicalFileConfiguration.FileConfigurationDelegate {
        private XMLFileConfigurationDelegate() {
        }

        public void load(InputStream in) throws ConfigurationException {
            XMLConfiguration.this.load(in);
        }
    }

    static class XMLBuilderVisitor
    extends HierarchicalConfiguration.BuilderVisitor {
        private Document document;

        public XMLBuilderVisitor(Document doc) {
            this.document = doc;
        }

        public void processDocument(HierarchicalConfiguration.Node rootNode) {
            rootNode.visit(this, null);
        }

        protected Object insert(HierarchicalConfiguration.Node newNode, HierarchicalConfiguration.Node parent, HierarchicalConfiguration.Node sibling1, HierarchicalConfiguration.Node sibling2) {
            if (ConfigurationKey.isAttributeKey(newNode.getName())) {
                XMLBuilderVisitor.updateAttribute(parent, this.getElement(parent), newNode.getName());
                return null;
            }
            Element elem = this.document.createElement(newNode.getName());
            if (newNode.getValue() != null) {
                elem.appendChild(this.document.createTextNode(PropertyConverter.escapeDelimiters(newNode.getValue().toString(), AbstractConfiguration.getDelimiter())));
            }
            if (sibling2 == null) {
                this.getElement(parent).appendChild(elem);
            } else if (sibling1 != null) {
                this.getElement(parent).insertBefore(elem, this.getElement(sibling1).getNextSibling());
            } else {
                this.getElement(parent).insertBefore(elem, this.getElement(parent).getFirstChild());
            }
            return elem;
        }

        private static void updateAttribute(HierarchicalConfiguration.Node node, Element elem, String name) {
            if (node != null && elem != null) {
                List attrs = node.getChildren(name);
                StringBuffer buf = new StringBuffer();
                Iterator it = attrs.iterator();
                while (it.hasNext()) {
                    HierarchicalConfiguration.Node attr = (HierarchicalConfiguration.Node)it.next();
                    if (attr.getValue() != null) {
                        if (buf.length() > 0) {
                            buf.append(AbstractConfiguration.getDelimiter());
                        }
                        buf.append(PropertyConverter.escapeDelimiters(attr.getValue().toString(), AbstractConfiguration.getDelimiter()));
                    }
                    attr.setReference(elem);
                }
                if (buf.length() < 1) {
                    elem.removeAttribute(ConfigurationKey.removeAttributeMarkers(name));
                } else {
                    elem.setAttribute(ConfigurationKey.removeAttributeMarkers(name), buf.toString());
                }
            }
        }

        static void updateAttribute(HierarchicalConfiguration.Node node, String name) {
            if (node != null) {
                XMLBuilderVisitor.updateAttribute(node, (Element)node.getReference(), name);
            }
        }

        private Element getElement(HierarchicalConfiguration.Node node) {
            return node.getName() != null ? (Element)node.getReference() : this.document.getDocumentElement();
        }
    }

    class XMLNode
    extends HierarchicalConfiguration.Node {
        public XMLNode(String name, Element elem) {
            super(name);
            this.setReference(elem);
        }

        public void setValue(Object value) {
            super.setValue(value);
            if (this.getReference() != null && XMLConfiguration.this.document != null) {
                if (ConfigurationKey.isAttributeKey(this.getName())) {
                    this.updateAttribute();
                } else {
                    this.updateElement(value);
                }
            }
        }

        protected void removeReference() {
            if (this.getReference() != null) {
                Element element = (Element)this.getReference();
                if (ConfigurationKey.isAttributeKey(this.getName())) {
                    this.updateAttribute();
                } else {
                    Node parentElem = element.getParentNode();
                    if (parentElem != null) {
                        parentElem.removeChild(element);
                    }
                }
            }
        }

        private void updateElement(Object value) {
            Text txtNode = this.findTextNodeForUpdate();
            if (value == null) {
                if (txtNode != null) {
                    ((Element)this.getReference()).removeChild(txtNode);
                }
            } else if (txtNode == null) {
                txtNode = XMLConfiguration.this.document.createTextNode(PropertyConverter.escapeDelimiters(value.toString(), AbstractConfiguration.getDelimiter()));
                if (((Element)this.getReference()).getFirstChild() != null) {
                    ((Element)this.getReference()).insertBefore(txtNode, ((Element)this.getReference()).getFirstChild());
                } else {
                    ((Element)this.getReference()).appendChild(txtNode);
                }
            } else {
                txtNode.setNodeValue(PropertyConverter.escapeDelimiters(value.toString(), AbstractConfiguration.getDelimiter()));
            }
        }

        private void updateAttribute() {
            XMLBuilderVisitor.updateAttribute(this.getParent(), this.getName());
        }

        private Text findTextNodeForUpdate() {
            Text result = null;
            Element elem = (Element)this.getReference();
            NodeList children = elem.getChildNodes();
            ArrayList<Node> textNodes = new ArrayList<Node>();
            int i = 0;
            while (i < children.getLength()) {
                Node nd = children.item(i);
                if (nd instanceof Text) {
                    if (result == null) {
                        result = (Text)nd;
                    } else {
                        textNodes.add(nd);
                    }
                }
                ++i;
            }
            if (result instanceof CDATASection) {
                textNodes.add(result);
                result = null;
            }
            Iterator it = textNodes.iterator();
            while (it.hasNext()) {
                elem.removeChild((Node)it.next());
            }
            return result;
        }
    }
}

