/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.graphic;

import com.businessobjects.visualization.common.exceptions.VisualizationInternalException;
import com.businessobjects.visualization.common.internal.HashtablePlus;
import com.businessobjects.visualization.graphic.VisuTemplate;
import com.businessobjects.visualization.graphic.VisuTemplateType;
import com.businessobjects.visualization.util.xml.XmlEventType;
import com.businessobjects.visualization.util.xml.XmlException;
import com.businessobjects.visualization.util.xml.XmlReader;
import com.businessobjects.visualization.util.xml.XmlWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;

public class VisuTemplateManager {
    private HashtablePlus templates_ = new HashtablePlus();
    private static final String VISU_TEMPLATES_ELT = "VisuTemplates";

    public void add(VisuTemplate template) {
        this.templates_.put(template.getId(), template);
    }

    public VisuTemplate get(String templateId) {
        return (VisuTemplate)this.templates_.get(templateId);
    }

    public void delete(String templateId) {
        this.templates_.remove(templateId);
    }

    public void delete(int index) {
        this.templates_.remove(index);
    }

    public VisuTemplate get(int index) {
        return (VisuTemplate)this.templates_.get(index);
    }

    public void clear() {
        this.templates_.clear();
    }

    public VisuTemplate[] getTemplateList() {
        VisuTemplate[] result = new VisuTemplate[this.templates_.size()];
        int i = 0;
        Iterator iter = this.templates_.elements();
        while (iter.hasNext()) {
            VisuTemplate vt = (VisuTemplate)iter.next();
            result[i++] = vt;
        }
        return result;
    }

    public VisuTemplate[] getTemplateList(VisuTemplateType type) {
        ArrayList<VisuTemplate> list = new ArrayList<VisuTemplate>();
        Iterator iter = this.templates_.elements();
        while (iter.hasNext()) {
            VisuTemplate vt = (VisuTemplate)iter.next();
            if (vt.getType() != type) continue;
            list.add(vt);
        }
        VisuTemplate[] result = new VisuTemplate[list.size()];
        list.toArray(result);
        return result;
    }

    public void write(OutputStream os) {
        try {
            XmlWriter xw = new XmlWriter(os, Charset.forName("UTF-8"));
            xw.startDocument();
            xw.declareNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            xw.startElement(VISU_TEMPLATES_ELT);
            Iterator iter = this.templates_.elements();
            while (iter.hasNext()) {
                VisuTemplate vt = (VisuTemplate)iter.next();
                vt.marshall(xw);
            }
            xw.endElement(VISU_TEMPLATES_ELT);
            xw.endDocument();
        }
        catch (XmlException e) {
            throw new VisualizationInternalException(e);
        }
    }

    public void read(InputStream is) {
        try {
            VisuTemplate vt;
            if (is.available() == 0) {
                return;
            }
            XmlReader xmlReader = new XmlReader(is);
            xmlReader.readToStartElement(null, VISU_TEMPLATES_ELT);
            while ((xmlReader.getEventType() != XmlEventType.END_ELEMENT || xmlReader.getName() == null || !xmlReader.getName().equals(VISU_TEMPLATES_ELT)) && (vt = new VisuTemplate()).unmarshall(xmlReader)) {
                this.add(vt);
            }
        }
        catch (XmlException e) {
            throw new VisualizationInternalException("Invalid stream for template library", e);
        }
        catch (IOException ioe) {
            throw new VisualizationInternalException("I/O error while reading template library", ioe);
        }
    }

    public void read(URL url) {
        try {
            this.read(url.openStream());
        }
        catch (IOException e) {
            throw new VisualizationInternalException("Cannot open the stream to read the templates file", e);
        }
    }
}

