/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.dataexchange.definition;

import com.businessobjects.visualization.common.internal.IXMLDelegator;
import com.businessobjects.visualization.common.internal.SerializationHelper;
import com.businessobjects.visualization.dataexchange.data.GroupingDimensionAdapter;
import com.businessobjects.visualization.dataexchange.definition.ClientInfoHolder;
import com.businessobjects.visualization.dataexchange.definition.DimensionLabels;
import com.businessobjects.visualization.dataexchange.definition.generated.XMLClientInfoHolder;
import com.businessobjects.visualization.dataexchange.definition.generated.XMLDimensionLabelsRef;
import com.businessobjects.visualization.dataexchange.definition.generated.XMLGroupingDimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class GroupingDimension
implements IXMLDelegator {
    private ArrayList dimensionLabelsList = new ArrayList();
    private ArrayList groupingDimensionList = new ArrayList();
    private ClientInfoHolder clientInfoHolder;
    private String title;

    private GroupingDimension() {
    }

    public GroupingDimension(String title, ClientInfoHolder cih) {
        this();
        this.clientInfoHolder = cih;
        this.title = title;
    }

    public GroupingDimension(XMLGroupingDimension xmlGroup, SerializationHelper sh) {
        this();
        this.clientInfoHolder = new ClientInfoHolder(xmlGroup.m_clientInfoHolder, sh);
        this.title = xmlGroup.m_a_title;
        Iterator iter = xmlGroup.m_list_dimensionLabelsRef.iterator();
        while (iter.hasNext()) {
            XMLDimensionLabelsRef dimRef = (XMLDimensionLabelsRef)iter.next();
            this.dimensionLabelsList.add((DimensionLabels)sh.getObjectFromSerialUid(dimRef.m_a_dataContainerId.id));
        }
        iter = xmlGroup.m_list_groupingDimension.iterator();
        while (iter.hasNext()) {
            XMLGroupingDimension group = (XMLGroupingDimension)iter.next();
            this.groupingDimensionList.add(new GroupingDimension(group, sh));
        }
    }

    public Object getXMLDelegate() {
        XMLGroupingDimension xmlGroup = new XMLGroupingDimension();
        xmlGroup.m_a_title = this.title;
        xmlGroup.m_clientInfoHolder = (XMLClientInfoHolder)this.clientInfoHolder.getXMLDelegate();
        Iterator iter = this.dimensionLabelsList.iterator();
        while (iter.hasNext()) {
            XMLDimensionLabelsRef aRef = new XMLDimensionLabelsRef();
            aRef.m_a_dataContainerId.id = ((DimensionLabels)iter.next()).getUid();
            xmlGroup.m_list_dimensionLabelsRef.add(aRef);
        }
        iter = this.groupingDimensionList.iterator();
        while (iter.hasNext()) {
            xmlGroup.m_list_groupingDimension.add((XMLGroupingDimension)((GroupingDimension)iter.next()).getXMLDelegate());
        }
        return xmlGroup;
    }

    public void addGroupingDimension(GroupingDimension gd) {
        this.groupingDimensionList.add(gd);
    }

    public void addDimensionLabels(DimensionLabels dl) {
        this.dimensionLabelsList.add(dl);
    }

    public DimensionLabels[] getDimensionLabelsList() {
        return this.dimensionLabelsList.toArray(new DimensionLabels[0]);
    }

    public GroupingDimension[] getGroupingDimensionList() {
        return this.groupingDimensionList.toArray(new GroupingDimension[0]);
    }

    public String getTitle() {
        return this.title;
    }

    public ClientInfoHolder getClientInfoHolder() {
        return this.clientInfoHolder;
    }

    public GroupingDimensionAdapter getCalculationAdapter() {
        GroupingDimension[] groupingList = this.getGroupingDimensionList();
        GroupingDimensionAdapter[] groupingAdapters = new GroupingDimensionAdapter[groupingList.length];
        for (int i = 0; i < groupingAdapters.length; ++i) {
            groupingAdapters[i] = groupingList[i].getCalculationAdapter();
        }
        return new GroupingDimensionAdapter(groupingAdapters, this.clientInfoHolder.getAdapter());
    }

    public boolean equals(Object oThat) {
        if (this == oThat) {
            return true;
        }
        if (!(oThat instanceof GroupingDimension)) {
            return false;
        }
        GroupingDimension that = (GroupingDimension)oThat;
        return Arrays.equals(this.getDimensionLabelsList(), that.getDimensionLabelsList()) && Arrays.equals(this.getGroupingDimensionList(), that.getGroupingDimensionList()) && this.title.equals(that.title) && this.clientInfoHolder.equals(that.clientInfoHolder);
    }
}

