/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.common.internal;

import com.businessobjects.visualization.common.exceptions.VisualizationInternalException;
import com.businessobjects.visualization.common.exceptions.VisualizationRuntimeException;
import com.businessobjects.visualization.common.internal.VersionHelper;
import com.businessobjects.visualization.common.internal.VisuVersion;
import com.businessobjects.visualization.formatting.IFormatFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;

public class SerializationHelper {
    private Hashtable hashTable_ = new Hashtable();
    private VersionHelper versionHelper_;
    private final IFormatFactory formatFactory_;
    private static long counter;

    public SerializationHelper(VersionHelper versionHelper, IFormatFactory formatFactory) {
        if (versionHelper == null) {
            throw new VisualizationRuntimeException("VIZ_00008_ERR_VERSIONHELPER_IS_NUL");
        }
        this.versionHelper_ = versionHelper;
        this.formatFactory_ = formatFactory;
    }

    public SerializationHelper(VersionHelper versionHelper) {
        this(versionHelper, null);
    }

    public IFormatFactory getFormatFactory() {
        return this.formatFactory_;
    }

    public VisuVersion getCurrentVersion() {
        return this.versionHelper_.getCurrentVersion();
    }

    public VisuVersion getSerializedVersion() {
        return this.versionHelper_.getSerializedVersion();
    }

    public synchronized Object getObjectFromSerialUid(String uid) {
        return this.hashTable_.get(uid);
    }

    public synchronized void registerObjectWithUid(Object o, String uid) {
        this.hashTable_.put(uid, o);
    }

    private static synchronized long getNextCount() {
        return counter++;
    }

    public static String getSerialUid() {
        return Long.toString(SerializationHelper.getNextCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] objectToBytes(Object arg) throws IOException {
        ByteArrayOutputStream baos = null;
        ObjectOutputStream oos = null;
        try {
            baos = new ByteArrayOutputStream(50000);
            oos = new ObjectOutputStream(baos);
            oos.writeObject(arg);
            oos.flush();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            try {
                if (oos != null) {
                    oos.close();
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (oos != null) {
                oos.close();
            }
        }
        catch (Throwable t) {}
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Object bytesToObject(byte[] bytes) throws IOException {
        Object object;
        ByteArrayInputStream bais = null;
        ObjectInputStream ois = null;
        try {
            Object obj;
            bais = new ByteArrayInputStream(bytes);
            ois = new ObjectInputStream(bais);
            try {
                obj = ois.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new VisualizationInternalException("Ouch, could not find class !!", e);
            }
            object = obj;
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (ois != null) {
                    ois.close();
                }
            }
            catch (Throwable t) {}
            throw throwable;
        }
        try {
            if (ois != null) {
                ois.close();
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        return object;
    }
}

