/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.utility;

import java.awt.Rectangle;
import java.util.List;

public class RectangleUtil {
    public static int BOUNDS_NONE = 0;
    public static int BOUNDS_BOTTOM = 1;
    public static int BOUNDS_TOP = 2;
    public static int BOUNDS_RIGHT = 4;
    public static int BOUNDS_LEFT = 8;
    public static final int TOP_AND_BOTTOM = 5;
    public static final int LEFT_AND_RIGHT = 6;
    public static final int FREE_FLOAT = -1;
    public static final int AUTO = 0;
    public static final int BOTTOM = 1;
    public static final int RIGHT = 2;
    public static final int LEFT = 3;
    public static final int TOP = 4;
    public static final int RIGHT_TOP = 5;
    public static final int RIGHT_BOTTOM = 6;
    public static final int LEFT_TOP = 7;
    public static final int LEFT_BOTTOM = 8;
    public static final int BOTTOM_LEFT = 9;
    public static final int BOTTOM_RIGHT = 10;
    public static final int TOP_LEFT = 11;
    public static final int TOP_RIGHT = 12;

    public static final void subtract(Rectangle r, int len, int where, int min) {
        switch (where) {
            case 1: 
            case 4: {
                if (r.height - len >= min) break;
                len = Math.max(0, r.height - min);
                break;
            }
            case 5: {
                if (r.height - len * 2 >= min) break;
                len = Math.max(0, r.height - min) / 2;
                break;
            }
            case 2: 
            case 3: {
                if (r.width - len >= min) break;
                len = Math.max(0, r.width - min);
                break;
            }
            case 6: {
                if (r.width - len * 2 >= min) break;
                len = Math.max(0, r.width - min) / 2;
            }
        }
        RectangleUtil.subtract(r, len, where);
    }

    public static final void subtract(Rectangle r, int len, int where) {
        switch (where) {
            case 4: {
                r.height -= len;
                break;
            }
            case 1: {
                r.y += len;
                r.height -= len;
                break;
            }
            case 5: {
                r.y += len;
                r.height -= 2 * len;
                break;
            }
            case 3: {
                r.x += len;
                r.width -= len;
                break;
            }
            case 2: {
                r.width -= len;
                break;
            }
            case 6: {
                r.x += len;
                r.width -= 2 * len;
            }
        }
    }

    public static final Rectangle positionRect(int pos, Rectangle rc, Rectangle ri) {
        int x = 0;
        int y = 0;
        int margin = 500;
        switch (pos) {
            case -1: {
                x = ri.x;
                y = ri.y;
                break;
            }
            case 0: {
                boolean isTallerThanWide;
                boolean bl = isTallerThanWide = ri.height > ri.width;
                if (isTallerThanWide) {
                    x = 16000 - ri.width - margin;
                    y = ri.height / 2 - ri.height;
                    break;
                }
                x = -ri.width / 2;
                y = rc.y;
                break;
            }
            case 1: {
                x = -ri.width / 2;
                y = rc.y;
                break;
            }
            case 2: {
                x = 16000 - ri.width - margin;
                y = ri.height / 2 - ri.height;
                break;
            }
            case 3: {
                x = -16000 + margin;
                y = ri.height / 2 - ri.height;
                break;
            }
            case 4: {
                x = -ri.width / 2;
                y = rc.y + rc.height - ri.height - margin;
                break;
            }
            case 5: {
                x = 16000 - ri.width - margin;
                y = rc.y + rc.height - ri.height;
                break;
            }
            case 6: {
                x = 16000 - ri.width - margin;
                y = rc.y;
                break;
            }
            case 7: {
                x = -16000 + margin;
                y = rc.y + rc.height - ri.height;
                break;
            }
            case 8: {
                x = -16000 + margin;
                y = rc.y;
                break;
            }
            case 9: {
                x = -16000 + margin;
                y = rc.y;
                break;
            }
            case 10: {
                x = 16000 - ri.width - margin;
                y = rc.y;
                break;
            }
            case 11: {
                x = -16000 + margin;
                y = rc.y + rc.height - ri.height;
                break;
            }
            case 12: {
                x = 16000 - ri.width - margin;
                y = rc.y + rc.height - ri.height;
            }
        }
        Rectangle r = new Rectangle(x, y, ri.width, ri.height);
        return r;
    }

    public static Rectangle calcBoundingRectangle(List rectangles) {
        int numRectangles = rectangles.size();
        if (numRectangles == 0) {
            return null;
        }
        Rectangle boundingRectangle = null;
        for (int i = 0; i < numRectangles; ++i) {
            Rectangle rect = (Rectangle)rectangles.get(i);
            if (rect.width == 0 || rect.height == 0) continue;
            if (boundingRectangle == null) {
                boundingRectangle = new Rectangle(rect);
            }
            boundingRectangle.add((Rectangle)rectangles.get(i));
        }
        return boundingRectangle;
    }

    public static boolean inBounds(Rectangle constraintBox, Rectangle testBox, int sidesToTest) {
        boolean inBounds = true;
        if ((sidesToTest & BOUNDS_LEFT) == BOUNDS_LEFT) {
            boolean bl = inBounds = inBounds && testBox.x >= constraintBox.x && (double)testBox.x <= constraintBox.getMaxX();
        }
        if ((sidesToTest & BOUNDS_RIGHT) == BOUNDS_RIGHT) {
            boolean bl = inBounds = inBounds && testBox.getMaxX() >= (double)constraintBox.x && testBox.getMaxX() <= constraintBox.getMaxX();
        }
        if ((sidesToTest & BOUNDS_TOP) == BOUNDS_TOP) {
            boolean bl = inBounds = inBounds && testBox.y >= constraintBox.y && (double)testBox.y <= constraintBox.getMaxY();
        }
        if ((sidesToTest & BOUNDS_BOTTOM) == BOUNDS_BOTTOM) {
            inBounds = inBounds && testBox.getMaxY() >= (double)constraintBox.y && testBox.getMaxY() <= constraintBox.getMaxY();
        }
        return inBounds;
    }

    public static boolean hasSide(int side, int searchSide) {
        switch (searchSide) {
            case 1: {
                return side == 1 || side == 5 || side == 9 || side == 10 || side == 8 || side == 6;
            }
            case 4: {
                return side == 4 || side == 5 || side == 11 || side == 12;
            }
            case 3: {
                return side == 3 || side == 9 || side == 6 || side == 7 || side == 8;
            }
            case 2: {
                return side == 2 || side == 6 || side == 10 || side == 12 || side == 6 || side == 5;
            }
        }
        throw new RuntimeException("Implement me!");
    }
}

