/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.paint;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.paint.GradientPaintExtContext;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.Random;

class RandomGradientPaintExtContext
extends GradientPaintExtContext {
    private final Random m_generator = new Random(0L);
    private int m_nRandomness = 0;
    private int m_nDoubleRandomness = 0;

    public RandomGradientPaintExtContext(Point2D start, Point2D end, double[] I, Color[] colors, AffineTransform t, boolean cyclic, int nRandomness) throws NoninvertibleTransformException {
        super(start, end, I, colors, t, cyclic);
        this.m_nRandomness = nRandomness;
        this.m_nDoubleRandomness = nRandomness << 1;
    }

    public void fillCyclicRaster(int[] pixels, int off, int adjust, int w, int h, double X, double Y) {
        double gs = 0.0;
        double g = 0.0;
        int rowLimit = off + w;
        double gradientMaxIndex = this.gradient.length - 1;
        int randomG = 0;
        for (int i = 0; i < h; ++i) {
            gs = this.dgdX * X + this.dgdY * (Y + (double)i) + this.gc;
            if ((gs %= gradientMaxIndex) < 0.0) {
                gs = gradientMaxIndex + gs;
            }
            g = gs;
            while (off < rowLimit) {
                while (g <= gradientMaxIndex && off < rowLimit) {
                    randomG = (int)(g + this.dgdX * (double)this.randomInt());
                    pixels[off++] = randomG >= 0 && (double)randomG < gradientMaxIndex ? this.gradient[randomG] : this.gradient[(int)g];
                    g += this.dgdX;
                }
                g %= gradientMaxIndex;
            }
            rowLimit = (off += adjust) + w;
        }
    }

    public void fillRaster(int[] pixels, int off, int adjust, int w, int h, double X, double Y) {
        double gs = 0.0;
        double ge = 0.0;
        double g = 0.0;
        int rgb = 0;
        int rowLimit = off + w;
        double gradientMaxIndex = this.gradient.length - 1;
        int randomG = 0;
        for (int i = 0; i < h; ++i) {
            gs = this.dgdX * X + this.dgdY * (Y + (double)i) + this.gc;
            ge = gs + this.dgdX * (double)w;
            if (gs >= gradientMaxIndex) {
                rgb = this.gradient[(int)gradientMaxIndex];
                while (off < rowLimit) {
                    pixels[off++] = rgb;
                }
            } else if (ge <= 0.0) {
                rgb = this.gradient[0];
                while (off < rowLimit) {
                    pixels[off++] = rgb;
                }
            } else {
                rgb = this.gradient[0];
                for (g = gs; g <= 0.0 && off < rowLimit; g += this.dgdX) {
                    pixels[off++] = rgb;
                }
                while (g <= gradientMaxIndex && off < rowLimit) {
                    randomG = (int)(g + this.dgdX * (double)this.randomInt());
                    pixels[off++] = randomG >= 0 && (double)randomG < gradientMaxIndex ? this.gradient[randomG] : this.gradient[(int)g];
                    g += this.dgdX;
                }
                rgb = this.gradient[(int)gradientMaxIndex];
                while (off < rowLimit) {
                    pixels[off++] = rgb;
                }
            }
            rowLimit = (off += adjust) + w;
        }
    }

    public final int randomInt() {
        return this.m_generator.nextInt(this.m_nDoubleRandomness) - this.m_nRandomness;
    }
}

