/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.model3d;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.DrawFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IBlackBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IDrawContainer;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JChart_3D;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d.Matrix4d;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d.Point3d;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.geom.ListOfLayersComposition;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.geom.Shape_Layer;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.geom.StrokeRenderer;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.model3d.GridlineView;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.model3d.Model3DShape;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.sun.Position;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.util.Iterator;

public final class Model3DGridline
extends Model3DShape {
    private JChart_3D m_chart;
    private boolean m_bConstantZ;
    private double m_dOrigin;
    private GridlineView m_gridlineView;
    private IdentObj m_id;
    private IBlackBox m_bb;
    private boolean m_bAutoshading;
    private double m_distance;
    private boolean[][] m_bGridStatus;

    public Model3DGridline(JChart_3D chart, IdentObj id, IBlackBox bb, boolean isConstantZ, Point3d[] points, Point3d size, boolean[][] bGridStatus, boolean bAutoshading) {
        if (points == null) {
            throw new RuntimeException(" points variable is null");
        }
        int nLen = points.length;
        if (nLen == 0) {
            throw new RuntimeException("zero points");
        }
        this.m_chart = chart;
        this.m_bConstantZ = isConstantZ;
        this.m_dOrigin = isConstantZ ? points[0].z : points[0].x;
        this.m_gridlineView = new GridlineView(chart, isConstantZ, points, size);
        this.m_id = id;
        this.m_bb = bb;
        this.m_bGridStatus = bGridStatus;
        this.m_bAutoshading = bAutoshading;
    }

    public Model3DGridline(Model3DGridline model) {
        this(model.m_chart, model.m_id, model.m_bb, model.m_bConstantZ, model.getPoints(), model.getSize(), model.m_bGridStatus, model.m_bAutoshading);
    }

    public IdentObj getIdentObj() {
        return this.m_id;
    }

    public Point2D.Double getPosition(Matrix4d matrix, int nDataTextPosition) throws UnsupportedOperationException {
        switch (nDataTextPosition) {
            default: 
        }
        throw new UnsupportedOperationException("NYI for data text position " + nDataTextPosition);
    }

    public void calcDistance(Matrix4d matrix, Point3d viewer) {
        Point3d center = this.getCenter();
        this.transformPoint3d(center, matrix);
        double dist2 = (viewer.x - center.x) * (viewer.x - center.x) + (viewer.y - center.y) * (viewer.y - center.y) + (viewer.z - center.z) * (viewer.z - center.z);
        this.m_distance = Math.sqrt(dist2);
    }

    public Point3d[] getPoints() {
        return this.m_gridlineView.getPoints();
    }

    public Point3d getSize() {
        return this.m_gridlineView.getSize();
    }

    public double getDistance() {
        return this.m_distance;
    }

    public Point3d getCenter() {
        if (this.m_bConstantZ) {
            return new Point3d(0.0, 0.0, this.m_dOrigin);
        }
        return new Point3d(this.m_dOrigin, 0.0, 0.0);
    }

    protected Point3d getGridLineEnd(int nAxis, int nFace, double d) {
        throw new UnsupportedOperationException();
    }

    protected Point3d getGridLineStart(int nAxis, int nFace, double d) {
        throw new UnsupportedOperationException();
    }

    public double getMinZ() {
        return this.m_gridlineView.getMinZ();
    }

    ListOfLayersComposition getComposition() {
        int margin = 10;
        Shape path = this.m_gridlineView.getShape();
        Color strokePaint = this.m_bConstantZ ? Color.red : Color.yellow;
        double strokeWidth = 3.0;
        StrokeRenderer strokeRenderer = new StrokeRenderer((Paint)strokePaint, strokeWidth);
        Rectangle bounds = path.getBounds();
        Dimension size = new Dimension(bounds.width + margin * 2, bounds.height + margin * 2);
        ListOfLayersComposition cmp = new ListOfLayersComposition(size);
        Shape_Layer layer = new Shape_Layer(cmp, path, strokeRenderer, Position.CENTER);
        cmp.setLayers(new Shape_Layer[]{layer});
        cmp.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        return cmp;
    }

    public boolean isVisibleIpsoFacto(int f) {
        return true;
    }

    public void display() {
        ListOfLayersComposition cmp = this.getComposition();
        IDrawContainer det = this.m_chart.getDrawContainer();
        Iterator<Shape_Layer> it = cmp.iterator();
        while (it.hasNext()) {
            Shape_Layer layer = it.next();
            Shape shape = layer.getShape();
            DrawFactory.createShape(det, this.m_id, shape, this.m_bb, null, layer.getRenderer());
        }
    }
}

