/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.geom;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.BlackBoxRenderer;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.ColorPinObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IBlackBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.paint.PaintExt;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.List;

public class FillRenderer
implements BlackBoxRenderer {
    private Paint m_PaintFill;
    private final List<ColorPinObj> m_gradientList = new ArrayList<ColorPinObj>();
    private final Dimension margins = new Dimension(0, 0);

    public FillRenderer(Paint filling) {
        if (filling == null) {
            throw new IllegalArgumentException();
        }
        this.m_PaintFill = filling;
    }

    public Paint getPaintFill() {
        return this.m_PaintFill;
    }

    public Dimension2D getMargins() {
        return (Dimension)this.margins.clone();
    }

    public void render(Graphics2D g, Shape shape) {
        g.setPaint(this.m_PaintFill);
        g.draw(shape);
        g.fill(shape);
    }

    public void updateFrom(IBlackBox bb) {
        if (bb != null) {
            int nSize;
            boolean bIsChanged;
            if (bb.getFillType() == 1) {
                // empty if block
            }
            if ((bIsChanged = bb.copyGradientColors(this.m_gradientList)) && (nSize = this.m_gradientList.size()) > 0 && this.m_PaintFill != null && this.m_PaintFill instanceof PaintExt) {
                Color[] colors = new Color[2 * nSize];
                double[] intervals = new double[2 * nSize - 1];
                this.calcIntervalsColors(intervals, colors);
                ((PaintExt)this.m_PaintFill).setIntervalsColors(intervals, colors);
            }
        }
    }

    public final void calcIntervalsColors(double[] intervals, Color[] colors) {
        int index = 0;
        double fLastPosition = 0.0;
        int intervalsLen = intervals.length;
        for (ColorPinObj pin : this.m_gradientList) {
            colors[index] = pin.getLeftColor();
            intervals[index] = fLastPosition = pin.getPosition();
            colors[++index] = pin.getRightColor();
            if (index < intervalsLen) {
                intervals[index] = fLastPosition;
            }
            ++index;
        }
        fLastPosition = 1.0;
        for (int i = intervals.length - 1; i >= 0; --i) {
            double fTemp = intervals[i];
            intervals[i] = fLastPosition - fTemp;
            fLastPosition = fTemp;
        }
    }
}

