/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.AxisTemplate;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.data.Access;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.Depth2D;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JChart_3D;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.MinMaxObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.Axis2DObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.Axis3DObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.AxisHistObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.AxisTaskObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.CircularAxisObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.IGanttAxis;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.IHistogramAxis;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.INumericAxis;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.IOrdinalAxis;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.TimeScaleAxis;

public final class AxisFactory {
    private AxisFactory() {
    }

    public static INumericAxis createTimeAxis(Perspective perspective, Access access, AxisTemplate id, MinMaxObj minMax, boolean bVertical, boolean bAscending, int nAxisOffset, int nAxisSize) {
        return new TimeScaleAxis(perspective, access, AxisTemplate.X1_AXIS, minMax, bVertical, bAscending, nAxisOffset, nAxisSize);
    }

    public static IHistogramAxis createHistogramAxis(Perspective perspective, Access access, AxisTemplate id, MinMaxObj minMax, boolean bVertical, boolean bAscending, int nAxisOffset, int nAxisSize) {
        return new AxisHistObj(perspective, access, id, minMax, bVertical, bAscending, nAxisOffset, nAxisSize);
    }

    public static INumericAxis createCircularNumericAxis(Perspective perspective, Access access, AxisTemplate id, MinMaxObj minMax, boolean bAscending, boolean bVertical, int nAxisOffset, int nAxisSize, boolean bRadius) {
        return new CircularAxisObj(perspective, access, AxisTemplate.Y1_AXIS, minMax, bAscending, bVertical, nAxisOffset, nAxisSize, bRadius);
    }

    public static IOrdinalAxis createCircularOrdinalAxis(Perspective perspective, Access access, AxisTemplate id, boolean bAscending, int nAxisOffset, int nAxisSize, boolean bRadius) {
        return new CircularAxisObj(perspective, access, id, bAscending, nAxisOffset, nAxisSize, bRadius);
    }

    public static IOrdinalAxis create2DOrdinalAxis(Perspective perspective, Access access, AxisTemplate id, int nAxisType, boolean bVertical, boolean bAscending) {
        return new Axis2DObj(perspective, access, id, nAxisType, bVertical, bAscending);
    }

    public static INumericAxis create2DNumericAxis(Perspective perspective, Access access, AxisTemplate id, MinMaxObj minMax, boolean bVertical, boolean bAscending, int nAxisOffset, int nAxisSize, boolean bDrawOnCalc) {
        return new Axis2DObj(perspective, access, id, minMax, bVertical, bAscending, nAxisOffset, nAxisSize, bDrawOnCalc);
    }

    public static IOrdinalAxis create3DOrdinalAxis(JChart_3D chart, Perspective perspective, Access access, AxisTemplate id, int nAxisType, int orient, boolean bAscending, int nAxisOriginVC, int nAxisLengthVC) {
        return new Axis3DObj(chart, perspective, access, id, nAxisType, orient, bAscending, nAxisOriginVC, nAxisLengthVC);
    }

    public static INumericAxis create3DNumericAxis(JChart_3D chart, Perspective perspective, Access access, AxisTemplate id, MinMaxObj minMax, int orient, boolean bAscending, int nAxisOffset, int nAxisSize, int nAxisOriginVC, int nAxisLengthVC) {
        return new Axis3DObj(chart, perspective, access, id, minMax, orient, bAscending, nAxisOffset, nAxisSize, nAxisOriginVC, nAxisLengthVC);
    }

    public static IGanttAxis createGanttEngine(Perspective perspective, INumericAxis timeAxis, IOrdinalAxis taskAxis, Access access, Depth2D depth2D) {
        return new AxisTaskObj(perspective, timeAxis, taskAxis, access, depth2D);
    }
}

