/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions12.sdk.occa.report.definition;

import com.crystaldecisions12.client.helper.CloneUtil;
import com.crystaldecisions12.client.helper.XMLSerializationHelper;
import com.crystaldecisions12.sdk.occa.report.definition.AreaSectionKind;
import com.crystaldecisions12.sdk.occa.report.definition.Areas;
import com.crystaldecisions12.sdk.occa.report.definition.IArea;
import com.crystaldecisions12.sdk.occa.report.definition.IReportDefinition;
import com.crystaldecisions12.sdk.occa.report.definition.IReportObject;
import com.crystaldecisions12.sdk.occa.report.definition.ISection;
import com.crystaldecisions12.sdk.occa.report.definition.ReportObjects;
import com.crystaldecisions12.sdk.occa.report.definition.ReportStyle;
import com.crystaldecisions12.sdk.occa.report.definition.Sections;
import com.crystaldecisions12.sdk.occa.report.lib.IClone;
import com.crystaldecisions12.xml.serialization.ClassFactory;
import com.crystaldecisions12.xml.serialization.IXMLSerializable;
import com.crystaldecisions12.xml.serialization.XMLConverter;
import com.crystaldecisions12.xml.serialization.XMLSerializationContext;
import com.crystaldecisions12.xml.serialization.XMLWriter;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.xml.sax.Attributes;

public class ReportDefinition
implements IReportDefinition,
IClone,
IXMLSerializable {
    private Areas mV = null;
    private ReportStyle mW = ReportStyle.none;

    public ReportDefinition(IReportDefinition iReportDefinition) {
        iReportDefinition.copyTo(this, true);
    }

    public ReportDefinition() {
    }

    public Object clone(boolean bl2) {
        ReportDefinition reportDefinition = new ReportDefinition();
        this.copyTo(reportDefinition, bl2);
        return reportDefinition;
    }

    public void copyTo(Object object, boolean bl2) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (!(object instanceof IReportDefinition)) {
            throw new ClassCastException();
        }
        IReportDefinition iReportDefinition = (IReportDefinition)object;
        iReportDefinition.setReportStyle(this.mW);
        if (this.mV != null && bl2) {
            iReportDefinition.setAreas((Areas)this.mV.clone(bl2));
        } else {
            iReportDefinition.setAreas(this.mV);
        }
    }

    public Object createMember(String string, Attributes attributes, XMLSerializationContext xMLSerializationContext, Map map, boolean[] blArray) {
        Object object = ClassFactory.createObject(attributes, xMLSerializationContext, blArray);
        if (string.equals("Areas") && object != null) {
            this.mV = (Areas)object;
        }
        return object;
    }

    public void endElement(String string, Map map) {
    }

    public Areas getAreas() {
        if (this.mV == null) {
            this.mV = new Areas();
        }
        return this.mV;
    }

    public ReportStyle getReportStyle() {
        return this.mW;
    }

    public boolean hasContent(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof IReportDefinition)) {
            return false;
        }
        IReportDefinition iReportDefinition = (IReportDefinition)object;
        if (this.mW != iReportDefinition.getReportStyle()) {
            return false;
        }
        return CloneUtil.hasContent(this.getAreas(), iReportDefinition.getAreas());
    }

    public void readElement(String string, String string2, Attributes attributes, Map map) {
        if (string.equals("ReportStyle")) {
            this.mW = ReportStyle.from_string(string2);
        }
    }

    public void save(XMLWriter xMLWriter, XMLSerializationContext xMLSerializationContext) throws IOException {
        String string = XMLConverter.getXMLFromClassName(this.getClass().getName());
        Properties properties = XMLSerializationHelper.getHeaderAttributes(string);
        xMLWriter.writeStartElement("CrystalReports.ReportDefinition", properties);
        this.saveContents(xMLWriter, xMLSerializationContext);
        xMLWriter.writeEndElement("CrystalReports.ReportDefinition");
    }

    public void save(XMLWriter xMLWriter, String string, XMLSerializationContext xMLSerializationContext) throws IOException {
        xMLWriter.writeStartObjectElement(string, "2", this, xMLSerializationContext);
        this.saveContents(xMLWriter, xMLSerializationContext);
        xMLWriter.writeEndElement(string);
    }

    public void saveContents(XMLWriter xMLWriter, XMLSerializationContext xMLSerializationContext) throws IOException {
        xMLWriter.writeTextElement("ReportStyle", this.mW.toString(), null);
        xMLWriter.writeObjectElement(this.mV, "Areas", xMLSerializationContext);
    }

    public void setAreas(Areas areas) {
        this.mV = areas;
    }

    public void setReportStyle(ReportStyle reportStyle) {
        if (reportStyle == null) {
            throw new IllegalArgumentException();
        }
        this.mW = reportStyle;
    }

    public void startElement(String string, Map map, Attributes attributes) {
    }

    public IReportObject findObjectByName(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException();
        }
        Areas areas = this.getAreas();
        int n2 = areas.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            IArea iArea = areas.getArea(i2);
            Sections sections = iArea.getSections();
            int n3 = sections.size();
            for (int i3 = 0; i3 < n3; ++i3) {
                ISection iSection = sections.getSection(i3);
                ReportObjects reportObjects = iSection.getReportObjects();
                int n4 = reportObjects.size();
                for (int i4 = 0; i4 < n4; ++i4) {
                    IReportObject iReportObject = reportObjects.getReportObject(i4);
                    if (!string.equalsIgnoreCase(iReportObject.getName())) continue;
                    return iReportObject;
                }
            }
        }
        return null;
    }

    public ISection findSectionByName(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException();
        }
        Areas areas = this.getAreas();
        int n2 = areas.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            IArea iArea = areas.getArea(i2);
            Sections sections = iArea.getSections();
            int n3 = sections.size();
            for (int i3 = 0; i3 < n3; ++i3) {
                ISection iSection = sections.getSection(i3);
                if (!string.equalsIgnoreCase(iSection.getName())) continue;
                return iSection;
            }
        }
        return null;
    }

    public IArea getDetailArea() {
        return this.a(AreaSectionKind.detail);
    }

    public IArea getGroupFooterArea(int n2) {
        return this.a(n2, false);
    }

    public IArea getGroupHeaderArea(int n2) {
        return this.a(n2, true);
    }

    public IArea getPageFooterArea() {
        return this.a(AreaSectionKind.pageFooter);
    }

    public IArea getPageHeaderArea() {
        return this.a(AreaSectionKind.pageHeader);
    }

    public IArea getReportFooterArea() {
        return this.a(AreaSectionKind.reportFooter);
    }

    public IArea getReportHeaderArea() {
        return this.a(AreaSectionKind.reportHeader);
    }

    private IArea a(AreaSectionKind areaSectionKind) {
        IArea iArea;
        if (areaSectionKind == AreaSectionKind.detail && (iArea = this.V()) != null) {
            return iArea;
        }
        int n2 = this.mV.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            iArea = this.mV.getArea(i2);
            if (iArea.getKind() != areaSectionKind) continue;
            return iArea;
        }
        return null;
    }

    private IArea V() {
        int n2;
        IArea iArea;
        int n3 = this.mV.size();
        if (n3 % 2 == 1 && (iArea = this.mV.getArea(n2 = (n3 - 1) / 2)).getKind() == AreaSectionKind.detail) {
            return iArea;
        }
        return null;
    }

    private IArea a(int n2, boolean bl2) {
        AreaSectionKind areaSectionKind = bl2 ? AreaSectionKind.groupHeader : AreaSectionKind.groupFooter;
        int n3 = this.mV.size();
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n5 = bl2 ? i2 : n3 - i2 - 1;
            IArea iArea = this.mV.getArea(n5);
            if (iArea.getKind() != areaSectionKind) continue;
            if (n4 == n2) {
                return iArea;
            }
            ++n4;
        }
        return null;
    }
}

