/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.xml.serialization;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.crystaldecisions.xml.serialization.IXMLSerializable;
import com.crystaldecisions.xml.serialization.IXMLSerializationOptions;
import com.crystaldecisions.xml.serialization.SaveOption;
import com.crystaldecisions.xml.serialization.XMLConverter;
import com.crystaldecisions.xml.serialization.XMLSerializationContext;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.TimeZone;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class XMLWriter {
    private static final ILogger if = LoggerManager.getLogger((String)XMLWriter.class.getName());
    private Writer a = null;
    private char for = (char)34;
    private SaveOption do = null;

    protected XMLWriter(Writer writer, SaveOption saveOption) {
        this.a = new BufferedWriter(writer);
        this.do = saveOption;
    }

    public XMLWriter(OutputStream outputStream, SaveOption saveOption) {
        this.a(outputStream);
        this.do = saveOption;
    }

    public void flush() throws IOException {
        this.a.flush();
    }

    public char getQuotechar() {
        return this.for;
    }

    public TimeZone getSaveTimeZone() {
        if (this.do != null) {
            return this.do.getTimeZone();
        }
        return TimeZone.getDefault();
    }

    public boolean isSkipWritingIdenticalObject() {
        return this.do.isSkipWritingIdenticalObject();
    }

    protected void a(OutputStream outputStream) {
        block2: {
            try {
                this.a = new BufferedWriter(new OutputStreamWriter(outputStream, "utf-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (!if.isWarnEnabled()) break block2;
                if.warn((Object)"Could not create outputstream. The encoding is not supported.", (Throwable)unsupportedEncodingException);
            }
        }
    }

    public void setQuotechar(char c10) {
        this.for = c10;
    }

    public void writeAttributeText(String string) throws IOException {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.writeChar(string.charAt(i2), true);
        }
    }

    private void a(boolean bl2) throws IOException {
        this.a.write(XMLConverter.getBooleanString(bl2));
    }

    public void writeBooleanElement(String string, boolean bl2, Properties properties) throws IOException {
        this.writeStartElement(string, properties);
        this.a(bl2);
        this.writeEndElement(string);
    }

    public void writeChar(char c10, boolean bl2) throws IOException {
        if (c10 < ' ' && c10 != '\t' && c10 != '\r' && c10 != '\n') {
            this.a.write(32);
            return;
        }
        switch (c10) {
            case '<': {
                this.writeEntityRef("lt");
                break;
            }
            case '>': {
                this.writeEntityRef("gt");
                break;
            }
            case '&': {
                this.writeEntityRef("amp");
                break;
            }
            case '\'': {
                if (bl2 && this.for == c10) {
                    this.writeEntityRef("apos");
                    break;
                }
                this.a.write(c10);
                break;
            }
            case '\"': {
                if (bl2 && this.for == c10) {
                    this.writeEntityRef("quot");
                    break;
                }
                this.a.write(c10);
                break;
            }
            case '\n': 
            case '\r': {
                this.writeCharEntity(c10);
                break;
            }
            default: {
                this.a.write(c10);
            }
        }
    }

    public void writeCharEntity(char c10) throws IOException {
        this.a.write("&#x");
        this.a.write(Integer.toHexString(c10));
        this.a.write(59);
    }

    public void writeChars(char[] cArray, int n2, int n3) throws IOException {
        if (cArray == null) {
            return;
        }
        int n4 = cArray.length < n2 + n3 ? cArray.length : n2 + n3;
        for (int i2 = n2; i2 < n4; ++i2) {
            this.writeChar(cArray[i2], false);
        }
    }

    public void writeDate(Date date) throws IOException {
        if (date != null) {
            this.a.write(XMLConverter.getDateString(date));
        }
    }

    private void a(double d10) throws IOException {
        this.a.write(XMLConverter.getDoubleString(d10));
    }

    public void writeDoubleElement(String string, double d10, Properties properties) throws IOException {
        this.writeStartElement(string, properties);
        this.a(d10);
        this.writeEndElement(string);
    }

    public void writeEndDocument() throws IOException {
    }

    public void writeEndElement(String string) throws IOException {
        this.a.write("</");
        this.a.write(string);
        this.a.write(62);
    }

    public void writeEntityRef(String string) throws IOException {
        this.a.write(38);
        this.a.write(string);
        this.a.write(59);
    }

    public void writeEnumElement(String string, Object object, Properties properties) throws IOException {
        if (object != null || !this.do.isExcludeNullObjects()) {
            if (object != null) {
                this.writeTextElement(string, object.toString(), properties);
            } else {
                this.writeTextElement(string, null, properties);
            }
        }
    }

    private void a(int n2) throws IOException {
        this.a.write(XMLConverter.getIntegerString(n2));
    }

    public void writeIntElement(String string, int n2, Properties properties) throws IOException {
        this.writeStartElement(string, properties);
        this.a(n2);
        this.writeEndElement(string);
    }

    public void writeObjectElement(IXMLSerializable iXMLSerializable, String string, XMLSerializationContext xMLSerializationContext) throws IOException {
        if (iXMLSerializable != null || !this.do.isExcludeNullObjects()) {
            if (iXMLSerializable != null) {
                if (this.do.isSkipWritingIdenticalObject()) {
                    int n2 = 0;
                    n2 = xMLSerializationContext.if(iXMLSerializable);
                    if (n2 > 0) {
                        this.a(string, iXMLSerializable, xMLSerializationContext, n2);
                        return;
                    }
                }
                iXMLSerializable.save(this, string, xMLSerializationContext);
            } else {
                this.a.write(60);
                this.a.write(string);
                this.a.write("/>");
            }
        }
    }

    public void writeStartDocument() throws IOException {
    }

    public void writeStartElement(String string, Properties properties) throws IOException {
        this.a.write(60);
        this.a.write(string);
        if (properties != null) {
            Enumeration<Object> enumeration = properties.keys();
            int n2 = properties.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                String string2 = (String)enumeration.nextElement();
                this.a.write(32);
                this.writeAttributeText(string2);
                this.a.write("=\"");
                this.writeAttributeText(properties.getProperty(string2));
                this.a.write(34);
            }
        }
        this.a.write(62);
    }

    public void writeStartObjectElement(String string, String string2, Object object, XMLSerializationContext xMLSerializationContext) throws IOException {
        Properties properties = new Properties();
        String string3 = XMLConverter.getXMLFromClassName(object.getClass().getName());
        properties.setProperty("xsi:type", string3);
        int n2 = 0;
        n2 = xMLSerializationContext.a(object) ? xMLSerializationContext.a((IXMLSerializationOptions)object) : xMLSerializationContext.getObjectID(object);
        xMLSerializationContext.setObject(n2, object);
        properties.setProperty("id", String.valueOf(n2));
        this.writeStartElement(string, properties);
    }

    public void writeText(String string) throws IOException {
        if (string == null) {
            return;
        }
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.writeChar(string.charAt(i2), false);
        }
    }

    public void writeTextElement(String string, String string2, Properties properties) throws IOException {
        this.writeTextElement(string, string2, properties, false);
    }

    public void writeTextElement(String string, String string2, Properties properties, boolean bl2) throws IOException {
        if (string2 != null || bl2 || !this.do.isExcludeNullObjects()) {
            if (string2 != null) {
                this.writeStartElement(string, properties);
                this.writeText(string2);
                this.writeEndElement(string);
            } else {
                if (properties == null) {
                    properties = new Properties();
                }
                properties.setProperty("xsi:nil", "true");
                this.writeStartEndElement(string, properties);
            }
        }
    }

    void a(String string, Object object, XMLSerializationContext xMLSerializationContext, int n2) throws IOException {
        Properties properties = new Properties();
        String string2 = XMLConverter.getXMLFromClassName(object.getClass().getName());
        properties.setProperty("xsi:type", string2);
        int n3 = xMLSerializationContext.a(object) ? xMLSerializationContext.getContentObjectID() : n2;
        properties.setProperty("id", String.valueOf(n3));
        properties.setProperty("content-id", String.valueOf(n2));
        this.writeStartEndElement(string, properties);
    }

    public void writeStartEndElement(String string, Properties properties) throws IOException {
        this.a.write(60);
        this.a.write(string);
        if (properties != null) {
            Enumeration<Object> enumeration = properties.keys();
            int n2 = properties.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                String string2 = (String)enumeration.nextElement();
                this.a.write(32);
                this.writeAttributeText(string2);
                this.a.write("=\"");
                this.writeAttributeText(properties.getProperty(string2));
                this.a.write(34);
            }
        }
        this.a.write("/>");
    }

    public void writeDateElement(String string, Date date, Properties properties) throws IOException {
        this.writeStartElement(string, properties);
        if (date != null) {
            this.a.write(this.a(date));
        }
        this.writeEndElement(string);
    }

    private String a(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(gregorianCalendar.get(1));
        stringBuffer.append('-');
        stringBuffer.append(gregorianCalendar.get(2) + 1);
        stringBuffer.append('-');
        stringBuffer.append(gregorianCalendar.get(5));
        return stringBuffer.toString();
    }

    public void writeTimeElement(String string, Time time, Properties properties) throws IOException {
        this.writeStartElement(string, properties);
        if (time != null) {
            this.a.write(time.toString());
        }
        this.writeEndElement(string);
    }

    public void writeTimestampElement(String string, Timestamp timestamp, Properties properties) throws IOException {
        this.writeStartElement(string, properties);
        this.writeDate(timestamp);
        this.writeEndElement(string);
    }
}

