/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.report.definition;

import com.crystaldecisions.client.helper.ColorConverter;
import com.crystaldecisions.client.helper.XMLSerializationHelper;
import com.crystaldecisions.sdk.occa.report.definition.BorderMargins;
import com.crystaldecisions.sdk.occa.report.definition.DrawingObject;
import com.crystaldecisions.sdk.occa.report.definition.IBorder;
import com.crystaldecisions.sdk.occa.report.definition.IBoxObject;
import com.crystaldecisions.sdk.occa.report.definition.LineStyle;
import com.crystaldecisions.sdk.occa.report.lib.IChange;
import com.crystaldecisions.sdk.occa.report.lib.IClone;
import com.crystaldecisions.sdk.occa.report.lib.ReportObjectKind;
import com.crystaldecisions.xml.serialization.XMLConverter;
import com.crystaldecisions.xml.serialization.XMLSerializationContext;
import com.crystaldecisions.xml.serialization.XMLWriter;
import java.awt.Color;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.xml.sax.Attributes;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BoxObject
extends DrawingObject
implements IBoxObject,
IClone {
    private int J = 0;
    private int I = 0;
    private boolean H = true;

    public BoxObject(IBoxObject iBoxObject) {
        this();
        iBoxObject.copyTo(this, true);
    }

    public BoxObject() {
        this.setKind(ReportObjectKind.box);
    }

    public Object clone(boolean bl2) {
        BoxObject boxObject = new BoxObject();
        this.copyTo(boxObject, bl2);
        return boxObject;
    }

    public void copyTo(Object object, boolean bl2) {
        super.copyTo(object, bl2);
        if (!(object instanceof IBoxObject)) {
            throw new ClassCastException();
        }
        IBoxObject iBoxObject = (IBoxObject)object;
        iBoxObject.setCornerEllipseHeight(this.J);
        iBoxObject.setCornerEllipseWidth(this.I);
        iBoxObject.setAlwaysCloseBorder(this.H);
    }

    public Object createMember(String string, Attributes attributes, XMLSerializationContext xMLSerializationContext, Map map, boolean[] blArray) {
        return super.createMember(string, attributes, xMLSerializationContext, map, blArray);
    }

    public void endElement(String string, Map map) {
    }

    public int getCornerEllipseHeight() {
        return this.J;
    }

    public int getCornerEllipseWidth() {
        return this.I;
    }

    public Color getFillColor() {
        return ColorConverter.a(this.getBorder().getBackgroundColorValue());
    }

    public int getFillColorValue() {
        return this.getBorder().getBackgroundColorValue();
    }

    public LineStyle getLineStyle() {
        return this.getBorder().getLeftLineStyle();
    }

    public boolean getAlwaysCloseBorder() {
        return this.H;
    }

    public boolean hasContent(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof IBoxObject)) {
            return false;
        }
        IBoxObject iBoxObject = (IBoxObject)object;
        if (!super.hasContent(iBoxObject)) {
            return false;
        }
        if (this.J != iBoxObject.getCornerEllipseHeight()) {
            return false;
        }
        if (this.I != iBoxObject.getCornerEllipseWidth()) {
            return false;
        }
        return this.H == iBoxObject.getAlwaysCloseBorder();
    }

    public void readElement(String string, String string2, Attributes attributes, Map map) {
        super.readElement(string, string2, attributes, map);
        if (string.equals("CornerEllipseHeight")) {
            this.J = XMLConverter.getInt(string2);
        } else if (string.equals("CornerEllipseWidth")) {
            this.I = XMLConverter.getInt(string2);
        } else if (string.equals("AlwaysCloseBorder")) {
            this.H = XMLConverter.getBooleanValue(string2);
        }
    }

    public void save(XMLWriter xMLWriter, XMLSerializationContext xMLSerializationContext) throws IOException {
        String string = XMLConverter.getXMLFromClassName(this.getClass().getName());
        Properties properties = XMLSerializationHelper.getHeaderAttributes(string);
        xMLWriter.writeStartElement("CrystalReports.BoxObject", properties);
        this.saveContents(xMLWriter, xMLSerializationContext);
        xMLWriter.writeEndElement("CrystalReports.BoxObject");
    }

    public void save(XMLWriter xMLWriter, String string, XMLSerializationContext xMLSerializationContext) throws IOException {
        xMLWriter.writeStartObjectElement(string, "2", this, xMLSerializationContext);
        this.saveContents(xMLWriter, xMLSerializationContext);
        xMLWriter.writeEndElement(string);
    }

    public void saveContents(XMLWriter xMLWriter, XMLSerializationContext xMLSerializationContext) throws IOException {
        super.saveContents(xMLWriter, xMLSerializationContext);
        xMLWriter.writeIntElement("CornerEllipseHeight", this.J, null);
        xMLWriter.writeIntElement("CornerEllipseWidth", this.I, null);
        xMLWriter.writeBooleanElement("AlwaysCloseBorder", this.H, null);
    }

    public void setCornerEllipseHeight(final int n2) {
        this.case.makeChange(new IChange(){

            public void run() {
                BoxObject.this.J = n2;
            }
        });
    }

    public void setCornerEllipseWidth(final int n2) {
        this.case.makeChange(new IChange(){

            public void run() {
                BoxObject.this.I = n2;
            }
        });
    }

    public void setFillColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException();
        }
        int n2 = ColorConverter.a(color);
        this.getBorder().setBackgroundColorValue(n2);
    }

    public void setFillColorValue(int n2) {
        this.getBorder().setBackgroundColorValue(n2);
    }

    public void setLineStyle(LineStyle lineStyle) {
        if (lineStyle == null) {
            throw new IllegalArgumentException();
        }
        IBorder iBorder = this.getBorder();
        iBorder.setLeftLineStyle(lineStyle);
        iBorder.setRightLineStyle(lineStyle);
        iBorder.setTopLineStyle(lineStyle);
        iBorder.setBottomLineStyle(lineStyle);
    }

    public void setAlwaysCloseBorder(final boolean bl2) {
        this.case.makeChange(new IChange(){

            public void run() {
                BoxObject.this.H = bl2;
            }
        });
    }

    public void startElement(String string, Map map, Attributes attributes) {
    }

    public BorderMargins getBorderMargins() {
        IBorder iBorder = this.getBorder();
        boolean bl2 = iBorder.getHasDropShadow();
        if (bl2) {
            return new BorderMargins(0, 0, 60, 60);
        }
        return new BorderMargins(0, 0, 0, 0);
    }
}

