/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.common.enums;

public final class LineWidthType {
    public static final int _hairline = 0;
    public static final int _halfpoint = 10;
    public static final int _onepoint = 20;
    public static final int _onehalfpoint = 30;
    public static final int _twopoint = 40;
    public static final int _twohalfpoint = 50;
    public static final int _threepoint = 60;
    public static final int _threehalfpoint = 70;
    public static LineWidthType hairline = new LineWidthType(0);
    public static LineWidthType halfpoint = new LineWidthType(10);
    public static LineWidthType onepoint = new LineWidthType(20);
    public static LineWidthType onehalfpoint = new LineWidthType(30);
    public static LineWidthType twopoint = new LineWidthType(40);
    public static LineWidthType twohalfpoint = new LineWidthType(50);
    public static LineWidthType threepoint = new LineWidthType(60);
    public static LineWidthType threehalfpoint = new LineWidthType(70);
    private final int a;

    public static LineWidthType fromInt(int n2) {
        switch (n2) {
            case 0: {
                return hairline;
            }
            case 10: {
                return halfpoint;
            }
            case 20: {
                return onepoint;
            }
            case 30: {
                return onehalfpoint;
            }
            case 40: {
                return twopoint;
            }
            case 50: {
                return twohalfpoint;
            }
            case 60: {
                return threepoint;
            }
            case 70: {
                return threehalfpoint;
            }
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Line width must be positive number!");
        }
        return new LineWidthType(n2);
    }

    private LineWidthType(int n2) {
        this.a = n2;
    }

    public int value() {
        return this.a;
    }

    public String toString() {
        switch (this.a) {
            case 0: {
                return "Hairline";
            }
            case 10: {
                return "0.5 pt";
            }
            case 20: {
                return "1 pt";
            }
            case 30: {
                return "1.5 pt";
            }
            case 40: {
                return "2 pt";
            }
            case 50: {
                return "2.5 pt";
            }
            case 60: {
                return "3 pt";
            }
            case 70: {
                return "3.5 pt";
            }
        }
        return "?";
    }
}

