/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.jakarta.poi.util;

import com.crystaldecisions.jakarta.poi.util.LittleEndianConsts;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LittleEndian
implements LittleEndianConsts {
    private LittleEndian() {
    }

    public static short case(byte[] byArray, int n2) {
        return (short)LittleEndian.do(byArray, n2, 2);
    }

    public static int for(byte[] byArray, int n2) {
        int n3 = (int)LittleEndian.do(byArray, n2, 2);
        int n4 = n3 < 0 ? 65536 + n3 : n3;
        return n4;
    }

    public static short[] int(byte[] byArray, int n2, int n3) {
        short[] sArray = new short[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            sArray[i2] = LittleEndian.case(byArray, n2 + 2 + i2 * 2);
        }
        return sArray;
    }

    public static short[] try(byte[] byArray, int n2) {
        short s2 = (short)LittleEndian.do(byArray, n2, 2);
        short[] sArray = LittleEndian.int(byArray, n2, s2);
        return sArray;
    }

    public static short for(byte[] byArray) {
        return LittleEndian.case(byArray, 0);
    }

    public static int try(byte[] byArray) {
        return LittleEndian.for(byArray, 0);
    }

    public static int a(byte[] byArray, int n2) {
        return (int)LittleEndian.do(byArray, n2, 4);
    }

    public static int int(byte[] byArray) {
        return LittleEndian.a(byArray, 0);
    }

    public static long new(byte[] byArray, int n2) {
        int n3 = (int)LittleEndian.do(byArray, n2, 4);
        long l2 = n3 < 0 ? 0x100000000L + (long)n3 : (long)n3;
        return l2;
    }

    public static long do(byte[] byArray) {
        return LittleEndian.new(byArray, 0);
    }

    public static long int(byte[] byArray, int n2) {
        return LittleEndian.do(byArray, n2, 8);
    }

    public static long if(byte[] byArray) {
        return LittleEndian.int(byArray, 0);
    }

    public static double do(byte[] byArray, int n2) {
        return Double.longBitsToDouble(LittleEndian.do(byArray, n2, 8));
    }

    public static double new(byte[] byArray) {
        return LittleEndian.do(byArray, 0);
    }

    public static void a(byte[] byArray, int n2, short s2) {
        LittleEndian.a(byArray, n2, s2, 2);
    }

    public static void a(byte[] byArray, int n2, short[] sArray) {
        LittleEndian.a(byArray, n2, sArray.length, 2);
        for (int i2 = 0; i2 < sArray.length; ++i2) {
            LittleEndian.a(byArray, n2 + 2 + i2 * 2, sArray[i2], 2);
        }
    }

    public static void if(byte[] byArray, int n2, int n3) {
        LittleEndian.a(byArray, n2, n3, 2);
    }

    public static void a(byte[] byArray, short s2) {
        LittleEndian.a(byArray, 0, s2);
    }

    public static void for(byte[] byArray, int n2, int n3) {
        LittleEndian.a(byArray, n2, n3, 4);
    }

    public static void byte(byte[] byArray, int n2) {
        LittleEndian.for(byArray, 0, n2);
    }

    public static void a(byte[] byArray, int n2, long l2) {
        LittleEndian.a(byArray, n2, l2, 8);
    }

    public static void a(byte[] byArray, long l2) {
        LittleEndian.a(byArray, 0, l2);
    }

    public static void a(byte[] byArray, int n2, double d10) {
        if (Double.isNaN(d10)) {
            LittleEndian.a(byArray, n2, -276939487313920L, 8);
        } else {
            LittleEndian.a(byArray, n2, Double.doubleToLongBits(d10), 8);
        }
    }

    public static void a(byte[] byArray, double d10) {
        LittleEndian.a(byArray, 0, d10);
    }

    public static short a(InputStream inputStream) throws IOException, BufferUnderrunException {
        return LittleEndian.for(LittleEndian.a(inputStream, 2));
    }

    public static int if(InputStream inputStream) throws IOException, BufferUnderrunException {
        return LittleEndian.int(LittleEndian.a(inputStream, 4));
    }

    public static long do(InputStream inputStream) throws IOException, BufferUnderrunException {
        return LittleEndian.if(LittleEndian.a(inputStream, 8));
    }

    public static byte[] a(InputStream inputStream, int n2) throws IOException, BufferUnderrunException {
        byte[] byArray = new byte[n2];
        int n3 = inputStream.read(byArray);
        if (n3 == -1) {
            Arrays.fill(byArray, (byte)0);
        } else if (n3 != n2) {
            throw new BufferUnderrunException();
        }
        return byArray;
    }

    private static long do(byte[] byArray, int n2, int n3) {
        long l2 = 0L;
        for (int i2 = n2 + n3 - 1; i2 >= n2; --i2) {
            l2 <<= 8;
            l2 |= (long)(0xFF & byArray[i2]);
        }
        return l2;
    }

    private static void a(byte[] byArray, int n2, long l2, int n3) {
        int n4 = n3 + n2;
        long l3 = l2;
        for (int i2 = n2; i2 < n4; ++i2) {
            byArray[i2] = (byte)(l3 & 0xFFL);
            l3 >>= 8;
        }
    }

    public static int a(byte n2) {
        return (n2 & 0x80) == 0 ? n2 : (n2 & 0x7F) + 128;
    }

    public static int if(byte[] byArray, int n2) {
        return (int)LittleEndian.do(byArray, n2, 1);
    }

    public static int a(byte[] byArray) {
        return LittleEndian.if(byArray, 0);
    }

    public static byte[] a(byte[] byArray, int n2, int n3) {
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        return byArray2;
    }

    public static class BufferUnderrunException
    extends IOException {
        BufferUnderrunException() {
            super("buffer underrun");
        }
    }
}

