/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.prompting.objectmodel.common;

import com.businessobjects.lov.ILOVDataSource;
import com.businessobjects.prompting.exceptions.PromptingException;
import com.businessobjects.prompting.internal.IPromptingControllerInterface;
import com.businessobjects.prompting.objectmodel.common.ILOVNetwork;
import com.businessobjects.prompting.objectmodel.common.IPrompt;
import com.businessobjects.prompting.objectmodel.common.PromptObjectType;
import com.crystaldecisions.client.helper.CloneUtil;
import com.crystaldecisions.sdk.occa.report.lib.ControllableMixin;
import com.crystaldecisions.sdk.occa.report.lib.IChange;
import com.crystaldecisions.sdk.occa.report.lib.IControllable;
import com.crystaldecisions.sdk.occa.report.lib.IMemberVisitor;
import com.crystaldecisions.sdk.occa.report.lib.IRepositoryObjectInternal;
import com.crystaldecisions.sdk.occa.report.lib.ReportSDKException;
import com.crystaldecisions.xml.serialization.ClassFactory;
import com.crystaldecisions.xml.serialization.SerializationHelper;
import com.crystaldecisions.xml.serialization.XMLConverter;
import com.crystaldecisions.xml.serialization.XMLSerializationContext;
import com.crystaldecisions.xml.serialization.XMLWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LOVNetwork
implements ILOVNetwork,
IRepositoryObjectInternal,
IControllable {
    private static final String case = "Name";
    private static final String long = "Description";
    private static final String goto = "LOVDS";
    private static final String byte = "Prompt";
    private static final String new = "CUID";
    private static final String int = "EnterpriseURI";
    private static final String try = "Version";
    private final ControllableMixin b = new ControllableMixin(this);
    private UUID do;
    private String for;
    private String void;
    private String if;
    private int else = 0;
    private ILOVDataSource a;
    private List<IPrompt> char = new ArrayList<IPrompt>();

    public LOVNetwork(String string, ILOVDataSource iLOVDataSource, List<IPrompt> list, String string2) {
        this(UUID.randomUUID());
        this.for = string;
        this.a = iLOVDataSource;
        this.if = string2;
        if (list != null) {
            for (IPrompt iPrompt : list) {
                this.addPrompt(iPrompt);
            }
        }
    }

    public LOVNetwork(UUID uUID, String string, String string2, String string3, ILOVDataSource iLOVDataSource, List<IPrompt> list) throws PromptingException.InvalidNetworkException {
        this(uUID);
        this.setName(string);
        this.setEnterpriseURI(string2);
        this.setDescription(string3);
        this.setLOVDataSource(iLOVDataSource);
        this.addPrompts(list);
    }

    private LOVNetwork(UUID uUID) {
        this.do = uUID;
    }

    public LOVNetwork() {
        this(UUID.randomUUID());
    }

    public PromptObjectType getObjectType() {
        return PromptObjectType.LovNetwork;
    }

    @Override
    public String getName() {
        return this.for;
    }

    @Override
    public void setName(final String string) {
        this.b.makeChange(new IChange(){

            public void run() {
                LOVNetwork.this.for = string;
            }
        });
    }

    @Override
    public String getDescription() {
        return this.void;
    }

    @Override
    public void setDescription(final String string) {
        this.b.makeChange(new IChange(){

            public void run() {
                LOVNetwork.this.void = string;
            }
        });
    }

    @Override
    public ILOVDataSource getLOVDataSource() {
        return this.a;
    }

    @Override
    public void setLOVDataSource(final ILOVDataSource iLOVDataSource) {
        this.b.makeChange(new IChange(){

            public void run() {
                LOVNetwork.this.a = iLOVDataSource;
            }
        });
    }

    @Override
    public String getEnterpriseURI() {
        return this.if;
    }

    @Override
    public void setEnterpriseURI(final String string) {
        this.b.makeChange(new IChange(){

            public void run() {
                LOVNetwork.this.if = string;
            }
        });
    }

    @Override
    public void addPrompt(IPrompt iPrompt) {
        try {
            ArrayList<IPrompt> arrayList = new ArrayList<IPrompt>();
            arrayList.add(iPrompt);
            this.addPrompts(arrayList);
        }
        catch (PromptingException.InvalidNetworkException invalidNetworkException) {
            this.char.add(iPrompt);
        }
    }

    @Override
    public void addPrompts(List<IPrompt> list) throws PromptingException.InvalidNetworkException {
        ArrayList<IPrompt> arrayList = new ArrayList<IPrompt>(this.char);
        arrayList.addAll(list);
        if (!this.a(arrayList)) {
            throw new PromptingException.InvalidNetworkException("RCIPROMPT99999999", "InvalidLOVNetwork");
        }
        this.char = arrayList;
    }

    @Override
    public IPrompt removePrompt(UUID uUID) {
        IPrompt iPrompt = this.getPrompt(uUID);
        try {
            ArrayList<IPrompt> arrayList = new ArrayList<IPrompt>();
            arrayList.add(iPrompt);
            this.removePrompts(arrayList);
        }
        catch (PromptingException.InvalidNetworkException invalidNetworkException) {
            this.char.remove(uUID);
        }
        return iPrompt;
    }

    public void removePrompts(List<IPrompt> list) throws PromptingException.InvalidNetworkException {
        ArrayList<IPrompt> arrayList = new ArrayList<IPrompt>(this.char);
        for (IPrompt iPrompt : list) {
            arrayList.remove(iPrompt);
        }
        if (!this.a(arrayList)) {
            throw new PromptingException.InvalidNetworkException("RCIPROMPT99999999", "InvalidLOVNetwork");
        }
        this.char = arrayList;
    }

    @Override
    public IPrompt getPrompt(UUID uUID) {
        for (IPrompt iPrompt : this.char) {
            if (!iPrompt.getUUID().equals(uUID)) continue;
            return iPrompt;
        }
        return null;
    }

    @Override
    public int getNumPrompts() {
        return this.char.size();
    }

    @Override
    public UUID getUUID() {
        return this.do;
    }

    public void setID(UUID uUID) {
        this.do = uUID;
    }

    @Override
    public String getLinkedURI() {
        return this.if;
    }

    @Override
    public void setLinkedURI(String string) {
        this.if = string;
    }

    @Override
    public int getVersion() {
        return this.else;
    }

    @Override
    public void setVersion(int n2) {
        this.else = n2;
    }

    @Override
    public Object createMember(String string, Attributes attributes, XMLSerializationContext xMLSerializationContext, Map<Object, Object> map, boolean[] blArray) {
        Object object = ClassFactory.createObject(attributes, xMLSerializationContext, blArray);
        if (string.equals(byte)) {
            IPrompt iPrompt = (IPrompt)object;
            this.char.add(iPrompt);
        } else if (string.equals(goto)) {
            this.a = (ILOVDataSource)object;
        }
        return object;
    }

    @Override
    public void endElement(String string, Map<Object, Object> map) {
        if (string == null || string.length() == 0) {
            ArrayList<IPrompt> arrayList = new ArrayList<IPrompt>(this.char);
            this.char.clear();
            try {
                this.addPrompts(arrayList);
            }
            catch (PromptingException.InvalidNetworkException invalidNetworkException) {
                throw new IllegalStateException();
            }
        }
    }

    @Override
    public void readElement(String string, String string2, Attributes attributes, Map<Object, Object> map) {
        if (string.equals(case)) {
            this.for = string2;
        } else if (string.equals(long)) {
            this.void = string2;
        } else if (string.equals(int)) {
            this.if = string2;
        } else if (string.equals(new)) {
            this.do = UUID.fromString(string2);
        } else if (string.equals(try)) {
            this.else = XMLConverter.getInt(string2);
        }
    }

    @Override
    public void save(XMLWriter xMLWriter, XMLSerializationContext xMLSerializationContext) throws IOException {
        String string = XMLConverter.getXMLFromClassName(this.getClass().getName());
        Properties properties = SerializationHelper.getHeaderAttributes(string);
        xMLWriter.writeStartElement(string, properties);
        this.saveContents(xMLWriter, xMLSerializationContext);
        xMLWriter.writeEndElement(string);
    }

    @Override
    public void save(XMLWriter xMLWriter, String string, XMLSerializationContext xMLSerializationContext) throws IOException {
        xMLWriter.writeStartObjectElement(string, "2", this, xMLSerializationContext);
        this.saveContents(xMLWriter, xMLSerializationContext);
        xMLWriter.writeEndElement(string);
    }

    @Override
    public void saveContents(XMLWriter xMLWriter, XMLSerializationContext xMLSerializationContext) throws IOException {
        xMLWriter.writeTextElement(case, this.for, null);
        xMLWriter.writeTextElement(long, this.void, null);
        xMLWriter.writeTextElement(new, this.do.toString(), null);
        xMLWriter.writeTextElement(int, this.if, null);
        for (IPrompt iPrompt : this.char) {
            xMLWriter.writeObjectElement(iPrompt, byte, xMLSerializationContext);
        }
        xMLWriter.writeObjectElement(this.a, goto, xMLSerializationContext);
        xMLWriter.writeIntElement(try, this.else, null);
    }

    @Override
    public void startElement(String string, Map<Object, Object> map, Attributes attributes) {
    }

    @Override
    public boolean isHierarchical() {
        if (!this.isValid()) {
            return false;
        }
        HashSet<UUID> hashSet = new HashSet<UUID>();
        Map map = new HashMap();
        try {
            map = PromptNode.if(this.char);
        }
        catch (PromptingException.InvalidNetworkException invalidNetworkException) {
            return false;
        }
        for (PromptNode promptNode : map.values()) {
            List<UUID> list = promptNode.if().getRequiredPromptCUIDs();
            if (list == null) continue;
            if (list.size() > 1) {
                return false;
            }
            for (UUID uUID : list) {
                if (hashSet.add(uUID)) continue;
                return false;
            }
        }
        return hashSet.size() == this.char.size() - 1;
    }

    @Override
    public List<IPrompt> getAllPrompts() {
        try {
            return Collections.unmodifiableList(PromptNode.a(this.char));
        }
        catch (PromptingException.InvalidNetworkException invalidNetworkException) {
            return Collections.unmodifiableList(this.char);
        }
    }

    @Override
    public boolean isValid() {
        return this.a(this.char);
    }

    private boolean a(List<IPrompt> list) {
        try {
            PromptNode.a(list);
        }
        catch (PromptingException.InvalidNetworkException invalidNetworkException) {
            return false;
        }
        return true;
    }

    @Override
    public void resetPromptChildren(IPrompt iPrompt) {
        Map map = new HashMap();
        try {
            map = PromptNode.if(this.char);
        }
        catch (PromptingException.InvalidNetworkException invalidNetworkException) {
            for (IPrompt iPrompt2 : this.char) {
                if (!iPrompt2.getRequiredPromptCUIDs().contains(iPrompt.getUUID())) continue;
                iPrompt2.getValues().clear();
                this.resetPromptChildren(iPrompt2);
            }
            return;
        }
        PromptNode promptNode = (PromptNode)map.get(iPrompt.getUUID());
        if (promptNode.a() == null) {
            return;
        }
        for (PromptNode promptNode2 : promptNode.a()) {
            IPrompt iPrompt3 = promptNode2.if();
            iPrompt3.getValues().clear();
            this.resetPromptChildren(iPrompt3);
        }
    }

    @Override
    public Object clone(boolean bl2) {
        LOVNetwork lOVNetwork = new LOVNetwork(this.do);
        this.copyTo(lOVNetwork, bl2);
        return lOVNetwork;
    }

    public ILOVNetwork cloneWithoutID(boolean bl2) {
        LOVNetwork lOVNetwork = new LOVNetwork();
        this.copyTo(lOVNetwork, bl2);
        return lOVNetwork;
    }

    @Override
    public void copyTo(Object object, boolean bl2) {
        LOVNetwork lOVNetwork = (LOVNetwork)object;
        lOVNetwork.for = this.for;
        lOVNetwork.a = this.a != null && bl2 ? (ILOVDataSource)this.a.clone(bl2) : this.a;
        if (bl2) {
            for (IPrompt iPrompt : this.char) {
                lOVNetwork.char.add((IPrompt)iPrompt.clone(bl2));
            }
        } else {
            lOVNetwork.char = this.char;
        }
        lOVNetwork.if = this.if;
        lOVNetwork.else = this.else;
        lOVNetwork.void = this.void;
    }

    @Override
    public boolean hasContent(Object object) {
        if (!(object instanceof LOVNetwork)) {
            return false;
        }
        LOVNetwork lOVNetwork = (LOVNetwork)object;
        if (!CloneUtil.equalStrings(this.for, lOVNetwork.for)) {
            return false;
        }
        if (!CloneUtil.hasContent(this.a, lOVNetwork.a)) {
            return false;
        }
        if (!CloneUtil.equalObjects(this.do, lOVNetwork.do)) {
            return false;
        }
        if (!CloneUtil.equalStrings(this.if, lOVNetwork.if)) {
            return false;
        }
        if (this.char.size() != lOVNetwork.char.size()) {
            return false;
        }
        for (IPrompt iPrompt : this.char) {
            IPrompt iPrompt2 = lOVNetwork.getPrompt(iPrompt.getUUID());
            if (iPrompt2 == null) {
                return false;
            }
            if (CloneUtil.hasContent(iPrompt, iPrompt2)) continue;
            return false;
        }
        if (this.else != lOVNetwork.else) {
            return false;
        }
        return CloneUtil.equalStrings(this.void, lOVNetwork.void);
    }

    @Override
    public void disconnect() {
    }

    @Override
    public boolean isConnected() {
        return this.if != null && this.if.trim().length() != 0;
    }

    @Override
    public void doControllerModification(Object object) throws ReportSDKException {
        ILOVNetwork iLOVNetwork = (ILOVNetwork)object;
        IPromptingControllerInterface iPromptingControllerInterface = (IPromptingControllerInterface)((Object)this.b.getControllerInterface());
        iPromptingControllerInterface.getLOVNetworkController().modify(this, iLOVNetwork);
    }

    @Override
    public void enumerateMembers(IMemberVisitor iMemberVisitor) {
        this.a = iMemberVisitor.visit(this.a, false);
    }

    @Override
    public void refresh() {
    }

    @Override
    public ControllableMixin getControllableMixin() {
        return this.b;
    }

    @Override
    public boolean isDirectlyControllable() {
        return true;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PromptNode {
        IPrompt nodePrompt;
        Map<UUID, PromptNode> childNodes = new HashMap<UUID, PromptNode>();
        PromptState state = PromptState.unvisited;

        private static List<IPrompt> a(List<IPrompt> list) throws PromptingException.InvalidNetworkException {
            Map<UUID, PromptNode> map = PromptNode.if(list);
            LinkedList<IPrompt> linkedList = new LinkedList<IPrompt>();
            for (int i2 = list.size() - 1; i2 >= 0; --i2) {
                IPrompt iPrompt = list.get(i2);
                PromptNode promptNode = map.get(iPrompt.getUUID());
                if (promptNode.state != PromptState.unvisited) continue;
                promptNode.do(linkedList);
            }
            return linkedList;
        }

        private static Map<UUID, PromptNode> if(List<IPrompt> list) throws PromptingException.InvalidNetworkException {
            HashMap<UUID, PromptNode> hashMap = new HashMap<UUID, PromptNode>();
            for (IPrompt object : list) {
                PromptNode promptNode = new PromptNode(object);
                hashMap.put(object.getUUID(), promptNode);
            }
            for (PromptNode promptNode : hashMap.values()) {
                for (UUID uUID : promptNode.if().getRequiredPromptCUIDs()) {
                    PromptNode promptNode2 = (PromptNode)hashMap.get(uUID);
                    if (promptNode2 == null) {
                        throw new PromptingException.InvalidNetworkException("RCIPROMPT99999999", "InvalidLOVNetwork");
                    }
                    promptNode2.a(promptNode);
                }
            }
            return hashMap;
        }

        PromptNode(IPrompt iPrompt) {
            this.nodePrompt = iPrompt;
        }

        private void do(List<IPrompt> list) throws PromptingException.InvalidNetworkException {
            this.state = PromptState.inProgress;
            for (PromptNode promptNode : this.childNodes.values()) {
                if (promptNode.state == PromptState.unvisited) {
                    promptNode.do(list);
                    continue;
                }
                if (promptNode.state != PromptState.inProgress) continue;
                throw new PromptingException.InvalidNetworkException("RCIPROMPT99999999", "InvalidLOVNetwork");
            }
            this.state = PromptState.finished;
            list.add(0, this.nodePrompt);
        }

        private void a(PromptNode promptNode) {
            this.childNodes.put(promptNode.if().getUUID(), promptNode);
        }

        boolean contains(PromptNode promptNode) {
            return this.childNodes.containsValue(promptNode);
        }

        PromptNode fetchNodeByID(UUID uUID) {
            if (this.nodePrompt.getUUID().equals(uUID)) {
                return this;
            }
            for (PromptNode promptNode : this.childNodes.values()) {
                PromptNode promptNode2 = promptNode.fetchNodeByID(uUID);
                if (promptNode2 == null) continue;
                return promptNode2;
            }
            return null;
        }

        private IPrompt if() {
            return this.nodePrompt;
        }

        private Collection<PromptNode> a() {
            return Collections.unmodifiableCollection(this.childNodes.values());
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum PromptState {
            unvisited,
            inProgress,
            finished;

        }
    }
}

