/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.VarnumAccessor;

class T4CVarnumAccessor
extends VarnumAccessor {
    T4CMAREngine mare;
    boolean underlyingLongRaw = false;
    final int[] meta = new int[1];
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    T4CVarnumAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean forBind, T4CMAREngine _mare) throws SQLException {
        super(stmt, max_len, form, external_type, forBind);
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CVarnumAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(external_type) + ", " + OracleLog.argument(forBind) + ", " + OracleLog.argument(_mare));
                    Object var8_7 = null;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.mare = _mare;
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CVarnumAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var12_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var12_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T4CVarnumAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var12_12 = null;
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    T4CVarnumAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, int contflag, int total_elems, short form, int _definedColumnType, int _definedColumnSize, T4CMAREngine _mare) throws SQLException {
        super(stmt, max_len == -1 ? _definedColumnSize : max_len, nullable, flags, precision, scale, contflag, total_elems, form);
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CVarnumAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(nullable) + ", " + OracleLog.argument(flags) + ", " + OracleLog.argument(precision) + ", " + OracleLog.argument(scale) + ", " + OracleLog.argument(contflag) + ", " + OracleLog.argument(total_elems) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(_definedColumnType) + ", " + OracleLog.argument(_definedColumnSize) + ", " + OracleLog.argument(_mare));
                    Object var14_13 = null;
                }
                catch (Throwable throwable) {
                    Object var14_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.mare = _mare;
            if (stmt != null && stmt.implicitDefineForLobPrefetchDone) {
                this.definedColumnType = 0;
                this.definedColumnSize = 0;
            } else {
                this.definedColumnType = _definedColumnType;
                this.definedColumnSize = _definedColumnSize;
            }
            if (max_len == -1) {
                this.underlyingLongRaw = true;
            }
            Object var16_16 = null;
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CVarnumAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var18_20 = null;
                }
                catch (Throwable throwable2) {
                    Object var18_21 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T4CVarnumAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var18_18 = null;
            }
            catch (Throwable throwable) {
                Object var18_19 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    void processIndicator(int size) throws IOException, SQLException {
        if (this.internalType == 1 && this.describeType == 112 || this.internalType == 23 && this.describeType == 113) {
            this.mare.unmarshalUB2();
            this.mare.unmarshalUB2();
        } else if (this.statement.connection.versionNumber < 9200) {
            this.mare.unmarshalSB2();
            if (!this.statement.sqlKind.isPlsqlOrCall()) {
                this.mare.unmarshalSB2();
            }
        } else if (this.statement.sqlKind.isPlsqlOrCall() || this.isDMLReturnedParam) {
            this.mare.processIndicator(size <= 0, size);
        }
    }

    boolean unmarshalOneRow() throws SQLException, IOException {
        if (this.isUseLess) {
            ++this.lastRowProcessed;
            return false;
        }
        if (this.rowSpaceIndicator == null) {
            byte[] buff = new byte[16000];
            this.mare.unmarshalCLR(buff, 0, this.meta);
            this.processIndicator(this.meta[0]);
            ++this.lastRowProcessed;
            return false;
        }
        int tmpIndicatorOffset = this.indicatorIndex + this.lastRowProcessed;
        int tmpLengthOffset = this.lengthIndex + this.lastRowProcessed;
        if (this.isNullByDescribe) {
            this.rowSpaceIndicator[tmpIndicatorOffset] = -1;
            this.rowSpaceIndicator[tmpLengthOffset] = 0;
            ++this.lastRowProcessed;
            if (this.statement.connection.versionNumber < 9200) {
                this.processIndicator(0);
            }
            return false;
        }
        int tmpSpaceByteOffset = this.columnIndex + this.lastRowProcessed * this.byteLength;
        this.mare.unmarshalCLR(this.rowSpaceByte, tmpSpaceByteOffset + 1, this.meta, this.byteLength - 1);
        this.rowSpaceByte[tmpSpaceByteOffset] = (byte)this.meta[0];
        this.processIndicator(this.meta[0]);
        if (this.meta[0] == 0) {
            this.rowSpaceIndicator[tmpIndicatorOffset] = -1;
            this.rowSpaceIndicator[tmpLengthOffset] = 0;
        } else {
            this.rowSpaceIndicator[tmpLengthOffset] = (short)this.meta[0];
            this.rowSpaceIndicator[tmpIndicatorOffset] = 0;
        }
        ++this.lastRowProcessed;
        return false;
    }

    void copyRow() throws SQLException, IOException {
        int lastRowOffset = this.lastRowProcessed == 0 ? this.statement.rowPrefetchInLastFetch - 1 : this.lastRowProcessed - 1;
        int tmpSpaceByteOffset = this.columnIndex + this.lastRowProcessed * this.byteLength;
        int tmpSpaceByteOffsetLastRow = this.columnIndex + lastRowOffset * this.byteLength;
        int tmpIndicatorOffset = this.indicatorIndex + this.lastRowProcessed;
        int tmpIndicatorOffsetLastRow = this.indicatorIndex + lastRowOffset;
        int tmpLengthOffset = this.lengthIndex + this.lastRowProcessed;
        int tmpLengthOffsetLastRow = this.lengthIndex + lastRowOffset;
        short nbBytes = this.rowSpaceIndicator[tmpLengthOffsetLastRow];
        int indexmetadata = this.metaDataIndex + this.lastRowProcessed * 1;
        int indexmetadataLastRow = this.metaDataIndex + lastRowOffset * 1;
        this.rowSpaceIndicator[tmpLengthOffset] = nbBytes;
        this.rowSpaceIndicator[tmpIndicatorOffset] = this.rowSpaceIndicator[tmpIndicatorOffsetLastRow];
        if (!this.isNullByDescribe) {
            System.arraycopy(this.rowSpaceByte, tmpSpaceByteOffsetLastRow, this.rowSpaceByte, tmpSpaceByteOffset, nbBytes + 1);
        }
        System.arraycopy(this.rowSpaceMetaData, indexmetadataLastRow, this.rowSpaceMetaData, indexmetadata, 1);
        ++this.lastRowProcessed;
    }

    void saveDataFromOldDefineBuffers(byte[] rowSpaceByteLastRow, char[] rowSpaceCharLastRow, short[] rowSpaceIndicatorLastRow, int oldPrefetchSize, int newPrefetchSize) throws SQLException {
        int tmpSpaceByteOffset = this.columnIndex + (newPrefetchSize - 1) * this.byteLength;
        int tmpSpaceByteOffsetLastRow = this.columnIndexLastRow + (oldPrefetchSize - 1) * this.byteLength;
        int tmpIndicatorOffset = this.indicatorIndex + newPrefetchSize - 1;
        int tmpIndicatorOffsetLastRow = this.indicatorIndexLastRow + oldPrefetchSize - 1;
        int tmpLengthOffset = this.lengthIndex + newPrefetchSize - 1;
        int tmpLengthOffsetLastRow = this.lengthIndexLastRow + oldPrefetchSize - 1;
        short nbBytes = rowSpaceIndicatorLastRow[tmpLengthOffsetLastRow];
        this.rowSpaceIndicator[tmpLengthOffset] = nbBytes;
        this.rowSpaceIndicator[tmpIndicatorOffset] = rowSpaceIndicatorLastRow[tmpIndicatorOffsetLastRow];
        if (nbBytes != 0) {
            System.arraycopy(rowSpaceByteLastRow, tmpSpaceByteOffsetLastRow, this.rowSpaceByte, tmpSpaceByteOffset, nbBytes + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getString(int currentRow) throws SQLException {
        String string;
        try {
            String ret;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CVarnumAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                    string = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if ((ret = super.getString(currentRow)) != null && this.definedColumnSize > 0 && ret.length() > this.definedColumnSize) {
                ret = ret.substring(0, this.definedColumnSize);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CVarnumAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            string = ret;
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CVarnumAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T4CVarnumAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    Object getObject(int currentRow) throws SQLException {
        Object var3_2;
        try {
            SQLException __ex__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CVarnumAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                    var3_2 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if (this.definedColumnType == 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CVarnumAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + super.getObject(currentRow));
                        Object var5_7 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var5_8 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                Object object = super.getObject(currentRow);
                Object var39_23 = null;
                if (!TRACE) return object;
                if (!OracleLog.recursiveEnter()) return object;
                try {
                    T4CVarnumAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var41_39 = null;
                    OracleLog.recursiveExit();
                    return object;
                }
                catch (Throwable throwable) {
                    Object var41_40 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            Object result = null;
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CVarnumAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                        Object var7_87 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var7_88 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
                switch (this.definedColumnType) {
                    case -1: 
                    case 1: 
                    case 12: {
                        Object __result__ = this.getString(currentRow);
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T4CVarnumAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                                Object var9_90 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                Object var9_91 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                        Object object = __result__;
                        Object var39_24 = null;
                        if (!TRACE) return object;
                        if (!OracleLog.recursiveEnter()) return object;
                        try {}
                        catch (Throwable throwable) {
                            Object var41_42 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        T4CVarnumAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var41_41 = null;
                        OracleLog.recursiveExit();
                        return object;
                    }
                    case 2: 
                    case 3: {
                        Object __result__ = this.getBigDecimal(currentRow);
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T4CVarnumAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                                Object var11_93 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                Object var11_94 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                        Object object = __result__;
                        Object var39_25 = null;
                        if (!TRACE) return object;
                        if (!OracleLog.recursiveEnter()) return object;
                        try {}
                        catch (Throwable throwable) {
                            Object var41_44 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        T4CVarnumAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var41_43 = null;
                        OracleLog.recursiveExit();
                        return object;
                    }
                    case 4: {
                        Object __result__ = this.getInt(currentRow);
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T4CVarnumAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                                Object var13_96 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                Object var13_97 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                        Object object = __result__;
                        Object var39_26 = null;
                        if (!TRACE) return object;
                        if (!OracleLog.recursiveEnter()) return object;
                        try {}
                        catch (Throwable throwable) {
                            Object var41_46 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        T4CVarnumAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var41_45 = null;
                        OracleLog.recursiveExit();
                        return object;
                    }
                    case -6: {
                        Object __result__ = this.getByte(currentRow);
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T4CVarnumAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                                Object var15_99 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                Object var15_100 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                        Object object = __result__;
                        Object var39_27 = null;
                        if (!TRACE) return object;
                        if (!OracleLog.recursiveEnter()) return object;
                        try {}
                        catch (Throwable throwable) {
                            Object var41_48 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        T4CVarnumAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var41_47 = null;
                        OracleLog.recursiveExit();
                        return object;
                    }
                    case 5: {
                        Object __result__ = this.getShort(currentRow);
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T4CVarnumAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                                Object var17_102 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                Object var17_103 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                        Object object = __result__;
                        Object var39_28 = null;
                        if (!TRACE) return object;
                        if (!OracleLog.recursiveEnter()) return object;
                        try {}
                        catch (Throwable throwable) {
                            Object var41_50 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        T4CVarnumAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var41_49 = null;
                        OracleLog.recursiveExit();
                        return object;
                    }
                    case -7: 
                    case 16: {
                        Object __result__ = this.getBoolean(currentRow);
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T4CVarnumAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                                Object var19_105 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                Object var19_106 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                        Object object = __result__;
                        Object var39_29 = null;
                        if (!TRACE) return object;
                        if (!OracleLog.recursiveEnter()) return object;
                        try {}
                        catch (Throwable throwable) {
                            Object var41_52 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        T4CVarnumAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var41_51 = null;
                        OracleLog.recursiveExit();
                        return object;
                    }
                    case -5: {
                        Object __result__ = this.getLong(currentRow);
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T4CVarnumAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                                Object var21_108 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                Object var21_109 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                        Object object = __result__;
                        Object var39_30 = null;
                        if (!TRACE) return object;
                        if (!OracleLog.recursiveEnter()) return object;
                        try {}
                        catch (Throwable throwable) {
                            Object var41_54 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        T4CVarnumAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var41_53 = null;
                        OracleLog.recursiveExit();
                        return object;
                    }
                    case 7: {
                        Object __result__ = Float.valueOf(this.getFloat(currentRow));
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T4CVarnumAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                                Object var23_111 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                Object var23_112 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                        Object object = __result__;
                        Object var39_31 = null;
                        if (!TRACE) return object;
                        if (!OracleLog.recursiveEnter()) return object;
                        try {}
                        catch (Throwable throwable) {
                            Object var41_56 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        T4CVarnumAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var41_55 = null;
                        OracleLog.recursiveExit();
                        return object;
                    }
                    case 6: 
                    case 8: {
                        Object __result__ = this.getDouble(currentRow);
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T4CVarnumAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                                Object var25_114 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                Object var25_115 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                        Object object = __result__;
                        Object var39_32 = null;
                        if (!TRACE) return object;
                        if (!OracleLog.recursiveEnter()) return object;
                        try {}
                        catch (Throwable throwable) {
                            Object var41_58 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        T4CVarnumAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var41_57 = null;
                        OracleLog.recursiveExit();
                        return object;
                    }
                    case 91: {
                        Object __result__ = this.getDate(currentRow);
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T4CVarnumAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                                Object var27_117 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                Object var27_118 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                        Object object = __result__;
                        Object var39_33 = null;
                        if (!TRACE) return object;
                        if (!OracleLog.recursiveEnter()) return object;
                        try {}
                        catch (Throwable throwable) {
                            Object var41_60 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        T4CVarnumAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var41_59 = null;
                        OracleLog.recursiveExit();
                        return object;
                    }
                    case 92: {
                        Object __result__ = this.getTime(currentRow);
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T4CVarnumAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                                Object var29_120 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                Object var29_121 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                        Object object = __result__;
                        Object var39_34 = null;
                        if (!TRACE) return object;
                        if (!OracleLog.recursiveEnter()) return object;
                        try {}
                        catch (Throwable throwable) {
                            Object var41_62 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        T4CVarnumAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var41_61 = null;
                        OracleLog.recursiveExit();
                        return object;
                    }
                    case 93: {
                        Object __result__ = this.getTimestamp(currentRow);
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T4CVarnumAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                                Object var31_123 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                Object var31_124 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                        Object object = __result__;
                        Object var39_35 = null;
                        if (!TRACE) return object;
                        if (!OracleLog.recursiveEnter()) return object;
                        try {}
                        catch (Throwable throwable) {
                            Object var41_64 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        T4CVarnumAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var41_63 = null;
                        OracleLog.recursiveExit();
                        return object;
                    }
                    case -4: 
                    case -3: 
                    case -2: {
                        Object __result__ = this.getBytes(currentRow);
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T4CVarnumAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                                Object var33_126 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                Object var33_127 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                        Object object = __result__;
                        Object var39_36 = null;
                        if (!TRACE) return object;
                        if (!OracleLog.recursiveEnter()) return object;
                        try {}
                        catch (Throwable throwable) {
                            Object var41_66 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        T4CVarnumAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var41_65 = null;
                        OracleLog.recursiveExit();
                        return object;
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CVarnumAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4);
                        Object var35_129 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var35_130 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CVarnumAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                    Object var37_132 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var37_133 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            var3_2 = result;
            Object var39_37 = null;
            if (!TRACE) return var3_2;
        }
        catch (Throwable throwable) {
            Object var39_38 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var41_70 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            T4CVarnumAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var41_69 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return var3_2;
        try {}
        catch (Throwable throwable) {
            Object var41_68 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        T4CVarnumAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
        Object var41_67 = null;
        OracleLog.recursiveExit();
        return var3_2;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CVarnumAccessor"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

