/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.RowidAccessor;
import oracle.jdbc.driver.T4CMAREngine;

class T4CRowidAccessor
extends RowidAccessor {
    T4CMAREngine mare;
    static final int maxLength = 128;
    final int[] meta = new int[1];
    static final int KGRD_EXTENDED_OBJECT = 6;
    static final int KGRD_EXTENDED_BLOCK = 6;
    static final int KGRD_EXTENDED_FILE = 3;
    static final int KGRD_EXTENDED_SLOT = 3;
    static final int kd4_ubridtype_physical = 1;
    static final int kd4_ubridtype_logical = 2;
    static final int kd4_ubridtype_remote = 3;
    static final int kd4_ubridtype_exttab = 4;
    static final int kd4_ubridtype_future2 = 5;
    static final int kd4_ubridtype_max = 5;
    static final int kd4_ubridlen_typeind = 1;
    static final byte[] kgrd_indbyte_char = new byte[]{65, 42, 45, 40, 41};
    static final byte[] kgrd_basis_64 = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    static final byte[] kgrd_index_64 = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1};
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    T4CRowidAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean forBind, T4CMAREngine _mare) throws SQLException {
        super(stmt, max_len, form, external_type, forBind);
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CRowidAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(external_type) + ", " + OracleLog.argument(forBind) + ", " + OracleLog.argument(_mare));
                    Object var8_7 = null;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.mare = _mare;
            this.defineType = 104;
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CRowidAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var12_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var12_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T4CRowidAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var12_12 = null;
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    T4CRowidAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, int contflag, int total_elems, short form, int _definedColumnType, int _definedColumnSize, T4CMAREngine _mare) throws SQLException {
        super(stmt, max_len, nullable, flags, precision, scale, contflag, total_elems, form);
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CRowidAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(nullable) + ", " + OracleLog.argument(flags) + ", " + OracleLog.argument(precision) + ", " + OracleLog.argument(scale) + ", " + OracleLog.argument(contflag) + ", " + OracleLog.argument(total_elems) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(_definedColumnType) + ", " + OracleLog.argument(_definedColumnSize) + ", " + OracleLog.argument(_mare));
                    Object var14_13 = null;
                }
                catch (Throwable throwable) {
                    Object var14_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.mare = _mare;
            this.definedColumnType = _definedColumnType;
            this.definedColumnSize = _definedColumnSize;
            this.defineType = 104;
            Object var16_16 = null;
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CRowidAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var18_20 = null;
                }
                catch (Throwable throwable2) {
                    Object var18_21 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T4CRowidAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var18_18 = null;
            }
            catch (Throwable throwable) {
                Object var18_19 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    void processIndicator(int size) throws IOException, SQLException {
        if (this.internalType == 1 && this.describeType == 112 || this.internalType == 23 && this.describeType == 113) {
            this.mare.unmarshalUB2();
            this.mare.unmarshalUB2();
        } else if (this.statement.connection.versionNumber < 9200) {
            this.mare.unmarshalSB2();
            if (!this.statement.sqlKind.isPlsqlOrCall()) {
                this.mare.unmarshalSB2();
            }
        } else if (this.statement.sqlKind.isPlsqlOrCall() || this.isDMLReturnedParam) {
            this.mare.processIndicator(size <= 0, size);
        }
    }

    boolean unmarshalOneRow() throws SQLException, IOException {
        if (this.isUseLess) {
            ++this.lastRowProcessed;
            return false;
        }
        if (this.rowSpaceIndicator == null) {
            short len = this.mare.unmarshalUB1();
            long rba = 0L;
            int partitionID = 0;
            short tableID = 0;
            long blockNumber = 0L;
            int slotNumber = 0;
            if (len > 0) {
                rba = this.mare.unmarshalUB4();
                partitionID = this.mare.unmarshalUB2();
                tableID = this.mare.unmarshalUB1();
                blockNumber = this.mare.unmarshalUB4();
                slotNumber = this.mare.unmarshalUB2();
            }
            this.processIndicator(this.meta[0]);
            ++this.lastRowProcessed;
            return false;
        }
        int tmpIndicatorOffset = this.indicatorIndex + this.lastRowProcessed;
        int tmpLengthOffset = this.lengthIndex + this.lastRowProcessed;
        if (this.isNullByDescribe) {
            this.rowSpaceIndicator[tmpIndicatorOffset] = -1;
            this.rowSpaceIndicator[tmpLengthOffset] = 0;
            ++this.lastRowProcessed;
            if (this.statement.connection.versionNumber < 9200) {
                this.processIndicator(0);
            }
            return false;
        }
        int tmpSpaceByteOffset = this.columnIndex + this.lastRowProcessed * this.byteLength;
        if (this.describeType != 208) {
            short len = this.mare.unmarshalUB1();
            long rba = 0L;
            int partitionID = 0;
            short tableID = 0;
            long blockNumber = 0L;
            int slotNumber = 0;
            if (len > 0) {
                rba = this.mare.unmarshalUB4();
                partitionID = this.mare.unmarshalUB2();
                tableID = this.mare.unmarshalUB1();
                blockNumber = this.mare.unmarshalUB4();
                slotNumber = this.mare.unmarshalUB2();
            }
            if (rba == 0L && partitionID == 0 && tableID == 0 && blockNumber == 0L && slotNumber == 0) {
                this.meta[0] = 0;
            } else {
                long[] args = new long[]{rba, partitionID, blockNumber, slotNumber};
                byte[] base64format = T4CRowidAccessor.rowidToString(args);
                int nbBytesToKeep = 18;
                if (this.byteLength - 2 < 18) {
                    nbBytesToKeep = this.byteLength - 2;
                }
                System.arraycopy(base64format, 0, this.rowSpaceByte, tmpSpaceByteOffset + 2, nbBytesToKeep);
                this.meta[0] = nbBytesToKeep;
            }
        } else {
            this.meta[0] = (int)this.mare.unmarshalUB4();
            if (this.meta[0] > 0) {
                byte[] b2 = new byte[this.meta[0]];
                this.mare.unmarshalCLR(b2, 0, this.meta);
                this.meta[0] = T4CRowidAccessor.kgrdub2c(b2, this.meta[0], 0, this.rowSpaceByte, tmpSpaceByteOffset + 2);
            }
        }
        this.rowSpaceByte[tmpSpaceByteOffset] = (byte)((this.meta[0] & 0xFF00) >> 8);
        this.rowSpaceByte[tmpSpaceByteOffset + 1] = (byte)(this.meta[0] & 0xFF);
        this.processIndicator(this.meta[0]);
        if (this.meta[0] == 0) {
            this.rowSpaceIndicator[tmpIndicatorOffset] = -1;
            this.rowSpaceIndicator[tmpLengthOffset] = 0;
        } else {
            this.rowSpaceIndicator[tmpLengthOffset] = (short)this.meta[0];
            this.rowSpaceIndicator[tmpIndicatorOffset] = 0;
        }
        ++this.lastRowProcessed;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String getString(int currentRow) throws SQLException {
        String string;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CRowidAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                    string = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            String result = null;
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CRowidAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                        Object var5_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_8 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
                int off = this.columnIndex + this.byteLength * currentRow;
                short len = this.rowSpaceIndicator[this.lengthIndex + currentRow];
                if (this.describeType != 208 || this.rowSpaceByte[off] == 1) {
                    result = new String(this.rowSpaceByte, off + 2, (int)len);
                    long[] result1 = T4CRowidAccessor.stringToRowid(result.getBytes(), 0, result.length());
                    result = new String(T4CRowidAccessor.rowidToString(result1));
                } else {
                    result = new String(this.rowSpaceByte, off + 2, (int)len);
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CRowidAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                    Object var7_12 = null;
                }
                catch (Throwable throwable) {
                    Object var7_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            string = result;
            Object var9_15 = null;
            if (!TRACE) return string;
        }
        catch (Throwable throwable) {
            Object var9_16 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                T4CRowidAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_19 = null;
            }
            catch (Throwable throwable2) {
                Object var11_20 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return string;
        try {
            T4CRowidAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var11_17 = null;
        }
        catch (Throwable throwable) {
            Object var11_18 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    Object getObject(int currentRow) throws SQLException {
        Object var3_2;
        try {
            Object __ex__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CRowidAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                    var3_2 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if (this.definedColumnType == 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CRowidAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + super.getObject(currentRow));
                        Object var5_7 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var5_8 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                Object object = super.getObject(currentRow);
                Object var13_10 = null;
                if (!TRACE) return object;
                if (!OracleLog.recursiveEnter()) return object;
                try {
                    T4CRowidAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var15_15 = null;
                    OracleLog.recursiveExit();
                    return object;
                }
                catch (Throwable throwable) {
                    Object var15_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            Object result = null;
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CRowidAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                        Object var7_30 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var7_31 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                ((Throwable)__ex__).fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
                switch (this.definedColumnType) {
                    case -1: 
                    case 1: 
                    case 12: {
                        __ex__ = this.getString(currentRow);
                        Object var13_11 = null;
                        if (!TRACE) return __ex__;
                        if (!OracleLog.recursiveEnter()) return __ex__;
                        try {}
                        catch (Throwable throwable) {
                            Object var15_18 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        T4CRowidAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var15_17 = null;
                        OracleLog.recursiveExit();
                        return __ex__;
                    }
                    case -8: {
                        __ex__ = this.getROWID(currentRow);
                        Object var13_12 = null;
                        if (!TRACE) return __ex__;
                        if (!OracleLog.recursiveEnter()) return __ex__;
                        try {}
                        catch (Throwable throwable) {
                            Object var15_20 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        T4CRowidAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var15_19 = null;
                        OracleLog.recursiveExit();
                        return __ex__;
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CRowidAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4);
                        Object var9_33 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var9_34 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
                ((Throwable)__ex__).fillInStackTrace();
                throw __ex__;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CRowidAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                    Object var11_36 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var11_37 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            var3_2 = result;
            Object var13_13 = null;
            if (!TRACE) return var3_2;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var15_24 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            T4CRowidAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var15_23 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return var3_2;
        try {}
        catch (Throwable throwable) {
            Object var15_22 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        T4CRowidAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
        Object var15_21 = null;
        OracleLog.recursiveExit();
        return var3_2;
    }

    void copyRow() throws SQLException, IOException {
        int lastRowOffset = this.lastRowProcessed == 0 ? this.statement.rowPrefetchInLastFetch - 1 : this.lastRowProcessed - 1;
        int tmpSpaceByteOffset = this.columnIndex + this.lastRowProcessed * this.byteLength;
        int tmpSpaceByteOffsetLastRow = this.columnIndex + lastRowOffset * this.byteLength;
        int tmpIndicatorOffset = this.indicatorIndex + this.lastRowProcessed;
        int tmpIndicatorOffsetLastRow = this.indicatorIndex + lastRowOffset;
        int tmpLengthOffset = this.lengthIndex + this.lastRowProcessed;
        int tmpLengthOffsetLastRow = this.lengthIndex + lastRowOffset;
        short nbBytes = this.rowSpaceIndicator[tmpLengthOffsetLastRow];
        int indexmetadata = this.metaDataIndex + this.lastRowProcessed * 1;
        int indexmetadataLastRow = this.metaDataIndex + lastRowOffset * 1;
        this.rowSpaceIndicator[tmpLengthOffset] = nbBytes;
        this.rowSpaceIndicator[tmpIndicatorOffset] = this.rowSpaceIndicator[tmpIndicatorOffsetLastRow];
        System.arraycopy(this.rowSpaceByte, tmpSpaceByteOffsetLastRow, this.rowSpaceByte, tmpSpaceByteOffset, nbBytes + 2);
        System.arraycopy(this.rowSpaceMetaData, indexmetadataLastRow, this.rowSpaceMetaData, indexmetadata, 1);
        ++this.lastRowProcessed;
    }

    void saveDataFromOldDefineBuffers(byte[] rowSpaceByteLastRow, char[] rowSpaceCharLastRow, short[] rowSpaceIndicatorLastRow, int oldPrefetchSize, int newPrefetchSize) throws SQLException {
        int tmpSpaceByteOffset = this.columnIndex + (newPrefetchSize - 1) * this.byteLength;
        int tmpSpaceByteOffsetLastRow = this.columnIndexLastRow + (oldPrefetchSize - 1) * this.byteLength;
        int tmpIndicatorOffset = this.indicatorIndex + newPrefetchSize - 1;
        int tmpIndicatorOffsetLastRow = this.indicatorIndexLastRow + oldPrefetchSize - 1;
        int tmpLengthOffset = this.lengthIndex + newPrefetchSize - 1;
        int tmpLengthOffsetLastRow = this.lengthIndexLastRow + oldPrefetchSize - 1;
        short nbBytes = rowSpaceIndicatorLastRow[tmpLengthOffsetLastRow];
        this.rowSpaceIndicator[tmpLengthOffset] = nbBytes;
        this.rowSpaceIndicator[tmpIndicatorOffset] = rowSpaceIndicatorLastRow[tmpIndicatorOffsetLastRow];
        if (nbBytes != 0) {
            System.arraycopy(rowSpaceByteLastRow, tmpSpaceByteOffsetLastRow, this.rowSpaceByte, tmpSpaceByteOffset, nbBytes + 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final byte[] rowidToString(long[] rowid) {
        byte[] byArray;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CRowidAccessor.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(rowid));
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            long rba = rowid[0];
            long tidpid = rowid[1];
            long ridrba = rowid[2];
            long ridsqn = rowid[3];
            int size = 18;
            byte[] ret = new byte[size];
            int offset = 0;
            offset = T4CRowidAccessor.kgrd42b(ret, rba, 6, offset);
            offset = T4CRowidAccessor.kgrd42b(ret, tidpid, 3, offset);
            offset = T4CRowidAccessor.kgrd42b(ret, ridrba, 6, offset);
            offset = T4CRowidAccessor.kgrd42b(ret, ridsqn, 3, offset);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CRowidAccessor.logger().log(Level.FINER, "         Return: " + ret);
                    Object var13_11 = null;
                }
                catch (Throwable throwable) {
                    Object var13_12 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            byArray = ret;
            Object var15_15 = null;
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CRowidAccessor.logger().log(Level.FINER, "         Exit");
                    Object var17_19 = null;
                }
                catch (Throwable throwable2) {
                    Object var17_20 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T4CRowidAccessor.logger().log(Level.FINER, "         Exit");
                Object var17_17 = null;
            }
            catch (Throwable throwable) {
                Object var17_18 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final long[] rcToRowid(byte[] data, int offset, int length) throws SQLException {
        long[] lArray;
        try {
            long partitionID;
            int size;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CRowidAccessor.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(data) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(length));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (length != (size = 18)) {
                throw new SQLException("Rowid size incorrect.");
            }
            long[] ret = new long[3];
            String value = new String(data, offset, length);
            long blockNumber = Long.parseLong(value.substring(0, 8), 16);
            long slotNumber = Long.parseLong(value.substring(9, 13), 16);
            ret[0] = partitionID = Long.parseLong(value.substring(14, 8), 16);
            ret[1] = blockNumber;
            ret[2] = slotNumber;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CRowidAccessor.logger().log(Level.FINER, "         Return: " + ret);
                    Object var13_11 = null;
                }
                catch (Throwable throwable) {
                    Object var13_12 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            lArray = ret;
            Object var15_15 = null;
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CRowidAccessor.logger().log(Level.FINER, "         Exit");
                    Object var17_19 = null;
                }
                catch (Throwable throwable2) {
                    Object var17_20 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T4CRowidAccessor.logger().log(Level.FINER, "         Exit");
                Object var17_17 = null;
            }
            catch (Throwable throwable) {
                Object var17_18 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return lArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    static final void kgrdr2rc(int tidrba, int tidpid, int tidtbl, int ridrba, int ridsqn, byte[] dstBytes, int offset) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CRowidAccessor.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(tidrba) + ", " + OracleLog.argument(tidpid) + ", " + OracleLog.argument(tidtbl) + ", " + OracleLog.argument(ridrba) + ", " + OracleLog.argument(ridsqn) + ", " + OracleLog.argument(dstBytes) + ", " + OracleLog.argument(offset));
                    Object var8_7 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            offset = T4CRowidAccessor.lmx42h(dstBytes, ridrba, 8, offset);
            dstBytes[offset++] = 46;
            offset = T4CRowidAccessor.lmx42h(dstBytes, ridsqn, 4, offset);
            dstBytes[offset++] = 46;
            offset = T4CRowidAccessor.lmx42h(dstBytes, tidpid, 4, offset);
            Object var10_10 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var12_15 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            T4CRowidAccessor.logger().log(Level.FINER, "         Exit");
            Object var12_14 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            T4CRowidAccessor.logger().log(Level.FINER, "         Exit");
            Object var12_12 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final int lmx42h(byte[] charsAsBytes, long value, int size, int offset) {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CRowidAccessor.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(charsAsBytes) + ", " + OracleLog.argument(value) + ", " + OracleLog.argument(size) + ", " + OracleLog.argument(offset));
                    Object var6_4 = null;
                }
                catch (Throwable throwable) {
                    Object var6_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            String hexRep = Long.toHexString(value).toUpperCase();
            int size_t = size;
            int hexRepOff = 0;
            do {
                if (hexRepOff < hexRep.length()) {
                    charsAsBytes[offset + size - 1] = (byte)hexRep.charAt(hexRep.length() - hexRepOff - 1);
                    ++hexRepOff;
                    continue;
                }
                charsAsBytes[offset + size - 1] = 48;
            } while (--size > 0);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CRowidAccessor.logger().log(Level.FINER, "         Return: " + (size_t + offset));
                    Object var9_10 = null;
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = size_t + offset;
            Object var11_14 = null;
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CRowidAccessor.logger().log(Level.FINER, "         Exit");
                    Object var13_18 = null;
                }
                catch (Throwable throwable2) {
                    Object var13_19 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T4CRowidAccessor.logger().log(Level.FINER, "         Exit");
                Object var13_16 = null;
            }
            catch (Throwable throwable) {
                Object var13_17 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final int kgrdc2ub(byte[] src, int src_offset, byte[] dst, int dst_offset, int length) throws SQLException {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CRowidAccessor.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(src) + ", " + OracleLog.argument(src_offset) + ", " + OracleLog.argument(dst) + ", " + OracleLog.argument(dst_offset) + ", " + OracleLog.argument(length));
                    Object var6_5 = null;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            byte rowid_type = T4CRowidAccessor.getRowidType(src, src_offset);
            byte[] byte_rowid = dst;
            int bytes_to_convert = length - 1;
            int next_input_byte = 0;
            byte[] kgrd_char64_tosigned = kgrd_index_64;
            int byte_used_len = 1 + (3 * ((length - 1) / 4) + ((length - 1) % 4 != 0 ? (length - 1) % 4 - 1 : 0));
            if (bytes_to_convert == 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CRowidAccessor.logger().log(OracleLog.INTERNAL_ERROR, "        Internal Error: 132");
                        Object var15_13 = null;
                    }
                    catch (Throwable throwable) {
                        Object var15_14 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(null, 132);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            byte_rowid[dst_offset + 0] = rowid_type;
            next_input_byte = src_offset + 1;
            int next_output_byte = 1;
            while (bytes_to_convert > 0) {
                byte byte_after_this;
                if (bytes_to_convert == 1) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CRowidAccessor.logger().log(OracleLog.INTERNAL_ERROR, "        Internal Error: 132");
                            Object var17_26 = null;
                        }
                        catch (Throwable throwable) {
                            Object var17_27 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(null, 132);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                byte this_byte = kgrd_char64_tosigned[src[next_input_byte]];
                if (this_byte == -1) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CRowidAccessor.logger().log(OracleLog.INTERNAL_ERROR, "        Internal Error: 132");
                            Object var19_29 = null;
                        }
                        catch (Throwable throwable) {
                            Object var19_30 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(null, 132);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if ((byte_after_this = kgrd_char64_tosigned[src[++next_input_byte]]) == -1) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CRowidAccessor.logger().log(OracleLog.INTERNAL_ERROR, "        Internal Error: 132");
                            Object var21_32 = null;
                        }
                        catch (Throwable throwable) {
                            Object var21_33 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(null, 132);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                byte_rowid[dst_offset + next_output_byte] = (byte)((this_byte & 0xFF) << 2 | (byte_after_this & 0x30) >> 4);
                if (bytes_to_convert == 2) break;
                ++next_output_byte;
                this_byte = byte_after_this;
                if ((byte_after_this = kgrd_char64_tosigned[src[++next_input_byte]]) == -1) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CRowidAccessor.logger().log(OracleLog.INTERNAL_ERROR, "        Internal Error: 132");
                            Object var23_35 = null;
                        }
                        catch (Throwable throwable) {
                            Object var23_36 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(null, 132);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                byte_rowid[dst_offset + next_output_byte] = (byte)((this_byte & 0xFF) << 4 | (byte_after_this & 0x3C) >> 2);
                if (bytes_to_convert == 3) break;
                ++next_output_byte;
                this_byte = byte_after_this;
                if ((byte_after_this = kgrd_char64_tosigned[src[++next_input_byte]]) == -1) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CRowidAccessor.logger().log(OracleLog.INTERNAL_ERROR, "        Internal Error: 132");
                            Object var25_38 = null;
                        }
                        catch (Throwable throwable) {
                            Object var25_39 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(null, 132);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                byte_rowid[dst_offset + next_output_byte] = (byte)((this_byte & 3) << 6 | byte_after_this);
                bytes_to_convert -= 4;
                ++next_input_byte;
                ++next_output_byte;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CRowidAccessor.logger().log(Level.FINER, "         Return: " + byte_used_len);
                    Object var27_41 = null;
                }
                catch (Throwable throwable) {
                    Object var27_42 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = byte_used_len;
            Object var29_44 = null;
        }
        catch (Throwable throwable) {
            Object var29_45 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CRowidAccessor.logger().log(Level.FINER, "         Exit");
                    Object var31_48 = null;
                }
                catch (Throwable throwable2) {
                    Object var31_49 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T4CRowidAccessor.logger().log(Level.FINER, "         Exit");
                Object var31_46 = null;
            }
            catch (Throwable throwable) {
                Object var31_47 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static final long[] stringToRowid(byte[] data, int offset, int length) throws SQLException {
        long[] lArray;
        try {
            int size;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CRowidAccessor.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(data) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(length));
                    Object var4_3 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if (length != (size = 18)) {
                throw new SQLException("Rowid size incorrect.");
            }
            long[] ret = new long[4];
            try {
                ret[0] = T4CRowidAccessor.kgrdb42(data, 6, offset);
                ret[1] = T4CRowidAccessor.kgrdb42(data, 3, offset += 6);
                ret[2] = T4CRowidAccessor.kgrdb42(data, 6, offset += 3);
                ret[3] = T4CRowidAccessor.kgrdb42(data, 3, offset += 6);
                offset += 3;
            }
            catch (Exception e2) {
                ret[0] = 0L;
                ret[1] = 0L;
                ret[2] = 0L;
                ret[3] = 0L;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CRowidAccessor.logger().log(Level.FINER, "         Return: " + ret);
                    Object var7_9 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            lArray = ret;
            Object var9_12 = null;
            if (!TRACE) return lArray;
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var11_17 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            T4CRowidAccessor.logger().log(Level.FINER, "         Exit");
            Object var11_16 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return lArray;
        try {
            T4CRowidAccessor.logger().log(Level.FINER, "         Exit");
            Object var11_14 = null;
            OracleLog.recursiveExit();
            return lArray;
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final int kgrd42b(byte[] charsAsBytes, long value, int size, int offset) {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CRowidAccessor.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(charsAsBytes) + ", " + OracleLog.argument(value) + ", " + OracleLog.argument(size) + ", " + OracleLog.argument(offset));
                    Object var6_4 = null;
                }
                catch (Throwable throwable) {
                    Object var6_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            int size_t = size;
            long val = value;
            while (size > 0) {
                charsAsBytes[offset + size - 1] = kgrd_basis_64[(int)val & 0x3F];
                val = val >>> 6 & 0x3FFFFFFL;
                --size;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CRowidAccessor.logger().log(Level.FINER, "         Return: " + (size_t + offset));
                    Object var9_9 = null;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = size_t + offset;
            Object var11_13 = null;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CRowidAccessor.logger().log(Level.FINER, "         Exit");
                    Object var13_17 = null;
                }
                catch (Throwable throwable2) {
                    Object var13_18 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T4CRowidAccessor.logger().log(Level.FINER, "         Exit");
                Object var13_15 = null;
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final long kgrdb42(byte[] charsAsBytes, int size, int offset) throws SQLException {
        long l2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CRowidAccessor.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(charsAsBytes) + ", " + OracleLog.argument(size) + ", " + OracleLog.argument(offset));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            long ret = 0L;
            for (int i2 = 0; i2 < size; ++i2) {
                byte value = charsAsBytes[offset + i2];
                if ((value = kgrd_index_64[value]) == -1) {
                    throw new SQLException("Char data to rowid conversion failed.");
                }
                ret <<= 6;
                ret |= (long)value;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CRowidAccessor.logger().log(Level.FINER, "         Return: " + ret);
                    Object var8_10 = null;
                }
                catch (Throwable throwable) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            l2 = ret;
            Object var10_13 = null;
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CRowidAccessor.logger().log(Level.FINER, "         Exit");
                    Object var12_17 = null;
                }
                catch (Throwable throwable2) {
                    Object var12_18 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T4CRowidAccessor.logger().log(Level.FINER, "         Exit");
                Object var12_15 = null;
            }
            catch (Throwable throwable) {
                Object var12_16 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void kgrdr2ec(int tidrba, int tidpid, int tidtbl, int ridrba, int ridsqn, byte[] dstBytes, int dstOffset) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CRowidAccessor.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(tidrba) + ", " + OracleLog.argument(tidpid) + ", " + OracleLog.argument(tidtbl) + ", " + OracleLog.argument(ridrba) + ", " + OracleLog.argument(ridsqn) + ", " + OracleLog.argument(dstBytes) + ", " + OracleLog.argument(dstOffset));
                    Object var8_7 = null;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            dstOffset = T4CRowidAccessor.kgrd42b(tidrba, dstBytes, dstOffset, 6);
            dstOffset = T4CRowidAccessor.kgrd42b(tidpid, dstBytes, dstOffset, 3);
            dstOffset = T4CRowidAccessor.kgrd42b(ridrba, dstBytes, dstOffset, 6);
            dstOffset = T4CRowidAccessor.kgrd42b(ridsqn, dstBytes, dstOffset, 3);
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CRowidAccessor.logger().log(Level.FINER, "         Exit");
                    Object var12_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var12_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T4CRowidAccessor.logger().log(Level.FINER, "         Exit");
                Object var12_12 = null;
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    static final int kgrd42b(int value, byte[] dstBytes, int dstOffset, int digits) throws SQLException {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CRowidAccessor.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(value) + ", " + OracleLog.argument(dstBytes) + ", " + OracleLog.argument(dstOffset) + ", " + OracleLog.argument(digits));
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            int len = digits;
            while (digits > 0) {
                dstBytes[dstOffset + --digits] = kgrd_basis_64[value & 0x3F];
                value >>= 6;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CRowidAccessor.logger().log(Level.FINER, "         Return: " + (dstOffset + len));
                    Object var7_9 = null;
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = dstOffset + len;
            Object var9_12 = null;
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CRowidAccessor.logger().log(Level.FINER, "         Exit");
                    Object var11_16 = null;
                }
                catch (Throwable throwable2) {
                    Object var11_17 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T4CRowidAccessor.logger().log(Level.FINER, "         Exit");
                Object var11_14 = null;
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final int kgrdub2c(byte[] bytes, int size, int offset, byte[] dstBytes, int dstOffset) throws SQLException {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CRowidAccessor.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(size) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(dstBytes) + ", " + OracleLog.argument(dstOffset));
                    Object var6_5 = null;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            int rid_length = -1;
            byte rid_type = bytes[offset];
            if (rid_type == 1) {
                int[] int_bytes = new int[bytes.length];
                for (int i2 = 0; i2 < bytes.length; ++i2) {
                    int_bytes[i2] = bytes[i2] & 0xFF;
                }
                int temp = offset + 1;
                int tidrba = (((int_bytes[temp + 0] << 8) + int_bytes[temp + 1] << 8) + int_bytes[temp + 2] << 8) + int_bytes[temp + 3];
                temp = offset + 5;
                int tidpid = (int_bytes[temp + 0] << 8) + int_bytes[temp + 1];
                int tidtbl = 0;
                temp = offset + 7;
                int ridrba = (((int_bytes[temp + 0] << 8) + int_bytes[temp + 1] << 8) + int_bytes[temp + 2] << 8) + int_bytes[temp + 3];
                temp = offset + 11;
                int ridsqn = (int_bytes[temp + 0] << 8) + int_bytes[temp + 1];
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CRowidAccessor.logger().log(OracleLog.TRACE_20, "         Debug: T4CRowidAccessor.kgrdub2c: tidrba=" + tidrba + ", tidpid=" + tidpid + ", tidtbl=" + tidtbl + ", ridrba=" + ridrba + ", ridsqn=" + ridsqn);
                        Object var15_24 = null;
                    }
                    catch (Throwable throwable) {
                        Object var15_25 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if (tidrba == 0) {
                    T4CRowidAccessor.kgrdr2rc(tidrba, tidpid, tidtbl, ridrba, ridsqn, dstBytes, dstOffset);
                } else {
                    T4CRowidAccessor.kgrdr2ec(tidrba, tidpid, tidtbl, ridrba, ridsqn, dstBytes, dstOffset);
                }
                rid_length = 18;
            } else {
                int next_output_byte = 0;
                int bytes_to_convert = size - 1;
                int body_length = 4 * (size / 3) + (size % 3 == 0 ? size % 3 + 1 : 0);
                int char_length = 1 + body_length - 1;
                if (char_length != 0) {
                    dstBytes[dstOffset + 0] = kgrd_indbyte_char[rid_type - 1];
                    int next_input_byte = offset + 1;
                    next_output_byte = 1;
                    byte second_byte = 0;
                    while (bytes_to_convert > 0) {
                        dstBytes[dstOffset + next_output_byte++] = kgrd_basis_64[(bytes[next_input_byte] & 0xFF) >> 2];
                        if (bytes_to_convert == 1) {
                            dstBytes[dstOffset + next_output_byte++] = kgrd_basis_64[(bytes[next_input_byte] & 3) << 4];
                            break;
                        }
                        second_byte = (byte)(bytes[next_input_byte + 1] & 0xFF);
                        dstBytes[dstOffset + next_output_byte++] = kgrd_basis_64[(bytes[next_input_byte] & 3) << 4 | (second_byte & 0xF0) >> 4];
                        if (bytes_to_convert == 2) {
                            dstBytes[dstOffset + next_output_byte++] = kgrd_basis_64[(second_byte & 0xF) << 2];
                            break;
                        }
                        dstBytes[dstOffset + next_output_byte++] = kgrd_basis_64[(second_byte & 0xF) << 2 | (bytes[next_input_byte += 2] & 0xC0) >> 6];
                        dstBytes[dstOffset + next_output_byte] = kgrd_basis_64[bytes[next_input_byte] & 0x3F];
                        bytes_to_convert -= 3;
                        ++next_input_byte;
                        ++next_output_byte;
                    }
                }
                rid_length = next_output_byte;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CRowidAccessor.logger().log(Level.FINER, "         Return: " + rid_length);
                    Object var17_27 = null;
                }
                catch (Throwable throwable) {
                    Object var17_28 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = rid_length;
            Object var19_30 = null;
        }
        catch (Throwable throwable) {
            Object var19_31 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CRowidAccessor.logger().log(Level.FINER, "         Exit");
                    Object var21_34 = null;
                }
                catch (Throwable throwable2) {
                    Object var21_35 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T4CRowidAccessor.logger().log(Level.FINER, "         Exit");
                Object var21_32 = null;
            }
            catch (Throwable throwable) {
                Object var21_33 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    static final boolean isUROWID(byte[] data, int offset) {
        return T4CRowidAccessor.getRowidType(data, offset) == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final byte getRowidType(byte[] data, int offset) {
        byte by;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CRowidAccessor.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(data) + ", " + OracleLog.argument(offset));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            byte rowid_type = 5;
            switch (data[offset]) {
                case 65: {
                    rowid_type = 1;
                    break;
                }
                case 42: {
                    rowid_type = 2;
                    break;
                }
                case 45: {
                    rowid_type = 3;
                    break;
                }
                case 40: {
                    rowid_type = 4;
                    break;
                }
                case 41: {
                    rowid_type = 5;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CRowidAccessor.logger().log(Level.FINER, "         Return: " + rowid_type);
                    Object var5_7 = null;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            by = rowid_type;
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CRowidAccessor.logger().log(Level.FINER, "         Exit");
                    Object var9_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T4CRowidAccessor.logger().log(Level.FINER, "         Exit");
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return by;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CRowidAccessor"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

