/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleOCIFailover;
import oracle.jdbc.driver.AutoKeyInfo;
import oracle.jdbc.driver.ClassRef;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleBlobInputStream;
import oracle.jdbc.driver.OracleBlobOutputStream;
import oracle.jdbc.driver.OracleClobInputStream;
import oracle.jdbc.driver.OracleClobOutputStream;
import oracle.jdbc.driver.OracleClobReader;
import oracle.jdbc.driver.OracleClobWriter;
import oracle.jdbc.driver.OracleConversionInputStream;
import oracle.jdbc.driver.OracleConversionReader;
import oracle.jdbc.driver.OracleDriverExtension;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T2CError;
import oracle.jdbc.driver.T2CStatement;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleStatement;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCLOB;
import oracle.jdbc.pool.OracleOCIConnectionPool;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.BfileDBAccess;
import oracle.sql.BlobDBAccess;
import oracle.sql.CLOB;
import oracle.sql.ClobDBAccess;
import oracle.sql.LobPlsqlUtil;
import oracle.sql.NCLOB;
import oracle.sql.SQLName;
import oracle.sql.ZONEIDMAP;
import oracle.sql.converter.CharacterSetMetaData;

public class T2CConnection
extends PhysicalConnection
implements BfileDBAccess,
BlobDBAccess,
ClobDBAccess {
    static final long JDBC_OCI_LIBRARY_VERSION = Long.parseLong("11.2.0.3.0".replaceAll("\\.", ""));
    short[] queryMetaData1 = null;
    byte[] queryMetaData2 = null;
    int queryMetaData1Offset = 0;
    int queryMetaData2Offset = 0;
    private String password;
    int fatalErrorNumber = 0;
    String fatalErrorMessage = null;
    static final int QMD_dbtype = 0;
    static final int QMD_dbsize = 1;
    static final int QMD_nullok = 2;
    static final int QMD_precision = 3;
    static final int QMD_scale = 4;
    static final int QMD_formOfUse = 5;
    static final int QMD_columnNameLength = 6;
    static final int QMD_tdo0 = 7;
    static final int QMD_tdo1 = 8;
    static final int QMD_tdo2 = 9;
    static final int QMD_tdo3 = 10;
    static final int QMD_charLength = 11;
    static final int QMD_typeNameLength = 12;
    static final int T2C_LOCATOR_MAX_LEN = 16;
    static final int T2C_LINEARIZED_LOCATOR_MAX_LEN = 4000;
    static final int T2C_LINEARIZED_BFILE_LOCATOR_MAX_LEN = 530;
    static final int METADATA1_INDICES_PER_COLUMN = 13;
    protected static final int SIZEOF_QUERYMETADATA2 = 8;
    static final String defaultDriverNameAttribute = "jdbcoci";
    int queryMetaData1Size = 100;
    int queryMetaData2Size = 800;
    long m_nativeState;
    short m_clientCharacterSet;
    byte byteAlign;
    private static final int EOJ_SUCCESS = 0;
    private static final int EOJ_ERROR = -1;
    private static final int EOJ_WARNING = 1;
    private static final int EOJ_GET_STORAGE_ERROR = -4;
    private static final int EOJ_ORA3113_SERVER_NORMAL = -6;
    private static final String OCILIBRARY = "ocijdbc11";
    private int logon_mode = 0;
    static final int LOGON_MODE_DEFAULT = 0;
    static final int LOGON_MODE_SYSDBA = 2;
    static final int LOGON_MODE_SYSOPER = 4;
    static final int LOGON_MODE_SYSASM = 32768;
    static final int LOGON_MODE_SYSBKP = 131072;
    static final int LOGON_MODE_SYSDGD = 262144;
    static final int LOGON_MODE_SYSKMT = 524288;
    static final int LOGON_MODE_CONNECTION_POOL = 5;
    static final int LOGON_MODE_CONNPOOL_CONNECTION = 6;
    static final int LOGON_MODE_CONNPOOL_PROXY_CONNECTION = 7;
    static final int LOGON_MODE_CONNPOOL_ALIASED_CONNECTION = 8;
    static final int T2C_PROXYTYPE_NONE = 0;
    static final int T2C_PROXYTYPE_USER_NAME = 1;
    static final int T2C_PROXYTYPE_DISTINGUISHED_NAME = 2;
    static final int T2C_PROXYTYPE_CERTIFICATE = 3;
    static final int T2C_CONNECTION_FLAG_DEFAULT_LOB_PREFETCH = 0;
    static final int T2C_CONNECTION_FLAG_PRELIM_AUTH = 1;
    private static boolean isLibraryLoaded;
    OracleOCIFailover appCallback = null;
    Object appCallbackObject = null;
    private Properties nativeInfo;
    ByteBuffer nioBufferForLob;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_;
    public static boolean TRACE;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T2CConnection(String ur, Properties info, OracleDriverExtension ext) throws SQLException {
        super(ur, info, ext);
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(ur) + ", " + OracleLog.argument(info) + ", " + OracleLog.argument(ext));
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.initialize();
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_11 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_12 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void initializePassword(String p2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(p2));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.password = p2;
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void initialize() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.allocQueryMetaDataBuffers();
            Object var4_4 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var6_9 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var6_8 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var6_6 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void allocQueryMetaDataBuffers() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.queryMetaData1Offset = 0;
            this.queryMetaData1 = new short[this.queryMetaData1Size * 13];
            this.queryMetaData2Offset = 0;
            this.queryMetaData2 = new byte[this.queryMetaData2Size];
            this.namedTypeAccessorByteLen = 0;
            this.refTypeAccessorByteLen = 0;
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var6_8 = null;
                }
                catch (Throwable throwable2) {
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reallocateQueryMetaData(int numColumns, int charSize) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(numColumns) + ", " + OracleLog.argument(charSize));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.queryMetaData1 = null;
            this.queryMetaData2 = null;
            this.queryMetaData1Size = Math.max(numColumns, this.queryMetaData1Size);
            this.queryMetaData2Size = Math.max(charSize, this.queryMetaData2Size);
            this.allocQueryMetaDataBuffers();
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    protected void logon() throws SQLException {
        try {
            block41: {
                byte[] nlsterritory;
                block42: {
                    block44: {
                        block45: {
                            block43: {
                                block40: {
                                    if (TRACE && OracleLog.recursiveEnter()) {
                                        try {
                                            T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                                            Object var2_1 = null;
                                            OracleLog.recursiveExit();
                                        }
                                        catch (Throwable throwable) {
                                            Object var2_2 = null;
                                            OracleLog.recursiveExit();
                                            throw throwable;
                                        }
                                    }
                                    if (this.database == null) {
                                        if (TRACE && OracleLog.recursiveEnter()) {
                                            try {
                                                T2CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 64);
                                                Object var4_6 = null;
                                                OracleLog.recursiveExit();
                                            }
                                            catch (Throwable throwable) {
                                                Object var4_7 = null;
                                                OracleLog.recursiveExit();
                                                throw throwable;
                                            }
                                        }
                                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 64);
                                        __ex__.fillInStackTrace();
                                        throw __ex__;
                                    }
                                    if (!isLibraryLoaded) {
                                        T2CConnection.loadNativeLibrary();
                                    }
                                    if (!this.ociConnectionPoolIsPooling) break block40;
                                    this.processOCIConnectionPooling();
                                    break block41;
                                }
                                long OCISvcCtxHandle = this.ociSvcCtxHandle;
                                long OCIEnvHandle = this.ociEnvHandle;
                                long OCIErrHandle = this.ociErrHandle;
                                if (OCISvcCtxHandle == 0L || OCIEnvHandle == 0L) break block42;
                                if (this.ociDriverCharset == null) break block43;
                                this.m_clientCharacterSet = new Integer(this.ociDriverCharset).shortValue();
                                this.conversion = new DBConversion(this.m_clientCharacterSet, this.m_clientCharacterSet, this.m_clientCharacterSet);
                                short[] csids = new short[5];
                                long[] flags = new long[]{this.defaultLobPrefetchSize};
                                this.sqlWarning = this.checkError(this.t2cUseConnection(this.m_nativeState, OCIEnvHandle, OCISvcCtxHandle, OCIErrHandle, csids, flags), this.sqlWarning);
                                this.conversion = new DBConversion(csids[0], this.m_clientCharacterSet, csids[1]);
                                this.byteAlign = (byte)(csids[2] & 0xFF);
                                this.timeZoneVersionNumber = (csids[3] << 16) + (csids[4] & 0xFFFF);
                                if (!TRACE) break block44;
                                break block45;
                            }
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    T2CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 89);
                                    Object var8_11 = null;
                                    OracleLog.recursiveExit();
                                }
                                catch (Throwable throwable) {
                                    Object var8_12 = null;
                                    OracleLog.recursiveExit();
                                    throw throwable;
                                }
                            }
                            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 89);
                            __ex__.fillInStackTrace();
                            throw __ex__;
                        }
                        if (OracleLog.recursiveEnter()) {
                            try {
                                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                                Object var10_19 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                Object var10_20 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                    }
                    Object var25_24 = null;
                    if (!TRACE) return;
                    if (!OracleLog.recursiveEnter()) return;
                    try {
                        T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var27_27 = null;
                        OracleLog.recursiveExit();
                        return;
                    }
                    catch (Throwable throwable) {
                        Object var27_28 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                if (this.internalLogon == null) {
                    this.logon_mode = 0;
                } else if (this.internalLogon.equalsIgnoreCase("SYSDBA")) {
                    this.logon_mode = 2;
                } else if (this.internalLogon.equalsIgnoreCase("SYSOPER")) {
                    this.logon_mode = 4;
                } else if (this.internalLogon.equalsIgnoreCase("SYSASM")) {
                    this.logon_mode = 32768;
                } else if (this.internalLogon.equalsIgnoreCase("SYSBACKUP")) {
                    this.logon_mode = 131072;
                } else if (this.internalLogon.equalsIgnoreCase("SYSDG")) {
                    this.logon_mode = 262144;
                } else if (this.internalLogon.equalsIgnoreCase("SYSKM")) {
                    this.logon_mode = 524288;
                }
                byte[] l_userName = null;
                byte[] l_proxyClientName = null;
                byte[] l_password = null;
                String newPassword = this.setNewPassword;
                byte[] newPasswordBytes = new byte[]{};
                byte[] editionNameBytes = new byte[]{};
                byte[] driverNameAttributeBytes = new byte[]{};
                this.m_clientCharacterSet = this.nlsLangBackdoor ? T2CConnection.getDriverCharSetIdFromNLS_LANG() : T2CConnection.getClientCharSetId();
                if (newPassword != null) {
                    newPasswordBytes = DBConversion.stringToDriverCharBytes(newPassword, this.m_clientCharacterSet);
                }
                if (this.editionName != null) {
                    editionNameBytes = DBConversion.stringToDriverCharBytes(this.editionName, this.m_clientCharacterSet);
                }
                driverNameAttributeBytes = this.driverNameAttribute == null ? DBConversion.stringToDriverCharBytes(defaultDriverNameAttribute, this.m_clientCharacterSet) : DBConversion.stringToDriverCharBytes(this.driverNameAttribute, this.m_clientCharacterSet);
                l_userName = this.userName == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(this.userName, this.m_clientCharacterSet);
                l_proxyClientName = this.proxyClientName == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(this.proxyClientName, this.m_clientCharacterSet);
                l_password = this.password == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(this.password, this.m_clientCharacterSet);
                byte[] l_database = DBConversion.stringToDriverCharBytes(this.database, this.m_clientCharacterSet);
                short[] csids = new short[5];
                String s2 = null;
                s2 = CharacterSetMetaData.getNLSLanguage(ClassRef.LOCALE.getDefault());
                byte[] nlslanguage = s2 != null ? s2.getBytes() : null;
                s2 = CharacterSetMetaData.getNLSTerritory(ClassRef.LOCALE.getDefault());
                byte[] byArray = nlsterritory = s2 != null ? s2.getBytes() : null;
                if (nlslanguage == null || nlsterritory == null) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T2CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 176);
                            Object var20_44 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var20_45 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 176);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                TimeZone tz = TimeZone.getDefault();
                String defaultTimeZone = tz.getID();
                if (!ZONEIDMAP.isValidRegion(defaultTimeZone) || !this.timezoneAsRegion) {
                    int tzOffset = tz.getOffset(System.currentTimeMillis());
                    int hr = tzOffset / 3600000;
                    int mi = tzOffset / 60000 % 60;
                    defaultTimeZone = (hr < 0 ? "" + hr : "+" + hr) + (mi < 10 ? ":0" + mi : ":" + mi);
                }
                T2CConnection.doSetSessionTimeZone(defaultTimeZone);
                this.sessionTimeZone = defaultTimeZone;
                this.conversion = new DBConversion(this.m_clientCharacterSet, this.m_clientCharacterSet, this.m_clientCharacterSet);
                long[] flags = new long[]{this.defaultLobPrefetchSize, this.prelimAuth ? 1 : 0};
                this.sqlWarning = this.m_nativeState == 0L ? this.checkError(this.t2cCreateState(l_userName, l_userName.length, l_proxyClientName, l_proxyClientName.length, l_password, l_password.length, newPasswordBytes, newPasswordBytes.length, editionNameBytes, editionNameBytes.length, driverNameAttributeBytes, driverNameAttributeBytes.length, l_database, l_database.length, this.m_clientCharacterSet, this.logon_mode, csids, nlslanguage, nlsterritory, this.retainV9BindBehavior, flags), this.sqlWarning) : this.checkError(this.t2cLogon(this.m_nativeState, l_userName, l_userName.length, l_proxyClientName, l_proxyClientName.length, l_password, l_password.length, newPasswordBytes, newPasswordBytes.length, editionNameBytes, editionNameBytes.length, driverNameAttributeBytes, driverNameAttributeBytes.length, l_database, l_database.length, this.logon_mode, csids, nlslanguage, nlsterritory, flags), this.sqlWarning);
                this.conversion = new DBConversion(csids[0], this.m_clientCharacterSet, csids[1]);
                this.byteAlign = (byte)(csids[2] & 0xFF);
                this.timeZoneVersionNumber = (csids[3] << 16) + (csids[4] & 0xFFFF);
            }
            Object var25_25 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var25_26 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var27_32 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var27_31 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {}
        catch (Throwable throwable) {
            Object var27_30 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
        Object var27_29 = null;
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logoff() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            try {
                if (this.lifecycle == 2) {
                    this.checkError(this.t2cLogoff(this.m_nativeState));
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.m_nativeState = 0L;
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var6_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var6_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var6_7 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(OracleStatement stmt) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            byte[] l_sqlString = stmt.sqlObject.getSql(stmt.processEscapes, stmt.convertNcharLiterals).getBytes();
            this.checkError(this.t2cCreateStatement(this.m_nativeState, 0L, l_sqlString, l_sqlString.length, stmt, false, stmt.rowPrefetch));
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_8 = null;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelOperationOnServer(boolean isStatementCancel) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkError(this.t2cCancel(this.m_nativeState));
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    native int t2cAbort(long var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doAbort() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkError(this.t2cAbort(this.m_nativeState));
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var6_8 = null;
                }
                catch (Throwable throwable2) {
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSetAutoCommit(boolean autoCommit) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(autoCommit));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkError(this.t2cSetAutoCommit(this.m_nativeState, autoCommit));
            this.autocommit = autoCommit;
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    protected void doCommit(int flags) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(flags));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkError(this.t2cCommit(this.m_nativeState, flags));
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doRollback() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkError(this.t2cRollback(this.m_nativeState));
            Object var4_4 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var6_8 = null;
            }
            catch (Throwable throwable2) {
                Object var6_9 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized int doPingDatabase() throws SQLException {
        block19: {
            int n2;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                        Object var2_1 = null;
                    }
                    catch (Throwable throwable) {
                        Object var2_2 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if (this.t2cPingDatabase(this.m_nativeState) != 0) break block19;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 0);
                        Object var4_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                n2 = 0;
                Object var8_9 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var10_16 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var10_17 = null;
                        OracleLog.recursiveExit();
                        throw throwable2;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_12 = null;
                }
                catch (Throwable throwable) {
                    Object var10_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return n2;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + -1);
                Object var6_21 = null;
            }
            catch (Throwable throwable) {
                Object var6_22 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        int n3 = -1;
        Object var8_10 = null;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_14 = null;
            }
            catch (Throwable throwable) {
                Object var10_15 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doGetDatabaseProductVersion() throws SQLException {
        String string;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            byte[] l_version = this.t2cGetProductionVersion(this.m_nativeState);
            String __result__ = this.conversion.CharBytesToString(l_version, l_version.length);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            string = __result__;
            Object var6_9 = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_11 = null;
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected short doGetVersionNumber() throws SQLException {
        short s2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            short version_num = 0;
            try {
                String ver_str = this.doGetDatabaseProductVersion();
                StringTokenizer st = new StringTokenizer(ver_str.trim(), " .", false);
                String tk = null;
                int ct = 0;
                short num = 0;
                while (st.hasMoreTokens()) {
                    tk = st.nextToken();
                    try {
                        num = Integer.decode(tk).shortValue();
                        version_num = (short)(version_num * 10 + num);
                        if (++ct != 4) continue;
                        break;
                    }
                    catch (NumberFormatException nfe) {
                    }
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            if (version_num == -1) {
                version_num = 0;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + version_num);
                    Object var9_12 = null;
                }
                catch (Throwable throwable) {
                    Object var9_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            s2 = version_num;
            Object var11_15 = null;
        }
        catch (Throwable throwable) {
            Object var11_16 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var13_19 = null;
                }
                catch (Throwable throwable2) {
                    Object var13_20 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var13_17 = null;
            }
            catch (Throwable throwable) {
                Object var13_18 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return s2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClobDBAccess createClobDBAccess() {
        T2CConnection t2CConnection;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            t2CConnection = this;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return t2CConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlobDBAccess createBlobDBAccess() {
        T2CConnection t2CConnection;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            t2CConnection = this;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return t2CConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BfileDBAccess createBfileDBAccess() {
        T2CConnection t2CConnection;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            t2CConnection = this;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return t2CConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected SQLWarning checkError(int errStatus) throws SQLException {
        SQLWarning sQLWarning;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(errStatus));
                    sQLWarning = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            SQLWarning __result__ = this.checkError(errStatus, null);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            sQLWarning = __result__;
            Object var7_9 = null;
            if (!TRACE) return sQLWarning;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_13 = null;
            }
            catch (Throwable throwable2) {
                Object var9_14 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return sQLWarning;
        try {
            T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_11 = null;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
        return sQLWarning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SQLWarning checkError(int errStatus, SQLWarning warning) throws SQLException {
        SQLWarning sQLWarning;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(errStatus) + ", " + OracleLog.argument(warning));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            switch (errStatus) {
                case 0: {
                    break;
                }
                case -1: 
                case 1: {
                    T2CError l_error = new T2CError();
                    int l_status = -1;
                    if (this.lifecycle != 1 && this.lifecycle != 16) {
                        if (this.fatalErrorNumber != 0) {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    T2CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 269);
                                    Object var6_9 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var6_10 = null;
                                    OracleLog.recursiveExit();
                                    throw throwable;
                                }
                                OracleLog.recursiveExit();
                                {
                                }
                            }
                            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 269);
                            __ex__.fillInStackTrace();
                            throw __ex__;
                        }
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T2CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 8);
                                Object var8_18 = null;
                            }
                            catch (Throwable throwable) {
                                Object var8_19 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    l_status = this.t2cDescribeError(this.m_nativeState, l_error, l_error.m_errorMessage);
                    String l_reason = null;
                    if (l_status != -1) {
                        int msgLength;
                        for (msgLength = 0; msgLength < l_error.m_errorMessage.length && l_error.m_errorMessage[msgLength] != 0; ++msgLength) {
                        }
                        if (this.conversion == null) {
                            throw new Error("conversion == null");
                        }
                        if (l_error == null) {
                            throw new Error("l_error == null");
                        }
                        l_reason = this.conversion.CharBytesToString(l_error.m_errorMessage, msgLength, true);
                    }
                    switch (l_error.m_errorNumber) {
                        case 28: 
                        case 600: 
                        case 1012: 
                        case 1041: {
                            this.internalClose();
                            break;
                        }
                        case 902: {
                            this.removeAllDescriptor();
                            break;
                        }
                        case 3113: 
                        case 3114: {
                            this.setUsable(false);
                            this.close();
                            break;
                        }
                        case -6: {
                            l_error.m_errorNumber = 3113;
                        }
                    }
                    if (l_status == -1) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T2CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1 + "Fetch error message failed!");
                                Object var10_21 = null;
                            }
                            catch (Throwable throwable) {
                                Object var10_22 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Fetch error message failed!");
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    if (errStatus == -1) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T2CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + l_reason + l_error.m_errorNumber);
                                Object var12_24 = null;
                            }
                            catch (Throwable throwable) {
                                Object var12_25 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), l_reason, l_error.m_errorNumber);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    warning = DatabaseError.addSqlWarning(warning, l_reason, l_error.m_errorNumber);
                    break;
                }
                case -4: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T2CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 254);
                            Object var14_27 = null;
                        }
                        catch (Throwable throwable) {
                            Object var14_28 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 254);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + warning);
                    Object var16_30 = null;
                }
                catch (Throwable throwable) {
                    Object var16_31 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            sQLWarning = warning;
            Object var18_33 = null;
        }
        catch (Throwable throwable) {
            Object var18_34 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var20_37 = null;
                }
                catch (Throwable throwable2) {
                    Object var20_38 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var20_35 = null;
            }
            catch (Throwable throwable) {
                Object var20_36 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return sQLWarning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OracleStatement RefCursorBytesToStatement(byte[] bytes, OracleStatement parent) throws SQLException {
        T2CStatement t2CStatement;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(parent));
                    t2CStatement = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            T2CStatement stmt = new T2CStatement(this, 1, this.defaultRowPrefetch, -1, -1);
            stmt.needToParse = false;
            stmt.serverCursor = true;
            stmt.isOpen = true;
            stmt.processEscapes = false;
            stmt.prepareForNewResults(true, false);
            stmt.sqlObject.initialize("select unknown as ref cursor from whatever");
            stmt.sqlKind = OracleStatement.SqlKind.SELECT;
            this.checkError(this.t2cCreateStatement(this.m_nativeState, parent.c_state, bytes, bytes.length, stmt, true, this.defaultRowPrefetch));
            parent.addChild(stmt);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + stmt);
                    Object var6_7 = null;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            t2CStatement = stmt;
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_12 = null;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return t2CStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getForm(OracleTypeADT otypeADT, OracleTypeCLOB otype, int attrIndex) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(otypeADT) + ", " + OracleLog.argument(otype) + ", " + OracleLog.argument(attrIndex));
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            boolean value = false;
            if (otype != null) {
                String[] schema = new String[1];
                String[] type = new String[1];
                SQLName.parse(otypeADT.getFullName(), schema, type, true);
                String fullname = "\"" + schema[0] + "\".\"" + type[0] + "\"";
                byte[] utf8bytes = this.conversion.StringToCharBytes(fullname);
                int formOfUse = this.t2cGetFormOfUse(this.m_nativeState, otype, utf8bytes, utf8bytes.length, attrIndex);
                if (formOfUse < 0) {
                    this.checkError(formOfUse);
                }
                otype.setForm(formOfUse);
            }
            Object var11_12 = null;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var13_16 = null;
                }
                catch (Throwable throwable2) {
                    Object var13_17 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var13_14 = null;
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTdoCState(String schemaName, String typeName) throws SQLException {
        long l2;
        try {
            int[] err;
            String fullNameWithQuotes;
            byte[] dbcsbytes;
            long tdoCState;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(schemaName) + ", " + OracleLog.argument(typeName));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if ((tdoCState = this.t2cGetTDO(this.m_nativeState, dbcsbytes = this.conversion.StringToCharBytes(fullNameWithQuotes = "\"" + schemaName + "\".\"" + typeName + "\""), dbcsbytes.length, err = new int[1])) == 0L) {
                this.checkError(err[0]);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + tdoCState);
                    Object var9_9 = null;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            l2 = tdoCState;
            Object var11_13 = null;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var13_17 = null;
                }
                catch (Throwable throwable2) {
                    Object var13_18 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var13_15 = null;
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getDBAccessProperties() throws SQLException {
        Properties properties;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    properties = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Properties __result__ = this.getOCIHandles();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            properties = __result__;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Properties getOCIHandles() throws SQLException {
        Properties properties;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (this.lifecycle != 1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 8);
                        Object var4_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.nativeInfo == null) {
                long[] handles = new long[3];
                this.checkError(this.t2cGetHandles(this.m_nativeState, handles));
                this.nativeInfo = new Properties();
                this.nativeInfo.put("OCIEnvHandle", String.valueOf(handles[0]));
                this.nativeInfo.put("OCISvcCtxHandle", String.valueOf(handles[1]));
                this.nativeInfo.put("OCIErrHandle", String.valueOf(handles[2]));
                this.nativeInfo.put("ClientCharSet", String.valueOf(this.m_clientCharacterSet));
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.nativeInfo);
                    Object var6_9 = null;
                }
                catch (Throwable throwable) {
                    Object var6_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            properties = this.nativeInfo;
            Object var8_12 = null;
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_16 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_17 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_14 = null;
            }
            catch (Throwable throwable) {
                Object var10_15 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public Properties getServerSessionInfo() throws SQLException {
        Properties properties;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (this.lifecycle != 1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 8);
                        Object var4_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.sessionProperties == null) {
                this.sessionProperties = new Properties();
            }
            if (this.getVersionNumber() < 10200) {
                this.queryFCFProperties(this.sessionProperties);
            } else {
                this.checkError(T2CConnection.t2cGetServerSessionInfo(this.m_nativeState, this.sessionProperties));
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.sessionProperties);
                    Object var6_9 = null;
                }
                catch (Throwable throwable) {
                    Object var6_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            properties = this.sessionProperties;
            Object var8_12 = null;
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_16 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_17 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_14 = null;
            }
            catch (Throwable throwable) {
                Object var10_15 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getInstanceProperty(OracleConnection.InstanceProperty whatProperty) throws SQLException {
        byte by;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            byte ret = 0;
            if (whatProperty == OracleConnection.InstanceProperty.ASM_VOLUME_SUPPORTED) {
                ret = this.t2cGetAsmVolProperty(this.m_nativeState);
            } else if (whatProperty == OracleConnection.InstanceProperty.INSTANCE_TYPE) {
                ret = this.t2cGetInstanceType(this.m_nativeState);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                    Object var5_7 = null;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            by = ret;
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return by;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getConnectionPoolInfo() throws SQLException {
        Properties properties;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    properties = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (this.lifecycle != 1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 8);
                        Object var4_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Properties info = new Properties();
            this.checkError(this.t2cGetConnPoolInfo(this.m_nativeState, info));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + info);
                    Object var6_9 = null;
                }
                catch (Throwable throwable) {
                    Object var6_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            properties = info;
            Object var8_12 = null;
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_16 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_17 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_14 = null;
            }
            catch (Throwable throwable) {
                Object var10_15 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public void setConnectionPoolInfo(int cpool_min, int cpool_max, int cpool_incr, int cpool_timeout, int cpool_nowait, int cpool_dist_txn) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(cpool_min) + ", " + OracleLog.argument(cpool_max) + ", " + OracleLog.argument(cpool_incr) + ", " + OracleLog.argument(cpool_timeout) + ", " + OracleLog.argument(cpool_nowait) + ", " + OracleLog.argument(cpool_dist_txn));
                    Object var8_7 = null;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkError(this.t2cSetConnPoolInfo(this.m_nativeState, cpool_min, cpool_max, cpool_incr, cpool_timeout, cpool_nowait, cpool_dist_txn));
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var12_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var12_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var12_12 = null;
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ociPasswordChange(String user, String oldPassword, String newPassword) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(user) + ", " + OracleLog.argument(oldPassword) + ", " + OracleLog.argument(newPassword));
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (this.lifecycle != 1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 8);
                        Object var7_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_10 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            byte[] l_userName = user == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(user, this.m_clientCharacterSet);
            byte[] l_oldPwd = oldPassword == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(oldPassword, this.m_clientCharacterSet);
            byte[] l_newPwd = newPassword == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(newPassword, this.m_clientCharacterSet);
            this.sqlWarning = this.checkError(this.t2cPasswordChange(this.m_nativeState, l_userName, l_userName.length, l_oldPwd, l_oldPwd.length, l_newPwd, l_newPwd.length), this.sqlWarning);
            Object var9_13 = null;
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var11_17 = null;
                }
                catch (Throwable throwable2) {
                    Object var11_18 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_15 = null;
            }
            catch (Throwable throwable) {
                Object var11_16 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processOCIConnectionPooling() throws SQLException {
        try {
            short[] csids;
            block46: {
                long[] flags;
                byte[] nlsterritory;
                byte[] nlslanguage;
                byte[] l_database;
                byte[] l_driverNameAttribute;
                byte[] l_editionName;
                byte[] l_password;
                byte[] l_userName;
                T2CConnection m_conn_pool;
                block45: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                            Object var2_1 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var2_2 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                    if (this.lifecycle != 1) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T2CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 8);
                                Object var4_6 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                Object var4_7 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    m_conn_pool = null;
                    if (this.ociConnectionPoolLogonMode == "connection_pool") {
                        this.m_clientCharacterSet = this.nlsLangBackdoor ? T2CConnection.getDriverCharSetIdFromNLS_LANG() : T2CConnection.getClientCharSetId();
                    } else {
                        m_conn_pool = (T2CConnection)this.ociConnectionPoolObject;
                        this.m_clientCharacterSet = m_conn_pool.m_clientCharacterSet;
                    }
                    l_userName = null;
                    l_password = this.password == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(this.password, this.m_clientCharacterSet);
                    l_editionName = this.editionName == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(this.editionName, this.m_clientCharacterSet);
                    l_driverNameAttribute = DBConversion.stringToDriverCharBytes(this.driverNameAttribute == null ? defaultDriverNameAttribute : this.driverNameAttribute, this.m_clientCharacterSet);
                    l_database = DBConversion.stringToDriverCharBytes(this.database, this.m_clientCharacterSet);
                    nlslanguage = CharacterSetMetaData.getNLSLanguage(ClassRef.LOCALE.getDefault()).getBytes();
                    nlsterritory = CharacterSetMetaData.getNLSTerritory(ClassRef.LOCALE.getDefault()).getBytes();
                    if (nlslanguage == null || nlsterritory == null) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T2CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 176);
                                Object var10_15 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                Object var10_16 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 176);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    csids = new short[5];
                    flags = new long[]{this.defaultLobPrefetchSize};
                    if (this.ociConnectionPoolLogonMode != "connection_pool") break block45;
                    l_userName = this.userName == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(this.userName, this.m_clientCharacterSet);
                    this.conversion = new DBConversion(this.m_clientCharacterSet, this.m_clientCharacterSet, this.m_clientCharacterSet);
                    this.logon_mode = 5;
                    if (this.lifecycle == 1) {
                        int[] p2 = new int[6];
                        OracleOCIConnectionPool.readPoolConfig(this.ociConnectionPoolMinLimit, this.ociConnectionPoolMaxLimit, this.ociConnectionPoolIncrement, this.ociConnectionPoolTimeout, this.ociConnectionPoolNoWait, this.ociConnectionPoolTransactionDistributed, p2);
                        this.sqlWarning = this.checkError(this.t2cCreateConnPool(l_userName, l_userName.length, l_password, l_password.length, l_database, l_database.length, this.m_clientCharacterSet, this.logon_mode, p2[0], p2[1], p2[2], p2[3], p2[4], p2[5]), this.sqlWarning);
                        this.versionNumber = (short)10000;
                        break block46;
                    } else {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T2CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 0 + "Internal Error: ");
                                Object var13_26 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                Object var13_27 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 0, "Internal Error: ");
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                }
                if (this.ociConnectionPoolLogonMode == "connpool_connection") {
                    this.logon_mode = 6;
                    l_userName = this.userName == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(this.userName, this.m_clientCharacterSet);
                    this.conversion = new DBConversion(this.m_clientCharacterSet, this.m_clientCharacterSet, this.m_clientCharacterSet);
                    this.sqlWarning = this.checkError(this.t2cConnPoolLogon(m_conn_pool.m_nativeState, l_userName, l_userName.length, l_password, l_password.length, l_editionName, l_editionName.length, l_driverNameAttribute, l_driverNameAttribute.length, l_database, l_database.length, this.logon_mode, 0, 0, null, null, 0, null, 0, null, 0, null, 0, null, 0, csids, nlslanguage, nlsterritory, flags), this.sqlWarning);
                } else if (this.ociConnectionPoolLogonMode == "connpool_alias_connection") {
                    this.logon_mode = 8;
                    byte[] connection_id = null;
                    connection_id = (byte[])this.ociConnectionPoolConnID;
                    l_userName = this.userName == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(this.userName, this.m_clientCharacterSet);
                    this.conversion = new DBConversion(this.m_clientCharacterSet, this.m_clientCharacterSet, this.m_clientCharacterSet);
                    this.sqlWarning = this.checkError(this.t2cConnPoolLogon(m_conn_pool.m_nativeState, l_userName, l_userName.length, l_password, l_password.length, l_editionName, l_editionName.length, l_driverNameAttribute, l_driverNameAttribute.length, l_database, l_database.length, this.logon_mode, 0, 0, null, null, 0, null, 0, null, 0, null, 0, connection_id, connection_id == null ? 0 : connection_id.length, csids, nlslanguage, nlsterritory, flags), this.sqlWarning);
                } else if (this.ociConnectionPoolLogonMode == "connpool_proxy_connection") {
                    this.logon_mode = 7;
                    String proxyType = this.ociConnectionPoolProxyType;
                    int num_proxy_roles = this.ociConnectionPoolProxyNumRoles;
                    String[] proxy_roles = null;
                    if (num_proxy_roles > 0) {
                        proxy_roles = (String[])this.ociConnectionPoolProxyRoles;
                    }
                    byte[] proxy_un = null;
                    byte[] proxy_pd = null;
                    byte[] proxy_dn = null;
                    byte[] proxy_cf = null;
                    int proxy_type = 0;
                    if (proxyType == "proxytype_user_name") {
                        proxy_type = 1;
                        String p3 = this.ociConnectionPoolProxyUserName;
                        if (p3 != null) {
                            proxy_un = p3.getBytes();
                        }
                        if ((p3 = this.ociConnectionPoolProxyPassword) != null) {
                            proxy_pd = p3.getBytes();
                        }
                    } else if (proxyType == "proxytype_distinguished_name") {
                        proxy_type = 2;
                        String p4 = this.ociConnectionPoolProxyDistinguishedName;
                        if (p4 != null) {
                            proxy_dn = p4.getBytes();
                        }
                    } else if (proxyType == "proxytype_certificate") {
                        proxy_type = 3;
                        proxy_cf = (byte[])this.ociConnectionPoolProxyCertificate;
                    } else {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T2CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 107);
                                Object var21_38 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                Object var21_39 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 107);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    l_userName = this.userName == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(this.userName, this.m_clientCharacterSet);
                    this.conversion = new DBConversion(this.m_clientCharacterSet, this.m_clientCharacterSet, this.m_clientCharacterSet);
                    this.sqlWarning = this.checkError(this.t2cConnPoolLogon(m_conn_pool.m_nativeState, l_userName, l_userName.length, l_password, l_password.length, l_editionName, l_editionName.length, l_driverNameAttribute, l_driverNameAttribute.length, l_database, l_database.length, this.logon_mode, proxy_type, num_proxy_roles, proxy_roles, proxy_un, proxy_un == null ? 0 : proxy_un.length, proxy_pd, proxy_pd == null ? 0 : proxy_pd.length, proxy_dn, proxy_dn == null ? 0 : proxy_dn.length, proxy_cf, proxy_cf == null ? 0 : proxy_cf.length, null, 0, csids, nlslanguage, nlsterritory, flags), this.sqlWarning);
                } else {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T2CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 23 + "connection-pool-logon");
                            Object var23_42 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var23_43 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23, "connection-pool-logon");
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            this.conversion = new DBConversion(csids[0], this.m_clientCharacterSet, csids[1]);
            this.byteAlign = (byte)(csids[2] & 0xFF);
            this.timeZoneVersionNumber = (csids[3] << 16) + (csids[4] & 0xFFFF);
            Object var25_45 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var25_46 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var27_50 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var27_49 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var27_47 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var27_48 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDescriptorSharable(OracleConnection conn) throws SQLException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(conn));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            T2CConnection c1 = this;
            PhysicalConnection c2 = (PhysicalConnection)conn.getPhysicalConnection();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (c1 == c2));
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = c1 == c2;
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl;
    }

    native int t2cBlobRead(long var1, byte[] var3, int var4, long var5, int var7, byte[] var8, int var9, boolean var10, ByteBuffer var11);

    native int t2cClobRead(long var1, byte[] var3, int var4, long var5, int var7, char[] var8, int var9, boolean var10, boolean var11, ByteBuffer var12);

    native int t2cBlobWrite(long var1, byte[] var3, int var4, long var5, int var7, byte[] var8, int var9, byte[][] var10);

    native int t2cClobWrite(long var1, byte[] var3, int var4, long var5, int var7, char[] var8, int var9, byte[][] var10, boolean var11);

    native long t2cLobGetLength(long var1, byte[] var3, int var4);

    native int t2cBfileOpen(long var1, byte[] var3, int var4, byte[][] var5);

    native int t2cBfileIsOpen(long var1, byte[] var3, int var4, boolean[] var5);

    native int t2cBfileExists(long var1, byte[] var3, int var4, boolean[] var5);

    native String t2cBfileGetName(long var1, byte[] var3, int var4);

    native String t2cBfileGetDirAlias(long var1, byte[] var3, int var4);

    native int t2cBfileClose(long var1, byte[] var3, int var4, byte[][] var5);

    native int t2cLobGetChunkSize(long var1, byte[] var3, int var4);

    native int t2cLobTrim(long var1, int var3, long var4, byte[] var6, int var7, byte[][] var8);

    native int t2cLobCreateTemporary(long var1, int var3, boolean var4, int var5, short var6, byte[][] var7);

    native int t2cLobFreeTemporary(long var1, int var3, byte[] var4, int var5, byte[][] var6);

    native int t2cLobIsTemporary(long var1, int var3, byte[] var4, int var5, boolean[] var6);

    native int t2cLobOpen(long var1, int var3, byte[] var4, int var5, int var6, byte[][] var7);

    native int t2cLobIsOpen(long var1, int var3, byte[] var4, int var5, boolean[] var6);

    native int t2cLobClose(long var1, int var3, byte[] var4, int var5, byte[][] var6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long lobLength(byte[] locator) throws SQLException {
        long l2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(locator));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            long result = 0L;
            result = this.t2cLobGetLength(this.m_nativeState, locator, locator.length);
            this.checkError((int)result);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            l2 = result;
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int blobRead(byte[] locator, long offset, int amount, byte[] buffer, boolean enableNio, ByteBuffer nioBuffer) throws SQLException {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(locator) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(amount) + ", " + OracleLog.argument(buffer));
                    Object var9_7 = null;
                }
                catch (Throwable throwable) {
                    Object var9_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            int result = 0;
            result = this.t2cBlobRead(this.m_nativeState, locator, locator.length, offset, amount, buffer, buffer.length, enableNio, nioBuffer);
            this.checkError(result);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                    Object var11_12 = null;
                }
                catch (Throwable throwable) {
                    Object var11_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = result;
            Object var13_15 = null;
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var15_19 = null;
                }
                catch (Throwable throwable2) {
                    Object var15_20 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var15_17 = null;
            }
            catch (Throwable throwable) {
                Object var15_18 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int blobWrite(byte[] locator, long offset, byte[] buffer, byte[][] newLocatorHolder, int bytesOffset, int amount) throws SQLException {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(locator) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(buffer) + ", " + OracleLog.argument(newLocatorHolder) + ", " + OracleLog.argument(bytesOffset) + ", " + OracleLog.argument(amount));
                    Object var9_7 = null;
                }
                catch (Throwable throwable) {
                    Object var9_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            int result = 0;
            result = this.t2cBlobWrite(this.m_nativeState, locator, locator.length, offset, amount, buffer, bytesOffset, newLocatorHolder);
            this.checkError(result);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                    Object var11_12 = null;
                }
                catch (Throwable throwable) {
                    Object var11_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = result;
            Object var13_15 = null;
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var15_19 = null;
                }
                catch (Throwable throwable2) {
                    Object var15_20 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var15_17 = null;
            }
            catch (Throwable throwable) {
                Object var15_18 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int clobWrite(byte[] locator, long offset, char[] buffer, byte[][] newLocatorHolder, boolean isNclob, int charsOffset, int amount) throws SQLException {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(locator) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(buffer) + ", " + OracleLog.argument(newLocatorHolder) + ", " + OracleLog.argument(isNclob) + ", " + OracleLog.argument(charsOffset) + ", " + OracleLog.argument(amount));
                    Object var10_8 = null;
                }
                catch (Throwable throwable) {
                    Object var10_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            int result = 0;
            result = this.t2cClobWrite(this.m_nativeState, locator, locator.length, offset, amount, buffer, charsOffset, newLocatorHolder, isNclob);
            this.checkError(result);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                    Object var12_13 = null;
                }
                catch (Throwable throwable) {
                    Object var12_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = result;
            Object var14_16 = null;
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var16_20 = null;
                }
                catch (Throwable throwable2) {
                    Object var16_21 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var16_18 = null;
            }
            catch (Throwable throwable) {
                Object var16_19 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int lobGetChunkSize(byte[] locator) throws SQLException {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(locator));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            int result = 0;
            result = this.t2cLobGetChunkSize(this.m_nativeState, locator, locator.length);
            this.checkError(result);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                    Object var5_7 = null;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = result;
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long length(BFILE bfile) throws SQLException {
        long l2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(bfile));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            byte[] locator = null;
            this.checkTrue(this.lifecycle == 1, 8);
            this.checkTrue(bfile != null && (locator = bfile.getLocator()) != null, 54);
            long __result__ = this.lobLength(locator);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var6_7 = null;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            l2 = __result__;
            Object var8_11 = null;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_15 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_13 = null;
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long position(BFILE bfile, byte[] pattern, long start) throws SQLException {
        long l2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(bfile) + ", " + OracleLog.argument(pattern) + ", " + OracleLog.argument(start));
                    Object var6_4 = null;
                }
                catch (Throwable throwable) {
                    Object var6_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (start < 1L) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68 + "position()");
                        Object var8_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_10 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            long result = LobPlsqlUtil.hasPattern(bfile, pattern, start);
            long l3 = result = result == 0L ? -1L : result;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                    Object var10_13 = null;
                }
                catch (Throwable throwable) {
                    Object var10_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            l2 = result;
            Object var12_16 = null;
        }
        catch (Throwable throwable) {
            Object var12_17 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var14_20 = null;
                }
                catch (Throwable throwable2) {
                    Object var14_21 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var14_18 = null;
            }
            catch (Throwable throwable) {
                Object var14_19 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized long position(BFILE bfile, BFILE pattern, long start) throws SQLException {
        long l2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(bfile) + ", " + OracleLog.argument(pattern) + ", " + OracleLog.argument(start));
                    Object var6_4 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var6_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if (start < 1L) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68 + "position()");
                        Object var8_9 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var8_10 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            long result = LobPlsqlUtil.isSubLob(bfile, pattern, start);
            long l3 = result = result == 0L ? -1L : result;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                    Object var10_13 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var10_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            l2 = result;
            Object var12_16 = null;
            if (!TRACE) return l2;
        }
        catch (Throwable throwable) {
            Object var12_17 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var14_21 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var14_20 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return l2;
        try {
            T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var14_18 = null;
            OracleLog.recursiveExit();
            return l2;
        }
        catch (Throwable throwable) {
            Object var14_19 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getBytes(BFILE bfile, long offset, int amount, byte[] buffer) throws SQLException {
        byte[] locator;
        block24: {
            int n2;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(bfile) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(amount) + ", " + OracleLog.argument(buffer));
                        Object var7_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_6 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                locator = null;
                this.checkTrue(this.lifecycle == 1, 8);
                this.checkTrue(bfile != null && (locator = bfile.getLocator()) != null, 54);
                if (amount > 0 && buffer != null) break block24;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 0);
                        Object var9_12 = null;
                    }
                    catch (Throwable throwable) {
                        Object var9_13 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                n2 = 0;
                Object var13_17 = null;
            }
            catch (Throwable throwable) {
                Object var13_19 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var15_24 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var15_25 = null;
                        OracleLog.recursiveExit();
                        throw throwable2;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var15_20 = null;
                }
                catch (Throwable throwable) {
                    Object var15_21 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return n2;
        }
        if (amount > buffer.length) {
            amount = buffer.length;
        }
        if (this.useNio) {
            int sizeOfBuffer = buffer.length;
            if (this.nioBufferForLob == null || this.nioBufferForLob.capacity() < sizeOfBuffer) {
                this.nioBufferForLob = ByteBuffer.allocateDirect(sizeOfBuffer);
            } else {
                this.nioBufferForLob.rewind();
            }
        }
        int returnValue = this.blobRead(locator, offset, amount, buffer, this.useNio, this.nioBufferForLob);
        if (this.useNio) {
            this.nioBufferForLob.get(buffer);
        }
        int __result__ = returnValue;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                Object var11_29 = null;
            }
            catch (Throwable throwable) {
                Object var11_30 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        int n3 = __result__;
        Object var13_18 = null;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var15_22 = null;
            }
            catch (Throwable throwable) {
                Object var15_23 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getName(BFILE bfile) throws SQLException {
        String string;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(bfile));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            byte[] locator = null;
            String fileName = null;
            this.checkTrue(this.lifecycle == 1, 8);
            this.checkTrue(bfile != null && (locator = bfile.getLocator()) != null, 54);
            fileName = this.t2cBfileGetName(this.m_nativeState, locator, locator.length);
            this.checkError(fileName.length());
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + fileName);
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            string = fileName;
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getDirAlias(BFILE bfile) throws SQLException {
        String string;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(bfile));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            byte[] locator = null;
            String aliasName = null;
            this.checkTrue(this.lifecycle == 1, 8);
            this.checkTrue(bfile != null && (locator = bfile.getLocator()) != null, 54);
            aliasName = this.t2cBfileGetDirAlias(this.m_nativeState, locator, locator.length);
            this.checkError(aliasName.length());
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + aliasName);
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            string = aliasName;
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public synchronized void openFile(BFILE bfile) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(bfile));
                    Object var3_2 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            byte[] locator = null;
            this.checkTrue(this.lifecycle == 1, 8);
            this.checkTrue(bfile != null && (locator = bfile.getLocator()) != null, 54);
            byte[][] newLocatorHolder = new byte[1][];
            this.checkError(this.t2cBfileOpen(this.m_nativeState, locator, locator.length, newLocatorHolder));
            bfile.setLocator(newLocatorHolder[0]);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    Object var5_6 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            Object var7_9 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var9_14 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_13 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_11 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isFileOpen(BFILE bfile) throws SQLException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(bfile));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            byte[] locator = null;
            this.checkTrue(this.lifecycle == 1, 8);
            this.checkTrue(bfile != null && (locator = bfile.getLocator()) != null, 54);
            boolean[] flagHolder = new boolean[1];
            this.checkError(this.t2cBfileIsOpen(this.m_nativeState, locator, locator.length, flagHolder));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + flagHolder[0]);
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = flagHolder[0];
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean fileExists(BFILE bfile) throws SQLException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(bfile));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            byte[] locator = null;
            this.checkTrue(this.lifecycle == 1, 8);
            this.checkTrue(bfile != null && (locator = bfile.getLocator()) != null, 54);
            boolean[] flagHolder = new boolean[1];
            this.checkError(this.t2cBfileExists(this.m_nativeState, locator, locator.length, flagHolder));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + flagHolder[0]);
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = flagHolder[0];
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void closeFile(BFILE bfile) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(bfile));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            byte[] locator = null;
            this.checkTrue(this.lifecycle == 1, 8);
            this.checkTrue(bfile != null && (locator = bfile.getLocator()) != null, 54);
            byte[][] newLocatorHolder = new byte[1][];
            this.checkError(this.t2cBfileClose(this.m_nativeState, locator, locator.length, newLocatorHolder));
            bfile.setLocator(newLocatorHolder[0]);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_13 = null;
            }
            catch (Throwable throwable2) {
                Object var9_14 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!TRACE || !OracleLog.recursiveEnter()) return;
        try {
            T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_11 = null;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void open(BFILE lob, int mode) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(lob) + ", " + OracleLog.argument(mode));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            byte[] locator = null;
            this.checkTrue(this.lifecycle == 1, 8);
            this.checkTrue(lob != null && (locator = lob.shareBytes()) != null, 54);
            byte[][] newLocatorHolder = new byte[1][];
            this.checkError(this.t2cLobOpen(this.m_nativeState, 114, locator, locator.length, mode, newLocatorHolder));
            lob.setShareBytes(newLocatorHolder[0]);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    Object var6_7 = null;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_14 = null;
            }
            catch (Throwable throwable2) {
                Object var10_15 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!TRACE || !OracleLog.recursiveEnter()) return;
        try {
            T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var10_12 = null;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void close(BFILE lob) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(lob));
                    Object var3_2 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            byte[] locator = null;
            this.checkTrue(this.lifecycle == 1, 8);
            this.checkTrue(lob != null && (locator = lob.shareBytes()) != null, 54);
            byte[][] newLocatorHolder = new byte[1][];
            this.checkError(this.t2cLobClose(this.m_nativeState, 114, locator, locator.length, newLocatorHolder));
            lob.setShareBytes(newLocatorHolder[0]);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    Object var5_6 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            Object var7_9 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var9_14 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_13 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_11 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean isOpen(BFILE lob) throws SQLException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(lob));
                    Object var3_2 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            byte[] locator = null;
            this.checkTrue(this.lifecycle == 1, 8);
            this.checkTrue(lob != null && (locator = lob.shareBytes()) != null, 54);
            boolean[] flagHolder = new boolean[1];
            this.checkError(this.t2cLobIsOpen(this.m_nativeState, 114, locator, locator.length, flagHolder));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + flagHolder[0]);
                    Object var5_6 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            bl = flagHolder[0];
            Object var7_10 = null;
            if (!TRACE) return bl;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var9_15 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_14 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return bl;
        try {
            T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_12 = null;
            OracleLog.recursiveExit();
            return bl;
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream newInputStream(BFILE bfile, int chunkSize, long pos) throws SQLException {
        OracleBlobInputStream oracleBlobInputStream;
        block19: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(bfile) + ", " + OracleLog.argument(chunkSize) + ", " + OracleLog.argument(pos));
                        oracleBlobInputStream = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_5 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if (pos != 0L) break block19;
                OracleBlobInputStream __result__ = new OracleBlobInputStream(bfile, chunkSize);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        Object var8_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_10 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                oracleBlobInputStream = __result__;
                Object var12_12 = null;
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var14_19 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var14_20 = null;
                        OracleLog.recursiveExit();
                        throw throwable2;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var14_15 = null;
                }
                catch (Throwable throwable) {
                    Object var14_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return oracleBlobInputStream;
        }
        OracleBlobInputStream __result__ = new OracleBlobInputStream(bfile, chunkSize, pos);
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                Object var10_24 = null;
            }
            catch (Throwable throwable) {
                Object var10_25 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        oracleBlobInputStream = __result__;
        Object var12_13 = null;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var14_17 = null;
            }
            catch (Throwable throwable) {
                Object var14_18 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return oracleBlobInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream newConversionInputStream(BFILE bfile, int conversionType) throws SQLException {
        OracleConversionInputStream oracleConversionInputStream;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(bfile) + ", " + OracleLog.argument(conversionType));
                    oracleConversionInputStream = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkTrue(bfile != null && bfile.shareBytes() != null, 54);
            OracleConversionInputStream result = new OracleConversionInputStream(this.conversion, bfile.getBinaryStream(), conversionType);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                    Object var6_7 = null;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            oracleConversionInputStream = result;
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_12 = null;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return oracleConversionInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader newConversionReader(BFILE bfile, int conversionType) throws SQLException {
        OracleConversionReader oracleConversionReader;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(bfile) + ", " + OracleLog.argument(conversionType));
                    oracleConversionReader = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkTrue(bfile != null && bfile.shareBytes() != null, 54);
            OracleConversionReader result = new OracleConversionReader(this.conversion, bfile.getBinaryStream(), conversionType);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                    Object var6_7 = null;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            oracleConversionReader = result;
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_12 = null;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return oracleConversionReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long length(BLOB blob) throws SQLException {
        long l2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(blob));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            byte[] locator = null;
            this.checkTrue(this.lifecycle == 1, 8);
            this.checkTrue(blob != null && (locator = blob.getLocator()) != null, 54);
            long __result__ = this.lobLength(locator);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var6_7 = null;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            l2 = __result__;
            Object var8_11 = null;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_15 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_13 = null;
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long position(BLOB blob, byte[] pattern, long start) throws SQLException {
        long l2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(blob) + ", " + OracleLog.argument(pattern) + ", " + OracleLog.argument(start));
                    Object var6_4 = null;
                }
                catch (Throwable throwable) {
                    Object var6_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkTrue(this.lifecycle == 1, 8);
            this.checkTrue(blob != null && blob.shareBytes() != null, 54);
            if (start < 1L) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68 + "position()");
                        Object var8_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_10 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            long result = LobPlsqlUtil.hasPattern(blob, pattern, start);
            long l3 = result = result == 0L ? -1L : result;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                    Object var10_13 = null;
                }
                catch (Throwable throwable) {
                    Object var10_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            l2 = result;
            Object var12_16 = null;
        }
        catch (Throwable throwable) {
            Object var12_17 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var14_20 = null;
                }
                catch (Throwable throwable2) {
                    Object var14_21 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var14_18 = null;
            }
            catch (Throwable throwable) {
                Object var14_19 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long position(BLOB blob, BLOB pattern, long start) throws SQLException {
        long l2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(blob) + ", " + OracleLog.argument(pattern) + ", " + OracleLog.argument(start));
                    Object var6_4 = null;
                }
                catch (Throwable throwable) {
                    Object var6_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkTrue(this.lifecycle == 1, 8);
            this.checkTrue(blob != null && blob.shareBytes() != null, 54);
            this.checkTrue(pattern != null && pattern.shareBytes() != null, 54);
            if (start < 1L) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68 + "position()");
                        Object var8_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_10 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            long result = LobPlsqlUtil.isSubLob(blob, pattern, start);
            long l3 = result = result == 0L ? -1L : result;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                    Object var10_13 = null;
                }
                catch (Throwable throwable) {
                    Object var10_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            l2 = result;
            Object var12_16 = null;
        }
        catch (Throwable throwable) {
            Object var12_17 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var14_20 = null;
                }
                catch (Throwable throwable2) {
                    Object var14_21 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var14_18 = null;
            }
            catch (Throwable throwable) {
                Object var14_19 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getBytes(BLOB blob, long offset, int amount, byte[] buffer) throws SQLException {
        int result;
        byte[] locator;
        block29: {
            int n2;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(blob) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(amount) + ", " + OracleLog.argument(buffer));
                        Object var7_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_6 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                locator = null;
                result = 0;
                this.checkTrue(this.lifecycle == 1, 8);
                this.checkTrue(blob != null && (locator = blob.getLocator()) != null, 54);
                if (amount > 0 && buffer != null) break block29;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 0);
                        Object var9_10 = null;
                    }
                    catch (Throwable throwable) {
                        Object var9_11 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                n2 = 0;
                Object var17_15 = null;
            }
            catch (Throwable throwable) {
                Object var17_17 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var19_22 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var19_23 = null;
                        OracleLog.recursiveExit();
                        throw throwable2;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var19_18 = null;
                }
                catch (Throwable throwable) {
                    Object var19_19 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return n2;
        }
        if (amount > buffer.length) {
            amount = buffer.length;
        }
        long lobLength = -1L;
        if (blob.isActivePrefetch()) {
            byte[] prefetchedBytes = blob.getPrefetchedData();
            lobLength = blob.length();
            if (prefetchedBytes != null && prefetchedBytes != null && offset <= (long)prefetchedBytes.length) {
                int nbOfBytesToGetFromPrefetched = Math.min(prefetchedBytes.length - (int)offset + 1, amount);
                System.arraycopy(prefetchedBytes, (int)offset - 1, buffer, 0, nbOfBytesToGetFromPrefetched);
                result += nbOfBytesToGetFromPrefetched;
            }
        }
        if (result < amount && (lobLength == -1L || offset - 1L + (long)result < lobLength)) {
            byte[] buffer2 = buffer;
            int result2 = result;
            int bytesToRead = (lobLength > 0L && lobLength < (long)amount ? (int)lobLength : amount) - result;
            if (result > 0) {
                buffer2 = new byte[bytesToRead];
            }
            if (this.useNio) {
                int sizeOfBuffer = buffer.length;
                if (this.nioBufferForLob == null || this.nioBufferForLob.capacity() < sizeOfBuffer) {
                    this.nioBufferForLob = ByteBuffer.allocateDirect(sizeOfBuffer);
                } else {
                    this.nioBufferForLob.rewind();
                }
            }
            result += this.blobRead(locator, offset + (long)result, bytesToRead, buffer2, this.useNio, this.nioBufferForLob);
            if (this.useNio) {
                this.nioBufferForLob.get(buffer2);
            }
            if (result2 > 0) {
                System.arraycopy(buffer2, 0, buffer, result2, buffer2.length);
            }
        }
        int __result__ = result;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                Object var15_32 = null;
            }
            catch (Throwable throwable) {
                Object var15_33 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        int n3 = __result__;
        Object var17_16 = null;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var19_20 = null;
            }
            catch (Throwable throwable) {
                Object var19_21 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int putBytes(BLOB blob, long offset, byte[] buffer, int bytesOffset, int length) throws SQLException {
        block21: {
            int n2;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(blob) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(buffer) + ", " + OracleLog.argument(bytesOffset) + ", " + OracleLog.argument(length));
                        Object var8_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                this.checkTrue(offset != 0L || length > 0, 68);
                this.checkTrue(offset >= 0L, 68);
                if (buffer != null && length > 0) break block21;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 0);
                        Object var10_12 = null;
                    }
                    catch (Throwable throwable) {
                        Object var10_13 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                n2 = 0;
                Object var14_16 = null;
            }
            catch (Throwable throwable) {
                Object var14_18 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var16_23 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var16_24 = null;
                        OracleLog.recursiveExit();
                        throw throwable2;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var16_19 = null;
                }
                catch (Throwable throwable) {
                    Object var16_20 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return n2;
        }
        int ret = 0;
        if (buffer == null || buffer.length == 0 || length <= 0) {
            ret = 0;
        } else {
            byte[] locator = null;
            this.checkTrue(this.lifecycle == 1, 8);
            this.checkTrue(blob != null && (locator = blob.getLocator()) != null, 54);
            byte[][] newLocatorHolder = new byte[1][];
            blob.setActivePrefetch(false);
            blob.clearCachedData();
            ret = this.blobWrite(locator, offset, buffer, newLocatorHolder, bytesOffset, length);
            blob.setLocator(newLocatorHolder[0]);
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                Object var12_28 = null;
            }
            catch (Throwable throwable) {
                Object var12_29 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        int n3 = ret;
        Object var14_17 = null;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var16_21 = null;
            }
            catch (Throwable throwable) {
                Object var16_22 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized int getChunkSize(BLOB blob) throws SQLException {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(blob));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            byte[] locator = null;
            this.checkTrue(this.lifecycle == 1, 8);
            this.checkTrue(blob != null && (locator = blob.getLocator()) != null, 54);
            int __result__ = this.lobGetChunkSize(locator);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var5_7 = null;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = __result__;
            Object var7_11 = null;
            if (!TRACE) return n2;
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_15 = null;
            }
            catch (Throwable throwable2) {
                Object var9_16 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return n2;
        try {
            T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_13 = null;
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void trim(BLOB lob, long newlen) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(newlen));
                    Object var5_3 = null;
                }
                catch (Throwable throwable) {
                    Object var5_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            byte[] locator = null;
            this.checkTrue(this.lifecycle == 1, 8);
            this.checkTrue(lob != null && (locator = lob.shareBytes()) != null, 54);
            byte[][] newLocatorHolder = new byte[1][];
            lob.setActivePrefetch(false);
            lob.clearCachedData();
            this.checkError(this.t2cLobTrim(this.m_nativeState, 113, newlen, locator, locator.length, newLocatorHolder));
            lob.setShareBytes(newLocatorHolder[0]);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    Object var7_7 = null;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_14 = null;
            }
            catch (Throwable throwable2) {
                Object var11_15 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!TRACE || !OracleLog.recursiveEnter()) return;
        try {
            T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var11_12 = null;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public synchronized BLOB createTemporaryBlob(Connection conn, boolean cache, int duration) throws SQLException {
        BLOB bLOB;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(cache) + ", " + OracleLog.argument(duration));
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            BLOB lob = null;
            this.checkTrue(this.lifecycle == 1, 8);
            lob = new BLOB((PhysicalConnection)conn);
            byte[][] newLocatorHolder = new byte[1][];
            this.checkError(this.t2cLobCreateTemporary(this.m_nativeState, 113, cache, duration, (short)0, newLocatorHolder));
            lob.setShareBytes(newLocatorHolder[0]);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + lob);
                    Object var7_8 = null;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bLOB = lob;
            Object var9_12 = null;
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var11_16 = null;
                }
                catch (Throwable throwable2) {
                    Object var11_17 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_14 = null;
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bLOB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void freeTemporary(BLOB temp_lob, boolean fromObject) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(temp_lob) + ", " + OracleLog.argument(fromObject));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            try {
                byte[] locator = null;
                this.checkTrue(this.lifecycle == 1, 8);
                this.checkTrue(temp_lob != null && (locator = temp_lob.shareBytes()) != null, 54);
                byte[][] newLocatorHolder = new byte[1][];
                this.checkError(this.t2cLobFreeTemporary(this.m_nativeState, 113, locator, locator.length, newLocatorHolder));
                temp_lob.setShareBytes(newLocatorHolder[0]);
            }
            catch (SQLException ex) {
                if (fromObject & ex.getErrorCode() == 64201) {
                    LobPlsqlUtil.freeTemporaryLob(this, temp_lob, 2004);
                }
                throw ex;
            }
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isTemporary(BLOB lob) throws SQLException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(lob));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            byte[] locator = null;
            this.checkTrue(lob != null && (locator = lob.shareBytes()) != null, 54);
            boolean[] flagHolder = new boolean[1];
            this.checkError(this.t2cLobIsTemporary(this.m_nativeState, 113, locator, locator.length, flagHolder));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + flagHolder[0]);
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = flagHolder[0];
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void open(BLOB blob, int mode) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(blob) + ", " + OracleLog.argument(mode));
                    Object var4_3 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            byte[] locator = null;
            this.checkTrue(this.lifecycle == 1, 8);
            this.checkTrue(blob != null && (locator = blob.shareBytes()) != null, 54);
            byte[][] newLocatorHolder = new byte[1][];
            this.checkError(this.t2cLobOpen(this.m_nativeState, 113, locator, locator.length, mode, newLocatorHolder));
            blob.setShareBytes(newLocatorHolder[0]);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    Object var6_7 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            Object var8_10 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var10_15 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var10_14 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var10_12 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void close(BLOB lob) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(lob));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            byte[] locator = null;
            this.checkTrue(this.lifecycle == 1, 8);
            this.checkTrue(lob != null && (locator = lob.shareBytes()) != null, 54);
            byte[][] newLocatorHolder = new byte[1][];
            this.checkError(this.t2cLobClose(this.m_nativeState, 113, locator, locator.length, newLocatorHolder));
            lob.setShareBytes(newLocatorHolder[0]);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_13 = null;
            }
            catch (Throwable throwable2) {
                Object var9_14 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!TRACE || !OracleLog.recursiveEnter()) return;
        try {
            T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_11 = null;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean isOpen(BLOB lob) throws SQLException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(lob));
                    Object var3_2 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            byte[] locator = null;
            this.checkTrue(this.lifecycle == 1, 8);
            this.checkTrue(lob != null && (locator = lob.shareBytes()) != null, 54);
            boolean[] flagHolder = new boolean[1];
            this.checkError(this.t2cLobIsOpen(this.m_nativeState, 113, locator, locator.length, flagHolder));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + flagHolder[0]);
                    Object var5_6 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            bl = flagHolder[0];
            Object var7_10 = null;
            if (!TRACE) return bl;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var9_15 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_14 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return bl;
        try {
            T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_12 = null;
            OracleLog.recursiveExit();
            return bl;
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream newInputStream(BLOB blob, int chunkSize, long pos) throws SQLException {
        OracleBlobInputStream oracleBlobInputStream;
        block19: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(blob) + ", " + OracleLog.argument(chunkSize) + ", " + OracleLog.argument(pos));
                        oracleBlobInputStream = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_5 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if (pos != 0L) break block19;
                OracleBlobInputStream __result__ = new OracleBlobInputStream(blob, chunkSize);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        Object var8_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_10 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                oracleBlobInputStream = __result__;
                Object var12_12 = null;
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var14_19 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var14_20 = null;
                        OracleLog.recursiveExit();
                        throw throwable2;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var14_15 = null;
                }
                catch (Throwable throwable) {
                    Object var14_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return oracleBlobInputStream;
        }
        OracleBlobInputStream __result__ = new OracleBlobInputStream(blob, chunkSize, pos);
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                Object var10_24 = null;
            }
            catch (Throwable throwable) {
                Object var10_25 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        oracleBlobInputStream = __result__;
        Object var12_13 = null;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var14_17 = null;
            }
            catch (Throwable throwable) {
                Object var14_18 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return oracleBlobInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OutputStream newOutputStream(BLOB blob, int chunkSize, long pos, boolean zeroInvalid) throws SQLException {
        OracleBlobOutputStream oracleBlobOutputStream;
        block20: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(blob) + ", " + OracleLog.argument(chunkSize) + ", " + OracleLog.argument(pos));
                        oracleBlobOutputStream = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_6 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if (pos != 0L) break block20;
                if (zeroInvalid & this.lobStreamPosStandardCompliant) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T2CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                            Object var9_11 = null;
                        }
                        catch (Throwable throwable) {
                            Object var9_12 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                OracleBlobOutputStream __result__ = new OracleBlobOutputStream(blob, chunkSize);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        Object var11_14 = null;
                    }
                    catch (Throwable throwable) {
                        Object var11_15 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                oracleBlobOutputStream = __result__;
                Object var15_17 = null;
                if (!TRACE) return oracleBlobOutputStream;
            }
            catch (Throwable throwable) {
                Object var15_19 = null;
                if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var17_24 = null;
                }
                catch (Throwable throwable2) {
                    Object var17_25 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                    throw throwable;
                }
            }
            if (!OracleLog.recursiveEnter()) return oracleBlobOutputStream;
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var17_20 = null;
            }
            catch (Throwable throwable) {
                Object var17_21 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            return oracleBlobOutputStream;
        }
        OracleBlobOutputStream __result__ = new OracleBlobOutputStream(blob, chunkSize, pos);
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                Object var13_29 = null;
            }
            catch (Throwable throwable) {
                Object var13_30 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        oracleBlobOutputStream = __result__;
        Object var15_18 = null;
        if (!TRACE) return oracleBlobOutputStream;
        if (!OracleLog.recursiveEnter()) return oracleBlobOutputStream;
        try {
            T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var17_22 = null;
        }
        catch (Throwable throwable) {
            Object var17_23 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
        return oracleBlobOutputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream newConversionInputStream(BLOB blob, int conversionType) throws SQLException {
        OracleConversionInputStream oracleConversionInputStream;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(blob) + ", " + OracleLog.argument(conversionType));
                    oracleConversionInputStream = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkTrue(blob != null && blob.shareBytes() != null, 54);
            OracleConversionInputStream result = new OracleConversionInputStream(this.conversion, blob.getBinaryStream(), conversionType);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                    Object var6_7 = null;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            oracleConversionInputStream = result;
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_12 = null;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return oracleConversionInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Reader newConversionReader(BLOB blob, int conversionType) throws SQLException {
        OracleConversionReader oracleConversionReader;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(blob) + ", " + OracleLog.argument(conversionType));
                    oracleConversionReader = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkTrue(blob != null && blob.shareBytes() != null, 54);
            OracleConversionReader result = new OracleConversionReader(this.conversion, blob.getBinaryStream(), conversionType);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                    Object var6_7 = null;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            oracleConversionReader = result;
            Object var8_10 = null;
            if (!TRACE) return oracleConversionReader;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_14 = null;
            }
            catch (Throwable throwable2) {
                Object var10_15 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return oracleConversionReader;
        try {
            T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var10_12 = null;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
        return oracleConversionReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized long length(CLOB clob) throws SQLException {
        long l2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(clob));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            byte[] locator = null;
            this.checkTrue(this.lifecycle == 1, 8);
            this.checkTrue(clob != null && (locator = clob.getLocator()) != null, 54);
            long __result__ = this.lobLength(locator);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var6_7 = null;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            l2 = __result__;
            Object var8_11 = null;
            if (!TRACE) return l2;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_15 = null;
            }
            catch (Throwable throwable2) {
                Object var10_16 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return l2;
        try {
            T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var10_13 = null;
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public synchronized long position(CLOB clob, String pattern, long start) throws SQLException {
        long l2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(clob) + ", " + OracleLog.argument(pattern) + ", " + OracleLog.argument(start));
                    Object var6_4 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var6_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if (pattern == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                        Object var8_11 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var8_12 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.checkTrue(this.lifecycle == 1, 8);
            this.checkTrue(clob != null && clob.shareBytes() != null, 54);
            if (start < 1L) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68 + "position()");
                        Object var10_15 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var10_16 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            char[] chars = new char[pattern.length()];
            pattern.getChars(0, chars.length, chars, 0);
            long result = LobPlsqlUtil.hasPattern(clob, chars, start);
            long l3 = result = result == 0L ? -1L : result;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                    Object var12_18 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var12_19 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            l2 = result;
            Object var14_21 = null;
            if (!TRACE) return l2;
        }
        catch (Throwable throwable) {
            Object var14_22 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var16_26 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var16_25 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return l2;
        try {
            T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var16_23 = null;
            OracleLog.recursiveExit();
            return l2;
        }
        catch (Throwable throwable) {
            Object var16_24 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized long position(CLOB clob, CLOB pattern, long start) throws SQLException {
        long l2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(clob) + ", " + OracleLog.argument(pattern) + ", " + OracleLog.argument(start));
                    Object var6_4 = null;
                }
                catch (Throwable throwable) {
                    Object var6_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkTrue(this.lifecycle == 1, 8);
            this.checkTrue(clob != null && clob.shareBytes() != null, 54);
            this.checkTrue(pattern != null && pattern.shareBytes() != null, 54);
            if (start < 1L) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68 + "position()");
                        Object var8_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_10 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            long result = LobPlsqlUtil.isSubLob(clob, pattern, start);
            long l3 = result = result == 0L ? -1L : result;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                    Object var10_13 = null;
                }
                catch (Throwable throwable) {
                    Object var10_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            l2 = result;
            Object var12_16 = null;
            if (!TRACE) return l2;
        }
        catch (Throwable throwable) {
            Object var12_17 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var14_20 = null;
            }
            catch (Throwable throwable2) {
                Object var14_21 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return l2;
        try {
            T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var14_18 = null;
        }
        catch (Throwable throwable) {
            Object var14_19 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getChars(CLOB clob, long offset, int amount, char[] buffer) throws SQLException {
        byte[] locator;
        block29: {
            int n2;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(clob) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(amount) + ", " + OracleLog.argument(buffer));
                        Object var7_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_6 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                locator = null;
                this.checkTrue(this.lifecycle == 1, 8);
                this.checkTrue(clob != null && (locator = clob.getLocator()) != null, 54);
                if (amount > 0 && buffer != null) break block29;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 0);
                        Object var9_11 = null;
                    }
                    catch (Throwable throwable) {
                        Object var9_12 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                n2 = 0;
                Object var18_15 = null;
            }
            catch (Throwable throwable) {
                Object var18_17 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var20_22 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var20_23 = null;
                        OracleLog.recursiveExit();
                        throw throwable2;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var20_18 = null;
                }
                catch (Throwable throwable) {
                    Object var20_19 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return n2;
        }
        if (amount > buffer.length) {
            amount = buffer.length;
        }
        int result = 0;
        long lobLength = -1L;
        if (clob.isActivePrefetch()) {
            lobLength = clob.length();
            char[] prefetchedChars = clob.getPrefetchedData();
            if (prefetchedChars != null && offset <= (long)prefetchedChars.length) {
                int nbOfCharsToGetFromPrefetched = Math.min(prefetchedChars.length - (int)offset + 1, amount);
                System.arraycopy(prefetchedChars, (int)offset - 1, buffer, 0, nbOfCharsToGetFromPrefetched);
                result += nbOfCharsToGetFromPrefetched;
            }
        }
        if (result < amount && (lobLength == -1L || offset - 1L + (long)result < lobLength)) {
            char[] buffer2 = buffer;
            int result2 = result;
            int bytesToRead = (lobLength > 0L && lobLength < (long)amount ? (int)lobLength : amount) - result;
            if (result > 0) {
                buffer2 = new char[bytesToRead];
            }
            if (this.useNio) {
                int sizeOfBuffer = buffer.length * 2;
                if (this.nioBufferForLob == null || this.nioBufferForLob.capacity() < sizeOfBuffer) {
                    this.nioBufferForLob = ByteBuffer.allocateDirect(sizeOfBuffer);
                } else {
                    this.nioBufferForLob.rewind();
                }
            }
            result += this.t2cClobRead(this.m_nativeState, locator, locator.length, offset + (long)result, bytesToRead, buffer2, buffer2.length, clob.isNCLOB(), this.useNio, this.nioBufferForLob);
            if (this.useNio) {
                ByteBuffer b2 = this.nioBufferForLob.order(ByteOrder.LITTLE_ENDIAN);
                CharBuffer c2 = b2.asCharBuffer();
                c2.get(buffer2);
            }
            if (result2 > 0) {
                System.arraycopy(buffer2, 0, buffer, result2, buffer2.length);
            }
            this.checkError(result);
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                Object var16_34 = null;
            }
            catch (Throwable throwable) {
                Object var16_35 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        int n3 = result;
        Object var18_16 = null;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var20_20 = null;
            }
            catch (Throwable throwable) {
                Object var20_21 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int putChars(CLOB clob, long offset, char[] buffer, int charsOffset, int length) throws SQLException {
        byte[] locator;
        block19: {
            int n2;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(clob) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(buffer) + ", " + OracleLog.argument(charsOffset) + ", " + OracleLog.argument(length));
                        Object var8_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                locator = null;
                this.checkTrue(this.lifecycle == 1, 8);
                this.checkTrue(offset >= 0L, 68);
                this.checkTrue(clob != null && (locator = clob.getLocator()) != null, 54);
                if (buffer != null) break block19;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 0);
                        Object var10_11 = null;
                    }
                    catch (Throwable throwable) {
                        Object var10_12 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                n2 = 0;
                Object var14_16 = null;
            }
            catch (Throwable throwable) {
                Object var14_18 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var16_23 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var16_24 = null;
                        OracleLog.recursiveExit();
                        throw throwable2;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var16_19 = null;
                }
                catch (Throwable throwable) {
                    Object var16_20 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return n2;
        }
        byte[][] newLocatorHolder = new byte[1][];
        clob.setActivePrefetch(false);
        clob.clearCachedData();
        int result = this.clobWrite(locator, offset, buffer, newLocatorHolder, clob.isNCLOB(), charsOffset, length);
        clob.setLocator(newLocatorHolder[0]);
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                Object var12_28 = null;
            }
            catch (Throwable throwable) {
                Object var12_29 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        int n3 = result;
        Object var14_17 = null;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var16_21 = null;
            }
            catch (Throwable throwable) {
                Object var16_22 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized int getChunkSize(CLOB clob) throws SQLException {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(clob));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            byte[] locator = null;
            this.checkTrue(this.lifecycle == 1, 8);
            this.checkTrue(clob != null && (locator = clob.getLocator()) != null, 54);
            int __result__ = this.lobGetChunkSize(locator);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var5_7 = null;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = __result__;
            Object var7_11 = null;
            if (!TRACE) return n2;
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_15 = null;
            }
            catch (Throwable throwable2) {
                Object var9_16 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return n2;
        try {
            T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_13 = null;
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void trim(CLOB clob, long newlen) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(clob) + ", " + OracleLog.argument(newlen));
                    Object var5_3 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var5_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            byte[] locator = null;
            this.checkTrue(this.lifecycle == 1, 8);
            this.checkTrue(clob != null && (locator = clob.shareBytes()) != null, 54);
            byte[][] newLocatorHolder = new byte[1][];
            clob.setActivePrefetch(false);
            clob.clearCachedData();
            this.checkError(this.t2cLobTrim(this.m_nativeState, 112, newlen, locator, locator.length, newLocatorHolder));
            clob.setShareBytes(newLocatorHolder[0]);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    Object var7_7 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            Object var9_10 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var11_15 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var11_14 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var11_12 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public synchronized CLOB createTemporaryClob(Connection conn, boolean cache, int duration, short form_of_use) throws SQLException {
        CLOB cLOB;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(cache) + ", " + OracleLog.argument(duration) + ", " + OracleLog.argument(form_of_use));
                    Object var6_5 = null;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            CLOB lob = null;
            this.checkTrue(this.lifecycle == 1, 8);
            lob = form_of_use == 1 ? new CLOB((PhysicalConnection)conn) : new NCLOB((PhysicalConnection)conn);
            byte[][] newLocatorHolder = new byte[1][];
            this.checkError(this.t2cLobCreateTemporary(this.m_nativeState, 112, cache, duration, form_of_use, newLocatorHolder));
            lob.setShareBytes(newLocatorHolder[0]);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + lob);
                    Object var8_9 = null;
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            cLOB = lob;
            Object var10_13 = null;
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var12_17 = null;
                }
                catch (Throwable throwable2) {
                    Object var12_18 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var12_15 = null;
            }
            catch (Throwable throwable) {
                Object var12_16 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return cLOB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void freeTemporary(CLOB temp_lob, boolean fromObject) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(temp_lob) + ", " + OracleLog.argument(fromObject));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            try {
                byte[] locator = null;
                this.checkTrue(this.lifecycle == 1, 8);
                this.checkTrue(temp_lob != null && (locator = temp_lob.shareBytes()) != null, 54);
                byte[][] newLocatorHolder = new byte[1][];
                this.checkError(this.t2cLobFreeTemporary(this.m_nativeState, 112, locator, locator.length, newLocatorHolder));
                temp_lob.setShareBytes(newLocatorHolder[0]);
            }
            catch (SQLException ex) {
                if (!(fromObject & ex.getErrorCode() == 64201)) throw ex;
                LobPlsqlUtil.freeTemporaryLob(this, temp_lob, 2005);
            }
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_12 = null;
            }
            catch (Throwable throwable2) {
                Object var8_13 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!TRACE || !OracleLog.recursiveEnter()) return;
        try {
            T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isTemporary(CLOB lob) throws SQLException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(lob));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            byte[] locator = null;
            this.checkTrue(lob != null && (locator = lob.shareBytes()) != null, 54);
            boolean[] flagHolder = new boolean[1];
            this.checkError(this.t2cLobIsTemporary(this.m_nativeState, 112, locator, locator.length, flagHolder));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + flagHolder[0]);
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = flagHolder[0];
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public synchronized void open(CLOB lob, int mode) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(lob) + ", " + OracleLog.argument(mode));
                    Object var4_3 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            byte[] locator = null;
            this.checkTrue(this.lifecycle == 1, 8);
            this.checkTrue(lob != null && (locator = lob.shareBytes()) != null, 54);
            byte[][] newLocatorHolder = new byte[1][];
            this.checkError(this.t2cLobOpen(this.m_nativeState, 112, locator, locator.length, mode, newLocatorHolder));
            lob.setShareBytes(newLocatorHolder[0]);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    Object var6_7 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            Object var8_10 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var10_15 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var10_14 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var10_12 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void close(CLOB lob) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(lob));
                    Object var3_2 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            byte[] locator = null;
            this.checkTrue(this.lifecycle == 1, 8);
            this.checkTrue(lob != null && (locator = lob.shareBytes()) != null, 54);
            byte[][] newLocatorHolder = new byte[1][];
            this.checkError(this.t2cLobClose(this.m_nativeState, 112, locator, locator.length, newLocatorHolder));
            lob.setShareBytes(newLocatorHolder[0]);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    Object var5_6 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            Object var7_9 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var9_14 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_13 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_11 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isOpen(CLOB lob) throws SQLException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(lob));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            byte[] locator = null;
            this.checkTrue(this.lifecycle == 1, 8);
            this.checkTrue(lob != null && (locator = lob.shareBytes()) != null, 54);
            boolean[] flagHolder = new boolean[1];
            this.checkError(this.t2cLobIsOpen(this.m_nativeState, 112, locator, locator.length, flagHolder));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + flagHolder[0]);
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = flagHolder[0];
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream newInputStream(CLOB clob, int chunkSize, long pos) throws SQLException {
        OracleClobInputStream oracleClobInputStream;
        block19: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(clob) + ", " + OracleLog.argument(chunkSize) + ", " + OracleLog.argument(pos));
                        oracleClobInputStream = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_5 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if (pos != 0L) break block19;
                OracleClobInputStream __result__ = new OracleClobInputStream(clob, chunkSize);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        Object var8_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_10 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                oracleClobInputStream = __result__;
                Object var12_12 = null;
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var14_19 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var14_20 = null;
                        OracleLog.recursiveExit();
                        throw throwable2;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var14_15 = null;
                }
                catch (Throwable throwable) {
                    Object var14_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return oracleClobInputStream;
        }
        OracleClobInputStream __result__ = new OracleClobInputStream(clob, chunkSize, pos);
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                Object var10_24 = null;
            }
            catch (Throwable throwable) {
                Object var10_25 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        oracleClobInputStream = __result__;
        Object var12_13 = null;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var14_17 = null;
            }
            catch (Throwable throwable) {
                Object var14_18 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return oracleClobInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream newOutputStream(CLOB clob, int chunkSize, long pos, boolean zeroInvalid) throws SQLException {
        OracleClobOutputStream oracleClobOutputStream;
        block23: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(clob) + ", " + OracleLog.argument(chunkSize) + ", " + OracleLog.argument(pos));
                        oracleClobOutputStream = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_6 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if (pos != 0L) break block23;
                if (zeroInvalid & this.lobStreamPosStandardCompliant) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T2CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                            Object var9_11 = null;
                        }
                        catch (Throwable throwable) {
                            Object var9_12 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                OracleClobOutputStream __result__ = new OracleClobOutputStream(clob, chunkSize);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        Object var11_14 = null;
                    }
                    catch (Throwable throwable) {
                        Object var11_15 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                oracleClobOutputStream = __result__;
                Object var15_17 = null;
            }
            catch (Throwable throwable) {
                Object var15_19 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var17_24 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var17_25 = null;
                        OracleLog.recursiveExit();
                        throw throwable2;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var17_20 = null;
                }
                catch (Throwable throwable) {
                    Object var17_21 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return oracleClobOutputStream;
        }
        OracleClobOutputStream __result__ = new OracleClobOutputStream(clob, chunkSize, pos);
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                Object var13_29 = null;
            }
            catch (Throwable throwable) {
                Object var13_30 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        oracleClobOutputStream = __result__;
        Object var15_18 = null;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var17_22 = null;
            }
            catch (Throwable throwable) {
                Object var17_23 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return oracleClobOutputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader newReader(CLOB clob, int chunkSize, long pos) throws SQLException {
        OracleClobReader oracleClobReader;
        block19: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(clob) + ", " + OracleLog.argument(chunkSize) + ", " + OracleLog.argument(pos));
                        oracleClobReader = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_5 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if (pos != 0L) break block19;
                OracleClobReader __result__ = new OracleClobReader(clob, chunkSize);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        Object var8_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_10 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                oracleClobReader = __result__;
                Object var12_12 = null;
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var14_19 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var14_20 = null;
                        OracleLog.recursiveExit();
                        throw throwable2;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var14_15 = null;
                }
                catch (Throwable throwable) {
                    Object var14_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return oracleClobReader;
        }
        OracleClobReader __result__ = new OracleClobReader(clob, chunkSize, pos);
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                Object var10_24 = null;
            }
            catch (Throwable throwable) {
                Object var10_25 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        oracleClobReader = __result__;
        Object var12_13 = null;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var14_17 = null;
            }
            catch (Throwable throwable) {
                Object var14_18 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return oracleClobReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public Reader newReader(CLOB clob, int chunkSize, long pos, long length) throws SQLException {
        OracleClobReader oracleClobReader;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(clob) + ", " + OracleLog.argument(chunkSize) + ", " + OracleLog.argument(pos) + ", " + OracleLog.argument(length));
                    oracleClobReader = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var8_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            OracleClobReader __result__ = new OracleClobReader(clob, chunkSize, pos, length);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var10_9 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var10_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            oracleClobReader = __result__;
            Object var12_12 = null;
            if (!TRACE) return oracleClobReader;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var14_17 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var14_16 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return oracleClobReader;
        try {
            T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var14_14 = null;
            OracleLog.recursiveExit();
            return oracleClobReader;
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Writer newWriter(CLOB clob, int chunkSize, long pos, boolean zeroInvalid) throws SQLException {
        OracleClobWriter oracleClobWriter;
        block23: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(clob) + ", " + OracleLog.argument(chunkSize) + ", " + OracleLog.argument(pos));
                        oracleClobWriter = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_6 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if (pos != 0L) break block23;
                if (zeroInvalid & this.lobStreamPosStandardCompliant) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T2CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                            Object var9_11 = null;
                        }
                        catch (Throwable throwable) {
                            Object var9_12 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                OracleClobWriter __result__ = new OracleClobWriter(clob, chunkSize);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        Object var11_14 = null;
                    }
                    catch (Throwable throwable) {
                        Object var11_15 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                oracleClobWriter = __result__;
                Object var15_17 = null;
            }
            catch (Throwable throwable) {
                Object var15_19 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var17_24 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var17_25 = null;
                        OracleLog.recursiveExit();
                        throw throwable2;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var17_20 = null;
                }
                catch (Throwable throwable) {
                    Object var17_21 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return oracleClobWriter;
        }
        OracleClobWriter __result__ = new OracleClobWriter(clob, chunkSize, pos);
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                Object var13_29 = null;
            }
            catch (Throwable throwable) {
                Object var13_30 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        oracleClobWriter = __result__;
        Object var15_18 = null;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var17_22 = null;
            }
            catch (Throwable throwable) {
                Object var17_23 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return oracleClobWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void registerTAFCallback(OracleOCIFailover cbk, Object obj) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(cbk) + ", " + OracleLog.argument(obj));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.appCallback = cbk;
            this.appCallbackObject = obj;
            this.checkError(this.t2cRegisterTAFCallback(this.m_nativeState));
            Object var6_6 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable2) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized int callTAFCallbackMethod(int type, int event) {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(type) + ", " + OracleLog.argument(event));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            int retCode = 0;
            if (this.appCallback != null) {
                retCode = this.appCallback.callbackFn(this, this.appCallbackObject, type, event);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + retCode);
                    Object var6_8 = null;
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = retCode;
            Object var8_11 = null;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_15 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_13 = null;
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHeapAllocSize() throws SQLException {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (this.lifecycle != 1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 8);
                        Object var4_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_8 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            int size = this.t2cGetHeapAllocSize(this.m_nativeState);
            if (size < 0) {
                SQLException __ex__;
                if (size == -999) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T2CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 23);
                            Object var6_10 = null;
                        }
                        catch (Throwable throwable) {
                            Object var6_11 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 89);
                        Object var8_13 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_14 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 89);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + size);
                    Object var10_16 = null;
                }
                catch (Throwable throwable) {
                    Object var10_17 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = size;
            Object var12_19 = null;
        }
        catch (Throwable throwable) {
            Object var12_20 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var14_23 = null;
                }
                catch (Throwable throwable2) {
                    Object var14_24 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var14_21 = null;
            }
            catch (Throwable throwable) {
                Object var14_22 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOCIEnvHeapAllocSize() throws SQLException {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (this.lifecycle != 1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 8);
                        Object var4_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_8 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            int size = this.t2cGetOciEnvHeapAllocSize(this.m_nativeState);
            if (size < 0) {
                SQLException __ex__;
                if (size == -999) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T2CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 23);
                            Object var6_10 = null;
                        }
                        catch (Throwable throwable) {
                            Object var6_11 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.checkError(size);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 89);
                        Object var8_13 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_14 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 89);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + size);
                    Object var10_16 = null;
                }
                catch (Throwable throwable) {
                    Object var10_17 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = size;
            Object var12_19 = null;
        }
        catch (Throwable throwable) {
            Object var12_20 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var14_23 = null;
                }
                catch (Throwable throwable2) {
                    Object var14_24 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var14_21 = null;
            }
            catch (Throwable throwable) {
                Object var14_22 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final short getClientCharSetId() {
        short s2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, "         Enter: " + OracleLog.argument());
                    Object var1 = null;
                }
                catch (Throwable throwable) {
                    Object var1_1 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            short __result__ = 871;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, "         Return: " + __result__);
                    Object var3_5 = null;
                }
                catch (Throwable throwable) {
                    Object var3_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            s2 = __result__;
            Object var5_8 = null;
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, "         Exit");
                    Object var7_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, "         Exit");
                Object var7_10 = null;
            }
            catch (Throwable throwable) {
                Object var7_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return s2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static short getDriverCharSetIdFromNLS_LANG() throws SQLException {
        short s2;
        try {
            short driverCharSetId;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, "         Enter: " + OracleLog.argument());
                    Object var1 = null;
                }
                catch (Throwable throwable) {
                    Object var1_1 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (!isLibraryLoaded) {
                T2CConnection.loadNativeLibrary();
            }
            if ((driverCharSetId = T2CConnection.t2cGetDriverCharSetFromNlsLang()) < 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CConnection.logger().log(Level.SEVERE, "         Throwing SQLException: 8");
                        Object var3_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_6 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(null, 8);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, "         Return: " + driverCharSetId);
                    Object var5_8 = null;
                }
                catch (Throwable throwable) {
                    Object var5_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            s2 = driverCharSetId;
            Object var7_11 = null;
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, "         Exit");
                    Object var9_15 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, "         Exit");
                Object var9_13 = null;
            }
            catch (Throwable throwable) {
                Object var9_14 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return s2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void doProxySession(int type, Properties prop) throws SQLException {
        try {
            byte[] cfBytes;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(type) + ", " + OracleLog.argument(prop));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Object roles = null;
            int numProxyRoles = 0;
            this.savedUser = this.userName;
            this.userName = null;
            byte[] dnBytes = cfBytes = new byte[0];
            byte[] pwdBytes = cfBytes;
            byte[] userBytes = cfBytes;
            switch (type) {
                case 1: {
                    this.userName = prop.getProperty("PROXY_USER_NAME");
                    String pwd = prop.getProperty("PROXY_USER_PASSWORD");
                    if (this.userName != null) {
                        userBytes = DBConversion.stringToDriverCharBytes(this.userName, this.m_clientCharacterSet);
                    }
                    if (pwd == null) break;
                    pwdBytes = DBConversion.stringToDriverCharBytes(pwd, this.m_clientCharacterSet);
                    break;
                }
                case 2: {
                    String distName = prop.getProperty("PROXY_DISTINGUISHED_NAME");
                    if (distName == null) break;
                    dnBytes = DBConversion.stringToDriverCharBytes(distName, this.m_clientCharacterSet);
                    break;
                }
                case 3: {
                    Object certif = prop.get("PROXY_CERTIFICATE");
                    cfBytes = (byte[])certif;
                }
            }
            String[] strRoles = (String[])prop.get("PROXY_ROLES");
            if (strRoles != null) {
                numProxyRoles = strRoles.length;
                roles = new byte[numProxyRoles][];
                for (int i2 = 0; i2 < numProxyRoles; ++i2) {
                    if (strRoles[i2] == null) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T2CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 150);
                                Object var15_16 = null;
                            }
                            catch (Throwable throwable) {
                                Object var15_17 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 150);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    roles[i2] = DBConversion.stringToDriverCharBytes(strRoles[i2], this.m_clientCharacterSet);
                }
            }
            this.sqlWarning = this.checkError(this.t2cDoProxySession(this.m_nativeState, type, userBytes, userBytes.length, pwdBytes, pwdBytes.length, dnBytes, dnBytes.length, cfBytes, cfBytes.length, numProxyRoles, (byte[][])roles), this.sqlWarning);
            this.isProxy = true;
            Object var17_20 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var17_21 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var19_24 = null;
            }
            catch (Throwable throwable2) {
                Object var19_25 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var19_22 = null;
        }
        catch (Throwable throwable) {
            Object var19_23 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void closeProxySession() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.checkError(this.t2cCloseProxySession(this.m_nativeState));
            this.userName = this.savedUser;
            Object var4_4 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var6_9 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var6_8 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var6_6 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDescribeTable(AutoKeyInfo info) throws SQLException {
        try {
            int numColumns;
            boolean tryAgain;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(info));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            String tableName = info.getTableName();
            byte[] bytesTableName = DBConversion.stringToDriverCharBytes(tableName, this.m_clientCharacterSet);
            do {
                tryAgain = false;
                numColumns = T2CConnection.t2cDescribeTable(this.m_nativeState, bytesTableName, bytesTableName.length, this.queryMetaData1, this.queryMetaData2, this.queryMetaData1Offset, this.queryMetaData2Offset, this.queryMetaData1Size, this.queryMetaData2Size);
                if (numColumns == -1) {
                    this.checkError(numColumns);
                }
                if (numColumns != T2CStatement.T2C_EXTEND_BUFFER) continue;
                tryAgain = true;
                this.reallocateQueryMetaData(this.queryMetaData1Size * 2, this.queryMetaData2Size * 2);
            } while (tryAgain);
            this.processDescribeTableData(numColumns, info);
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_10 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDescribeTableData(int numColumns, AutoKeyInfo info) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(numColumns) + ", " + OracleLog.argument(info));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            short[] s2 = this.queryMetaData1;
            byte[] c2 = this.queryMetaData2;
            int currentShort = this.queryMetaData1Offset;
            int currentChar = this.queryMetaData2Offset;
            info.allocateSpaceForDescribedData(numColumns);
            for (int i2 = 0; i2 < numColumns; ++i2) {
                short type = s2[currentShort + 0];
                short columnNameLen = s2[currentShort + 6];
                String columnName = T2CConnection.bytes2String(c2, currentChar, columnNameLen, this.conversion);
                short maxLength = s2[currentShort + 1];
                short maxCharLength = s2[currentShort + 11];
                boolean nullable = s2[currentShort + 2] != 0;
                short formOfUse = s2[currentShort + 5];
                short precision = s2[currentShort + 3];
                short scale = s2[currentShort + 4];
                short typeNameLen = s2[currentShort + 12];
                currentChar += columnNameLen;
                currentShort += 13;
                String typeName = null;
                if (typeNameLen > 0) {
                    typeName = T2CConnection.bytes2String(c2, currentChar, typeNameLen, this.conversion);
                    currentChar += typeNameLen;
                }
                info.fillDescribedData(i2, columnName, type, maxCharLength > 0 ? maxCharLength : maxLength, nullable, formOfUse, precision, scale, typeName);
            }
            Object var20_21 = null;
        }
        catch (Throwable throwable) {
            Object var20_22 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var22_25 = null;
                }
                catch (Throwable throwable2) {
                    Object var22_26 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var22_23 = null;
            }
            catch (Throwable throwable) {
                Object var22_24 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doSetApplicationContext(String nameSpace, String attribute, String value) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(nameSpace) + ", " + OracleLog.argument(attribute) + ", " + OracleLog.argument(value));
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkError(this.t2cSetApplicationContext(this.m_nativeState, nameSpace, attribute, value));
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_11 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_12 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doClearAllApplicationContext(String nameSpace) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(nameSpace));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkError(this.t2cClearAllApplicationContext(this.m_nativeState, nameSpace));
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doStartup(int mode) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(mode));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.checkError(this.t2cStartupDatabase(this.m_nativeState, mode));
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void doShutdown(int mode) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(mode));
                    Object var3_2 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.checkError(this.t2cShutdownDatabase(this.m_nativeState, mode));
            Object var5_5 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var7_10 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var7_9 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var7_7 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void loadNativeLibrary() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, "         Enter: " + OracleLog.argument());
                    Object var1 = null;
                }
                catch (Throwable throwable) {
                    Object var1_1 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Class<T2CConnection> clazz = T2CConnection.class;
            synchronized (T2CConnection.class) {
                if (!isLibraryLoaded) {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public Object run() {
                            System.loadLibrary(T2CConnection.OCILIBRARY);
                            int libraryVersion = T2CConnection.getLibraryVersionNumber();
                            if ((long)libraryVersion != JDBC_OCI_LIBRARY_VERSION) {
                                throw new Error("Incompatible version of libocijdbc[Jdbc:" + JDBC_OCI_LIBRARY_VERSION + ", Jdbc-OCI:" + libraryVersion);
                            }
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    T2CConnection.logger().log(Level.FINER, "         Return: " + null);
                                    Object var3_2 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var3_3 = null;
                                    OracleLog.recursiveExit();
                                    throw throwable;
                                }
                                OracleLog.recursiveExit();
                                {
                                }
                            }
                            return null;
                        }
                    });
                    isLibraryLoaded = true;
                }
                // ** MonitorExit[var0_3] (shouldn't be in output)
                Object var4_5 = null;
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, "         Exit");
                    Object var6_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var6_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, "         Exit");
                    Object var6_7 = null;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkTrue(boolean assertion, int errCode) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(assertion) + ", " + OracleLog.argument(errCode));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (!assertion) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T2CConnection.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + errCode);
                        Object var6_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_8 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), errCode);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_12 = null;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean useLittleEndianSetCHARBinder() throws SQLException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            boolean __result__ = this.t2cPlatformIsLittleEndian(this.m_nativeState);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var4_6 = null;
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = __result__;
            Object var6_9 = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_11 = null;
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getPropertyForPooledConnection(OraclePooledConnection pc) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(pc));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            super.getPropertyForPooledConnection(pc, this.password);
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static final char[] getCharArray(String s2) {
        char[] cArray;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(s2));
                    cArray = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            char[] r2 = null;
            if (s2 == null) {
                r2 = new char[]{};
            } else {
                r2 = new char[s2.length()];
                s2.getChars(0, s2.length(), r2, 0);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, "         Return: " + r2);
                    Object var4_5 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            cArray = r2;
            Object var6_8 = null;
            if (!TRACE) return cArray;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var8_13 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            T2CConnection.logger().log(Level.FINER, "         Exit");
            Object var8_12 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return cArray;
        try {
            T2CConnection.logger().log(Level.FINER, "         Exit");
            Object var8_10 = null;
            OracleLog.recursiveExit();
            return cArray;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String bytes2String(byte[] bytes, int offset, int size, DBConversion conversion) throws SQLException {
        String string;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(size) + ", " + OracleLog.argument(conversion));
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            byte[] tmp = new byte[size];
            System.arraycopy(bytes, offset, tmp, 0, size);
            String __result__ = conversion.CharBytesToString(tmp, size);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, "         Return: " + __result__);
                    Object var7_8 = null;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            string = __result__;
            Object var9_12 = null;
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, "         Exit");
                    Object var11_16 = null;
                }
                catch (Throwable throwable2) {
                    Object var11_17 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CConnection.logger().log(Level.FINER, "         Exit");
                Object var11_14 = null;
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void disableNio() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.useNio = false;
            Object var4_4 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                T2CConnection.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var6_8 = null;
            }
            catch (Throwable throwable2) {
                Object var6_9 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            T2CConnection.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static synchronized void doSetSessionTimeZone(String defaultTimeZone) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CConnection.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(defaultTimeZone));
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            T2CConnection.t2cSetSessionTimeZone(defaultTimeZone);
            Object var4_4 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                T2CConnection.logger().log(Level.FINER, "         Exit");
                Object var6_8 = null;
            }
            catch (Throwable throwable2) {
                Object var6_9 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            T2CConnection.logger().log(Level.FINER, "         Exit");
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    static native int getLibraryVersionNumber();

    static native short t2cGetServerSessionInfo(long var0, Properties var2);

    static native short t2cGetDriverCharSetFromNlsLang();

    native int t2cDescribeError(long var1, T2CError var3, byte[] var4);

    native int t2cCreateState(byte[] var1, int var2, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, int var8, byte[] var9, int var10, byte[] var11, int var12, byte[] var13, int var14, short var15, int var16, short[] var17, byte[] var18, byte[] var19, boolean var20, long[] var21);

    native int t2cLogon(long var1, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, int var8, byte[] var9, int var10, byte[] var11, int var12, byte[] var13, int var14, byte[] var15, int var16, int var17, short[] var18, byte[] var19, byte[] var20, long[] var21);

    private native int t2cLogoff(long var1);

    private native int t2cCancel(long var1);

    private native byte t2cGetAsmVolProperty(long var1);

    private native byte t2cGetInstanceType(long var1);

    private native int t2cCreateStatement(long var1, long var3, byte[] var5, int var6, OracleStatement var7, boolean var8, int var9);

    private native int t2cSetAutoCommit(long var1, boolean var3);

    private native int t2cCommit(long var1, int var3);

    private native int t2cRollback(long var1);

    private native int t2cPingDatabase(long var1);

    private native byte[] t2cGetProductionVersion(long var1);

    private native int t2cGetVersionNumber(long var1);

    private native int t2cGetDefaultStreamChunkSize(long var1);

    native int t2cGetFormOfUse(long var1, OracleTypeCLOB var3, byte[] var4, int var5, int var6);

    native long t2cGetTDO(long var1, byte[] var3, int var4, int[] var5);

    native int t2cCreateConnPool(byte[] var1, int var2, byte[] var3, int var4, byte[] var5, int var6, short var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14);

    native int t2cConnPoolLogon(long var1, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, int var8, byte[] var9, int var10, byte[] var11, int var12, int var13, int var14, int var15, String[] var16, byte[] var17, int var18, byte[] var19, int var20, byte[] var21, int var22, byte[] var23, int var24, byte[] var25, int var26, short[] var27, byte[] var28, byte[] var29, long[] var30);

    native int t2cGetConnPoolInfo(long var1, Properties var3);

    native int t2cSetConnPoolInfo(long var1, int var3, int var4, int var5, int var6, int var7, int var8);

    native int t2cPasswordChange(long var1, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, int var8);

    protected native byte[] t2cGetConnectionId(long var1);

    native int t2cGetHandles(long var1, long[] var3);

    native int t2cUseConnection(long var1, long var3, long var5, long var7, short[] var9, long[] var10);

    native boolean t2cPlatformIsLittleEndian(long var1);

    native int t2cRegisterTAFCallback(long var1);

    native int t2cGetHeapAllocSize(long var1);

    native int t2cGetOciEnvHeapAllocSize(long var1);

    native int t2cDoProxySession(long var1, int var3, byte[] var4, int var5, byte[] var6, int var7, byte[] var8, int var9, byte[] var10, int var11, int var12, byte[][] var13);

    native int t2cCloseProxySession(long var1);

    static native int t2cDescribeTable(long var0, byte[] var2, int var3, short[] var4, byte[] var5, int var6, int var7, int var8, int var9);

    native int t2cSetApplicationContext(long var1, String var3, String var4, String var5);

    native int t2cClearAllApplicationContext(long var1, String var3);

    native int t2cStartupDatabase(long var1, int var3);

    native int t2cShutdownDatabase(long var1, int var3);

    static native void t2cSetSessionTimeZone(String var0);

    public void incrementTempLobReferenceCount(byte[] locator) throws SQLException {
    }

    public int decrementTempLobReferenceCount(byte[] locator) throws SQLException {
        return 0;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
        TRACE = false;
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T2CConnection"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

