/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.core.lmx.CoreException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.VarnumBinder;

class FloatBinder
extends VarnumBinder {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FloatBinder() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    FloatBinder.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    FloatBinder.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var6_8 = null;
                }
                catch (Throwable throwable2) {
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                FloatBinder.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bind(OraclePreparedStatement stmt, int bindPosition, int rankInBuffer, int rank, byte[] bindBytes, char[] bindChars, short[] bindIndicators, int bytePitch, int charPitch, int byteoffset, int charoffset, int lenoffset, int indoffset, boolean clearPriorBindValues) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    FloatBinder.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(bindPosition) + ", " + OracleLog.argument(rankInBuffer) + ", " + OracleLog.argument(rank) + ", " + OracleLog.argument(bindBytes) + ", " + OracleLog.argument(bindChars) + ", " + OracleLog.argument(bindIndicators) + ", " + OracleLog.argument(bytePitch) + ", " + OracleLog.argument(charPitch) + ", " + OracleLog.argument(byteoffset) + ", " + OracleLog.argument(charoffset) + ", " + OracleLog.argument(lenoffset) + ", " + OracleLog.argument(indoffset) + ", " + OracleLog.argument(clearPriorBindValues));
                    Object var16_15 = null;
                }
                catch (Throwable throwable) {
                    Object var16_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            byte[] b2 = bindBytes;
            int offset = byteoffset + 1;
            double val = stmt.parameterDouble[rank][bindPosition];
            int len = 0;
            if (val == 0.0) {
                b2[offset] = -128;
                len = 1;
            } else if (val == Double.POSITIVE_INFINITY) {
                b2[offset] = -1;
                b2[offset + 1] = 101;
                len = 2;
            } else if (val == Double.NEGATIVE_INFINITY) {
                b2[offset] = 0;
                len = 1;
            } else {
                long bits;
                int rawExponent;
                int guess;
                boolean neg;
                boolean bl = neg = val < 0.0;
                if (neg) {
                    val = -val;
                }
                if ((guess = ((rawExponent = (int)((bits = Double.doubleToLongBits(val)) >> 52 & 0x7FFL)) > 1023 ? 126 : 127) - (int)((double)(rawExponent - 1023) / 6.643856189774725)) < 0) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            FloatBinder.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1 + CoreException.getMessage((byte)3) + " trying to bind " + val);
                            Object var27_26 = null;
                        }
                        catch (Throwable throwable) {
                            Object var27_27 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, CoreException.getMessage((byte)3) + " trying to bind " + val);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (guess > 192) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            FloatBinder.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1 + CoreException.getMessage((byte)2) + " trying to bind " + val);
                            Object var29_37 = null;
                        }
                        catch (Throwable throwable) {
                            Object var29_38 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, CoreException.getMessage((byte)2) + " trying to bind " + val);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (val > factorTable[guess]) {
                    while (guess > 0 && val > factorTable[--guess]) {
                    }
                } else {
                    while (guess < 193 && val <= factorTable[guess + 1]) {
                        ++guess;
                    }
                }
                if (val == factorTable[guess]) {
                    if (guess < 65) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                FloatBinder.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1 + CoreException.getMessage((byte)3) + " trying to bind " + val);
                                Object var31_42 = null;
                            }
                            catch (Throwable throwable) {
                                Object var31_43 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, CoreException.getMessage((byte)3) + " trying to bind " + val);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    if (guess > 192) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                FloatBinder.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1 + CoreException.getMessage((byte)2) + " trying to bind " + val);
                                Object var33_46 = null;
                            }
                            catch (Throwable throwable) {
                                Object var33_47 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, CoreException.getMessage((byte)2) + " trying to bind " + val);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    if (neg) {
                        b2[offset] = (byte)(62 - (127 - guess));
                        b2[offset + 1] = 100;
                        b2[offset + 2] = 102;
                        len = 3;
                    } else {
                        b2[offset] = (byte)(192 + (128 - guess));
                        b2[offset + 1] = 2;
                        len = 2;
                    }
                } else {
                    int nSignificantBits;
                    if (guess < 64) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                FloatBinder.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1 + CoreException.getMessage((byte)3) + " trying to bind " + val);
                                Object var35_49 = null;
                            }
                            catch (Throwable throwable) {
                                Object var35_50 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, CoreException.getMessage((byte)3) + " trying to bind " + val);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    if (guess > 191) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                FloatBinder.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1 + CoreException.getMessage((byte)2) + " trying to bind " + val);
                                Object var37_52 = null;
                            }
                            catch (Throwable throwable) {
                                Object var37_53 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, CoreException.getMessage((byte)2) + " trying to bind " + val);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    int fBits = Float.floatToIntBits((float)val);
                    int fractBits = fBits & 0x7FFFFF;
                    int binExp = fBits >> 23 & 0xFF;
                    char[] digits = stmt.digits;
                    if (binExp == 0) {
                        while ((long)(fractBits & 0x800000) == 0L) {
                            fractBits <<= 1;
                            --binExp;
                        }
                        nSignificantBits = 24 + binExp;
                        ++binExp;
                    } else {
                        fractBits |= 0x800000;
                        nSignificantBits = 24;
                    }
                    len = this.dtoa(b2, offset, val, neg, true, digits, binExp -= 127, (long)fractBits << 29, nSignificantBits);
                }
            }
            b2[byteoffset] = (byte)len;
            bindIndicators[indoffset] = 0;
            bindIndicators[lenoffset] = (short)(len + 1);
            Object var39_55 = null;
        }
        catch (Throwable throwable) {
            Object var39_56 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    FloatBinder.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var41_59 = null;
                }
                catch (Throwable throwable2) {
                    Object var41_60 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                FloatBinder.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var41_57 = null;
            }
            catch (Throwable throwable) {
                Object var41_58 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.FloatBinder"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

