/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.foundation.commandline;

import java.util.HashMap;
import java.util.Map;

public class Parameters {
    private static Parameters s_instances = new Parameters();
    private Map m_properties = new HashMap();
    private boolean m_activated = false;

    private Parameters() {
    }

    public static Parameters getInstance() {
        return s_instances;
    }

    public String getProperty(String key) {
        return this.getProperty(key, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProperty(String key, String def) {
        if (this.m_activated) {
            return this.getPropertyInternal(key, def);
        }
        Parameters parameters = this;
        synchronized (parameters) {
            return this.getPropertyInternal(key, def);
        }
    }

    private String getPropertyInternal(String key, String def) {
        Object value = this.m_properties.get(key);
        return value == null ? def : (String)value;
    }

    public void activate() {
        this.m_activated = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String key, String value) {
        if (this.m_activated) {
            Parameters parameters = this;
            synchronized (parameters) {
                HashMap<String, String> temp = new HashMap<String, String>(this.m_properties);
                temp.put(key, value);
                this.m_properties = temp;
            }
        }
        Parameters parameters = this;
        synchronized (parameters) {
            this.m_properties.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String key) {
        if (this.m_activated) {
            Parameters parameters = this;
            synchronized (parameters) {
                HashMap temp = new HashMap(this.m_properties);
                temp.remove(key);
                this.m_properties = temp;
            }
        }
        Parameters parameters = this;
        synchronized (parameters) {
            this.m_properties.remove(key);
        }
    }
}

