/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.net.SocketException;
import java.util.Properties;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVNavigator;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.NetException;
import oracle.net.nt.NTAdapter;
import oracle.net.nt.SdpNTAdapter;
import oracle.net.nt.TcpNTAdapter;
import oracle.net.nt.TcpsNTAdapter;

public class ConnOption {
    public NTAdapter nt;
    public int port;
    public int tdu;
    public int sdu;
    public String protocol;
    public String host;
    public String sid;
    public String addr;
    public String service_name;
    public String instance_name;
    public StringBuffer conn_data = new StringBuffer();
    public String sslServerCertDN;
    public String origSSLServerCertDN;
    public String origServiceName;
    public String origSid;
    public boolean done;

    private NTAdapter getNT(Properties socketOptions) throws NetException {
        block6: {
            try {
                if (this.protocol.equalsIgnoreCase("tcp")) {
                    this.nt = new TcpNTAdapter(this.addr, socketOptions);
                    this.origServiceName = this.service_name;
                    this.origSid = this.sid;
                    break block6;
                }
                if (this.protocol.equalsIgnoreCase("tcps")) {
                    this.nt = new TcpsNTAdapter(this.addr, socketOptions);
                    this.origSSLServerCertDN = this.sslServerCertDN;
                    this.origServiceName = this.service_name;
                    this.origSid = this.sid;
                    String[] valArray = new String[]{this.origSSLServerCertDN, this.origServiceName, this.origSid};
                    this.nt.setOption(8, valArray);
                    break block6;
                }
                if (this.protocol.equalsIgnoreCase("sdp")) {
                    this.nt = new SdpNTAdapter(this.addr, socketOptions);
                    this.origServiceName = this.service_name;
                    this.origSid = this.sid;
                    break block6;
                }
                throw new NetException(21);
            }
            catch (NLException nle) {
                throw new NetException(501);
            }
            catch (Exception ex) {
                throw new NetException(21);
            }
        }
        return this.nt;
    }

    public void connect(Properties socketOptions) throws IOException {
        try {
            this.populateProtocol();
            if (this.protocol == null) {
                throw new NetException(501);
            }
        }
        catch (NLException ex) {
            throw new NetException(501);
        }
        this.nt = this.getNT(socketOptions);
        this.nt.connect();
    }

    private void populateProtocol() throws NLException {
        NVPair nvpProt = null;
        NVNavigator nav = new NVNavigator();
        NVPair nvpAddr = new NVFactory().createNVPair(this.addr);
        nvpProt = nav.findNVPair(nvpAddr, "PROTOCOL");
        if (nvpProt == null) {
            throw new NLException("NoNVPair-04614", "PROTOCOL");
        }
        this.protocol = nvpProt.getAtom();
    }

    public void restoreFromOrigCoption(ConnOption origCoption) throws IOException {
        this.origSSLServerCertDN = origCoption.origSSLServerCertDN;
        this.origServiceName = origCoption.origServiceName;
        this.origSid = origCoption.origSid;
        this.conn_data = origCoption.conn_data;
        if (this.protocol.equalsIgnoreCase("tcps")) {
            String[] valArray = new String[]{this.origSSLServerCertDN, this.origServiceName, this.origSid};
            this.nt.setOption(8, valArray);
        }
    }

    public String toString() {
        return "host=" + this.host + ", port=" + this.port + ", sid=" + this.sid + ", protocol=" + this.protocol + ", service_name=" + this.service_name + "\naddr=" + this.addr + "\nconn_data=" + this.conn_data + "\nsslServerCertDN=" + this.sslServerCertDN + ", origSSLServerCertDN=" + this.origSSLServerCertDN + ", origServiceName=" + this.origServiceName + ", origSid=" + this.origSid + ", done=" + this.done;
    }

    boolean isConnectionSocketKeepAlive() throws SocketException {
        return this.nt.isConnectionSocketKeepAlive();
    }
}

