/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.RowSet;
import javax.sql.RowSetInternal;
import javax.sql.RowSetWriter;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.rowset.OracleCachedRowSet;
import oracle.jdbc.rowset.OracleCachedRowSetReader;
import oracle.jdbc.rowset.OracleRow;

public class OracleCachedRowSetWriter
implements RowSetWriter,
Serializable {
    static final long serialVersionUID = 8932894189919931169L;
    private StringBuffer updateClause = new StringBuffer("");
    private StringBuffer deleteClause = new StringBuffer("");
    private StringBuffer insertClause = new StringBuffer("");
    private PreparedStatement insertStmt;
    private PreparedStatement updateStmt;
    private PreparedStatement deleteStmt;
    private ResultSetMetaData rsmd;
    private transient Connection connection;
    private int columnCount;
    static final int ASCII_STREAM = 1;
    static final int BINARY_STREAM = 2;
    static final int CHARACTER_STREAM = 3;
    static final int NCHARACTER_STREAM = 4;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OracleCachedRowSetWriter() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetWriter.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleCachedRowSetWriter.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var6_8 = null;
            }
            catch (Throwable throwable2) {
                Object var6_9 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!TRACE || !OracleLog.recursiveEnter()) return;
        try {
            OracleCachedRowSetWriter.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getSchemaName(RowSet rowset) throws SQLException {
        String string;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(rowset));
                    string = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            String __result__ = rowset.getUsername();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            string = __result__;
            Object var7_9 = null;
            if (!TRACE) return string;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_13 = null;
            }
            catch (Throwable throwable2) {
                Object var9_14 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return string;
        try {
            OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_11 = null;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTableName(RowSet rowset) throws SQLException {
        StringTokenizer st;
        String string;
        block33: {
            String string2;
            try {
                String tableName;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(rowset));
                        string2 = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if ((tableName = ((OracleCachedRowSet)rowset).getTableName()) == null) break block33;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + tableName);
                        Object var5_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                string2 = tableName;
                Object var17_12 = null;
            }
            catch (Throwable throwable) {
                Object var17_14 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var19_19 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var19_20 = null;
                        OracleLog.recursiveExit();
                        throw throwable2;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var19_15 = null;
                }
                catch (Throwable throwable) {
                    Object var19_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return string2;
        }
        String cmd = rowset.getCommand().toUpperCase();
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSetWriter.getTableName(RowSet)," + "cmd=" + cmd);
                string = null;
            }
            catch (Throwable throwable) {
                Object var7_25 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        int index = cmd.indexOf(" FROM ");
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSetWriter.getTableName(RowSet)," + "index=" + index);
                Object var9_28 = null;
            }
            catch (Throwable throwable) {
                Object var9_29 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        if (index == -1) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetWriter.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 343 + (cmd.length() != 0 ? cmd : "Please use RowSet.setCommand (String) to set the SQL query string."));
                    Object var11_31 = null;
                }
                catch (Throwable throwable) {
                    Object var11_32 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 343, cmd.length() != 0 ? cmd : "Please use RowSet.setCommand (String) to set the SQL query string.");
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        String tab = cmd.substring(index + 6).trim();
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSetWriter.getTableName(), tab=" + tab);
                Object var13_34 = null;
            }
            catch (Throwable throwable) {
                Object var13_35 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        if ((st = new StringTokenizer(tab)).hasMoreTokens()) {
            tab = st.nextToken();
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + tab);
                Object var15_37 = null;
            }
            catch (Throwable throwable) {
                Object var15_38 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        string = tab;
        Object var17_13 = null;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var19_17 = null;
            }
            catch (Throwable throwable) {
                Object var19_18 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSQLStatement(RowSet rowset) throws SQLException {
        try {
            int i2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(rowset));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.insertClause = new StringBuffer("INSERT INTO " + this.getTableName(rowset) + "(");
            this.updateClause = new StringBuffer("UPDATE " + this.getTableName(rowset) + " SET ");
            this.deleteClause = new StringBuffer("DELETE FROM " + this.getTableName(rowset) + " WHERE ");
            this.rsmd = rowset.getMetaData();
            this.columnCount = this.rsmd.getColumnCount();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSetWriter.initSQLStatement(RowSet)" + ", insertClause=" + this.insertClause + ", updateClause=" + this.updateClause + ", deleteClause=" + this.deleteClause + ", rsmd=" + this.rsmd + ", columnCount=" + this.columnCount);
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            for (i2 = 0; i2 < this.columnCount; ++i2) {
                if (i2 != 0) {
                    this.insertClause.append(", ");
                }
                this.insertClause.append(this.rsmd.getColumnName(i2 + 1));
                if (i2 != 0) {
                    this.updateClause.append(", ");
                }
                this.updateClause.append(this.rsmd.getColumnName(i2 + 1) + " = :" + i2);
                if (i2 != 0) {
                    this.deleteClause.append(" AND ");
                }
                this.deleteClause.append(this.rsmd.getColumnName(i2 + 1) + " = :" + i2);
            }
            this.insertClause.append(") VALUES (");
            this.updateClause.append(" WHERE ");
            for (i2 = 0; i2 < this.columnCount; ++i2) {
                if (i2 != 0) {
                    this.insertClause.append(", ");
                }
                this.insertClause.append(":" + i2);
                if (i2 != 0) {
                    this.updateClause.append(" AND ");
                }
                this.updateClause.append(this.rsmd.getColumnName(i2 + 1) + " = :" + i2);
            }
            this.insertClause.append(")");
            this.insertStmt = this.connection.prepareStatement(this.insertClause.substring(0, this.insertClause.length()));
            this.updateStmt = this.connection.prepareStatement(this.updateClause.substring(0, this.updateClause.length()));
            this.deleteStmt = this.connection.prepareStatement(this.deleteClause.substring(0, this.deleteClause.length()));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSetWriter.initSQLStatement(RowSet)" + ", insertStmt=" + this.insertStmt + ", updateStmt=" + this.updateStmt + ", deleteStmt=" + this.deleteStmt);
                    Object var7_9 = null;
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Object var9_12 = null;
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var11_16 = null;
                }
                catch (Throwable throwable2) {
                    Object var11_17 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_14 = null;
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean insertRow(OracleRow row) throws SQLException {
        boolean bl;
        try {
            boolean __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(row));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.insertStmt.clearParameters();
            for (int i2 = 1; i2 <= this.columnCount; ++i2) {
                Object o2 = null;
                Object object = o2 = row.isColumnChanged(i2) ? row.getModifiedColumn(i2) : row.getColumn(i2);
                if (TRACE && OracleLog.recursiveEnter()) {
                    Object var5_7;
                    try {
                        OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSetWriter.insertRow(OracleRow), o=" + o2);
                        var5_7 = null;
                    }
                    catch (Throwable throwable) {
                        var5_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if (o2 == null) {
                    this.insertStmt.setNull(i2, this.rsmd.getColumnType(i2));
                    row.markOriginalNull(i2, true);
                    continue;
                }
                this.insertStmt.setObject(i2, o2);
            }
            boolean bl2 = __result__ = this.insertStmt.executeUpdate() == 1;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var7_9 = null;
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = __result__;
            Object var9_12 = null;
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var11_16 = null;
                }
                catch (Throwable throwable2) {
                    Object var11_17 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_14 = null;
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private boolean updateRow(RowSet rowset, OracleRow row) throws SQLException {
        boolean bl;
        try {
            boolean __result__;
            int i2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(rowset) + ", " + OracleLog.argument(row));
                    Object var4_3 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.updateStmt.clearParameters();
            for (i2 = 1; i2 <= this.columnCount; ++i2) {
                Object o2 = null;
                Object object = o2 = row.isColumnChanged(i2) ? row.getModifiedColumn(i2) : row.getColumn(i2);
                if (TRACE && OracleLog.recursiveEnter()) {
                    Object var6_12;
                    try {
                        OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSetWriter.updateRow(OracleRow), o=" + o2);
                        var6_12 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        var6_12 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                if (o2 == null) {
                    this.updateStmt.setNull(i2, this.rsmd.getColumnType(i2));
                    continue;
                }
                if (o2 instanceof Reader) {
                    OraclePreparedStatement pstmt = (OraclePreparedStatement)this.updateStmt;
                    if (row.columnTypeInfo[i2 - 1][1] == 4) {
                        pstmt.setFormOfUse(i2, (short)2);
                    } else if (row.columnTypeInfo[i2 - 1][1] == 3) {
                        pstmt.setFormOfUse(i2, (short)1);
                    }
                    this.updateStmt.setCharacterStream(i2, (Reader)o2, row.columnTypeInfo[i2 - 1][0]);
                    continue;
                }
                if (o2 instanceof InputStream) {
                    if (row.columnTypeInfo[i2 - 1][1] == 2) {
                        this.updateStmt.setBinaryStream(i2, (InputStream)o2, row.columnTypeInfo[i2 - 1][0]);
                        continue;
                    }
                    if (row.columnTypeInfo[i2 - 1][1] != 1) continue;
                    this.updateStmt.setAsciiStream(i2, (InputStream)o2, row.columnTypeInfo[i2 - 1][0]);
                    continue;
                }
                this.updateStmt.setObject(i2, o2);
            }
            for (i2 = 1; i2 <= this.columnCount; ++i2) {
                if (row.isOriginalNull(i2)) {
                    boolean __result__2 = this.updateRowWithNull(rowset, row);
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__2);
                            Object var8_13 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var8_14 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                    boolean bl2 = __result__2;
                    Object var12_16 = null;
                    if (!TRACE) return bl2;
                    if (!OracleLog.recursiveEnter()) return bl2;
                    try {
                        OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var14_19 = null;
                        OracleLog.recursiveExit();
                        return bl2;
                    }
                    catch (Throwable throwable) {
                        Object var14_20 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                this.updateStmt.setObject(i2 + this.columnCount, row.getColumn(i2));
            }
            boolean bl3 = __result__ = this.updateStmt.executeUpdate() == 1;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var10_28 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var10_29 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            bl = __result__;
            Object var12_17 = null;
            if (!TRACE) return bl;
        }
        catch (Throwable throwable) {
            Object var12_18 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var14_24 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var14_23 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return bl;
        try {}
        catch (Throwable throwable) {
            Object var14_22 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
        Object var14_21 = null;
        OracleLog.recursiveExit();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean updateRowWithNull(RowSet rowset, OracleRow row) throws SQLException {
        try {
            if (OracleCachedRowSetWriter.TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(rowset) + ", " + OracleLog.argument(row));
                    var4_3 = null;
                }
                catch (Throwable var3_5) {
                    var4_4 = null;
                    OracleLog.recursiveExit();
                    throw var3_5;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            returnValue = false;
            updateClauseWithNull = new StringBuffer("UPDATE " + this.getTableName(rowset) + " SET ");
            for (i = 1; i <= this.columnCount; ++i) {
                if (i != 1) {
                    updateClauseWithNull.append(", ");
                }
                updateClauseWithNull.append(this.rsmd.getColumnName(i) + " = :" + i);
            }
            updateClauseWithNull.append(" WHERE ");
            for (i = 1; i <= this.columnCount; ++i) {
                if (i != 1) {
                    updateClauseWithNull.append(" AND ");
                }
                if (row.isOriginalNull(i)) {
                    updateClauseWithNull.append(this.rsmd.getColumnName(i) + " IS NULL ");
                    continue;
                }
                updateClauseWithNull.append(this.rsmd.getColumnName(i) + " = :" + i);
            }
            stmt = null;
            try {
                stmt = this.connection.prepareStatement(updateClauseWithNull.substring(0, updateClauseWithNull.length()));
                for (i = 1; i <= this.columnCount; ++i) {
                    o = null;
                    v0 = o = row.isColumnChanged(i) != false ? row.getModifiedColumn(i) : row.getColumn(i);
                    if (OracleCachedRowSetWriter.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSetWriter.updateRowWithNull(OracleRow), o=" + o);
                            var9_14 = null;
                        }
                        catch (Throwable var8_13) {
                            var9_14 = null;
                            OracleLog.recursiveExit();
                            throw var8_13;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    if (o == null) {
                        stmt.setNull(i, this.rsmd.getColumnType(i));
                        continue;
                    }
                    if (o instanceof Reader) {
                        pstmt = (OraclePreparedStatement)stmt;
                        if (row.columnTypeInfo[i - 1][1] == 4) {
                            pstmt.setFormOfUse(i, (short)2);
                        } else if (row.columnTypeInfo[i - 1][1] == 3) {
                            pstmt.setFormOfUse(i, (short)1);
                        }
                        stmt.setCharacterStream(i, (Reader)o, row.columnTypeInfo[i - 1][0]);
                        continue;
                    }
                    if (o instanceof InputStream) {
                        if (row.columnTypeInfo[i - 1][1] == 2) {
                            stmt.setBinaryStream(i, (InputStream)o, row.columnTypeInfo[i - 1][0]);
                            continue;
                        }
                        if (row.columnTypeInfo[i - 1][1] != 1) continue;
                        stmt.setAsciiStream(i, (InputStream)o, row.columnTypeInfo[i - 1][0]);
                        continue;
                    }
                    stmt.setObject(i, o);
                }
                columnIndex = 1;
                for (i = 1; i <= this.columnCount; ++i) {
                    if (row.isOriginalNull(i)) continue;
                    stmt.setObject(columnIndex + this.columnCount, row.getColumn(i));
                    ++columnIndex;
                }
                returnValue = stmt.executeUpdate() == 1;
                var11_15 = null;
                ** if (stmt == null) goto lbl-1000
            }
            catch (Throwable var10_17) {
                var11_16 = null;
                if (stmt != null) {
                    stmt.close();
                }
                throw var10_17;
            }
lbl-1000:
            // 1 sources

            {
                stmt.close();
            }
lbl-1000:
            // 2 sources

            {
            }
            if (OracleCachedRowSetWriter.TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + returnValue);
                    var13_18 = null;
                }
                catch (Throwable var12_20) {
                    var13_19 = null;
                    OracleLog.recursiveExit();
                    throw var12_20;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            var6_9 = returnValue;
            var15_21 = null;
        }
        catch (Throwable var14_29) {
            var15_22 = null;
            if (OracleCachedRowSetWriter.TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    var17_25 = null;
                }
                catch (Throwable var16_28) {
                    var17_26 = null;
                    OracleLog.recursiveExit();
                    throw var16_28;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw var14_29;
        }
        if (OracleCachedRowSetWriter.TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                var17_23 = null;
            }
            catch (Throwable var16_27) {
                var17_24 = null;
                OracleLog.recursiveExit();
                throw var16_27;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return var6_9;
    }

    /*
     * Exception decompiling
     */
    private boolean deleteRow(RowSet rowset, OracleRow row) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Missing node tying up JSR block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.tieUpRelations(Op02WithProcessedDataAndRefs.java:2900)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.copyBlock(Op02WithProcessedDataAndRefs.java:2889)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.inlineJSR(Op02WithProcessedDataAndRefs.java:2845)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSRs(Op02WithProcessedDataAndRefs.java:2591)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSR(Op02WithProcessedDataAndRefs.java:2481)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:444)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean deleteRowWithNull(RowSet rowset, OracleRow row) throws SQLException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(rowset) + ", " + OracleLog.argument(row));
                    Object var4_3 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            boolean returnValue = false;
            StringBuffer deleteClauseWithNull = new StringBuffer("DELETE FROM " + this.getTableName(rowset) + " WHERE ");
            for (int i2 = 1; i2 <= this.columnCount; ++i2) {
                if (i2 != 1) {
                    deleteClauseWithNull.append(" AND ");
                }
                if (row.isOriginalNull(i2)) {
                    deleteClauseWithNull.append(this.rsmd.getColumnName(i2) + " IS NULL ");
                    continue;
                }
                deleteClauseWithNull.append(this.rsmd.getColumnName(i2) + " = :" + i2);
            }
            PreparedStatement stmt = null;
            try {
                stmt = this.connection.prepareStatement(deleteClauseWithNull.substring(0, deleteClauseWithNull.length()));
                int columnIndex = 1;
                for (int i3 = 1; i3 <= this.columnCount; ++i3) {
                    if (row.isOriginalNull(i3)) continue;
                    stmt.setObject(columnIndex++, row.getColumn(i3));
                }
                returnValue = stmt.executeUpdate() == 1;
                Object var9_11 = null;
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                if (stmt == null) throw throwable;
                stmt.close();
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + returnValue);
                    Object var11_14 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var11_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            bl = returnValue;
            Object var13_17 = null;
            if (!TRACE) return bl;
        }
        catch (Throwable throwable) {
            Object var13_18 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var15_22 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var15_21 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return bl;
        try {
            OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var15_19 = null;
            OracleLog.recursiveExit();
            return bl;
        }
        catch (Throwable throwable) {
            Object var15_20 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized boolean writeData(RowSetInternal rowsetInternal) throws SQLException {
        boolean bl;
        OracleCachedRowSet rowset;
        block38: {
            block37: {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSetWriter.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(rowsetInternal));
                        Object var3_2 = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                rowset = (OracleCachedRowSet)rowsetInternal;
                this.connection = ((OracleCachedRowSetReader)rowset.getReader()).getConnection(rowsetInternal);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSetWriter.writeData(RowSetInternal)," + "connection=" + this.connection + ",columnCount=" + this.columnCount);
                        Object var5_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_10 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if (this.connection == null) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSetWriter.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 342);
                            Object var7_14 = null;
                        }
                        catch (Throwable throwable) {
                            Object var7_15 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 342);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (this.connection.getAutoCommit()) {
                    this.connection.setAutoCommit(false);
                }
                try {
                    this.connection.setTransactionIsolation(rowset.getTransactionIsolation());
                }
                catch (Exception exc) {
                    if (!TRACE || !OracleLog.recursiveEnter()) break block37;
                    try {
                        OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSetWriter.writeData(), setTransactionIsolation() throws exception: " + exc);
                        Object var9_19 = null;
                    }
                    catch (Throwable throwable) {
                        Object var9_20 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
            }
            this.initSQLStatement(rowset);
            if (this.columnCount >= 1) break block38;
            this.connection.close();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetWriter.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                    Object var11_23 = null;
                }
                catch (Throwable throwable) {
                    Object var11_24 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            boolean exc = true;
            Object var17_26 = null;
            if (!TRACE) return exc;
            if (!OracleLog.recursiveEnter()) return exc;
            try {
                OracleCachedRowSetWriter.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var19_29 = null;
            }
            catch (Throwable throwable) {
                Object var19_30 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            return exc;
        }
        try {
            boolean oldFlag = rowset.getShowDeleted();
            rowset.setShowDeleted(true);
            rowset.beforeFirst();
            boolean updateFlag = true;
            boolean insertFlag = true;
            boolean deleteFlag = true;
            OracleRow row = null;
            while (rowset.next()) {
                if (rowset.rowInserted()) {
                    if (rowset.rowDeleted()) continue;
                    row = rowset.getCurrentRow();
                    insertFlag = this.insertRow(row) || insertFlag;
                    continue;
                }
                if (rowset.rowUpdated()) {
                    row = rowset.getCurrentRow();
                    updateFlag = this.updateRow(rowset, row) || updateFlag;
                    continue;
                }
                if (!rowset.rowDeleted()) continue;
                row = rowset.getCurrentRow();
                deleteFlag = this.deleteRow(rowset, row) || deleteFlag;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetWriter.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleCachedRowSetWriter.writeData(RowSetInternal)," + "oldFlag=" + oldFlag + ", updateFlag=" + updateFlag + ", insertFlag=" + insertFlag + ", deleteFlag" + deleteFlag + ", row=" + row);
                    Object var13_38 = null;
                }
                catch (Throwable throwable) {
                    Object var13_39 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (updateFlag && insertFlag && deleteFlag) {
                this.connection.commit();
                rowset.setOriginal();
            } else {
                this.connection.rollback();
            }
            this.insertStmt.close();
            this.updateStmt.close();
            this.deleteStmt.close();
            if (!rowset.isConnectionStayingOpen()) {
                this.connection.close();
            }
            rowset.setShowDeleted(oldFlag);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetWriter.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                    Object var15_41 = null;
                }
                catch (Throwable throwable) {
                    Object var15_42 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = true;
            Object var17_27 = null;
            if (!TRACE) return bl;
        }
        catch (Throwable throwable) {
            Object var17_28 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleCachedRowSetWriter.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var19_33 = null;
            }
            catch (Throwable throwable2) {
                Object var19_34 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return bl;
        try {
            OracleCachedRowSetWriter.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var19_31 = null;
        }
        catch (Throwable throwable) {
            Object var19_32 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        OracleConnection oracleConnection;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    Object var4_5 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            oracleConnection = null;
            Object var6_8 = null;
            if (!TRACE) return oracleConnection;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var8_13 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_12 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return oracleConnection;
        try {
            OracleCachedRowSetWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_10 = null;
            OracleLog.recursiveExit();
            return oracleConnection;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.rowset");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.rowset.OracleCachedRowSetWriter"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

