/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.CharCommonAccessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.internal.OracleStatement;
import oracle.sql.ROWID;

class VarcharAccessor
extends CharCommonAccessor {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    VarcharAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean forBind) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    VarcharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(external_type) + ", " + OracleLog.argument(forBind));
                    Object var7_6 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            int maxLength = 4000;
            if (stmt.sqlKind == OracleStatement.SqlKind.PLSQL_BLOCK) {
                maxLength = stmt.connection.plsqlVarcharParameter4KOnly ? 4000 : 32766;
            }
            this.init(stmt, 1, 9, max_len, form, external_type, forBind, maxLength, 2000);
            Object var9_10 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var11_15 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            VarcharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var11_14 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            VarcharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var11_12 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    VarcharAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, int contflag, int total_elems, short form) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    VarcharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(nullable) + ", " + OracleLog.argument(flags) + ", " + OracleLog.argument(precision) + ", " + OracleLog.argument(scale) + ", " + OracleLog.argument(contflag) + ", " + OracleLog.argument(total_elems) + ", " + OracleLog.argument(form));
                    Object var11_10 = null;
                }
                catch (Throwable throwable) {
                    Object var11_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            int maxLength = 4000;
            if (stmt.sqlKind == OracleStatement.SqlKind.PLSQL_BLOCK) {
                maxLength = stmt.connection.plsqlVarcharParameter4KOnly ? 4000 : 32766;
            }
            this.init(stmt, 1, 9, max_len, nullable, flags, precision, scale, contflag, total_elems, form, maxLength, 2000);
            Object var13_14 = null;
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    VarcharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var15_18 = null;
                }
                catch (Throwable throwable2) {
                    Object var15_19 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                VarcharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var15_16 = null;
            }
            catch (Throwable throwable) {
                Object var15_17 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ROWID getROWID(int currentRow) throws SQLException {
        ROWID rOWID;
        try {
            byte[] b2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    VarcharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        VarcharAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                        Object var5_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_8 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            ROWID rowid = null;
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1 && (b2 = this.getBytesInternal(currentRow)) != null) {
                rowid = new ROWID(b2);
            }
            ROWID __result__ = rowid;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    VarcharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var7_11 = null;
                }
                catch (Throwable throwable) {
                    Object var7_12 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            rOWID = __result__;
            Object var9_14 = null;
        }
        catch (Throwable throwable) {
            Object var9_15 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    VarcharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var11_18 = null;
                }
                catch (Throwable throwable2) {
                    Object var11_19 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                VarcharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_16 = null;
            }
            catch (Throwable throwable) {
                Object var11_17 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return rOWID;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.VarcharAccessor"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

