/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DateTimeCommonAccessor;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.OffsetDST;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.TIMEZONETAB;
import oracle.sql.ZONEIDMAP;

class TimestampltzAccessor
extends DateTimeCommonAccessor {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TimestampltzAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean forBind) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(external_type) + ", " + OracleLog.argument(forBind));
                    Object var7_6 = null;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.init(stmt, 231, 231, form, forBind);
            this.initForDataAccess(external_type, max_len, null);
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var11_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var11_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_11 = null;
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TimestampltzAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, int contflag, int total_elems, short form) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(nullable) + ", " + OracleLog.argument(flags) + ", " + OracleLog.argument(precision) + ", " + OracleLog.argument(scale) + ", " + OracleLog.argument(contflag) + ", " + OracleLog.argument(total_elems) + ", " + OracleLog.argument(form));
                    Object var11_10 = null;
                }
                catch (Throwable throwable) {
                    Object var11_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.init(stmt, 231, 231, form, false);
            this.initForDescribe(231, max_len, nullable, flags, precision, scale, contflag, total_elems, form, null);
            this.initForDataAccess(0, max_len, null);
            Object var13_13 = null;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var15_17 = null;
                }
                catch (Throwable throwable2) {
                    Object var15_18 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var15_15 = null;
            }
            catch (Throwable throwable) {
                Object var15_16 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    void initForDataAccess(int external_type, int max_len, String typeName) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(external_type) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(typeName));
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (external_type != 0) {
                this.externalType = external_type;
            }
            this.internalTypeMaxLength = 11;
            if (max_len > 0 && max_len < this.internalTypeMaxLength) {
                this.internalTypeMaxLength = max_len;
            }
            this.byteLength = this.internalTypeMaxLength;
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_11 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_12 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getString(int currentRow) throws SQLException {
        block29: {
            String __ex__2;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                        Object var3_2 = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if (this.rowSpaceIndicator == null) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            TimestampltzAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                            Object var5_8 = null;
                        }
                        catch (Throwable throwable) {
                            Object var5_9 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__2 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                    __ex__2.fillInStackTrace();
                    throw __ex__2;
                }
                if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) break block29;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                        Object var7_14 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_15 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                __ex__2 = null;
                Object var21_19 = null;
            }
            catch (Throwable throwable) {
                Object var21_21 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var23_26 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var23_27 = null;
                        OracleLog.recursiveExit();
                        throw throwable2;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var23_22 = null;
                }
                catch (Throwable throwable) {
                    Object var23_23 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return __ex__2;
        }
        Calendar dbTzCal = this.statement.connection.getDbTzCalendar();
        String sessTzStr = this.statement.connection.getSessionTimeZone();
        if (sessTzStr == null) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 198);
                    Object var9_31 = null;
                }
                catch (Throwable throwable) {
                    Object var9_32 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 198);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        TimeZone zone = TimeZone.getTimeZone(sessTzStr);
        Calendar sessTzCal = Calendar.getInstance(zone);
        int off = this.columnIndex + this.byteLength * currentRow;
        short len = this.rowSpaceIndicator[this.lengthIndex + currentRow];
        int year = this.oracleYear(off);
        dbTzCal.set(1, year);
        dbTzCal.set(2, this.oracleMonth(off));
        dbTzCal.set(5, this.oracleDay(off));
        dbTzCal.set(11, this.oracleHour(off));
        dbTzCal.set(12, this.oracleMin(off));
        dbTzCal.set(13, this.oracleSec(off));
        dbTzCal.set(14, 0);
        this.TimeZoneAdjust(dbTzCal, sessTzCal);
        year = sessTzCal.get(1);
        int month = sessTzCal.get(2) + 1;
        int date = sessTzCal.get(5);
        int hour = sessTzCal.get(11);
        int minute = sessTzCal.get(12);
        int second = sessTzCal.get(13);
        int nanos = 0;
        boolean am = hour < 12;
        String regname = sessTzCal.getTimeZone().getID();
        if (regname.length() > 3 && regname.startsWith("GMT")) {
            regname = regname.substring(3);
        }
        if (len == 11) {
            nanos = this.oracleNanos(off);
        }
        String __result__ = this.toText(year, month, date, hour, minute, second, nanos, am, regname);
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                Object var19_44 = null;
            }
            catch (Throwable throwable) {
                Object var19_45 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        String string = __result__;
        Object var21_20 = null;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var23_24 = null;
            }
            catch (Throwable throwable) {
                Object var23_25 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return string;
    }

    Date getDate(int currentRow, Calendar cal) throws SQLException {
        return this.getDate(currentRow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Date getDate(int currentRow) throws SQLException {
        block24: {
            Date __ex__2;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                        Object var3_2 = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if (this.rowSpaceIndicator == null) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            TimestampltzAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                            Object var5_8 = null;
                        }
                        catch (Throwable throwable) {
                            Object var5_9 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__2 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                    __ex__2.fillInStackTrace();
                    throw __ex__2;
                }
                if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) break block24;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                        Object var7_14 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_15 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                __ex__2 = null;
                Object var14_19 = null;
                if (!TRACE) return __ex__2;
            }
            catch (Throwable throwable) {
                Object var14_21 = null;
                if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var16_26 = null;
                }
                catch (Throwable throwable2) {
                    Object var16_27 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                    throw throwable;
                }
            }
            if (!OracleLog.recursiveEnter()) return __ex__2;
            try {
                TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var16_22 = null;
            }
            catch (Throwable throwable) {
                Object var16_23 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            return __ex__2;
        }
        Calendar dbTzCal = this.statement.connection.getDbTzCalendar();
        String sessTzStr = this.statement.connection.getSessionTimeZone();
        if (sessTzStr == null) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 198);
                    Object var9_31 = null;
                }
                catch (Throwable throwable) {
                    Object var9_32 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 198);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        TimeZone zone = TimeZone.getTimeZone(sessTzStr);
        Calendar sessTzCal = Calendar.getInstance(zone);
        int off = this.columnIndex + this.byteLength * currentRow;
        int year = this.oracleYear(off);
        dbTzCal.set(1, year);
        dbTzCal.set(2, this.oracleMonth(off));
        dbTzCal.set(5, this.oracleDay(off));
        dbTzCal.set(11, this.oracleHour(off));
        dbTzCal.set(12, this.oracleMin(off));
        dbTzCal.set(13, this.oracleSec(off));
        dbTzCal.set(14, 0);
        long millis = this.TimeZoneAdjustUTC(dbTzCal);
        Date __result__ = new Date(millis);
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                Object var12_36 = null;
            }
            catch (Throwable throwable) {
                Object var12_37 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        Date date = __result__;
        Object var14_20 = null;
        if (!TRACE) return date;
        if (!OracleLog.recursiveEnter()) return date;
        try {
            TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var16_24 = null;
        }
        catch (Throwable throwable) {
            Object var16_25 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
        return date;
    }

    Time getTime(int currentRow, Calendar cal) throws SQLException {
        return this.getTime(currentRow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Time getTime(int currentRow) throws SQLException {
        block27: {
            Time __ex__2;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                        Object var3_2 = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if (this.rowSpaceIndicator == null) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            TimestampltzAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                            Object var5_8 = null;
                        }
                        catch (Throwable throwable) {
                            Object var5_9 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__2 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                    __ex__2.fillInStackTrace();
                    throw __ex__2;
                }
                if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) break block27;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                        Object var7_14 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_15 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                __ex__2 = null;
                Object var14_19 = null;
            }
            catch (Throwable throwable) {
                Object var14_21 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var16_26 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var16_27 = null;
                        OracleLog.recursiveExit();
                        throw throwable2;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var16_22 = null;
                }
                catch (Throwable throwable) {
                    Object var16_23 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return __ex__2;
        }
        Calendar dbTzCal = this.statement.connection.getDbTzCalendar();
        String sessTzStr = this.statement.connection.getSessionTimeZone();
        if (sessTzStr == null) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 198);
                    Object var9_31 = null;
                }
                catch (Throwable throwable) {
                    Object var9_32 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 198);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        TimeZone zone = TimeZone.getTimeZone(sessTzStr);
        Calendar sessTzCal = Calendar.getInstance(zone);
        int off = this.columnIndex + this.byteLength * currentRow;
        int year = this.oracleYear(off);
        dbTzCal.set(1, year);
        dbTzCal.set(2, this.oracleMonth(off));
        dbTzCal.set(5, this.oracleDay(off));
        dbTzCal.set(11, this.oracleHour(off));
        dbTzCal.set(12, this.oracleMin(off));
        dbTzCal.set(13, this.oracleSec(off));
        dbTzCal.set(14, 0);
        long millis = this.TimeZoneAdjustUTC(dbTzCal);
        Time __result__ = new Time(millis);
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                Object var12_36 = null;
            }
            catch (Throwable throwable) {
                Object var12_37 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        Time time = __result__;
        Object var14_20 = null;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var16_24 = null;
            }
            catch (Throwable throwable) {
                Object var16_25 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return time;
    }

    Timestamp getTimestamp(int currentRow, Calendar cal) throws SQLException {
        return this.getTimestamp(currentRow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Timestamp getTimestamp(int currentRow) throws SQLException {
        block28: {
            Timestamp __ex__2;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                        Object var3_2 = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if (this.rowSpaceIndicator == null) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            TimestampltzAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                            Object var5_8 = null;
                        }
                        catch (Throwable throwable) {
                            Object var5_9 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__2 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                    __ex__2.fillInStackTrace();
                    throw __ex__2;
                }
                if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) break block28;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                        Object var7_14 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_15 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                __ex__2 = null;
                Object var15_19 = null;
            }
            catch (Throwable throwable) {
                Object var15_21 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var17_26 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var17_27 = null;
                        OracleLog.recursiveExit();
                        throw throwable2;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var17_22 = null;
                }
                catch (Throwable throwable) {
                    Object var17_23 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return __ex__2;
        }
        Calendar dbTzCal = this.statement.connection.getDbTzCalendar();
        String sessTzStr = this.statement.connection.getSessionTimeZone();
        if (sessTzStr == null) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 198);
                    Object var9_31 = null;
                }
                catch (Throwable throwable) {
                    Object var9_32 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 198);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        TimeZone zone = TimeZone.getTimeZone(sessTzStr);
        Calendar sessTzCal = Calendar.getInstance(zone);
        int off = this.columnIndex + this.byteLength * currentRow;
        short len = this.rowSpaceIndicator[this.lengthIndex + currentRow];
        int year = this.oracleYear(off);
        dbTzCal.set(1, year);
        dbTzCal.set(2, this.oracleMonth(off));
        dbTzCal.set(5, this.oracleDay(off));
        dbTzCal.set(11, this.oracleHour(off));
        dbTzCal.set(12, this.oracleMin(off));
        dbTzCal.set(13, this.oracleSec(off));
        dbTzCal.set(14, 0);
        long millis = this.TimeZoneAdjustUTC(dbTzCal);
        Timestamp result = new Timestamp(millis);
        if (len == 11) {
            result.setNanos(this.oracleNanos(off));
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                Object var13_37 = null;
            }
            catch (Throwable throwable) {
                Object var13_38 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        Timestamp timestamp = result;
        Object var15_20 = null;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var17_24 = null;
            }
            catch (Throwable throwable) {
                Object var17_25 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getObject(int currentRow) throws SQLException {
        TIMESTAMPLTZ tIMESTAMPLTZ;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                    tIMESTAMPLTZ = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            TIMESTAMPLTZ __result__ = this.getTIMESTAMPLTZ(currentRow);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            tIMESTAMPLTZ = __result__;
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return tIMESTAMPLTZ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Datum getOracleObject(int currentRow) throws SQLException {
        TIMESTAMPLTZ tIMESTAMPLTZ;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                    tIMESTAMPLTZ = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            TIMESTAMPLTZ __result__ = this.getTIMESTAMPLTZ(currentRow);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var5_6 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            tIMESTAMPLTZ = __result__;
            Object var7_9 = null;
            if (!TRACE) return tIMESTAMPLTZ;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var9_14 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_13 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return tIMESTAMPLTZ;
        try {
            TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_11 = null;
            OracleLog.recursiveExit();
            return tIMESTAMPLTZ;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    Object getObject(int currentRow, Map map) throws SQLException {
        TIMESTAMPLTZ tIMESTAMPLTZ;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow) + ", " + OracleLog.argument(map));
                    tIMESTAMPLTZ = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            TIMESTAMPLTZ __result__ = this.getTIMESTAMPLTZ(currentRow);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var6_7 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            tIMESTAMPLTZ = __result__;
            Object var8_10 = null;
            if (!TRACE) return tIMESTAMPLTZ;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var10_15 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var10_14 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return tIMESTAMPLTZ;
        try {
            TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var10_12 = null;
            OracleLog.recursiveExit();
            return tIMESTAMPLTZ;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TIMESTAMPLTZ getTIMESTAMPLTZ(int currentRow) throws SQLException {
        TIMESTAMPLTZ tIMESTAMPLTZ;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                    tIMESTAMPLTZ = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            TIMESTAMPLTZ result = null;
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TimestampltzAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                        Object var5_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_8 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
                short len = this.rowSpaceIndicator[this.lengthIndex + currentRow];
                int off = this.columnIndex + this.byteLength * currentRow;
                byte[] data = new byte[len];
                System.arraycopy(this.rowSpaceByte, off, data, 0, len);
                result = new TIMESTAMPLTZ(data);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                    Object var7_12 = null;
                }
                catch (Throwable throwable) {
                    Object var7_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            tIMESTAMPLTZ = result;
            Object var9_15 = null;
        }
        catch (Throwable throwable) {
            Object var9_16 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var11_19 = null;
                }
                catch (Throwable throwable2) {
                    Object var11_20 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_17 = null;
            }
            catch (Throwable throwable) {
                Object var11_18 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return tIMESTAMPLTZ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TIMESTAMPTZ getTIMESTAMPTZ(int currentRow) throws SQLException {
        TIMESTAMPTZ tIMESTAMPTZ;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                    tIMESTAMPTZ = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            TIMESTAMPTZ result = null;
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TimestampltzAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                        Object var5_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_8 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
                short len = this.rowSpaceIndicator[this.lengthIndex + currentRow];
                int off = this.columnIndex + this.byteLength * currentRow;
                byte[] data = new byte[len];
                System.arraycopy(this.rowSpaceByte, off, data, 0, len);
                result = oracle.sql.TIMESTAMPLTZ.toTIMESTAMPTZ(this.statement.connection, data);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                    Object var7_12 = null;
                }
                catch (Throwable throwable) {
                    Object var7_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            tIMESTAMPTZ = result;
            Object var9_15 = null;
        }
        catch (Throwable throwable) {
            Object var9_16 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var11_19 = null;
                }
                catch (Throwable throwable2) {
                    Object var11_20 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_17 = null;
            }
            catch (Throwable throwable) {
                Object var11_18 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return tIMESTAMPTZ;
    }

    TIMESTAMP getTIMESTAMP(int currentRow) throws SQLException {
        TIMESTAMPTZ tmtz = this.getTIMESTAMPTZ(currentRow);
        return oracle.sql.TIMESTAMPTZ.toTIMESTAMP(this.statement.connection, tmtz.getBytes());
    }

    DATE getDATE(int currentRow) throws SQLException {
        TIMESTAMPTZ tmtz = this.getTIMESTAMPTZ(currentRow);
        return oracle.sql.TIMESTAMPTZ.toDATE(this.statement.connection, tmtz.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void TimeZoneAdjust(Calendar cal1, Calendar cal2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(cal1) + ", " + OracleLog.argument(cal2));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            String cal1String = cal1.getTimeZone().getID();
            String cal2String = cal2.getTimeZone().getID();
            if (!cal2String.equals(cal1String)) {
                int Offset_gmt;
                OffsetDST trans_db = new OffsetDST();
                byte dbolap = this.getZoneOffset(cal1, trans_db);
                int offset = trans_db.getOFFSET();
                cal1.add(11, -(offset / 3600000));
                cal1.add(12, -(offset % 3600000) / 60000);
                if (cal2String.equals("Custom") || cal2String.startsWith("GMT") && cal2String.length() > 3) {
                    Offset_gmt = cal2.getTimeZone().getRawOffset();
                } else {
                    int regionID = ZONEIDMAP.getID(cal2String);
                    if (!ZONEIDMAP.isValidID(regionID)) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                TimestampltzAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 199);
                                Object var11_14 = null;
                            }
                            catch (Throwable throwable) {
                                Object var11_15 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 199);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    TIMEZONETAB tzTab = this.statement.connection.getTIMEZONETAB();
                    if (tzTab.checkID(regionID)) {
                        tzTab.updateTable(this.statement.connection, regionID);
                    }
                    Calendar calUTC = this.statement.getGMTCalendar();
                    calUTC.set(1, cal1.get(1));
                    calUTC.set(2, cal1.get(2));
                    calUTC.set(5, cal1.get(5));
                    calUTC.set(11, cal1.get(11));
                    calUTC.set(12, cal1.get(12));
                    calUTC.set(13, cal1.get(13));
                    calUTC.set(14, cal1.get(14));
                    Offset_gmt = tzTab.getOffset(calUTC, regionID);
                }
                cal1.add(11, Offset_gmt / 3600000);
                cal1.add(12, Offset_gmt % 3600000 / 60000);
            }
            if (cal2String.equals("Custom") && cal1String.equals("Custom") || cal2String.startsWith("GMT") && cal2String.length() > 3 && cal1String.startsWith("GMT") && cal1String.length() > 3) {
                int offset1 = cal1.getTimeZone().getRawOffset();
                int offset2 = cal2.getTimeZone().getRawOffset();
                int net_offset = 0;
                if (offset1 != offset2) {
                    net_offset = offset1 - offset2;
                    int n2 = net_offset = net_offset > 0 ? net_offset : -net_offset;
                }
                if (offset1 > offset2) {
                    net_offset = -net_offset;
                }
                cal1.add(11, net_offset / 3600000);
                cal1.add(12, net_offset % 3600000 / 60000);
            }
            int year = cal1.get(1);
            int month = cal1.get(2);
            int day = cal1.get(5);
            int hour = cal1.get(11);
            int minute = cal1.get(12);
            int second = cal1.get(13);
            int msecond = cal1.get(14);
            cal2.set(1, year);
            cal2.set(2, month);
            cal2.set(5, day);
            cal2.set(11, hour);
            cal2.set(12, minute);
            cal2.set(13, second);
            cal2.set(14, msecond);
            Object var14_23 = null;
        }
        catch (Throwable throwable) {
            Object var14_24 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var16_27 = null;
                }
                catch (Throwable throwable2) {
                    Object var16_28 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var16_25 = null;
            }
            catch (Throwable throwable) {
                Object var16_26 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    long TimeZoneAdjustUTC(Calendar cal1) throws SQLException {
        long l2;
        try {
            String cal1String;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(cal1));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if ((cal1String = cal1.getTimeZone().getID()).equals("Custom") || cal1String.startsWith("GMT") && cal1String.length() > 3) {
                int offset = cal1.getTimeZone().getRawOffset();
                cal1.add(11, -(offset / 3600000));
                cal1.add(12, -(offset % 3600000) / 60000);
            } else if (!cal1String.equals("GMT") && !cal1String.equals("UTC")) {
                OffsetDST trans_db = new OffsetDST();
                byte dbolap = this.getZoneOffset(cal1, trans_db);
                int offset = trans_db.getOFFSET();
                cal1.add(11, -(offset / 3600000));
                cal1.add(12, -(offset % 3600000) / 60000);
            }
            int year = cal1.get(1);
            int month = cal1.get(2);
            int day = cal1.get(5);
            int hour = cal1.get(11);
            int minute = cal1.get(12);
            int second = cal1.get(13);
            int msecond = cal1.get(14);
            Calendar calUTC = this.statement.getGMTCalendar();
            calUTC.set(1, year);
            calUTC.set(2, month);
            calUTC.set(5, day);
            calUTC.set(11, hour);
            calUTC.set(12, minute);
            calUTC.set(13, second);
            calUTC.set(14, msecond);
            long tstamp = calUTC.getTimeInMillis();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + tstamp);
                    Object var14_16 = null;
                }
                catch (Throwable throwable) {
                    Object var14_17 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            l2 = tstamp;
            Object var16_20 = null;
            if (!TRACE) return l2;
        }
        catch (Throwable throwable) {
            Object var16_21 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var18_24 = null;
            }
            catch (Throwable throwable2) {
                Object var18_25 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return l2;
        try {
            TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var18_22 = null;
        }
        catch (Throwable throwable) {
            Object var18_23 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte getZoneOffset(Calendar cal, OffsetDST tempVar) throws SQLException {
        byte by;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(cal) + ", " + OracleLog.argument(tempVar));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            byte olap = 0;
            String timeZone = cal.getTimeZone().getID();
            if (timeZone == "Custom" || timeZone.startsWith("GMT") && timeZone.length() > 3) {
                tempVar.setOFFSET(cal.getTimeZone().getRawOffset());
            } else {
                int regionID = ZONEIDMAP.getID(timeZone);
                if (!ZONEIDMAP.isValidID(regionID)) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            TimestampltzAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 199);
                            Object var7_8 = null;
                        }
                        catch (Throwable throwable) {
                            Object var7_9 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 199);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                TIMEZONETAB tzTab = this.statement.connection.getTIMEZONETAB();
                if (tzTab.checkID(regionID)) {
                    tzTab.updateTable(this.statement.connection, regionID);
                }
                olap = tzTab.getLocalOffset(cal, regionID, tempVar);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + olap);
                    Object var9_13 = null;
                }
                catch (Throwable throwable) {
                    Object var9_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            by = olap;
            Object var11_16 = null;
        }
        catch (Throwable throwable) {
            Object var11_17 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var13_20 = null;
                }
                catch (Throwable throwable2) {
                    Object var13_21 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                TimestampltzAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var13_18 = null;
            }
            catch (Throwable throwable) {
                Object var13_19 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return by;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.TimestampltzAccessor"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

