/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.text.DateFormatSymbols;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.TimestampAccessor;

class T4CTimestampAccessor
extends TimestampAccessor {
    T4CMAREngine mare;
    boolean underlyingLongRaw = false;
    final int[] meta = new int[1];
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    T4CTimestampAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean forBind, T4CMAREngine _mare) throws SQLException {
        super(stmt, max_len, form, external_type, forBind);
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CTimestampAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(external_type) + ", " + OracleLog.argument(forBind) + ", " + OracleLog.argument(_mare));
                    Object var8_7 = null;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.mare = _mare;
            Object var10_10 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                T4CTimestampAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var12_14 = null;
            }
            catch (Throwable throwable2) {
                Object var12_15 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            T4CTimestampAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var12_12 = null;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    T4CTimestampAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, int contflag, int total_elems, short form, int _definedColumnType, int _definedColumnSize, T4CMAREngine _mare) throws SQLException {
        super(stmt, max_len == -1 ? _definedColumnSize : max_len, nullable, flags, precision, scale, contflag, total_elems, form);
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CTimestampAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(nullable) + ", " + OracleLog.argument(flags) + ", " + OracleLog.argument(precision) + ", " + OracleLog.argument(scale) + ", " + OracleLog.argument(contflag) + ", " + OracleLog.argument(total_elems) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(_definedColumnType) + ", " + OracleLog.argument(_definedColumnSize) + ", " + OracleLog.argument(_mare));
                    Object var14_13 = null;
                }
                catch (Throwable throwable) {
                    Object var14_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.mare = _mare;
            if (stmt != null && stmt.implicitDefineForLobPrefetchDone) {
                this.definedColumnType = 0;
                this.definedColumnSize = 0;
            } else {
                this.definedColumnType = _definedColumnType;
                this.definedColumnSize = _definedColumnSize;
            }
            if (max_len == -1) {
                this.underlyingLongRaw = true;
            }
            Object var16_16 = null;
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CTimestampAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var18_20 = null;
                }
                catch (Throwable throwable2) {
                    Object var18_21 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T4CTimestampAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var18_18 = null;
            }
            catch (Throwable throwable) {
                Object var18_19 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    void processIndicator(int size) throws IOException, SQLException {
        if (this.internalType == 1 && this.describeType == 112 || this.internalType == 23 && this.describeType == 113) {
            this.mare.unmarshalUB2();
            this.mare.unmarshalUB2();
        } else if (this.statement.connection.versionNumber < 9200) {
            this.mare.unmarshalSB2();
            if (!this.statement.sqlKind.isPlsqlOrCall()) {
                this.mare.unmarshalSB2();
            }
        } else if (this.statement.sqlKind.isPlsqlOrCall() || this.isDMLReturnedParam) {
            this.mare.processIndicator(size <= 0, size);
        }
    }

    boolean unmarshalOneRow() throws SQLException, IOException {
        if (this.isUseLess) {
            ++this.lastRowProcessed;
            return false;
        }
        if (this.rowSpaceIndicator == null) {
            byte[] buff = new byte[16000];
            this.mare.unmarshalCLR(buff, 0, this.meta);
            this.processIndicator(this.meta[0]);
            ++this.lastRowProcessed;
            return false;
        }
        int tmpIndicatorOffset = this.indicatorIndex + this.lastRowProcessed;
        int tmpLengthOffset = this.lengthIndex + this.lastRowProcessed;
        if (this.isNullByDescribe) {
            this.rowSpaceIndicator[tmpIndicatorOffset] = -1;
            this.rowSpaceIndicator[tmpLengthOffset] = 0;
            ++this.lastRowProcessed;
            if (this.statement.connection.versionNumber < 9200) {
                this.processIndicator(0);
            }
            return false;
        }
        int tmpSpaceByteOffset = this.columnIndex + this.lastRowProcessed * this.byteLength;
        this.mare.unmarshalCLR(this.rowSpaceByte, tmpSpaceByteOffset, this.meta, this.byteLength);
        this.processIndicator(this.meta[0]);
        if (this.meta[0] == 0) {
            this.rowSpaceIndicator[tmpIndicatorOffset] = -1;
            this.rowSpaceIndicator[tmpLengthOffset] = 0;
        } else {
            this.rowSpaceIndicator[tmpLengthOffset] = (short)this.meta[0];
            this.rowSpaceIndicator[tmpIndicatorOffset] = 0;
        }
        ++this.lastRowProcessed;
        return false;
    }

    void copyRow() throws SQLException, IOException {
        int lastRowOffset = this.lastRowProcessed == 0 ? this.statement.rowPrefetchInLastFetch - 1 : this.lastRowProcessed - 1;
        int tmpSpaceByteOffset = this.columnIndex + this.lastRowProcessed * this.byteLength;
        int tmpSpaceByteOffsetLastRow = this.columnIndex + lastRowOffset * this.byteLength;
        int tmpIndicatorOffset = this.indicatorIndex + this.lastRowProcessed;
        int tmpIndicatorOffsetLastRow = this.indicatorIndex + lastRowOffset;
        int tmpLengthOffset = this.lengthIndex + this.lastRowProcessed;
        int tmpLengthOffsetLastRow = this.lengthIndex + lastRowOffset;
        short nbBytes = this.rowSpaceIndicator[tmpLengthOffsetLastRow];
        int indexmetadata = this.metaDataIndex + this.lastRowProcessed * 1;
        int indexmetadataLastRow = this.metaDataIndex + lastRowOffset * 1;
        this.rowSpaceIndicator[tmpLengthOffset] = nbBytes;
        this.rowSpaceIndicator[tmpIndicatorOffset] = this.rowSpaceIndicator[tmpIndicatorOffsetLastRow];
        if (!this.isNullByDescribe) {
            System.arraycopy(this.rowSpaceByte, tmpSpaceByteOffsetLastRow, this.rowSpaceByte, tmpSpaceByteOffset, nbBytes);
        }
        System.arraycopy(this.rowSpaceMetaData, indexmetadataLastRow, this.rowSpaceMetaData, indexmetadata, 1);
        ++this.lastRowProcessed;
    }

    void saveDataFromOldDefineBuffers(byte[] rowSpaceByteLastRow, char[] rowSpaceCharLastRow, short[] rowSpaceIndicatorLastRow, int oldPrefetchSize, int newPrefetchSize) throws SQLException {
        int tmpSpaceByteOffset = this.columnIndex + (newPrefetchSize - 1) * this.byteLength;
        int tmpSpaceByteOffsetLastRow = this.columnIndexLastRow + (oldPrefetchSize - 1) * this.byteLength;
        int tmpIndicatorOffset = this.indicatorIndex + newPrefetchSize - 1;
        int tmpIndicatorOffsetLastRow = this.indicatorIndexLastRow + oldPrefetchSize - 1;
        int tmpLengthOffset = this.lengthIndex + newPrefetchSize - 1;
        int tmpLengthOffsetLastRow = this.lengthIndexLastRow + oldPrefetchSize - 1;
        short nbBytes = rowSpaceIndicatorLastRow[tmpLengthOffsetLastRow];
        this.rowSpaceIndicator[tmpLengthOffset] = nbBytes;
        this.rowSpaceIndicator[tmpIndicatorOffset] = rowSpaceIndicatorLastRow[tmpIndicatorOffsetLastRow];
        if (nbBytes != 0) {
            System.arraycopy(rowSpaceByteLastRow, tmpSpaceByteOffsetLastRow, this.rowSpaceByte, tmpSpaceByteOffset, nbBytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getString(int currentRow) throws SQLException {
        String string;
        try {
            String ret;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CTimestampAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                    string = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if ((ret = super.getString(currentRow)) != null && this.definedColumnSize > 0 && ret.length() > this.definedColumnSize) {
                ret = ret.substring(0, this.definedColumnSize);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CTimestampAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            string = ret;
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CTimestampAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T4CTimestampAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return string;
    }

    String toText(int year, int month, int day, int hour, int min, int sec, int nanos, boolean am, String zone) throws SQLException {
        if (this.definedColumnType == 0 || this.definedColumnType == 93) {
            return super.toText(year, month, day, hour, min, sec, nanos, am, zone);
        }
        String format = (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTMPFM");
        return T4CTimestampAccessor.nlsFormatToText(year, month, day, hour, min, sec, nanos, am, zone, format);
    }

    private static final String nlsFormatToText(int year, int month, int day, int hour, int min, int sec, int nanos, boolean am, String zone, String format) throws SQLException {
        char[] fChars = (format + "      ").toCharArray();
        int fLength = format.length();
        StringBuffer sb = new StringBuffer(fLength + 25);
        String[] sMonths = null;
        String[] lMonths = null;
        TimeZone tz = null;
        block11: for (int i2 = 0; i2 < fLength; ++i2) {
            switch (fChars[i2]) {
                case 'R': 
                case 'r': {
                    if (fChars[i2 + 1] != 'R' && fChars[i2 + 1] != 'r') continue block11;
                    if (!(fChars[i2 + 2] != 'R' && fChars[i2 + 2] != 'r' || fChars[i2 + 3] != 'R' && fChars[i2 + 3] != 'r')) {
                        if (year < 1000) {
                            sb.append("0" + year);
                        } else if (year < 100) {
                            sb.append("00" + year);
                        } else if (year < 10) {
                            sb.append("000" + year);
                        } else {
                            sb.append(year);
                        }
                        i2 += 3;
                        continue block11;
                    }
                    if (year >= 100) {
                        year %= 100;
                    }
                    if (year < 10) {
                        sb.append("0" + year);
                    } else {
                        sb.append(year);
                    }
                    ++i2;
                    continue block11;
                }
                case 'Y': 
                case 'y': {
                    if (fChars[i2 + 1] != 'Y' && fChars[i2 + 1] != 'y') continue block11;
                    if (!(fChars[i2 + 2] != 'Y' && fChars[i2 + 2] != 'y' || fChars[i2 + 3] != 'Y' && fChars[i2 + 3] != 'y')) {
                        if (year < 1000) {
                            sb.append("0" + year);
                        } else if (year < 100) {
                            sb.append("00" + year);
                        } else if (year < 10) {
                            sb.append("000" + year);
                        } else {
                            sb.append(year);
                        }
                        i2 += 3;
                        continue block11;
                    }
                    if (year >= 100) {
                        year %= 100;
                    }
                    if (year < 10) {
                        sb.append("0" + year);
                    } else {
                        sb.append(year);
                    }
                    ++i2;
                    continue block11;
                }
                case 'D': 
                case 'd': {
                    if (fChars[i2 + 1] != 'D' && fChars[i2 + 1] != 'd') continue block11;
                    sb.append((day < 10 ? "0" : "") + day);
                    ++i2;
                    continue block11;
                }
                case 'M': 
                case 'm': {
                    if (fChars[i2 + 1] == 'M' || fChars[i2 + 1] == 'm') {
                        sb.append((month < 10 ? "0" : "") + month);
                        ++i2;
                        continue block11;
                    }
                    if (fChars[i2 + 1] == 'I' || fChars[i2 + 1] == 'i') {
                        sb.append((min < 10 ? "0" : "") + min);
                        ++i2;
                        continue block11;
                    }
                    if (fChars[i2 + 1] != 'O' && fChars[i2 + 1] != 'o' || fChars[i2 + 2] != 'N' && fChars[i2 + 2] != 'n') continue block11;
                    if (!(fChars[i2 + 3] != 'T' && fChars[i2 + 3] != 't' || fChars[i2 + 4] != 'H' && fChars[i2 + 4] != 'h')) {
                        if (lMonths == null) {
                            lMonths = new DateFormatSymbols().getMonths();
                        }
                        if (fChars[i2] == 'm') {
                            sb.append(lMonths[month - 1].toLowerCase());
                        } else if (fChars[i2 + 1] == 'O') {
                            sb.append(lMonths[month - 1].toUpperCase());
                        } else {
                            sb.append(lMonths[month - 1]);
                        }
                        i2 += 4;
                        continue block11;
                    }
                    if (sMonths == null) {
                        sMonths = new DateFormatSymbols().getShortMonths();
                    }
                    if (fChars[i2] == 'm') {
                        sb.append(sMonths[month - 1].toLowerCase());
                    } else if (fChars[i2 + 1] == 'O') {
                        sb.append(sMonths[month - 1].toUpperCase());
                    } else {
                        sb.append(sMonths[month - 1]);
                    }
                    i2 += 2;
                    continue block11;
                }
                case 'H': 
                case 'h': {
                    if (fChars[i2 + 1] != 'H' && fChars[i2 + 1] != 'h') continue block11;
                    if (fChars[i2 + 2] == '2' || fChars[i2 + 3] == '4') {
                        sb.append((hour < 10 ? "0" : "") + hour);
                        i2 += 3;
                        continue block11;
                    }
                    if (hour > 12) {
                        hour -= 12;
                    }
                    sb.append((hour < 10 ? "0" : "") + hour);
                    ++i2;
                    continue block11;
                }
                case 'S': 
                case 's': {
                    if (fChars[i2 + 1] != 'S' && fChars[i2 + 1] != 's') continue block11;
                    sb.append((sec < 10 ? "0" : "") + sec);
                    if (fChars[++i2 + 1] != 'X' && fChars[i2 + 1] != 'x' || fChars[i2 + 2] != 'F' && fChars[i2 + 2] != 'f' || fChars[i2 + 3] != 'F' && fChars[i2 + 3] != 'f') continue block11;
                    sb.append(".");
                    ++i2;
                    continue block11;
                }
                case 'F': 
                case 'f': {
                    if (fChars[i2 + 1] != 'F' && fChars[i2 + 1] != 'f') continue block11;
                    if (nanos >= 0) {
                        sb.append(nanos);
                    } else {
                        sb.append(0);
                    }
                    ++i2;
                    continue block11;
                }
                case 'T': 
                case 't': {
                    if (fChars[i2 + 1] != 'Z' && fChars[i2 + 1] != 'z') continue block11;
                    if (fChars[i2 + 2] == 'R' || fChars[i2 + 2] == 'r') {
                        if (zone.length() > 3 && zone.startsWith("GMT")) {
                            sb.append(zone.substring(3));
                        } else {
                            sb.append(zone.toUpperCase());
                        }
                        i2 += 2;
                        continue block11;
                    }
                    if (fChars[i2 + 2] == 'H' || fChars[i2 + 2] == 'h') {
                        if (tz == null) {
                            tz = TimeZone.getTimeZone(zone);
                        }
                        long offsetHr = tz.getRawOffset() / 3600000;
                        sb.append(offsetHr);
                        i2 += 2;
                        continue block11;
                    }
                    if (fChars[i2 + 2] != 'M' && fChars[i2 + 2] != 'm') continue block11;
                    if (tz == null) {
                        tz = TimeZone.getTimeZone(zone);
                    }
                    long offsetMin = Math.abs(tz.getRawOffset()) % 3600000 / 60000;
                    sb.append((offsetMin < 10L ? "0" : "") + offsetMin);
                    i2 += 2;
                    continue block11;
                }
                case 'A': 
                case 'P': 
                case 'a': 
                case 'p': {
                    if (fChars[i2 + 1] != 'M' && fChars[i2 + 1] != 'm') continue block11;
                    sb.append(am ? "AM" : "PM");
                    ++i2;
                    continue block11;
                }
                default: {
                    sb.append(fChars[i2]);
                }
            }
        }
        return sb.substring(0, sb.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    Object getObject(int currentRow) throws SQLException {
        Object var3_2;
        try {
            Object __ex__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CTimestampAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                    var3_2 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if (this.definedColumnType == 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CTimestampAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + super.getObject(currentRow));
                        Object var5_7 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var5_8 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                Object object = super.getObject(currentRow);
                Object var23_10 = null;
                if (!TRACE) return object;
                if (!OracleLog.recursiveEnter()) return object;
                try {
                    T4CTimestampAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var25_18 = null;
                    OracleLog.recursiveExit();
                    return object;
                }
                catch (Throwable throwable) {
                    Object var25_19 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            Object result = null;
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CTimestampAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                        Object var7_42 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var7_43 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                ((Throwable)__ex__).fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
                switch (this.definedColumnType) {
                    case -1: 
                    case 1: 
                    case 12: {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T4CTimestampAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.getString(currentRow));
                                Object var9_45 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                Object var9_46 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                        __ex__ = this.getString(currentRow);
                        Object var23_11 = null;
                        if (!TRACE) return __ex__;
                        if (!OracleLog.recursiveEnter()) return __ex__;
                        try {}
                        catch (Throwable throwable) {
                            Object var25_21 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        T4CTimestampAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var25_20 = null;
                        OracleLog.recursiveExit();
                        return __ex__;
                    }
                    case 93: {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T4CTimestampAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.getTimestamp(currentRow));
                                Object var11_48 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                Object var11_49 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                        __ex__ = this.getTimestamp(currentRow);
                        Object var23_12 = null;
                        if (!TRACE) return __ex__;
                        if (!OracleLog.recursiveEnter()) return __ex__;
                        try {}
                        catch (Throwable throwable) {
                            Object var25_23 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        T4CTimestampAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var25_22 = null;
                        OracleLog.recursiveExit();
                        return __ex__;
                    }
                    case 91: {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T4CTimestampAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.getDate(currentRow));
                                Object var13_51 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                Object var13_52 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                        __ex__ = this.getDate(currentRow);
                        Object var23_13 = null;
                        if (!TRACE) return __ex__;
                        if (!OracleLog.recursiveEnter()) return __ex__;
                        try {}
                        catch (Throwable throwable) {
                            Object var25_25 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        T4CTimestampAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var25_24 = null;
                        OracleLog.recursiveExit();
                        return __ex__;
                    }
                    case 92: {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T4CTimestampAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.getTime(currentRow));
                                Object var15_54 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                Object var15_55 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                        __ex__ = this.getTime(currentRow);
                        Object var23_14 = null;
                        if (!TRACE) return __ex__;
                        if (!OracleLog.recursiveEnter()) return __ex__;
                        try {}
                        catch (Throwable throwable) {
                            Object var25_27 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        T4CTimestampAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var25_26 = null;
                        OracleLog.recursiveExit();
                        return __ex__;
                    }
                    case -4: 
                    case -3: 
                    case -2: {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T4CTimestampAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.getBytes(currentRow));
                                Object var17_57 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                Object var17_58 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                        __ex__ = this.getBytes(currentRow);
                        Object var23_15 = null;
                        if (!TRACE) return __ex__;
                        if (!OracleLog.recursiveEnter()) return __ex__;
                        try {}
                        catch (Throwable throwable) {
                            Object var25_29 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        T4CTimestampAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var25_28 = null;
                        OracleLog.recursiveExit();
                        return __ex__;
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CTimestampAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4);
                        Object var19_60 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var19_61 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
                ((Throwable)__ex__).fillInStackTrace();
                throw __ex__;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CTimestampAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                    Object var21_63 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var21_64 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            var3_2 = result;
            Object var23_16 = null;
            if (!TRACE) return var3_2;
        }
        catch (Throwable throwable) {
            Object var23_17 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var25_33 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            T4CTimestampAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var25_32 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return var3_2;
        try {}
        catch (Throwable throwable) {
            Object var25_31 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        T4CTimestampAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
        Object var25_30 = null;
        OracleLog.recursiveExit();
        return var3_2;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CTimestampAccessor"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

