/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.jdbc.driver.OracleDriverExtension;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T2CCallableStatement;
import oracle.jdbc.driver.T2CConnection;
import oracle.jdbc.driver.T2CInputStream;
import oracle.jdbc.driver.T2CPreparedStatement;
import oracle.jdbc.driver.T2CStatement;
import oracle.jdbc.oci.OracleOCIConnection;

class T2CDriverExtension
extends OracleDriverExtension {
    static final int T2C_DEFAULT_BATCHSIZE = 1;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    T2CDriverExtension() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Connection getConnection(String url, Properties info) throws SQLException {
        T2CConnection t2CConnection;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CDriverExtension.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(url) + ", " + OracleLog.argument(info));
                    t2CConnection = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            T2CConnection t2Conn = null;
            t2Conn = info.getProperty("is_connection_pooling") == "true" ? new OracleOCIConnection(url, info, (Object)this) : new T2CConnection(url, info, this);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CDriverExtension.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + t2Conn);
                    Object var6_7 = null;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            t2CConnection = t2Conn;
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CDriverExtension.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CDriverExtension.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_12 = null;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return t2CConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OracleStatement allocateStatement(PhysicalConnection conn, int resultSetType, int resultSetConcurrency) throws SQLException {
        T2CStatement t2CStatement;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CDriverExtension.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(resultSetType) + ", " + OracleLog.argument(resultSetConcurrency));
                    t2CStatement = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            T2CStatement __result__ = new T2CStatement((T2CConnection)conn, 1, conn.defaultRowPrefetch, resultSetType, resultSetConcurrency);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CDriverExtension.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var7_8 = null;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            t2CStatement = __result__;
            Object var9_11 = null;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CDriverExtension.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var11_15 = null;
                }
                catch (Throwable throwable2) {
                    Object var11_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CDriverExtension.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_13 = null;
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return t2CStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    OraclePreparedStatement allocatePreparedStatement(PhysicalConnection conn, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        T2CPreparedStatement t2CPreparedStatement;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CDriverExtension.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(sql) + ", " + OracleLog.argument(resultSetType) + ", " + OracleLog.argument(resultSetConcurrency));
                    t2CPreparedStatement = null;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            T2CPreparedStatement __result__ = new T2CPreparedStatement((T2CConnection)conn, sql, conn.defaultExecuteBatch, conn.defaultRowPrefetch, resultSetType, resultSetConcurrency);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CDriverExtension.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var8_9 = null;
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            t2CPreparedStatement = __result__;
            Object var10_12 = null;
            if (!TRACE) return t2CPreparedStatement;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                T2CDriverExtension.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var12_16 = null;
            }
            catch (Throwable throwable2) {
                Object var12_17 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return t2CPreparedStatement;
        try {
            T2CDriverExtension.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var12_14 = null;
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
        return t2CPreparedStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OracleCallableStatement allocateCallableStatement(PhysicalConnection conn, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        T2CCallableStatement t2CCallableStatement;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CDriverExtension.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(sql) + ", " + OracleLog.argument(resultSetType) + ", " + OracleLog.argument(resultSetConcurrency));
                    t2CCallableStatement = null;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            T2CCallableStatement __result__ = new T2CCallableStatement((T2CConnection)conn, sql, conn.defaultExecuteBatch, conn.defaultRowPrefetch, resultSetType, resultSetConcurrency);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CDriverExtension.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var8_9 = null;
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            t2CCallableStatement = __result__;
            Object var10_12 = null;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CDriverExtension.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var12_16 = null;
                }
                catch (Throwable throwable2) {
                    Object var12_17 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T2CDriverExtension.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var12_14 = null;
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return t2CCallableStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    OracleInputStream createInputStream(OracleStatement stmt, int index, Accessor accessor) throws SQLException {
        T2CInputStream t2CInputStream;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CDriverExtension.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(index) + ", " + OracleLog.argument(accessor));
                    t2CInputStream = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            T2CInputStream __result__ = new T2CInputStream(stmt, index, accessor);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T2CDriverExtension.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var7_8 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            t2CInputStream = __result__;
            Object var9_11 = null;
            if (!TRACE) return t2CInputStream;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var11_16 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            T2CDriverExtension.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var11_15 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return t2CInputStream;
        try {
            T2CDriverExtension.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var11_13 = null;
            OracleLog.recursiveExit();
            return t2CInputStream;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T2CDriverExtension"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

