/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleBufferedStream;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;

class OracleConversionInputStream
extends OracleBufferedStream {
    static final int CHUNK_SIZE = 4096;
    DBConversion converter;
    int conversion;
    InputStream istream;
    Reader reader;
    byte[] convbuf;
    char[] javaChars;
    int maxSize;
    int totalSize;
    int numUnconvertedBytes;
    boolean endOfStream;
    private short csform;
    int[] nbytes;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleConversionInputStream(DBConversion conv_object, InputStream istream, int conversion) {
        this(conv_object, istream, conversion, 1);
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(conv_object) + ", " + OracleLog.argument(istream) + ", " + OracleLog.argument(conversion));
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_11 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_12 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConversionInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleConversionInputStream(DBConversion conv_object, InputStream istream, int conversion, short formOfUse) {
        super(4096);
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(conv_object) + ", " + OracleLog.argument(istream) + ", " + OracleLog.argument(conversion) + ", " + OracleLog.argument(formOfUse));
                    Object var6_5 = null;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.istream = istream;
            this.conversion = conversion;
            this.converter = conv_object;
            this.maxSize = 0;
            this.totalSize = 0;
            this.numUnconvertedBytes = 0;
            this.endOfStream = false;
            this.nbytes = new int[1];
            this.csform = formOfUse;
            this.currentBufferSize = this.initialBufferSize;
            this.resizableBuffer = new byte[this.currentBufferSize];
            switch (conversion) {
                case 0: {
                    this.javaChars = new char[4096];
                    this.convbuf = new byte[4096];
                    break;
                }
                case 1: {
                    this.convbuf = new byte[2048];
                    this.javaChars = new char[2048];
                    break;
                }
                case 2: {
                    this.convbuf = new byte[2048];
                    this.javaChars = new char[4096];
                    break;
                }
                case 3: {
                    this.convbuf = new byte[1024];
                    this.javaChars = new char[2048];
                    break;
                }
                case 4: {
                    int size = 4096 / this.converter.getMaxCharbyteSize();
                    this.convbuf = new byte[size * 2];
                    this.javaChars = new char[size];
                    break;
                }
                case 5: {
                    if (this.converter.isUcs2CharSet()) {
                        this.convbuf = new byte[2048];
                        this.javaChars = new char[2048];
                        break;
                    }
                    this.convbuf = new byte[4096];
                    this.javaChars = new char[4096];
                    break;
                }
                case 7: {
                    int size = 4096 / (formOfUse == 2 ? this.converter.getMaxNCharbyteSize() : this.converter.getMaxCharbyteSize());
                    this.javaChars = new char[size];
                    break;
                }
                default: {
                    this.convbuf = new byte[4096];
                    this.javaChars = new char[4096];
                }
            }
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConversionInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_12 = null;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleConversionInputStream(DBConversion conv_object, InputStream istream, int conversion, int max_bytesize) {
        this(conv_object, istream, conversion, 1);
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(conv_object) + ", " + OracleLog.argument(istream) + ", " + OracleLog.argument(max_bytesize));
                    Object var6_5 = null;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.maxSize = max_bytesize;
            this.totalSize = 0;
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConversionInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_10 = null;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleConversionInputStream(DBConversion conv_object, Reader reader, int conversion, int max_charsize, short formOfUse) {
        this(conv_object, (InputStream)null, conversion, formOfUse);
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(conv_object) + ", " + OracleLog.argument(conversion) + ", " + OracleLog.argument(max_charsize) + ", " + OracleLog.argument(formOfUse));
                    Object var7_6 = null;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.reader = reader;
            this.maxSize = max_charsize;
            this.totalSize = 0;
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var11_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var11_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConversionInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_11 = null;
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFormOfUse(short csform) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(csform));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.csform = csform;
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConversionInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public boolean needBytes(int ignore) throws IOException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var3_2 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            boolean __result__ = this.needBytes();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            bl = __result__;
            Object var7_10 = null;
            if (!TRACE) return bl;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var9_15 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleConversionInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_14 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return bl;
        try {
            OracleConversionInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_12 = null;
            OracleLog.recursiveExit();
            return bl;
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean needBytes() throws IOException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConversionInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                        Object var4_11 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var4_12 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                boolean bl2 = false;
                Object var14_14 = null;
                if (!TRACE) return bl2;
                if (!OracleLog.recursiveEnter()) return bl2;
                try {
                    OracleConversionInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var16_20 = null;
                    OracleLog.recursiveExit();
                    return bl2;
                }
                catch (Throwable throwable) {
                    Object var16_21 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if (this.pos < this.count) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConversionInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                        Object var6_38 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var6_39 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                boolean bl3 = true;
                Object var14_15 = null;
                if (!TRACE) return bl3;
                if (!OracleLog.recursiveEnter()) return bl3;
                try {}
                catch (Throwable throwable) {
                    Object var16_23 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleConversionInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var16_22 = null;
                OracleLog.recursiveExit();
                return bl3;
            }
            if (this.istream != null) {
                boolean __result__ = this.needBytesFromStream();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConversionInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        Object var8_41 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var8_42 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                boolean bl4 = __result__;
                Object var14_16 = null;
                if (!TRACE) return bl4;
                if (!OracleLog.recursiveEnter()) return bl4;
                try {}
                catch (Throwable throwable) {
                    Object var16_25 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleConversionInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var16_24 = null;
                OracleLog.recursiveExit();
                return bl4;
            }
            if (this.reader != null) {
                boolean __result__ = this.needBytesFromReader();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConversionInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        Object var10_44 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var10_45 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                boolean bl5 = __result__;
                Object var14_17 = null;
                if (!TRACE) return bl5;
                if (!OracleLog.recursiveEnter()) return bl5;
                try {}
                catch (Throwable throwable) {
                    Object var16_27 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleConversionInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var16_26 = null;
                OracleLog.recursiveExit();
                return bl5;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                    Object var12_47 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var12_48 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            bl = false;
            Object var14_18 = null;
            if (!TRACE) return bl;
        }
        catch (Throwable throwable) {
            Object var14_19 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var16_31 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleConversionInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var16_30 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return bl;
        try {}
        catch (Throwable throwable) {
            Object var16_29 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleConversionInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
        Object var16_28 = null;
        OracleLog.recursiveExit();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    public boolean needBytesFromReader() throws IOException {
        if (OracleConversionInputStream.TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConversionInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                var2_1 = null;
            }
            catch (Throwable var1_5) {
                var2_2 = null;
                OracleLog.recursiveExit();
                throw var1_5;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        read_size = 0;
        read_size = this.maxSize == 0 ? this.javaChars.length : Math.min(this.maxSize - this.totalSize, this.javaChars.length);
        if (read_size > 0) break block32;
        if (OracleConversionInputStream.TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConversionInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                var4_8 = null;
            }
            catch (Throwable var3_10) {
                var4_9 = null;
                OracleLog.recursiveExit();
                throw var3_10;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        var2_3 = false;
        var12_12 = null;
        if (!OracleConversionInputStream.TRACE || !OracleLog.recursiveEnter()) ** GOTO lbl-1000
        try {
            OracleConversionInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            var14_16 = null;
        }
        catch (Throwable var13_24) {
            var14_17 = null;
            OracleLog.recursiveExit();
            throw var13_24;
        }
        OracleLog.recursiveExit();
        {
        }
lbl-1000:
        // 2 sources

        {
            block32: {
                return var2_3;
            }
            chars_read = this.reader.read(this.javaChars, 0, read_size);
            if (chars_read != -1) break block33;
            if (OracleConversionInputStream.TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                    var6_28 = null;
                }
                catch (Throwable var5_30) {
                    var6_29 = null;
                    OracleLog.recursiveExit();
                    throw var5_30;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            var3_11 = false;
        }
        var12_13 = null;
        if (!OracleConversionInputStream.TRACE || !OracleLog.recursiveEnter()) ** GOTO lbl-1000
        try {
            OracleConversionInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            var14_18 = null;
        }
        catch (Throwable var13_25) {
            var14_19 = null;
            OracleLog.recursiveExit();
            throw var13_25;
        }
        OracleLog.recursiveExit();
        {
        }
lbl-1000:
        // 2 sources

        {
            block33: {
                return var3_11;
            }
            try {
                this.totalSize += chars_read;
                switch (this.conversion) {
                    case 7: {
                        if (this.csform == 2) {
                            this.count = this.converter.javaCharsToNCHARBytes(this.javaChars, chars_read, this.resizableBuffer);
                            break;
                        }
                        this.count = this.converter.javaCharsToCHARBytes(this.javaChars, chars_read, this.resizableBuffer);
                        break;
                    }
                    default: {
                        System.arraycopy(this.convbuf, 0, this.resizableBuffer, 0, chars_read);
                        this.count = chars_read;
                        break;
                    }
                }
            }
            catch (SQLException e) {
                if (OracleConversionInputStream.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConversionInputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + e);
                        var8_31 = null;
                    }
                    catch (Throwable var7_33) {
                        var8_32 = null;
                        OracleLog.recursiveExit();
                        throw var7_33;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                __ex__ = DatabaseError.createIOException(e);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.pos = 0;
            if (OracleConversionInputStream.TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                    var10_34 = null;
                }
                catch (Throwable var9_36) {
                    var10_35 = null;
                    OracleLog.recursiveExit();
                    throw var9_36;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            var1_6 = true;
        }
        var12_14 = null;
        if (OracleConversionInputStream.TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConversionInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                var14_20 = null;
            }
            catch (Throwable var13_26) {
                var14_21 = null;
                OracleLog.recursiveExit();
                throw var13_26;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return var1_6;
        catch (Throwable var11_37) {
            var12_15 = null;
            if (OracleConversionInputStream.TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    var14_22 = null;
                }
                catch (Throwable var13_27) {
                    var14_23 = null;
                    OracleLog.recursiveExit();
                    throw var13_27;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw var11_37;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean needBytesFromStream() throws IOException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if (!this.endOfStream) {
                int bytes_read;
                block52: {
                    int read_size = 0;
                    read_size = this.maxSize == 0 ? this.convbuf.length : Math.min(this.maxSize - this.totalSize, this.convbuf.length);
                    bytes_read = 0;
                    if (read_size <= 0) {
                        this.endOfStream = true;
                        this.istream.close();
                        if (this.numUnconvertedBytes != 0) {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleConversionInputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 55);
                                    Object var4_8 = null;
                                    OracleLog.recursiveExit();
                                }
                                catch (Throwable throwable) {
                                    Object var4_9 = null;
                                    OracleLog.recursiveExit();
                                    throw throwable;
                                }
                            }
                            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 55);
                            __ex__.fillInStackTrace();
                            throw __ex__;
                        }
                    } else {
                        bytes_read = this.istream.read(this.convbuf, this.numUnconvertedBytes, read_size - this.numUnconvertedBytes);
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleConversionInputStream.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + OracleLog.bytesToPrintableForm("Read " + bytes_read + " bytes into convbuf", this.convbuf, bytes_read));
                                Object var6_22 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                Object var6_23 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                    }
                    if (bytes_read == -1) {
                        this.endOfStream = true;
                        this.istream.close();
                        if (this.numUnconvertedBytes != 0) {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleConversionInputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 55);
                                    Object var8_25 = null;
                                    OracleLog.recursiveExit();
                                }
                                catch (Throwable throwable) {
                                    Object var8_26 = null;
                                    OracleLog.recursiveExit();
                                    throw throwable;
                                }
                            }
                            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 55);
                            __ex__.fillInStackTrace();
                            throw __ex__;
                        }
                    } else {
                        this.totalSize += (bytes_read += this.numUnconvertedBytes);
                    }
                    if (bytes_read > 0) break block52;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleConversionInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                            Object var10_28 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var10_29 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                    boolean __ex__ = false;
                    Object var18_31 = null;
                    if (!TRACE) return __ex__;
                    if (!OracleLog.recursiveEnter()) return __ex__;
                    try {
                        OracleConversionInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var20_35 = null;
                        OracleLog.recursiveExit();
                        return __ex__;
                    }
                    catch (Throwable throwable) {
                        Object var20_36 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                try {
                    int chars_read;
                    switch (this.conversion) {
                        case 0: {
                            this.nbytes[0] = bytes_read;
                            chars_read = this.converter.CHARBytesToJavaChars(this.convbuf, 0, this.javaChars, 0, this.nbytes, this.javaChars.length);
                            this.numUnconvertedBytes = this.nbytes[0];
                            for (int i2 = 0; i2 < this.numUnconvertedBytes; ++i2) {
                                this.convbuf[i2] = this.convbuf[bytes_read - this.numUnconvertedBytes];
                            }
                        }
                        this.count = DBConversion.javaCharsToAsciiBytes(this.javaChars, chars_read, this.resizableBuffer);
                        break;
                        case 1: {
                            this.nbytes[0] = bytes_read;
                            chars_read = this.converter.CHARBytesToJavaChars(this.convbuf, 0, this.javaChars, 0, this.nbytes, this.javaChars.length);
                            this.numUnconvertedBytes = this.nbytes[0];
                            for (int i3 = 0; i3 < this.numUnconvertedBytes; ++i3) {
                                this.convbuf[i3] = this.convbuf[bytes_read - this.numUnconvertedBytes];
                            }
                        }
                        this.count = DBConversion.javaCharsToUcs2Bytes(this.javaChars, chars_read, this.resizableBuffer);
                        break;
                        case 2: {
                            chars_read = DBConversion.RAWBytesToHexChars(this.convbuf, bytes_read, this.javaChars);
                            this.count = DBConversion.javaCharsToAsciiBytes(this.javaChars, chars_read, this.resizableBuffer);
                            break;
                        }
                        case 3: {
                            chars_read = DBConversion.RAWBytesToHexChars(this.convbuf, bytes_read, this.javaChars);
                            this.count = DBConversion.javaCharsToUcs2Bytes(this.javaChars, chars_read, this.resizableBuffer);
                            break;
                        }
                        case 4: {
                            chars_read = DBConversion.ucs2BytesToJavaChars(this.convbuf, bytes_read, this.javaChars);
                            this.count = this.converter.javaCharsToCHARBytes(this.javaChars, chars_read, this.resizableBuffer);
                            break;
                        }
                        case 12: {
                            chars_read = DBConversion.ucs2BytesToJavaChars(this.convbuf, bytes_read, this.javaChars);
                            this.count = DBConversion.javaCharsToAsciiBytes(this.javaChars, chars_read, this.resizableBuffer);
                            break;
                        }
                        case 5: {
                            DBConversion.asciiBytesToJavaChars(this.convbuf, bytes_read, this.javaChars);
                            this.count = this.converter.javaCharsToCHARBytes(this.javaChars, bytes_read, this.resizableBuffer);
                            break;
                        }
                        default: {
                            System.arraycopy(this.convbuf, 0, this.resizableBuffer, 0, bytes_read);
                            this.count = bytes_read;
                            break;
                        }
                    }
                }
                catch (SQLException e2) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleConversionInputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + e2);
                            Object var12_47 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var12_48 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                    IOException __ex__ = DatabaseError.createIOException(e2);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.pos = 0;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConversionInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                        Object var14_50 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var14_51 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                boolean bl2 = true;
                Object var18_32 = null;
                if (!TRACE) return bl2;
                if (!OracleLog.recursiveEnter()) return bl2;
                try {}
                catch (Throwable throwable) {
                    Object var20_38 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleConversionInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var20_37 = null;
                OracleLog.recursiveExit();
                return bl2;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                    Object var16_53 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var16_54 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            bl = false;
            Object var18_33 = null;
            if (!TRACE) return bl;
        }
        catch (Throwable throwable) {
            Object var18_34 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var20_42 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleConversionInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var20_41 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return bl;
        try {}
        catch (Throwable throwable) {
            Object var20_40 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleConversionInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
        Object var20_39 = null;
        OracleLog.recursiveExit();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        OracleConnection oracleConnection;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            oracleConnection = null;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConversionInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return oracleConnection;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.OracleConversionInputStream"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

