/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.aq;

import java.sql.SQLException;
import java.util.EventObject;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.aq.AQMessageProperties;
import oracle.jdbc.driver.OracleLog;

public abstract class AQNotificationEvent
extends EventObject {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AQNotificationEvent(Object source) {
        block12: {
            super(source);
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block12;
                try {
                    AQNotificationEvent.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(source));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        AQNotificationEvent.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    public abstract AQMessageProperties getMessageProperties() throws SQLException;

    public abstract String getRegistration() throws SQLException;

    public abstract byte[] getPayload() throws SQLException;

    public abstract String getQueueName() throws SQLException;

    public abstract byte[] getMessageId() throws SQLException;

    public abstract String getConsumerName() throws SQLException;

    public abstract String getConnectionInformation();

    public abstract EventType getEventType();

    public abstract AdditionalEventType getAdditionalEventType();

    public abstract String toString();

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.aq");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.aq.AQNotificationEvent"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AdditionalEventType {
        NONE(0),
        TIMEOUT(1),
        GROUPING(2);

        private final int code;

        private AdditionalEventType(int _code) {
            this.code = _code;
        }

        public final int getCode() {
            return this.code;
        }

        public static final AdditionalEventType getEventType(int code) {
            if (code == TIMEOUT.getCode()) {
                return TIMEOUT;
            }
            if (code == GROUPING.getCode()) {
                return GROUPING;
            }
            return NONE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EventType {
        REGULAR(0),
        DEREG(1);

        private final int code;

        private EventType(int _code) {
            this.code = _code;
        }

        public final int getCode() {
            return this.code;
        }
    }
}

