/*
 * Decompiled with CFR 0.152.
 */
package com.crystalreports.reportformulacomponent.formulafunctions.formatting;

import com.crystaldecisions.reports.common.value.ColourValue;
import com.crystaldecisions.reports.common.value.FormulaValue;
import com.crystaldecisions.reports.common.value.FormulaValueType;
import com.crystaldecisions.reports.common.value.NumberValue;
import com.crystaldecisions.reports.formulas.FormulaEnvironment;
import com.crystaldecisions.reports.formulas.FormulaFunctionArgumentDefinition;
import com.crystaldecisions.reports.formulas.FormulaFunctionBase;
import com.crystaldecisions.reports.formulas.FormulaFunctionCallException;
import com.crystaldecisions.reports.formulas.FormulaFunctionDefinition;
import com.crystaldecisions.reports.formulas.FormulaInfo;
import com.crystaldecisions.reports.formulas.FormulaValueReference;
import com.crystaldecisions.reports.formulas.FormulaValueTypeReference;
import com.crystaldecisions.reports.formulas.functions.CommonArguments;
import com.crystaldecisions.reports.formulas.functions.FormulaFunctionFactory;
import com.crystaldecisions.reports.formulas.functions.NumberConstantFunction;
import java.awt.Color;

public class ColourFunctionFactory
implements FormulaFunctionFactory {
    private static FormulaFunctionFactory iG = new ColourFunctionFactory();
    private static final NumberConstantFunction[] iH = new NumberConstantFunction[]{new NumberConstantFunction("crBlack", "crblack", 0.0), new NumberConstantFunction("crMaroon", "crmaroon", 128.0), new NumberConstantFunction("crGreen", "crgreen", 32768.0), new NumberConstantFunction("crOlive", "crolive", 32896.0), new NumberConstantFunction("crNavy", "crnavy", 8388608.0), new NumberConstantFunction("crPurple", "crpurple", 8388736.0), new NumberConstantFunction("crTeal", "crteal", 8421376.0), new NumberConstantFunction("crGray", "crgray", 8421504.0), new NumberConstantFunction("crSilver", "crsilver", 1.2632256E7), new NumberConstantFunction("crRed", "crred", 255.0), new NumberConstantFunction("crLime", "crlime", 65280.0), new NumberConstantFunction("crYellow", "cryellow", 65535.0), new NumberConstantFunction("crBlue", "crblue", 1.671168E7), new NumberConstantFunction("crFuchsia", "crfuchsia", 1.6711935E7), new NumberConstantFunction("crAqua", "craqua", 1.677696E7), new NumberConstantFunction("crWhite", "crwhite", 1.6777215E7), new NumberConstantFunction("crNoColor", "crnocolor", -1.0)};
    private static final NumberConstantFunction[] iE = new NumberConstantFunction[]{new NumberConstantFunction("Black", "black", 0.0, true, FormulaInfo.Syntax.crystalSyntax), new NumberConstantFunction("Maroon", "maroon", 128.0, true, FormulaInfo.Syntax.crystalSyntax), new NumberConstantFunction("Green", "green", 32768.0, true, FormulaInfo.Syntax.crystalSyntax), new NumberConstantFunction("Olive", "olive", 32896.0, true, FormulaInfo.Syntax.crystalSyntax), new NumberConstantFunction("Navy", "navy", 8388608.0, true, FormulaInfo.Syntax.crystalSyntax), new NumberConstantFunction("Purple", "purple", 8388736.0, true, FormulaInfo.Syntax.crystalSyntax), new NumberConstantFunction("Teal", "teal", 8421376.0, true, FormulaInfo.Syntax.crystalSyntax), new NumberConstantFunction("Gray", "gray", 8421504.0, true, FormulaInfo.Syntax.crystalSyntax), new NumberConstantFunction("Silver", "silver", 1.2632256E7, true, FormulaInfo.Syntax.crystalSyntax), new NumberConstantFunction("Red", "red", 255.0, true, FormulaInfo.Syntax.crystalSyntax), new NumberConstantFunction("Lime", "lime", 65280.0, true, FormulaInfo.Syntax.crystalSyntax), new NumberConstantFunction("Yellow", "yellow", 65535.0, true, FormulaInfo.Syntax.crystalSyntax), new NumberConstantFunction("Blue", "blue", 1.671168E7, true, FormulaInfo.Syntax.crystalSyntax), new NumberConstantFunction("Fuchsia", "fuchsia", 1.6711935E7, true, FormulaInfo.Syntax.crystalSyntax), new NumberConstantFunction("Aqua", "aqua", 1.677696E7, true, FormulaInfo.Syntax.crystalSyntax), new NumberConstantFunction("White", "white", 1.6777215E7, true, FormulaInfo.Syntax.crystalSyntax), new NumberConstantFunction("NoColor", "nocolor", -1.0, true, FormulaInfo.Syntax.crystalSyntax)};
    private static final a[] iF = new a[]{new a("Color", "color", FormulaInfo.Syntax.crystalSyntax), new a("RGB", "rgb", FormulaInfo.Syntax.basicSyntax)};

    private ColourFunctionFactory() {
    }

    public static String makeFormulaTextForColour(ColourValue colourValue, FormulaInfo.Syntax syntax) {
        String string = ColourFunctionFactory.getCrColourFunctionName(colourValue);
        if (string != null) {
            return string;
        }
        string = ColourFunctionFactory.a(syntax);
        Color color = colourValue.getColor();
        return string + "(" + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue() + ")";
    }

    public static String getCrColourFunctionName(ColourValue colourValue) {
        for (int i2 = 0; i2 < iH.length; ++i2) {
            if (iH[i2].for() != (double)ColourValue.getColorRef((ColourValue)colourValue)) continue;
            return iH[i2].getName();
        }
        return null;
    }

    public static ColourValue getValueFromIdentifier(String string) {
        for (int i2 = 0; i2 < iH.length; ++i2) {
            if (!iH[i2].getIdentifier().equals(string)) continue;
            return ColourValue.fromColorRef((int)((int)iH[i2].for()));
        }
        return null;
    }

    private static String a(FormulaInfo.Syntax syntax) {
        for (int i2 = 0; i2 < iF.length; ++i2) {
            if (iF[i2].getSyntax() != null && iF[i2].getSyntax() != syntax || iF[i2].isHidden(syntax)) continue;
            return iF[i2].getName();
        }
        throw new IllegalArgumentException();
    }

    public static FormulaFunctionFactory getInstance() {
        return iG;
    }

    public int getNFunctionInstances() {
        return iF.length + iH.length + iE.length;
    }

    public FormulaFunctionDefinition getFunctionInstance(int n2) {
        if (n2 >= 0 && n2 < iF.length) {
            return iF[n2];
        }
        if (n2 < iF.length + iH.length) {
            return iH[n2 - iF.length];
        }
        if (n2 < this.getNFunctionInstances()) {
            return iE[n2 - (iF.length + iH.length)];
        }
        throw new IndexOutOfBoundsException();
    }

    private static class a
    extends FormulaFunctionBase {
        private static final FormulaFunctionArgumentDefinition ai = new CommonArguments("red", FormulaValueTypeReference.numberValue);
        private static final FormulaFunctionArgumentDefinition ak = new CommonArguments("green", FormulaValueTypeReference.numberValue);
        private static final FormulaFunctionArgumentDefinition aj = new CommonArguments("blue", FormulaValueTypeReference.numberValue);
        private static FormulaFunctionArgumentDefinition[] al = new FormulaFunctionArgumentDefinition[]{ai, ak, aj};

        public a(String string, String string2, FormulaInfo.Syntax syntax) {
            super(string, string2, al, false, syntax);
        }

        public FormulaValueType validate(FormulaValueReference[] formulaValueReferenceArray, FormulaEnvironment formulaEnvironment) throws FormulaFunctionCallException {
            return FormulaValueType.number;
        }

        public FormulaValue evaluate(FormulaValueReference[] formulaValueReferenceArray, FormulaEnvironment formulaEnvironment) throws FormulaFunctionCallException {
            NumberValue numberValue = (NumberValue)formulaValueReferenceArray[0].getFormulaValue();
            NumberValue numberValue2 = (NumberValue)formulaValueReferenceArray[1].getFormulaValue();
            NumberValue numberValue3 = (NumberValue)formulaValueReferenceArray[2].getFormulaValue();
            return NumberValue.fromDouble((double)ColourValue.getColorRefFromRGB((int)numberValue.getInt(), (int)numberValue2.getInt(), (int)numberValue3.getInt()));
        }
    }
}

