/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions12.reports.reportdefinition.formulafunctions.formatting;

import com.crystaldecisions12.reports.common.value.ColourValue;
import com.crystaldecisions12.reports.common.value.FormulaValue;
import com.crystaldecisions12.reports.common.value.FormulaValueType;
import com.crystaldecisions12.reports.common.value.NumberValue;
import com.crystaldecisions12.reports.formulas.FormulaEnvironment;
import com.crystaldecisions12.reports.formulas.FormulaFunctionArgumentDefinition;
import com.crystaldecisions12.reports.formulas.FormulaFunctionBase;
import com.crystaldecisions12.reports.formulas.FormulaFunctionCallException;
import com.crystaldecisions12.reports.formulas.FormulaFunctionDefinition;
import com.crystaldecisions12.reports.formulas.FormulaInfo;
import com.crystaldecisions12.reports.formulas.FormulaValueReference;
import com.crystaldecisions12.reports.formulas.FormulaValueTypeReference;
import com.crystaldecisions12.reports.formulas.functions.CommonArguments;
import com.crystaldecisions12.reports.formulas.functions.FormulaFunctionFactory;
import com.crystaldecisions12.reports.formulas.functions.NumberConstantFunction;
import java.awt.Color;

public class ColourFunctionFactory
implements FormulaFunctionFactory {
    private static FormulaFunctionFactory hs = new ColourFunctionFactory();
    private static final NumberConstantFunction[] ht = new NumberConstantFunction[]{new NumberConstantFunction("crBlack", "crblack", 0.0), new NumberConstantFunction("crMaroon", "crmaroon", 128.0), new NumberConstantFunction("crGreen", "crgreen", 32768.0), new NumberConstantFunction("crOlive", "crolive", 32896.0), new NumberConstantFunction("crNavy", "crnavy", 8388608.0), new NumberConstantFunction("crPurple", "crpurple", 8388736.0), new NumberConstantFunction("crTeal", "crteal", 8421376.0), new NumberConstantFunction("crGray", "crgray", 8421504.0), new NumberConstantFunction("crSilver", "crsilver", 1.2632256E7), new NumberConstantFunction("crRed", "crred", 255.0), new NumberConstantFunction("crLime", "crlime", 65280.0), new NumberConstantFunction("crYellow", "cryellow", 65535.0), new NumberConstantFunction("crBlue", "crblue", 1.671168E7), new NumberConstantFunction("crFuchsia", "crfuchsia", 1.6711935E7), new NumberConstantFunction("crAqua", "craqua", 1.677696E7), new NumberConstantFunction("crWhite", "crwhite", 1.6777215E7), new NumberConstantFunction("crNoColor", "crnocolor", -1.0)};
    private static final NumberConstantFunction[] hq = new NumberConstantFunction[]{new NumberConstantFunction("Black", "black", 0.0, true, FormulaInfo.Syntax.crystalSyntax), new NumberConstantFunction("Maroon", "maroon", 128.0, true, FormulaInfo.Syntax.crystalSyntax), new NumberConstantFunction("Green", "green", 32768.0, true, FormulaInfo.Syntax.crystalSyntax), new NumberConstantFunction("Olive", "olive", 32896.0, true, FormulaInfo.Syntax.crystalSyntax), new NumberConstantFunction("Navy", "navy", 8388608.0, true, FormulaInfo.Syntax.crystalSyntax), new NumberConstantFunction("Purple", "purple", 8388736.0, true, FormulaInfo.Syntax.crystalSyntax), new NumberConstantFunction("Teal", "teal", 8421376.0, true, FormulaInfo.Syntax.crystalSyntax), new NumberConstantFunction("Gray", "gray", 8421504.0, true, FormulaInfo.Syntax.crystalSyntax), new NumberConstantFunction("Silver", "silver", 1.2632256E7, true, FormulaInfo.Syntax.crystalSyntax), new NumberConstantFunction("Red", "red", 255.0, true, FormulaInfo.Syntax.crystalSyntax), new NumberConstantFunction("Lime", "lime", 65280.0, true, FormulaInfo.Syntax.crystalSyntax), new NumberConstantFunction("Yellow", "yellow", 65535.0, true, FormulaInfo.Syntax.crystalSyntax), new NumberConstantFunction("Blue", "blue", 1.671168E7, true, FormulaInfo.Syntax.crystalSyntax), new NumberConstantFunction("Fuchsia", "fuchsia", 1.6711935E7, true, FormulaInfo.Syntax.crystalSyntax), new NumberConstantFunction("Aqua", "aqua", 1.677696E7, true, FormulaInfo.Syntax.crystalSyntax), new NumberConstantFunction("White", "white", 1.6777215E7, true, FormulaInfo.Syntax.crystalSyntax), new NumberConstantFunction("NoColor", "nocolor", -1.0, true, FormulaInfo.Syntax.crystalSyntax)};
    private static final a[] hr = new a[]{new a("Color", "color", FormulaInfo.Syntax.crystalSyntax), new a("RGB", "rgb", FormulaInfo.Syntax.basicSyntax)};

    private ColourFunctionFactory() {
    }

    public static String makeFormulaTextForColour(ColourValue colourValue, FormulaInfo.Syntax syntax) {
        String string = ColourFunctionFactory.a(colourValue);
        if (string != null) {
            return string;
        }
        string = ColourFunctionFactory.a(syntax);
        Color color = colourValue.getColor();
        return string + "(" + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue() + ")";
    }

    private static String a(ColourValue colourValue) {
        for (int i2 = 0; i2 < ht.length; ++i2) {
            if (ht[i2].do() != (double)ColourValue.getColorRef(colourValue)) continue;
            return ht[i2].getName();
        }
        return null;
    }

    private static String a(FormulaInfo.Syntax syntax) {
        for (int i2 = 0; i2 < hr.length; ++i2) {
            if (hr[i2].getSyntax() != null && hr[i2].getSyntax() != syntax || hr[i2].isHidden(syntax)) continue;
            return hr[i2].getName();
        }
        throw new IllegalArgumentException();
    }

    public static FormulaFunctionFactory getInstance() {
        return hs;
    }

    public int getNFunctionInstances() {
        return hr.length + ht.length + hq.length;
    }

    public FormulaFunctionDefinition getFunctionInstance(int n2) {
        if (n2 >= 0 && n2 < hr.length) {
            return hr[n2];
        }
        if (n2 < hr.length + ht.length) {
            return ht[n2 - hr.length];
        }
        if (n2 < this.getNFunctionInstances()) {
            return hq[n2 - (hr.length + ht.length)];
        }
        throw new IndexOutOfBoundsException();
    }

    private static class a
    extends FormulaFunctionBase {
        private static final FormulaFunctionArgumentDefinition aq = new CommonArguments("red", FormulaValueTypeReference.numberValue);
        private static final FormulaFunctionArgumentDefinition as = new CommonArguments("green", FormulaValueTypeReference.numberValue);
        private static final FormulaFunctionArgumentDefinition ar = new CommonArguments("blue", FormulaValueTypeReference.numberValue);
        private static FormulaFunctionArgumentDefinition[] at = new FormulaFunctionArgumentDefinition[]{aq, as, ar};

        public a(String string, String string2, FormulaInfo.Syntax syntax) {
            super(string, string2, at, false, syntax);
        }

        public FormulaValueType validate(FormulaValueReference[] formulaValueReferenceArray, FormulaEnvironment formulaEnvironment) throws FormulaFunctionCallException {
            return FormulaValueType.number;
        }

        public FormulaValue evaluate(FormulaValueReference[] formulaValueReferenceArray, FormulaEnvironment formulaEnvironment) throws FormulaFunctionCallException {
            NumberValue numberValue = (NumberValue)formulaValueReferenceArray[0].getFormulaValue();
            NumberValue numberValue2 = (NumberValue)formulaValueReferenceArray[1].getFormulaValue();
            NumberValue numberValue3 = (NumberValue)formulaValueReferenceArray[2].getFormulaValue();
            return NumberValue.fromDouble(ColourValue.getColorRefFromRGB(numberValue.getInt(), numberValue2.getInt(), numberValue3.getInt()));
        }
    }
}

