/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions12.reports.formulas.functions.financial;

import com.crystaldecisions12.reports.common.asserts.CrystalAssert;
import com.crystaldecisions12.reports.common.value.CurrencyValue;
import com.crystaldecisions12.reports.common.value.DateTimeValue;
import com.crystaldecisions12.reports.common.value.DateValue;
import com.crystaldecisions12.reports.common.value.FormulaValue;
import com.crystaldecisions12.reports.common.value.FormulaValueType;
import com.crystaldecisions12.reports.common.value.NumberValue;
import com.crystaldecisions12.reports.formulas.FormulaEnvironment;
import com.crystaldecisions12.reports.formulas.FormulaFunctionArgumentDefinition;
import com.crystaldecisions12.reports.formulas.FormulaFunctionArgumentException;
import com.crystaldecisions12.reports.formulas.FormulaFunctionBase;
import com.crystaldecisions12.reports.formulas.FormulaFunctionCallException;
import com.crystaldecisions12.reports.formulas.FormulaFunctionDefinition;
import com.crystaldecisions12.reports.formulas.FormulaResources;
import com.crystaldecisions12.reports.formulas.FormulaValueReference;
import com.crystaldecisions12.reports.formulas.functions.CommonArguments;
import com.crystaldecisions12.reports.formulas.functions.FormulaFunctionFactory;
import com.crystaldecisions12.reports.formulas.functions.financial.ae;
import com.crystaldecisions12.reports.formulas.functions.financial.an;

class aq
implements FormulaFunctionFactory {
    private static aq gs = new aq();
    private static final FormulaFunctionArgumentDefinition[][] gt = new FormulaFunctionArgumentDefinition[][]{{CommonArguments.issueDate, CommonArguments.firstInterestDate, CommonArguments.settlementDate, CommonArguments.rate, CommonArguments.parValue, CommonArguments.frequency}, {CommonArguments.issueDate, CommonArguments.firstInterestDate, CommonArguments.settlementDate, CommonArguments.rate, CommonArguments.parValue, CommonArguments.frequency, CommonArguments.basis}};
    private static FormulaFunctionDefinition[] gu = new FormulaFunctionDefinition[]{new a(gt[0]), new a(gt[1])};

    private aq() {
    }

    public static aq bf() {
        return gs;
    }

    public FormulaFunctionDefinition getFunctionInstance(int n2) {
        return gu[n2];
    }

    public int getNFunctionInstances() {
        return gu.length;
    }

    private static class a
    extends FormulaFunctionBase {
        public a(FormulaFunctionArgumentDefinition[] formulaFunctionArgumentDefinitionArray) {
            super("ACCRINT", "accrint", formulaFunctionArgumentDefinitionArray);
        }

        public FormulaValueType validate(FormulaValueReference[] formulaValueReferenceArray, FormulaEnvironment formulaEnvironment) throws FormulaFunctionCallException {
            int n2;
            int n3;
            double d10;
            double d11;
            if (formulaValueReferenceArray[0].getFormulaValue() != null && formulaValueReferenceArray[2].getFormulaValue() != null) {
                DateValue dateValue = ((DateTimeValue)formulaValueReferenceArray[0].getFormulaValue()).getDateValue();
                DateValue dateValue2 = ((DateTimeValue)formulaValueReferenceArray[2].getFormulaValue()).getDateValue();
                if (dateValue.getCRDate() >= dateValue2.getCRDate()) {
                    String[] stringArray = new String[]{"issueDate", "interestDate"};
                    throw new FormulaFunctionArgumentException(FormulaResources.a(), "BadOrder", stringArray, 0);
                }
            }
            if (formulaValueReferenceArray[3].getFormulaValue() != null && (d11 = ((NumberValue)formulaValueReferenceArray[3].getFormulaValue()).getDouble()) <= 0.0) {
                throw new FormulaFunctionArgumentException(FormulaResources.a(), "ArgumentOutOfRange", 3);
            }
            if (formulaValueReferenceArray[4].getFormulaValue() != null && (d10 = ((NumberValue)formulaValueReferenceArray[4].getFormulaValue()).getDouble()) <= 0.0) {
                throw new FormulaFunctionArgumentException(FormulaResources.a(), "ArgumentOutOfRange", 4);
            }
            if (formulaValueReferenceArray[5].getFormulaValue() != null && (n3 = ((NumberValue)formulaValueReferenceArray[5].getFormulaValue()).getInt()) != 1 && n3 != 2 && n3 != 4) {
                throw new FormulaFunctionArgumentException(FormulaResources.a(), "ArgumentOutOfRange", 5);
            }
            if (formulaValueReferenceArray.length == 7 && formulaValueReferenceArray[6].getFormulaValue() != null && ((n2 = ((NumberValue)formulaValueReferenceArray[6].getFormulaValue()).getInt()) < 0 || n2 > 4)) {
                throw new FormulaFunctionArgumentException(FormulaResources.a(), "ArgumentOutOfRange", 6);
            }
            return FormulaValueType.currency;
        }

        public FormulaValue evaluate(FormulaValueReference[] formulaValueReferenceArray, FormulaEnvironment formulaEnvironment) throws FormulaFunctionCallException {
            double d10;
            int n2;
            this.validate(formulaValueReferenceArray, formulaEnvironment);
            DateValue dateValue = ((DateTimeValue)formulaValueReferenceArray[0].getFormulaValue()).getDateValue();
            DateValue dateValue2 = ((DateTimeValue)formulaValueReferenceArray[1].getFormulaValue()).getDateValue();
            DateValue dateValue3 = ((DateTimeValue)formulaValueReferenceArray[2].getFormulaValue()).getDateValue();
            double d11 = ((NumberValue)formulaValueReferenceArray[3].getFormulaValue()).getDouble();
            double d12 = ((NumberValue)formulaValueReferenceArray[4].getFormulaValue()).getScaledDouble();
            int n3 = ((NumberValue)formulaValueReferenceArray[5].getFormulaValue()).getInt();
            an an2 = an.do;
            if (formulaValueReferenceArray.length == 7) {
                n2 = ((NumberValue)formulaValueReferenceArray[6].getFormulaValue()).getInt();
                an2 = an.a(n2);
            }
            boolean bl2 = true;
            boolean bl3 = false;
            double[] dArray = ae.a(dateValue, dateValue2, n3, an2, bl2);
            double d13 = dArray[0];
            n2 = (int)dArray[1];
            dArray = ae.a(dateValue3, dateValue2, n3, an2, bl3);
            double d14 = dArray[0];
            int n4 = (int)dArray[1];
            CrystalAssert.a(n2 >= n4);
            if (n2 == n4 && an2 != an.a) {
                double[] dArray2 = ae.a(dateValue, dateValue3, an2);
                int n5 = (int)dArray2[0];
                double d15 = dArray2[1];
                d10 = (double)n5 / d15 * (double)n3;
            } else {
                d10 = d13 + d14 + (double)n2 - (double)n4 - 1.0;
            }
            double d16 = d12 * d11 / (double)n3 * d10;
            return CurrencyValue.fromScaledDouble(d16);
        }
    }
}

