/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.report.definition.visualization;

import com.businessobjects.visualization.graphic.Region;
import com.businessobjects.visualization.graphic.VisuBool;
import com.businessobjects.visualization.graphic.VisuColor;
import com.businessobjects.visualization.graphic.VisuColorType;
import com.businessobjects.visualization.graphic.VisuDouble;
import com.businessobjects.visualization.graphic.VisuFont;
import com.businessobjects.visualization.graphic.VisuInteger;
import com.businessobjects.visualization.graphic.VisuObject;
import com.businessobjects.visualization.graphic.VisuObjectType;
import com.businessobjects.visualization.graphic.VisuRGBA;
import com.businessobjects.visualization.graphic.VisuState;
import com.businessobjects.visualization.graphic.VisuString;
import com.crystaldecisions.sdk.occa.report.definition.Font;
import com.crystaldecisions.sdk.occa.report.definition.FontColor;
import com.crystaldecisions.sdk.occa.report.definition.IFont;
import com.crystaldecisions.sdk.occa.report.definition.visualization.GraphicInstance;
import com.crystaldecisions.sdk.occa.report.definition.visualization.graphic.PropertyDef;
import java.awt.Color;

public class CVOMUtils {
    public static PropertyDef.PropertyValueType toPropertyValueType(VisuObjectType visuObjectType) {
        switch (visuObjectType.value()) {
            case 0: {
                return PropertyDef.PropertyValueType.BOOL;
            }
            case 5: {
                return PropertyDef.PropertyValueType.FILL;
            }
            case 2: {
                return PropertyDef.PropertyValueType.DOUBLE;
            }
            case 4: {
                return PropertyDef.PropertyValueType.FONTCOLOR;
            }
            case 7: {
                return PropertyDef.PropertyValueType.FORMULA;
            }
            case 10: {
                return PropertyDef.PropertyValueType.GRADIENT;
            }
            case 1: {
                return PropertyDef.PropertyValueType.INTEGER;
            }
            case 9: {
                return PropertyDef.PropertyValueType.COLOR;
            }
            case 6: {
                return PropertyDef.PropertyValueType.STATE;
            }
            case 3: {
                return PropertyDef.PropertyValueType.STRING;
            }
            case 8: {
                return PropertyDef.PropertyValueType.TEXTURE;
            }
        }
        return null;
    }

    public static VisuObject toVisuObject(PropertyDef.PropertyValueType propertyValueType, Object object) {
        switch (propertyValueType) {
            case BOOL: {
                return VisuBool.getVisuBool((boolean)((Boolean)object));
            }
            case FILL: {
                return CVOMUtils.a(object);
            }
            case DOUBLE: {
                return new VisuDouble((Double)object);
            }
            case FONTCOLOR: {
                return CVOMUtils.a((FontColor)object);
            }
            case INTEGER: {
                return new VisuInteger((Integer)object);
            }
            case COLOR: {
                return CVOMUtils.a((Color)object);
            }
            case STATE: {
                return CVOMUtils.a((String)object);
            }
            case STRING: {
                return new VisuString((String)object);
            }
        }
        return null;
    }

    public static Object fromVisuObject(VisuObject visuObject) {
        if (visuObject == null) {
            return null;
        }
        switch (visuObject.getType().value()) {
            case 0: {
                return ((VisuBool)visuObject).booleanValue();
            }
            case 5: {
                return CVOMUtils.a((VisuColor)visuObject);
            }
            case 2: {
                return ((VisuDouble)visuObject).doubleValue();
            }
            case 4: {
                return CVOMUtils.a((VisuFont)visuObject);
            }
            case 1: {
                return ((VisuInteger)visuObject).intValue();
            }
            case 9: {
                return CVOMUtils.a((VisuRGBA)visuObject);
            }
            case 6: {
                return CVOMUtils.a((VisuState)visuObject);
            }
            case 3: {
                return ((VisuString)visuObject).toString();
            }
        }
        return null;
    }

    private static String a(VisuState visuState) {
        return visuState.getId();
    }

    private static Color a(VisuRGBA visuRGBA) {
        return new Color(visuRGBA.getRed(), visuRGBA.getGreen(), visuRGBA.getBlue(), 255 - visuRGBA.getAlpha());
    }

    private static FontColor a(VisuFont visuFont) {
        Color color = CVOMUtils.a(visuFont.getFontColor());
        int n2 = visuFont.getStyle().intValue();
        Font font = new Font();
        font.setBold((n2 & 1) == 1);
        font.setItalic((n2 & 2) == 2);
        font.setStrikethrough((n2 & 8) == 8);
        font.setUnderline((n2 & 4) == 4);
        font.setName(visuFont.getName().toString());
        font.setSize((float)visuFont.getHeight().doubleValue());
        FontColor fontColor = new FontColor();
        fontColor.setIFont(font);
        fontColor.setColor(color);
        return fontColor;
    }

    private static Color a(VisuColor visuColor) {
        if (visuColor.getColorType().equals(VisuColorType.RGBA)) {
            return CVOMUtils.a((VisuRGBA)visuColor.getValue());
        }
        return null;
    }

    private static VisuObject a(String string) {
        return new VisuState(string);
    }

    private static VisuColor a(Object object) {
        if (object instanceof Color) {
            Color color = (Color)object;
            return new VisuColor(color.getRed(), color.getGreen(), color.getBlue(), 255 - color.getAlpha());
        }
        return null;
    }

    private static VisuRGBA a(Color color) {
        return new VisuRGBA(color.getRed(), color.getGreen(), color.getBlue(), 255 - color.getAlpha());
    }

    private static VisuFont a(FontColor fontColor) {
        boolean bl2;
        int n2 = 0;
        IFont iFont = fontColor.getIFont();
        int n3 = iFont.getFontStyle().value();
        boolean bl3 = n3 == 1 || n3 == 3;
        boolean bl4 = bl2 = n3 == 2 || n3 == 3;
        if (bl3) {
            n2 |= 1;
        }
        if (bl2) {
            n2 |= 2;
        }
        if (iFont.getUnderline()) {
            n2 |= 4;
        }
        if (iFont.getStrikethrough()) {
            n2 |= 8;
        }
        Color color = fontColor.getColor();
        return new VisuFont(iFont.getName(), (double)iFont.getSize(), n2, CVOMUtils.a(color));
    }

    public static void setPropertyValue(GraphicInstance graphicInstance, String string, String string2, Object object) {
        com.businessobjects.visualization.GraphicInstance graphicInstance2 = graphicInstance.getInternalCVOMObject();
        if (graphicInstance2.getGraphic().hasRegion(string) && ((Region)graphicInstance2.getRegion(string)).hasProperty(string2)) {
            graphicInstance.getGraphic().setPropertyValue(string, string2, object);
        }
    }
}

