/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.report.definition;

import com.crystaldecisions.client.helper.CloneUtil;
import com.crystaldecisions.client.helper.XMLSerializationHelper;
import com.crystaldecisions.sdk.occa.report.definition.GraphicObject;
import com.crystaldecisions.sdk.occa.report.definition.IConditionFormula;
import com.crystaldecisions.sdk.occa.report.definition.IPictureObject;
import com.crystaldecisions.sdk.occa.report.definition.PictureFormatConditionFormulaType;
import com.crystaldecisions.sdk.occa.report.definition.PictureType;
import com.crystaldecisions.sdk.occa.report.lib.ByteArray;
import com.crystaldecisions.sdk.occa.report.lib.IByteArray;
import com.crystaldecisions.sdk.occa.report.lib.IChange;
import com.crystaldecisions.sdk.occa.report.lib.IEROMControllerInterface;
import com.crystaldecisions.sdk.occa.report.lib.IMemberVisitor;
import com.crystaldecisions.sdk.occa.report.lib.IRepositoryObjectInternal;
import com.crystaldecisions.sdk.occa.report.lib.ReportObjectKind;
import com.crystaldecisions.xml.serialization.ClassFactory;
import com.crystaldecisions.xml.serialization.IXMLSerializable;
import com.crystaldecisions.xml.serialization.XMLConverter;
import com.crystaldecisions.xml.serialization.XMLSerializationContext;
import com.crystaldecisions.xml.serialization.XMLWriter;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.xml.sax.Attributes;

public class PictureObject
extends GraphicObject
implements IPictureObject,
IRepositoryObjectInternal,
IXMLSerializable {
    private PictureType aU = PictureType.unknown;
    private IByteArray aX = null;
    private String aW = null;
    private IConditionFormula aV = null;
    private static final String aZ = "PictureType";
    private static final String aS = "PictureData";
    private static final String aT = "GraphicLocation";
    private static final String aY = "GraphicLocationFormula";

    public PictureObject(IPictureObject iPictureObject) {
        iPictureObject.copyTo(this, true);
    }

    public PictureObject() {
        this.setKind(ReportObjectKind.picture);
    }

    public Object clone(boolean bl2) {
        PictureObject pictureObject = new PictureObject();
        this.copyTo(pictureObject, bl2);
        return pictureObject;
    }

    public void copyTo(Object object, boolean bl2) {
        Object object2;
        super.copyTo(object, bl2);
        if (!(object instanceof IPictureObject)) {
            throw new ClassCastException();
        }
        PictureObject pictureObject = (PictureObject)object;
        if (this.aX != null && bl2) {
            object2 = new ByteArray(this.aX.getBytes());
            pictureObject.setPictureData((IByteArray)object2);
        } else {
            pictureObject.setPictureData(this.aX);
        }
        if (this.aV != null && bl2) {
            if (CloneUtil.canCopyTo(this.aV, pictureObject.getGraphicLocationFormula())) {
                this.aV.copyTo(pictureObject.getGraphicLocationFormula(), bl2);
            } else {
                object2 = (IConditionFormula)this.aV.clone(true);
                pictureObject.setGraphicLocationFormula((IConditionFormula)object2);
            }
        } else {
            pictureObject.setGraphicLocationFormula(this.aV);
        }
        pictureObject.setPictureType(this.aU);
        if (object instanceof PictureObject) {
            this.aW = ((PictureObject)object).getGraphicLocation();
        }
    }

    public Object createMember(String string, Attributes attributes, XMLSerializationContext xMLSerializationContext, Map map, boolean[] blArray) {
        Object object = null;
        if (string.equals(aS)) {
            object = ClassFactory.createObject(attributes, xMLSerializationContext, blArray);
            if (object != null) {
                this.aX = (IByteArray)object;
            }
        } else if (string.equals(aY)) {
            object = ClassFactory.createObject(attributes, xMLSerializationContext, blArray);
            if (object != null && object instanceof IConditionFormula) {
                this.setGraphicLocationFormula((IConditionFormula)object);
            }
        } else {
            return super.createMember(string, attributes, xMLSerializationContext, map, blArray);
        }
        return object;
    }

    public void endElement(String string, Map map) {
    }

    public PictureType getPictureType() {
        return this.aU;
    }

    public IByteArray getPictureData() {
        return this.aX;
    }

    public boolean hasContent(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof PictureObject)) {
            return false;
        }
        PictureObject pictureObject = (PictureObject)object;
        if (!super.hasContent(pictureObject)) {
            return false;
        }
        if (!this.aU.equals(pictureObject.getPictureType())) {
            return false;
        }
        if (this.aX != null ? !((ByteArray)this.aX).hasContent(pictureObject.getPictureData()) : pictureObject.getPictureData() != null) {
            return false;
        }
        if (pictureObject instanceof PictureObject && !CloneUtil.equalStrings(this.aW, pictureObject.getGraphicLocation())) {
            return false;
        }
        if (this.aV != null & pictureObject.getGraphicLocationFormula() != null) {
            if (!CloneUtil.equalStrings(this.aV.getText(), pictureObject.getGraphicLocationFormula().getText())) {
                return false;
            }
            if (this.aV.getSyntax() != pictureObject.getGraphicLocationFormula().getSyntax()) {
                return false;
            }
            if (this.aV.getFormulaNullTreatment() != pictureObject.getGraphicLocationFormula().getFormulaNullTreatment()) {
                return false;
            }
        } else {
            if (this.aV != null && pictureObject.getGraphicLocationFormula() == null) {
                return false;
            }
            if (this.aV == null && pictureObject.getGraphicLocationFormula() != null) {
                return false;
            }
        }
        return true;
    }

    public void readElement(String string, String string2, Attributes attributes, Map map) {
        super.readElement(string, string2, attributes, map);
        if (string.equals(aZ)) {
            this.aU = PictureType.from_string(string2);
        } else if (string.equals(aT)) {
            this.aW = string2;
        }
    }

    public void save(XMLWriter xMLWriter, XMLSerializationContext xMLSerializationContext) throws IOException {
        String string = XMLConverter.getXMLFromClassName(this.getClass().getName());
        Properties properties = XMLSerializationHelper.getHeaderAttributes(string);
        xMLWriter.writeStartElement("CrystalReports.PictureObject", properties);
        this.saveContents(xMLWriter, xMLSerializationContext);
        xMLWriter.writeEndElement("CrystalReports.PictureObject");
    }

    public void save(XMLWriter xMLWriter, String string, XMLSerializationContext xMLSerializationContext) throws IOException {
        xMLWriter.writeStartObjectElement(string, "2", this, xMLSerializationContext);
        this.saveContents(xMLWriter, xMLSerializationContext);
        xMLWriter.writeEndElement(string);
    }

    public void saveContents(XMLWriter xMLWriter, XMLSerializationContext xMLSerializationContext) throws IOException {
        super.saveContents(xMLWriter, xMLSerializationContext);
        xMLWriter.writeEnumElement(aZ, this.aU, null);
        xMLWriter.writeObjectElement((IXMLSerializable)((Object)this.aX), aS, xMLSerializationContext);
        xMLWriter.writeTextElement(aT, this.aW, null);
        xMLWriter.writeObjectElement((IXMLSerializable)((Object)this.aV), aY, xMLSerializationContext);
    }

    public void setPictureType(final PictureType pictureType) {
        this.case.makeChange(new IChange(){

            public void run() {
                if (pictureType == null) {
                    PictureObject.this.aU = PictureType.unknown;
                } else {
                    PictureObject.this.aU = pictureType;
                }
            }
        });
    }

    public void setPictureData(final IByteArray iByteArray) {
        this.case.makeChange(new IChange(){

            public void run() {
                PictureObject.this.aX = iByteArray;
            }
        });
    }

    public void startElement(String string, Map map, Attributes attributes) {
    }

    public IConditionFormula getGraphicLocationFormula() {
        return this.aV;
    }

    public void setGraphicLocationFormula(final IConditionFormula iConditionFormula) {
        this.case.makeChange(new IChange(){

            public void run() {
                PictureObject.this.aV = iConditionFormula;
                if (PictureObject.this.aV != null) {
                    PictureObject.this.aV.setConditionFormulaType(PictureFormatConditionFormulaType.location);
                }
            }
        });
    }

    public String getGraphicLocation() {
        return this.aW;
    }

    public void setGraphicLocation(final String string) {
        this.case.makeChange(new IChange(){

            public void run() {
                PictureObject.this.aW = string;
            }
        });
    }

    public void enumerateMembers(IMemberVisitor iMemberVisitor) {
        super.enumerateMembers(iMemberVisitor);
        this.aV = iMemberVisitor.visit(this.aV, true);
    }

    public boolean isConnected() {
        String string = this.getLinkedURI();
        return string != null && string.length() > 0;
    }

    public void disconnect() {
        this.setLinkedURI(null);
    }

    public void refresh() {
        IEROMControllerInterface iEROMControllerInterface = (IEROMControllerInterface)((Object)this.case.getControllerInterface());
        iEROMControllerInterface.getRepositoryService().refreshRepositoryObject(this);
    }
}

