/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.exporters.excel.formatter.cm;

import com.crystaldecisions.reports.common.logging.ILoggerService;
import com.crystaldecisions.reports.common.value.BooleanValue;
import com.crystaldecisions.reports.common.value.CrystalValue;
import com.crystaldecisions.reports.common.value.DateTimeValue;
import com.crystaldecisions.reports.common.value.DateValue;
import com.crystaldecisions.reports.common.value.NumericValue;
import com.crystaldecisions.reports.common.value.StringValue;
import com.crystaldecisions.reports.common.value.TimeValue;
import com.crystaldecisions.reports.common.value.ValueType;
import com.crystaldecisions.reports.exporters.excel.formatter.Excel97ExportFormatter;
import com.crystaldecisions.reports.exporters.excel.formatter.ExcelFieldObjectFormatter;
import com.crystaldecisions.reports.exporters.excel.formatter.ExcelObjectFormatterBase;
import com.crystaldecisions.reports.exporters.excel.libs.biff.WorksheetLocationNotEmptyException;
import com.crystaldecisions.reports.exporters.excel.libs.biff.sst.BIFFString;
import com.crystaldecisions.reports.exporters.excel.libs.biff.xlsDOM.ExcelCell;
import com.crystaldecisions.reports.formattedcontentmodel.cellmodel.ICMFieldObject;
import com.crystalreports.sdk.enums.AlignmentType;
import java.util.Locale;

public final class ExcelCMFieldObjectFormatter
extends ExcelFieldObjectFormatter {
    public ExcelCMFieldObjectFormatter(Excel97ExportFormatter excel97ExportFormatter, ILoggerService iLoggerService, Locale locale) {
        super(excel97ExportFormatter, iLoggerService, locale);
    }

    public void a(ICMFieldObject iCMFieldObject) throws WorksheetLocationNotEmptyException {
        CrystalValue crystalValue = iCMFieldObject.getRawValue();
        ValueType valueType = crystalValue.getValueType();
        if (!valueType.isScalar()) {
            return;
        }
        this.do();
        boolean bl2 = valueType == ValueType.string || valueType.isMemo();
        boolean bl3 = iCMFieldObject.isInGridObject();
        this.a(this.if, iCMFieldObject.isClipped(), iCMFieldObject.getRotation(), iCMFieldObject.getAdornments(), iCMFieldObject.getBackgroundColour(), iCMFieldObject.canGrow(), iCMFieldObject.isCloseBorder(), new ExcelObjectFormatterBase.CloseBorderInfo(iCMFieldObject.isCloseAtLeft(), iCMFieldObject.isCloseAtRight(), iCMFieldObject.isCloseAtTop(), iCMFieldObject.isCloseAtBottom()), new ExcelObjectFormatterBase.ObjectTypeInfo(ExcelObjectFormatterBase.ObjectTypeInfo.ObjectType.for, bl2, bl3));
        this.a(this.if, iCMFieldObject.getFontInfo());
        this.a(iCMFieldObject.getHorizontalAlignment(), AlignmentType.defaultAligned, null, this.if.m == -90 ? 270 : this.if.m);
        ExcelCell.CellType cellType = ExcelCell.CellType.int;
        if (valueType.isDateOrTime() && ((Excel97ExportFormatter)this.a()).r().c() || iCMFieldObject.testValueDisplay()) {
            cellType = ExcelCell.CellType.for;
            this.for.a(new BIFFString(iCMFieldObject.getStringValue()));
        } else {
            if (valueType.isNumeric()) {
                this.for.a(((NumericValue)crystalValue).getDouble());
            }
            switch (valueType.value()) {
                case 8: {
                    this.for.a(((BooleanValue)crystalValue).getBoolean() ? 1.0 : 0.0);
                    break;
                }
                case 9: {
                    this.for.a(((DateValue)crystalValue).getOleDate());
                    break;
                }
                case 10: {
                    this.for.a(((TimeValue)crystalValue).getOleDate());
                    break;
                }
                case 15: {
                    this.for.a(((DateTimeValue)crystalValue).getOleDate());
                    break;
                }
                case 11: {
                    cellType = ExcelCell.CellType.for;
                    String string = iCMFieldObject.getStringValue();
                    if (string != null && string.length() != 0) {
                        this.for.a(new BIFFString(string));
                        break;
                    }
                    this.for.a(new BIFFString(((StringValue)crystalValue).getString()));
                    break;
                }
            }
            this.if(iCMFieldObject.getFieldFormat(), valueType);
        }
        this.a(cellType, iCMFieldObject.getStartingRowIndex(), iCMFieldObject.getStartingColumnIndex(), iCMFieldObject.getRowSpan(), iCMFieldObject.getColumnSpan(), iCMFieldObject.getHyperlink(), true);
    }
}

