/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.common.archive;

import com.crystaldecisions.reports.common.Base64;
import com.crystaldecisions.reports.common.archive.ArchiveException;
import com.crystaldecisions.reports.common.archive.IGetIdForObject;
import com.crystaldecisions.reports.common.archive.IOutputRecordArchive;
import com.crystaldecisions.reports.common.archive.RecordType;
import com.crystaldecisions.reports.common.asserts.CrystalAssert;
import com.crystaldecisions.reports.common.value.ColourValue;
import com.crystaldecisions.reports.common.value.DateValue;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.XMLOutputter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class XmlOutputRecordArchive
implements IOutputRecordArchive {
    static String a = "elem";
    static String do = "id";
    static String char = "schema";
    Namespace if = null;
    Document byte = null;
    Element int = null;
    static Namespace new = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
    OutputStream try = null;
    int for = 0;
    boolean case = false;

    public XmlOutputRecordArchive(OutputStream outputStream, int n2, String string) {
        this.for = n2;
        this.try = outputStream;
        if (outputStream == null) {
            throw new NullPointerException();
        }
        if (string != null && string.length() > 0) {
            this.int = new Element(string, this.if);
            this.byte = new Document(this.int);
        }
    }

    public XmlOutputRecordArchive(OutputStream outputStream, int n2) {
        this(outputStream, n2, null);
    }

    public void a(boolean bl2) {
        this.case = bl2;
    }

    public boolean a() {
        return this.case;
    }

    public int getDefaultSchema() {
        return this.for;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws ArchiveException {
        try {
            try {
                if (this.byte != null) {
                    XMLOutputter xMLOutputter = new XMLOutputter("  ", true);
                    xMLOutputter.output(this.byte, this.try);
                }
            }
            catch (IOException iOException) {
                throw new ArchiveException("JRC00001621", "", iOException);
            }
        }
        finally {
            this.byte = null;
            try {
                this.try.close();
            }
            catch (IOException iOException) {
                CrystalAssert.ASSERT((boolean)false);
            }
            this.try = null;
        }
    }

    public void startRecord(RecordType recordType, int n2, int n3, int n4) throws ArchiveException {
        String string = recordType.a;
        if (string == null || string.length() == 0) {
            string = a;
        }
        Element element = new Element(string, this.if);
        if (n4 != 0) {
            element.setAttribute(do, Integer.toString(n4), this.if);
        }
        if (this.case || n2 != this.for) {
            element.setAttribute(char, Integer.toString(n2), this.if);
        }
        if (this.int == null) {
            this.byte = new Document(element);
        } else {
            this.int.addContent(element);
        }
        this.int = element;
    }

    public void endRecord() throws ArchiveException {
        Element element;
        this.int = element = this.int.getParent();
    }

    public void startCollection(RecordType recordType, int n2, int n3) throws ArchiveException {
        this.startRecord(recordType, n3, 0, 0);
    }

    public void endCollection() throws ArchiveException {
        this.endRecord();
    }

    void a(String string, Object object) {
        if (string == null || string.length() == 0) {
            string = a;
        }
        Element element = new Element(string, this.if);
        if (object != null) {
            element.setText(object.toString());
        } else {
            element.setAttribute("nil", "true", new);
        }
        this.int.addContent(element);
    }

    public void storeString(String string, String string2) throws ArchiveException {
        this.a(string, string2);
    }

    public void storeInt8s(String string, int n2) throws ArchiveException {
        this.a(string, Integer.toString(n2));
    }

    public void storeInt8u(String string, int n2) throws ArchiveException {
        this.a(string, Integer.toString(n2));
    }

    public void storeInt16s(String string, int n2) throws ArchiveException {
        this.a(string, Integer.toString(n2));
    }

    public void storeInt16u(String string, int n2) throws ArchiveException {
        this.a(string, Integer.toString(n2));
    }

    public void storeInt32(String string, int n2) throws ArchiveException {
        this.a(string, Integer.toString(n2));
    }

    public void storeInt64(String string, long l2) throws ArchiveException {
        this.a(string, Long.toString(l2));
    }

    public void storeDouble(String string, double d10) throws ArchiveException {
        this.a(string, Double.toString(d10));
    }

    public void storeBoolean(String string, boolean bl2) throws ArchiveException {
        this.a(string, bl2 ? "true" : "false");
    }

    public void storeBinary(String string, byte[] byArray) throws ArchiveException {
        if (byArray == null) {
            this.a(string, null);
        } else {
            this.a(string, Base64.a(byArray));
        }
    }

    public void storeEnum(String string, int n2, Map map) throws ArchiveException {
        String string2;
        if (map != null && (string2 = (String)map.get(n2)) != null && string2.length() > 0) {
            this.a(string, string2);
            return;
        }
        this.a(string, Integer.toString(n2));
    }

    public void storeValue(String string, Object object, IGetIdForObject iGetIdForObject) throws ArchiveException {
        if (object == null) {
            this.storeInt16u(string, 0);
        } else if (object instanceof String) {
            this.storeInt16u(string, 8);
            this.storeString(string, (String)object);
        } else if (object instanceof Short) {
            this.storeInt16u(string, 2);
            this.storeInt16s(string, ((Short)object).shortValue());
        } else if (object instanceof Integer) {
            this.storeInt16u(string, 3);
            this.storeInt32(string, (Integer)object);
        } else if (object instanceof Byte) {
            this.storeInt16u(string, 16);
            this.storeInt8s(string, ((Byte)object).byteValue());
        } else if (object instanceof Character) {
            this.storeInt16u(string, 18);
            this.storeInt16u(string, ((Character)object).charValue());
        } else if (object instanceof Long) {
            this.storeInt16u(string, 20);
            this.storeInt64(string, (Long)object);
        } else if (object instanceof Double) {
            this.storeInt16u(string, 5);
            this.storeDouble(string, (Double)object);
        } else if (object instanceof Float) {
            this.storeInt16u(string, 4);
            this.storeDouble(string, ((Float)object).floatValue());
        } else if (object instanceof Boolean) {
            this.storeInt16u(string, 11);
            this.storeBoolean(string, (Boolean)object);
        } else if (object instanceof Date) {
            this.storeInt16u(string, 7);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)object);
            double d10 = DateValue.fromCalendar((Calendar)calendar).getOleDate();
            this.storeDouble(string, d10);
        } else if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            this.storeInt16u(string, 14);
            this.storeInt8u(string, bigDecimal.scale());
            this.storeInt8u(string, bigDecimal.signum() < 0 ? 128 : 0);
            BigInteger bigInteger = bigDecimal.unscaledValue();
            if (bigInteger.signum() < 0) {
                bigInteger = bigInteger.negate();
            }
            if (bigInteger.bitLength() > 96) {
                CrystalAssert.ASSERT((boolean)false);
            }
            CrystalAssert.ASSERT((boolean)false, (String)"BigDecimal not supported.");
            this.storeInt32(string, 0);
            this.storeInt64(string, 0L);
        } else if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            this.storeInt16u(string, 8209);
            this.storeInt32(string, byArray.length);
        } else {
            int n2 = 0;
            if (iGetIdForObject != null) {
                n2 = iGetIdForObject.char(object);
            }
            this.storeInt16u(string, 13);
            this.storeInt32(string, n2);
        }
    }

    public void storeColour(String string, Color color) throws ArchiveException {
        int n2 = ColourValue.getColorRefFromColor((Color)color);
        this.storeInt32(string, n2);
    }

    public void storeInt16Compressed(String string, int n2) throws ArchiveException {
        this.storeInt16u(string, n2);
    }

    public void storeInt32Compressed(String string, int n2) throws ArchiveException {
        this.storeInt32(string, n2);
    }
}

