/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.common;

import com.crystaldecisions.reports.common.filemanagement.ExtendedDataInput;
import com.crystaldecisions.reports.common.filemanagement.ExtendedDataOutput;
import java.io.IOException;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class GroupPath
implements Comparable {
    private static final int[] if = new int[0];
    public static final GroupPath ROOT_GROUP_PATH = new GroupPath(0);
    private final int[] for;
    private int a;

    public GroupPath(int[] nArray) {
        this.for = nArray == null || nArray.length == 0 ? if : GroupPath.a(nArray);
    }

    private static int[] a(int[] nArray) {
        int n2 = nArray.length;
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        return nArray2;
    }

    public GroupPath(int[] nArray, int n2) {
        this(n2);
        if (n2 > 0) {
            System.arraycopy(nArray, 0, this.for, 0, n2);
        }
    }

    public GroupPath(int n2) {
        assert (n2 >= 0);
        this.for = n2 > 0 ? new int[n2] : if;
    }

    public int getGroupLevel() {
        return this.for.length;
    }

    public int getGroupIndex(int n2) {
        return n2 == 0 ? 0 : this.for[n2 - 1];
    }

    public int[] getLevelIndexes() {
        if (this.for.length == 0) {
            return this.for;
        }
        return GroupPath.a(this.for);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Group Path: [");
        for (int i2 = 0; i2 < this.for.length; ++i2) {
            if (i2 != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.for[i2]);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof GroupPath)) {
            return false;
        }
        GroupPath groupPath = (GroupPath)object;
        if (this.for.length != groupPath.for.length) {
            return false;
        }
        for (int i2 = 0; i2 < this.for.length; ++i2) {
            if (this.for[i2] == groupPath.for[i2]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n2 = this.a;
        if (n2 == 0) {
            this.a = n2 = Arrays.hashCode(this.for);
        }
        return n2;
    }

    public int compareTo(Object object) {
        GroupPath groupPath = (GroupPath)object;
        for (int i2 = 0; i2 < this.for.length && i2 < groupPath.for.length; ++i2) {
            if (this.for[i2] == groupPath.for[i2]) continue;
            return this.for[i2] < groupPath.for[i2] ? -1 : 1;
        }
        if (this.for.length != groupPath.for.length) {
            return this.for.length < groupPath.for.length ? -1 : 1;
        }
        return 0;
    }

    public GroupPath getChildGroupPath(int n2) {
        GroupPath groupPath = new GroupPath(this.for.length + 1);
        System.arraycopy(this.for, 0, groupPath.for, 0, this.for.length);
        groupPath.for[this.for.length] = n2;
        return groupPath;
    }

    public GroupPath getParentGroupPath() {
        if (this.for.length == 0) {
            throw new IllegalStateException();
        }
        return this.getLevelGroupPath(this.for.length - 1);
    }

    public GroupPath getNextSiblingGroupPath() {
        if (this.for.length == 0 || this.for[this.for.length - 1] == Integer.MAX_VALUE) {
            throw new IllegalStateException();
        }
        GroupPath groupPath = new GroupPath(this.for);
        int n2 = this.for.length - 1;
        groupPath.for[n2] = groupPath.for[n2] + 1;
        return groupPath;
    }

    public GroupPath getPrevSiblingGroupPath() {
        if (this.for.length == 0 || this.for[this.for.length - 1] == 0) {
            throw new IllegalStateException();
        }
        GroupPath groupPath = new GroupPath(this.for);
        int n2 = this.for.length - 1;
        groupPath.for[n2] = groupPath.for[n2] - 1;
        return groupPath;
    }

    public boolean isOnSameBranch(GroupPath groupPath) {
        if (this.for.length == 0 && groupPath.for.length == 0) {
            return true;
        }
        int n2 = Math.min(this.for.length, groupPath.for.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.for[i2] == groupPath.for[i2]) continue;
            return false;
        }
        return true;
    }

    public boolean isAncestorOf(GroupPath groupPath) {
        if (groupPath == null) {
            return false;
        }
        int[] nArray = groupPath.for;
        if (this.for.length >= nArray.length) {
            return false;
        }
        for (int i2 = 0; i2 < this.for.length; ++i2) {
            if (this.for[i2] == nArray[i2]) continue;
            return false;
        }
        return true;
    }

    public GroupPath makeRelativeGroupPath(GroupPath groupPath) {
        if (groupPath == null || groupPath == ROOT_GROUP_PATH) {
            return this;
        }
        assert (this.getGroupLevel() >= groupPath.getGroupLevel());
        GroupPath groupPath2 = new GroupPath(this.for);
        for (int i2 = 0; i2 < groupPath.for.length; ++i2) {
            int n2 = i2;
            groupPath2.for[n2] = groupPath2.for[n2] - groupPath.for[i2];
        }
        return groupPath2;
    }

    public GroupPath makeAbsoluteGroupPath(GroupPath groupPath) {
        if (groupPath == null || groupPath == ROOT_GROUP_PATH) {
            return this;
        }
        assert (this.getGroupLevel() >= groupPath.getGroupLevel());
        GroupPath groupPath2 = new GroupPath(this.for);
        for (int i2 = 0; i2 < groupPath.for.length; ++i2) {
            int n2 = i2;
            groupPath2.for[n2] = groupPath2.for[n2] + groupPath.for[i2];
        }
        return groupPath2;
    }

    public GroupPath getLevelGroupPath(int n2) {
        if (n2 > this.for.length) {
            throw new IllegalStateException();
        }
        if (n2 == this.getGroupLevel()) {
            return this;
        }
        return new GroupPath(this.for, n2);
    }

    public static GroupPath Load(ExtendedDataInput extendedDataInput) throws IOException {
        int n2 = extendedDataInput.readInt();
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = extendedDataInput.readInt();
        }
        return new GroupPath(nArray);
    }

    public void store(ExtendedDataOutput extendedDataOutput) throws IOException {
        extendedDataOutput.writeInt(this.for.length);
        for (int i2 = 0; i2 < this.for.length; ++i2) {
            extendedDataOutput.writeInt(this.for[i2]);
        }
    }
}

