/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.reports.reportdatainterface;

import com.businessobjects.reports.reportdatainterface.b;
import com.crystaldecisions.reports.common.value.BinaryValue;
import com.crystaldecisions.reports.common.value.BooleanValue;
import com.crystaldecisions.reports.common.value.ColourValue;
import com.crystaldecisions.reports.common.value.CrystalValue;
import com.crystaldecisions.reports.common.value.DateTimeValue;
import com.crystaldecisions.reports.common.value.DateValue;
import com.crystaldecisions.reports.common.value.NumericValue;
import com.crystaldecisions.reports.common.value.StringValue;
import com.crystaldecisions.reports.common.value.TimeValue;
import com.crystaldecisions.reports.common.value.ValueType;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class ReportDataInterfaceUtils {
    private static final long a = 1000000L;

    public static int[] GetSelectedColumns(boolean[] blArray) {
        if (blArray == null) {
            return null;
        }
        int n2 = 0;
        for (int i2 = 0; i2 < blArray.length; ++i2) {
            if (!blArray[i2]) continue;
            ++n2;
        }
        int[] nArray = new int[n2];
        int n3 = 0;
        for (int i3 = 0; i3 < blArray.length; ++i3) {
            if (!blArray[i3]) continue;
            nArray[n3] = i3;
            ++n3;
        }
        return nArray;
    }

    public static int CrystalDataTypeToJDBCDataType(ValueType valueType) {
        switch (valueType.value()) {
            case 11: {
                return 12;
            }
            case 16: {
                return 3;
            }
            case 6: {
                return 8;
            }
            case 7: {
                return 8;
            }
            case 8: {
                return 16;
            }
            case 9: {
                return 91;
            }
            case 10: {
                return 92;
            }
            case 15: {
                return 93;
            }
            case 13: {
                return -1;
            }
            case 14: {
                return 2004;
            }
            case 0: {
                return -6;
            }
            case 1: {
                return 5;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return -5;
            }
            case 17: {
                return -5;
            }
            case 18: {
                return 3;
            }
        }
        throw new IllegalArgumentException("Unsupported value type: " + valueType.value());
    }

    public static Object CrystalValueToJDBCValue(CrystalValue crystalValue) {
        if (crystalValue == null) {
            return null;
        }
        if (crystalValue instanceof StringValue) {
            return ((StringValue)crystalValue).getString();
        }
        if (crystalValue instanceof NumericValue) {
            NumericValue numericValue = (NumericValue)crystalValue;
            if (numericValue.isIntegerValue()) {
                return new Long(numericValue.getLong());
            }
            return new Double(numericValue.getDouble());
        }
        if (crystalValue instanceof BooleanValue) {
            BooleanValue booleanValue = (BooleanValue)crystalValue;
            return new Boolean(booleanValue.getBoolean());
        }
        if (crystalValue instanceof DateTimeValue) {
            TimeValue timeValue;
            DateTimeValue dateTimeValue = (DateTimeValue)crystalValue;
            DateValue dateValue = dateTimeValue.getDateValue();
            if (dateValue == null) {
                dateValue = DateValue.now();
            }
            if ((timeValue = dateTimeValue.getTimeValue()) == null) {
                timeValue = TimeValue.now();
            }
            Calendar calendar = Calendar.getInstance();
            calendar.clear();
            calendar.set(dateValue.getYear(), dateValue.getMonth() - 1, dateValue.getDay(), timeValue.getHours(), timeValue.getMinutes(), timeValue.getWholeSeconds());
            long l2 = calendar.getTimeInMillis() + timeValue.getNanoseconds() / 1000000L;
            return new Timestamp(l2);
        }
        if (crystalValue instanceof TimeValue) {
            TimeValue timeValue = (TimeValue)crystalValue;
            Calendar calendar = Calendar.getInstance();
            calendar.clear();
            calendar.set(11, timeValue.getHours());
            calendar.set(12, timeValue.getMinutes());
            calendar.set(13, timeValue.getWholeSeconds());
            long l3 = calendar.getTimeInMillis() + timeValue.getNanoseconds() / 1000000L;
            return new Time(l3);
        }
        if (crystalValue instanceof DateValue) {
            DateValue dateValue = (DateValue)crystalValue;
            Calendar calendar = Calendar.getInstance();
            calendar.clear();
            calendar.set(dateValue.getYear(), dateValue.getMonth() - 1, dateValue.getDay());
            return new Date(calendar.getTimeInMillis());
        }
        if (crystalValue instanceof ColourValue) {
            ColourValue colourValue = (ColourValue)crystalValue;
            return new Integer(colourValue.getColorRef());
        }
        if (crystalValue instanceof BinaryValue) {
            BinaryValue binaryValue = (BinaryValue)crystalValue;
            return new b(binaryValue);
        }
        throw new IllegalArgumentException("Programming error, this type of crystalValue is not supported!");
    }
}

