/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.reports.crprompting;

import com.businessobjects.lov.ILOVContext;
import com.businessobjects.lov.ILOVDataSource;
import com.businessobjects.lov.ILOVField;
import com.businessobjects.lov.ILOVObject;
import com.businessobjects.lov.ILOVRowset;
import com.businessobjects.prompting.exceptions.PromptingException;
import com.businessobjects.prompting.objectmodel.common.ILOVNetwork;
import com.businessobjects.prompting.objectmodel.common.IPrompt;
import com.businessobjects.prompting.objectmodel.common.IPromptValue;
import com.businessobjects.prompting.objectmodel.common.PromptValueList;
import com.businessobjects.prompting.objectmodel.common.PromptValueType;
import com.businessobjects.reports.crprompting.CRLOVFactory;
import com.businessobjects.reports.crprompting.CRPromptValue;
import com.businessobjects.reports.crprompting.Prompt;
import com.crystaldecisions.reports.common.value.BooleanValue;
import com.crystaldecisions.reports.common.value.CrystalValue;
import com.crystaldecisions.reports.common.value.DateTimeValue;
import com.crystaldecisions.reports.common.value.DateValue;
import com.crystaldecisions.reports.common.value.FormulaValue;
import com.crystaldecisions.reports.common.value.NumericValue;
import com.crystaldecisions.reports.common.value.StringValue;
import com.crystaldecisions.reports.common.value.TimeValue;
import com.crystaldecisions.reports.common.value.ValueType;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PromptingUtils {
    public static final String CR_OBJECT_PREFIX = "crobj://";
    public static final String CE_OBJECT_PREFIX = "eor://";
    public static final String BooleanPartOfGroup = "Boolean_PartOfGroup";
    public static final String BooleanGroupNumber = "Boolean_GroupNumber";
    public static final String BooleanMutuallyExclusiveGroup = "Boolean_MutuallyExclusiveGroup";
    public static final int ValueIndex = 0;
    public static final int DescriptionIndex = 1;
    public static final int MaxIndex = 1;
    public static final Integer ValueIndexInteger = 0;
    public static final Integer DescriptionIndexInteger = 1;

    @Deprecated
    public static boolean isLocalURI(String URI2) {
        if (URI2 == null || URI2.length() == 0) {
            return false;
        }
        return URI2.startsWith(CR_OBJECT_PREFIX);
    }

    @Deprecated
    public static boolean isCEURI(String URI2) {
        if (URI2 == null || URI2.length() == 0) {
            return false;
        }
        return URI2.startsWith(CE_OBJECT_PREFIX);
    }

    public static ILOVNetwork createLOVNetwork(String paramName, String promptText, ValueType valueType, boolean allowNullValue, boolean allowMultipleValues, boolean allowDiscreteValue, boolean allowRangeValue, boolean allowCustomValue, boolean valueRequired, CrystalValue minValue, CrystalValue maxValue, String editMask, IPromptValue.IPromptValueList initialValues) {
        Prompt prompt = new Prompt();
        prompt.setName(paramName);
        PromptValueType pValueType = PromptingUtils.getPromptValueTypeFromValueType(valueType.getBaseValueType());
        prompt.setValueType(pValueType);
        prompt.setDefaultPromptText(promptText);
        prompt.setNullable(allowNullValue);
        prompt.setAllowMultipleValues(allowMultipleValues);
        prompt.setAllowDiscreteValue(allowDiscreteValue);
        prompt.setAllowRangeValue(allowRangeValue);
        prompt.setAllowCustomValue(allowCustomValue);
        prompt.setValueRequired(valueRequired);
        if (minValue instanceof FormulaValue) {
            prompt.setMin(CRPromptValue.fromFormulaValue((FormulaValue)minValue));
        }
        if (maxValue instanceof FormulaValue) {
            prompt.setMax(CRPromptValue.fromFormulaValue((FormulaValue)maxValue));
        }
        prompt.setEditMask(editMask);
        if (initialValues != null) {
            prompt.setDefaultValues(initialValues);
        }
        return PromptingUtils.makeStaticLOVNetwork(prompt);
    }

    public static Object getValue(CrystalValue value) {
        ValueType valueType = value.getValueType();
        switch (valueType.value()) {
            case 8: {
                return new Boolean(((BooleanValue)value).getBoolean());
            }
            case 6: 
            case 7: {
                return new Double(((NumericValue)value).getDouble());
            }
            case 11: {
                return ((StringValue)value).getString();
            }
            case 9: {
                return ((DateValue)value).getJavaDate();
            }
            case 10: {
                return ((TimeValue)value).getJavaDate();
            }
            case 15: {
                return ((DateTimeValue)value).getJavaDate();
            }
        }
        throw new IllegalArgumentException();
    }

    public static ValueType getCRValueType(PromptValueType valueType) {
        switch (valueType.value()) {
            case 2: {
                return ValueType.bool;
            }
            case 1: {
                return ValueType.currency;
            }
            case 3: {
                return ValueType.date;
            }
            case 5: {
                return ValueType.dateTime;
            }
            case 0: {
                return ValueType.number;
            }
            case 4: {
                return ValueType.string;
            }
            case 6: {
                return ValueType.time;
            }
        }
        throw new IllegalArgumentException();
    }

    public static IPromptValue.IPromptValueList getIPromptValuesFromCrystalValues(List<? extends CrystalValue> crystalValues) throws IllegalArgumentException {
        PromptValueList promptValueList = new PromptValueList();
        for (CrystalValue crystalValue : crystalValues) {
            promptValueList.add(CRPromptValue.fromFormulaValue((FormulaValue)crystalValue));
        }
        return promptValueList;
    }

    public static List<FormulaValue> getFormulaValuesFromIPromptValues(IPromptValue.IPromptValueList values) {
        ArrayList<FormulaValue> crystalValues = new ArrayList<FormulaValue>();
        for (IPromptValue value : values) {
            crystalValues.add(CRPromptValue.getFormulaValue(value));
        }
        return crystalValues;
    }

    public static PromptValueType getPromptValueTypeFromValueType(ValueType type) {
        if (type.isNumber()) {
            return PromptValueType.number;
        }
        switch (type.getBaseValueType().value()) {
            case 7: {
                return PromptValueType.currency;
            }
            case 8: {
                return PromptValueType.bool;
            }
            case 9: {
                return PromptValueType.date;
            }
            case 10: {
                return PromptValueType.time;
            }
            case 15: {
                return PromptValueType.dateTime;
            }
            case 11: 
            case 13: {
                return PromptValueType.string;
            }
        }
        throw new IllegalArgumentException();
    }

    public static List<IPromptValue.IPromptValueList> getStaticLOVRows(IPrompt prompt, ILOVDataSource lovDS) {
        ILOVObject.IStaticLOVObject staticLOVObject = PromptingUtils.getStaticLOVObject(prompt, lovDS);
        return staticLOVObject == null ? new ArrayList() : staticLOVObject.getRows();
    }

    public static void removeStaticLOVRows(IPrompt prompt, ILOVDataSource lovDS) {
        ILOVObject.IStaticLOVObject staticLOVObject = PromptingUtils.getStaticLOVObject(prompt, lovDS);
        if (staticLOVObject == null) {
            throw new IllegalArgumentException("Prompt does not have a Static LOV");
        }
        staticLOVObject.removeRows();
    }

    public static void addStaticLOVRow(IPrompt prompt, ILOVDataSource lovDS, IPromptValue.IPromptValueList row) {
        ILOVObject.IStaticLOVObject staticLOVObject = PromptingUtils.getStaticLOVObject(prompt, lovDS);
        if (staticLOVObject == null) {
            throw new IllegalArgumentException("Prompt does not have a Static LOV");
        }
        staticLOVObject.addRow(row);
    }

    public static boolean hasStaticLOVDescription(IPrompt prompt, ILOVDataSource lovDS) {
        List<ILOVField> fields = PromptingUtils.getStaticLOVFields(prompt, lovDS);
        return fields != null && fields.size() > 1;
    }

    private static List<ILOVField> getStaticLOVFields(IPrompt prompt, ILOVDataSource lovDS) {
        ILOVObject.IStaticLOVObject staticLOVObject = PromptingUtils.getStaticLOVObject(prompt, lovDS);
        if (staticLOVObject == null) {
            throw new IllegalArgumentException("Prompt does not have a Static LOV");
        }
        return staticLOVObject.getFields();
    }

    private static ILOVObject.IStaticLOVObject getStaticLOVObject(IPrompt prompt, ILOVDataSource lovDS) {
        if (PromptingUtils.isDynamic(lovDS)) {
            return null;
        }
        ILOVObject lovObject = lovDS.getLOVObject(prompt.getLOVObjectUUID());
        if (!(lovObject instanceof ILOVObject.IStaticLOVObject)) {
            assert (false) : "Prompting objects are inconsistent";
            return null;
        }
        return (ILOVObject.IStaticLOVObject)lovObject;
    }

    public static List<ILOVField> getLOVFields(IPrompt prompt, ILOVDataSource lovDS) {
        return lovDS.getLOVObject(prompt.getLOVObjectUUID()).getFields();
    }

    public static ILOVNetwork makeStaticLOVNetwork(IPrompt prompt) {
        ArrayList<IPrompt> prompts = new ArrayList<IPrompt>();
        prompts.add(prompt);
        try {
            return CRLOVFactory.getStaticLOVFactory().makeLOVNetwork(UUID.randomUUID(), prompt.getName(), null, "", PromptingUtils.makeStaticLOVDataSource(prompt), prompts);
        }
        catch (PromptingException.InvalidNetworkException e10) {
            assert (false) : e10;
            return null;
        }
    }

    public static ILOVDataSource makeStaticLOVDataSource(IPrompt prompt) {
        ArrayList<ILOVObject> lovObjects = new ArrayList<ILOVObject>();
        lovObjects.add(PromptingUtils.makeStaticLOVObject(prompt));
        return CRLOVFactory.getStaticLOVFactory().makeLOVDataSource(UUID.randomUUID(), prompt.getName(), null, lovObjects);
    }

    public static ILOVObject makeStaticLOVObject(IPrompt prompt) {
        prompt.setLOVObjectUUID(UUID.randomUUID());
        return CRLOVFactory.getStaticLOVFactory().makeStaticLOVObject(prompt.getLOVObjectUUID(), prompt.getName(), null, ILOVContext.FilterType.EQUAL_TO, PromptingUtils.makeDefaultStaticLOVFields(prompt), null);
    }

    private static List<ILOVField> makeDefaultStaticLOVFields(IPrompt prompt) {
        ILOVField valueField = CRLOVFactory.getStaticLOVFactory().makeLOVField(UUID.randomUUID(), "Value", "", prompt.getName(), prompt.getValueType(), 0, 0);
        ILOVField descriptionField = CRLOVFactory.getStaticLOVFactory().makeLOVField(UUID.randomUUID(), "Description", "", prompt.getName(), PromptValueType.string, 0, 0);
        ArrayList<ILOVField> fields = new ArrayList<ILOVField>();
        for (int index = 0; index <= 1; ++index) {
            if (index == 0) {
                fields.add(valueField);
                continue;
            }
            if (index == 1) {
                fields.add(descriptionField);
                continue;
            }
            fields.add(null);
        }
        return fields;
    }

    public static boolean isStatic(ILOVDataSource lovDataSource) {
        return lovDataSource instanceof CRLOVFactory.IStaticLOVDataSource;
    }

    public static boolean isDynamic(ILOVDataSource lovDataSource) {
        return !PromptingUtils.isStatic(lovDataSource);
    }

    public static boolean isLocal(ILOVDataSource lovDataSource) {
        return lovDataSource instanceof CRLOVFactory.ILocalLOVDataSource;
    }

    public static boolean isCE(ILOVDataSource lovDataSource) {
        return lovDataSource instanceof CRLOVFactory.ICELOVDataSource;
    }

    public static boolean isHideLOVValue(IPrompt prompt) {
        return prompt.getLOVHiddenFields().contains(ValueIndexInteger);
    }

    public static void setHideLOVValue(IPrompt prompt, boolean hideLOVValue) {
        ArrayList<Integer> hiddenFields = new ArrayList<Integer>(prompt.getLOVHiddenFields());
        if (hideLOVValue == hiddenFields.contains(ValueIndexInteger)) {
            return;
        }
        if (hideLOVValue) {
            hiddenFields.add(ValueIndexInteger);
        } else {
            hiddenFields.remove(ValueIndexInteger);
        }
        prompt.setLOVHiddenFields(hiddenFields);
    }

    public static String getFormattedPromptValue(IPromptValue promptValue, Locale locale) {
        return CRLOVFactory.getFormattedPromptValue(promptValue, locale);
    }

    public static boolean isDirectDependentPromptMissingValue(IPrompt prompt, ILOVNetwork lovNetwork) {
        for (UUID uuid : prompt.getRequiredPromptCUIDs()) {
            IPromptValue.IPromptValueList dependentValues = lovNetwork.getPrompt(uuid).getValues();
            if (dependentValues != null && !dependentValues.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static String dumpRowset(ILOVRowset rowset, List<ILOVField> fields, int maxRows) {
        if (rowset == null) {
            return "rowset is null";
        }
        StringBuilder builder = new StringBuilder();
        int nRows = rowset.getNRows();
        builder.append("Number of rows = ").append(nRows).append("\n");
        int savedRowN = rowset.getRowN();
        for (int i2 = 0; i2 < nRows && i2 < maxRows - 1; ++i2) {
            builder.append(PromptingUtils.dumpRow(rowset, fields, i2));
        }
        if (nRows > maxRows - 1) {
            builder.append(PromptingUtils.dumpRow(rowset, fields, nRows - 1));
        }
        rowset.seek(savedRowN);
        return builder.toString();
    }

    private static String dumpRow(ILOVRowset rowset, List<ILOVField> fields, int rowN) {
        StringBuilder builder = new StringBuilder();
        rowset.seek(rowN);
        builder.append("row ").append(rowN).append(" : ").append(PromptingUtils.dumpRow(rowset.getRow(), fields)).append("\n");
        return builder.toString();
    }

    public static String dumpRow(ILOVRowset.ILOVRow row, List<ILOVField> fields) {
        StringBuilder builder = new StringBuilder();
        for (ILOVField field : fields) {
            builder.append(row.getValue(field)).append(" ");
        }
        return builder.toString();
    }

    public static String getFieldIDKey(int index) {
        StringBuilder builder = new StringBuilder();
        builder.append("FieldIDKeyForColumn").append(index);
        return builder.toString();
    }
}

