/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.rendering;

import com.businessobjects.visualization.common.exceptions.NotImplementedException;
import com.businessobjects.visualization.map.IGraphicMap;
import com.businessobjects.visualization.rendering.AdditionalResource;
import com.businessobjects.visualization.rendering.Plugin;
import com.businessobjects.visualization.rendering.RenderFormat;
import com.businessobjects.visualization.rendering.formats.BMPRenderFormat;
import com.businessobjects.visualization.rendering.formats.FlashRenderFormat;
import com.businessobjects.visualization.rendering.formats.GIFRenderFormat;
import com.businessobjects.visualization.rendering.formats.JPGRenderFormat;
import com.businessobjects.visualization.rendering.formats.PNGRenderFormat;
import com.businessobjects.visualization.rendering.formats.SVGRenderFormat;
import com.businessobjects.visualization.rendering.formats.XAMLRenderFormat;
import com.businessobjects.visualization.rendering.formats.XMLRenderFormat;
import java.io.IOException;
import java.io.OutputStream;

public class RenderEngine {
    private String[] renderParameters_;
    private IGraphicMap graphicMap_;
    private byte[] result_;
    private Object native_;
    private Plugin plugin_;
    private AdditionalResource[] staticResources_;
    private RenderFormat renderFormat_;
    public static final int NO_MAP = 0;
    public static final int RETRIEVE_REGIONS_MAP = 1;

    public RenderEngine(int outputType, IGraphicMap map, byte[] result) {
        this.setRenderFormat(outputType);
        this.graphicMap_ = map;
        this.result_ = result;
        this.staticResources_ = new AdditionalResource[0];
    }

    public RenderEngine(int outputType, IGraphicMap map, Object img) {
        this.setRenderFormat(outputType);
        this.graphicMap_ = map;
        this.result_ = null;
        this.native_ = img;
        this.staticResources_ = new AdditionalResource[0];
    }

    private void setRenderFormat(int outputType) {
        if (outputType == 4) {
            this.renderFormat_ = new PNGRenderFormat();
        } else if (outputType == 2) {
            this.renderFormat_ = new JPGRenderFormat();
        } else if (outputType == 8) {
            this.renderFormat_ = new GIFRenderFormat();
        } else if (outputType == 1) {
            this.renderFormat_ = new BMPRenderFormat();
        } else if ((outputType & 0x10) > 0) {
            this.renderFormat_ = new FlashRenderFormat(outputType);
        } else if ((outputType & 0x100) > 0) {
            this.renderFormat_ = new SVGRenderFormat(outputType);
        } else if ((outputType & 0x400) > 0) {
            this.renderFormat_ = null;
        } else if ((outputType & 0x20) > 0) {
            this.renderFormat_ = new XMLRenderFormat(outputType);
        } else if ((outputType & 0x200) > 0) {
            this.renderFormat_ = new XAMLRenderFormat(outputType);
        }
    }

    public byte[] render() {
        return this.result_;
    }

    public Object nativeRender() {
        return this.native_;
    }

    public boolean render(OutputStream os) throws IOException {
        boolean ret = false;
        if (this.result_ != null) {
            os.write(this.result_);
            ret = true;
        }
        return ret;
    }

    public boolean nativeRender(Object graphObject, boolean bSynchronous) {
        throw new NotImplementedException();
    }

    public String[] getRenderParameters() {
        return this.renderParameters_;
    }

    public void setRenderParameters(String[] renderParameters) {
        this.renderParameters_ = renderParameters;
    }

    public IGraphicMap getGraphicMap() {
        return this.graphicMap_;
    }

    protected void setGraphicMap(IGraphicMap map) {
        this.graphicMap_ = map;
    }

    public RenderFormat getRenderFormat() {
        return this.renderFormat_;
    }

    public Plugin getPlugin() {
        return this.plugin_;
    }

    protected void setPlugin(Plugin plugin) {
        this.plugin_ = plugin;
    }

    public AdditionalResource[] getExtraResources() {
        return this.staticResources_;
    }

    protected void setExtraResources(AdditionalResource[] staticResources) {
        this.staticResources_ = staticResources;
    }

    public byte[] getBinaryStaticResource(String resourceName) {
        throw new NotImplementedException();
    }
}

