/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.graphic.xml.settings.generated;

import com.businessobjects.visualization.common.internal.XmlReaderVersion;
import com.businessobjects.visualization.graphic.xml.settings.MigrationSettings;
import com.businessobjects.visualization.graphic.xml.settings.generated.XMLColors;
import com.businessobjects.visualization.graphic.xml.settings.generated.XMLCustomValues;
import com.businessobjects.visualization.graphic.xml.settings.generated.XMLDefaultValues;
import com.businessobjects.visualization.util.xml.Helper;
import com.businessobjects.visualization.util.xml.XmlEventType;
import com.businessobjects.visualization.util.xml.XmlException;
import com.businessobjects.visualization.util.xml.XmlWriter;

public class XMLGlobalValue {
    public XMLDefaultValues m_DefaultValues = null;
    public XMLColors m_Colors = null;
    public XMLCustomValues m_CustomValues = null;

    public void unmarshall(XmlReaderVersion readerVersion) throws XmlException {
        this.processAttribute(readerVersion);
        while (!(readerVersion.getXmlReader().next() == XmlEventType.END_DOCUMENT || readerVersion.getXmlReader().getEventType() == XmlEventType.END_ELEMENT && readerVersion.getXmlReader().getName() != null && readerVersion.getXmlReader().getName().equals("GlobalValue"))) {
            String sNode = readerVersion.getXmlReader().getName();
            MigrationSettings.instance().manageNode(this, readerVersion, sNode);
            if (sNode != null && sNode.equals("DefaultValues")) {
                this.m_DefaultValues = new XMLDefaultValues();
                this.m_DefaultValues.unmarshall(readerVersion);
                continue;
            }
            if (sNode != null && sNode.equals("Colors")) {
                this.m_Colors = new XMLColors();
                this.m_Colors.unmarshall(readerVersion);
                continue;
            }
            if (sNode == null || !sNode.equals("CustomValues")) continue;
            this.m_CustomValues = new XMLCustomValues();
            this.m_CustomValues.unmarshall(readerVersion);
        }
    }

    public void processAttribute(XmlReaderVersion readerVersion) throws XmlException {
        for (int i = 0; i < readerVersion.getXmlReader().getAttributeCount(); ++i) {
            String prefixName = readerVersion.getXmlReader().getAttributePrefix(i);
            String attName = readerVersion.getXmlReader().getAttributeName(i);
            String finalName = (prefixName != null ? prefixName : "") + (prefixName != null && attName != null ? ":" : "") + (attName != null ? attName : "");
            MigrationSettings.instance().manageAttribute(this, readerVersion, finalName, readerVersion.getXmlReader().getAttributeValue(i));
        }
    }

    public void dump() {
        ++Helper.indent;
        Helper.print("XMLGlobalValue");
        if (this.m_DefaultValues != null) {
            this.m_DefaultValues.dump();
        }
        if (this.m_Colors != null) {
            this.m_Colors.dump();
        }
        if (this.m_CustomValues != null) {
            this.m_CustomValues.dump();
        }
        Helper.println("XMLGlobalValue ");
        --Helper.indent;
    }

    public void marshall2(XmlWriter xw) throws XmlException {
        if (this.m_DefaultValues != null) {
            xw.startElement("DefaultValues");
            this.m_DefaultValues.marshall2(xw);
            xw.endElement("DefaultValues");
        }
        if (this.m_Colors != null) {
            xw.startElement("Colors");
            this.m_Colors.marshall2(xw);
            xw.endElement("Colors");
        }
        if (this.m_CustomValues != null) {
            xw.startElement("CustomValues");
            this.m_CustomValues.marshall2(xw);
            xw.endElement("CustomValues");
        }
    }

    public boolean equals(Object o) {
        XMLGlobalValue obj = (XMLGlobalValue)o;
        if (!this.m_DefaultValues.equals(obj.m_DefaultValues)) {
            return false;
        }
        if (!this.m_Colors.equals(obj.m_Colors)) {
            return false;
        }
        return this.m_CustomValues.equals(obj.m_CustomValues);
    }
}

