/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.graphic;

import com.businessobjects.visualization.common.exceptions.VisualizationInternalException;
import com.businessobjects.visualization.common.exceptions.VisualizationRuntimeException;
import com.businessobjects.visualization.graphic.VisuInteger;
import com.businessobjects.visualization.graphic.VisuObject;
import com.businessobjects.visualization.graphic.VisuObjectType;
import org.json.JSONException;
import org.json.JSONObject;

public class VisuString
extends VisuObject {
    private static VisuObjectType type = VisuObjectType.STRING;
    private String value_;

    public VisuString(String s) {
        this.value_ = s;
    }

    public String getXmlValue() {
        return this.value_;
    }

    public String toString() {
        String s = this.value_;
        return s;
    }

    public VisuObjectType getType() {
        return type;
    }

    protected void setXmlValue(String xmlValue) {
        this.value_ = xmlValue;
    }

    protected Object clone() {
        return super.clone();
    }

    protected boolean checkValidity(Object param) {
        VisuInteger vi = (VisuInteger)param;
        if (this.value_.length() > vi.intValue()) {
            throw new VisualizationRuntimeException("VIZ_00055_ERR_VISUSTRING_IS_TOO_LO", new Object[]{vi, this.value_});
        }
        return true;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof VisuString) {
            VisuString vs = (VisuString)obj;
            if (vs.value_.equals(this.value_)) {
                result = true;
            }
        }
        return result;
    }

    public int hashCode() {
        return super.hashCode();
    }

    protected JSONObject getJSONObject() {
        try {
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("type", new Integer(type.value()));
            jsonObj.put("value", this.value_);
            return jsonObj;
        }
        catch (JSONException jex) {
            throw new VisualizationInternalException(jex);
        }
    }

    VisuString(JSONObject jobj) {
        try {
            this.value_ = jobj.getString("value");
        }
        catch (JSONException jex) {
            throw new VisualizationInternalException(jex);
        }
    }
}

