/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.graphic;

import com.businessobjects.visualization.common.internal.IXMLDelegator;
import com.businessobjects.visualization.graphic.ColorManager;
import com.businessobjects.visualization.graphic.Palette;
import com.businessobjects.visualization.graphic.VisuColor;
import com.businessobjects.visualization.graphic.VisuColorEffectType;
import com.businessobjects.visualization.graphic.VisuCustomValues;
import com.businessobjects.visualization.graphic.VisuDefaultValues;
import com.businessobjects.visualization.graphic.VisuObject;
import com.businessobjects.visualization.graphic.VisuObjectType;
import com.businessobjects.visualization.graphic.xml.settings.generated.XMLColors;
import com.businessobjects.visualization.graphic.xml.settings.generated.XMLCustomValues;
import com.businessobjects.visualization.graphic.xml.settings.generated.XMLDefaultValues;
import com.businessobjects.visualization.graphic.xml.settings.generated.XMLGlobalValue;

public class VisuObjectManager
implements IXMLDelegator {
    private VisuDefaultValues defaultValues_ = new VisuDefaultValues();
    private VisuCustomValues customValues_ = new VisuCustomValues();
    private ColorManager colorManager_ = new ColorManager();

    VisuObjectManager() {
    }

    public void setDefaultValue(VisuObject visuObject) {
        this.defaultValues_.setValue(visuObject);
    }

    public VisuObject getDefaultValue(VisuObjectType vot) {
        return this.defaultValues_.getValue(vot);
    }

    public VisuObject getValueFromPartial(VisuObject vo) {
        return this.defaultValues_.getValueFromPartial(vo);
    }

    public void setCustomValue(String key, VisuObject visuObject) {
        this.customValues_.setValue(key, visuObject);
    }

    public void removeCustomValue(String key, VisuObjectType vot) {
        this.customValues_.removeValue(key, vot);
    }

    public VisuObject getCustomValue(String key, VisuObjectType vot) {
        return this.customValues_.getValue(key, vot);
    }

    public void setPalette(Palette palette) {
        this.colorManager_.setPalette(palette);
    }

    public VisuColor getColor(int index) {
        return this.colorManager_.getColor(index);
    }

    public VisuColor getColor(int index, VisuColorEffectType effect) {
        return this.colorManager_.getColor(index, effect);
    }

    public void setColorEffectValue(VisuColorEffectType effect, int value) {
        if (effect == VisuColorEffectType.ALPHA) {
            this.colorManager_.setAlpha(value);
        } else if (effect == VisuColorEffectType.BRIGHTNESS) {
            this.colorManager_.setBrightness(value);
        }
    }

    public String[] getCustomKeys(VisuObjectType vot) {
        return this.customValues_.getKeys(vot);
    }

    public Object getXMLDelegate() {
        XMLGlobalValue xgv = new XMLGlobalValue();
        xgv.m_Colors = (XMLColors)this.colorManager_.getXMLDelegate();
        xgv.m_CustomValues = (XMLCustomValues)this.customValues_.getXMLDelegate();
        xgv.m_DefaultValues = (XMLDefaultValues)this.defaultValues_.getXMLDelegate();
        return xgv;
    }

    void init(XMLGlobalValue xgv) {
        if (xgv != null) {
            this.customValues_.init(xgv.m_CustomValues);
            this.colorManager_.init(xgv.m_Colors);
            this.defaultValues_.init(xgv.m_DefaultValues);
        }
    }

    public ColorManager getColorManager() {
        return this.colorManager_;
    }
}

