/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.graphic;

import com.businessobjects.visualization.common.exceptions.VisualizationRuntimeException;

public final class RegionShape {
    public static final int I_RECTANGLE = 0;
    public static final int I_POLYGON = 1;
    public static final int I_POLYGONE = 1;
    public static final int I_SECTOR = 2;
    public static final int I_RING = 3;
    public static final int I_CIRCLE = 4;
    private static final String[] SVALUES = new String[]{"RECTANGLE", "POLYGON", "SECTOR", "RING", "CIRCLE"};
    public static final RegionShape RECTANGLE = new RegionShape(0);
    public static final RegionShape POLYGON = new RegionShape(1);
    public static final RegionShape POLYGONE = new RegionShape(1);
    public static final RegionShape SECTOR = new RegionShape(2);
    public static final RegionShape RING = new RegionShape(3);
    public static final RegionShape CIRCLE = new RegionShape(4);
    private final int value_;

    private RegionShape(int value) {
        this.value_ = value;
    }

    public int value() {
        return this.value_;
    }

    public String toString() {
        return SVALUES[this.value_];
    }

    public static RegionShape parse(String typeToParse) {
        if ("rect".equals(typeToParse)) {
            return RECTANGLE;
        }
        if ("poly".equals(typeToParse)) {
            return POLYGON;
        }
        if ("sect".equals(typeToParse)) {
            return SECTOR;
        }
        if ("ring".equals(typeToParse)) {
            return RING;
        }
        if ("circle".equals(typeToParse)) {
            return CIRCLE;
        }
        throw new VisualizationRuntimeException("VIZ_00045_ERR_ERROR__REGIONSHAPE__", new Object[]{typeToParse});
    }
}

