/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.graphic;

import com.businessobjects.visualization.LocalizedEngine;
import com.businessobjects.visualization.common.exceptions.VisualizationInternalException;
import com.businessobjects.visualization.graphic.BaseRegionPropertyDef;
import com.businessobjects.visualization.graphic.GraphicDefNode;
import com.businessobjects.visualization.graphic.IGraphicDefNode;
import com.businessobjects.visualization.graphic.ISettingsCallback;
import com.businessobjects.visualization.graphic.PropertyDefVisibilityType;
import com.businessobjects.visualization.graphic.PropertyState;
import com.businessobjects.visualization.graphic.RegionDef;
import com.businessobjects.visualization.graphic.VisuBool;
import com.businessobjects.visualization.graphic.VisuCallback;
import com.businessobjects.visualization.graphic.VisuColor;
import com.businessobjects.visualization.graphic.VisuColorType;
import com.businessobjects.visualization.graphic.VisuColorZones;
import com.businessobjects.visualization.graphic.VisuDouble;
import com.businessobjects.visualization.graphic.VisuDynamicNode;
import com.businessobjects.visualization.graphic.VisuFont;
import com.businessobjects.visualization.graphic.VisuInteger;
import com.businessobjects.visualization.graphic.VisuObject;
import com.businessobjects.visualization.graphic.VisuObjectType;
import com.businessobjects.visualization.graphic.VisuState;
import com.businessobjects.visualization.graphic.VisuString;
import com.businessobjects.visualization.graphic.xml.settingsdefinition.generated.XMLBool;
import com.businessobjects.visualization.graphic.xml.settingsdefinition.generated.XMLCallback;
import com.businessobjects.visualization.graphic.xml.settingsdefinition.generated.XMLColor;
import com.businessobjects.visualization.graphic.xml.settingsdefinition.generated.XMLColorZones;
import com.businessobjects.visualization.graphic.xml.settingsdefinition.generated.XMLDoubleRange;
import com.businessobjects.visualization.graphic.xml.settingsdefinition.generated.XMLDynamicNode;
import com.businessobjects.visualization.graphic.xml.settingsdefinition.generated.XMLFont;
import com.businessobjects.visualization.graphic.xml.settingsdefinition.generated.XMLIntRange;
import com.businessobjects.visualization.graphic.xml.settingsdefinition.generated.XMLMultiState;
import com.businessobjects.visualization.graphic.xml.settingsdefinition.generated.XMLProperty;
import com.businessobjects.visualization.graphic.xml.settingsdefinition.generated.XMLStateItem;
import com.businessobjects.visualization.graphic.xml.settingsdefinition.generated.XMLText;
import com.businessobjects.visualization.graphic.xml.settingsdefinition.generated.XMLVisibilityType;
import java.util.ArrayList;
import java.util.Iterator;

public class PropertyDef
extends BaseRegionPropertyDef {
    private VisuObjectType propertyType_;
    private PropertyDefVisibilityType visibility_;
    private VisuObject defaultValue_;
    private VisuObject validValue_;
    private Object parameter_;
    private VisuCallback callback_;
    private ArrayList stateList_;
    private ArrayList stateIds_ = new ArrayList();

    PropertyDef(RegionDef rd, IGraphicDefNode parent, XMLProperty xprop, LocalizedEngine.Localizator loc, String stateId, String newDefaultValue) {
        super(xprop.m_a_Id, loc.getValue(xprop.m_a_Name), loc.getValue(xprop.m_a_Description), parent, rd, loc, IGraphicDefNode.GraphicDefNodeType.PROPERTY);
        this.visibility_ = PropertyDef.computeVisiblility(xprop.m_a_Visibility);
        if (stateId != null) {
            this.stateIds_.add(stateId);
        }
        this.computeXmlProperty(xprop, loc, newDefaultValue);
        ((GraphicDefNode)this.getParent()).addChildVisibility(this.visibility_);
    }

    public VisuObjectType getType() {
        return this.propertyType_;
    }

    public PropertyDefVisibilityType getVisibility() {
        return this.visibility_;
    }

    void setVisibility(PropertyDefVisibilityType vis) {
        this.visibility_ = vis;
    }

    public boolean hasSettingsCallback() {
        return this.callback_ != null && this.callback_.getSettingsCallback() != null;
    }

    public ISettingsCallback getSettingsCallback() {
        return this.callback_.getSettingsCallback();
    }

    public ArrayList getStateList() {
        return this.stateList_;
    }

    private void addState(String stateId, String stateLabel) {
        if (this.stateExists(stateId)) {
            throw new VisualizationInternalException("duplicate key for state : " + stateId);
        }
        this.stateList_.add(new PropertyState(stateId, stateLabel));
    }

    private boolean stateExists(String stateId) {
        boolean result = false;
        if (this.stateList_ != null) {
            for (int i = 0; i < this.stateList_.size() && !result; ++i) {
                PropertyState ps = (PropertyState)this.stateList_.get(i);
                if (!ps.getId().equals(stateId)) continue;
                result = true;
            }
        }
        return result;
    }

    public PropertyDef[] getProperties(String stateId, PropertyDefVisibilityType[] visibilities) {
        PropertyDef[] result = new PropertyDef[]{};
        if (this.stateList_ != null && this.stateExists(stateId)) {
            ArrayList listAllChildren = this.getChildren(IGraphicDefNode.GraphicDefNodeType.PROPERTY);
            Iterator iter = listAllChildren.iterator();
            ArrayList<PropertyDef> list = new ArrayList<PropertyDef>();
            while (iter.hasNext()) {
                PropertyDef pd = (PropertyDef)iter.next();
                if (!pd.containsState(stateId) || !pd.testVisibility(visibilities)) continue;
                list.add(pd);
            }
            result = new PropertyDef[list.size()];
            list.toArray(result);
        }
        return result;
    }

    public PropertyDef[] getProperties(String stateId) {
        return this.getProperties(stateId, null);
    }

    boolean testVisibility(PropertyDefVisibilityType[] visibilities) {
        boolean result = false;
        if (visibilities == null) {
            result = true;
        } else {
            for (int i = 0; i < visibilities.length; ++i) {
                if (this.visibility_ != visibilities[i]) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private boolean containsState(String stateId) {
        boolean find = false;
        for (int i = 0; i < this.stateIds_.size() && !find; ++i) {
            String s = (String)this.stateIds_.get(i);
            if (!s.equals(stateId)) continue;
            find = true;
        }
        return find;
    }

    public String[] getStateIds() {
        String[] result = new String[this.stateIds_.size()];
        this.stateIds_.toArray(result);
        return result;
    }

    public VisuObject getDefaultValue() {
        return this.defaultValue_;
    }

    public Object getParameter() {
        return this.parameter_;
    }

    private void computeXmlProperty(XMLProperty xprop, LocalizedEngine.Localizator loc, String newDefaultValue) {
        String strDefaultValue;
        String string = strDefaultValue = newDefaultValue != null ? newDefaultValue : xprop.m_a_DefaultValue;
        if (strDefaultValue == null) {
            this.defaultValue_ = null;
        }
        if (xprop instanceof XMLBool) {
            if (strDefaultValue != null) {
                this.defaultValue_ = new VisuBool(strDefaultValue);
            }
            this.propertyType_ = VisuObjectType.BOOL;
        } else if (xprop instanceof XMLIntRange) {
            XMLIntRange irange = (XMLIntRange)xprop;
            VisuInteger vi = null;
            if (strDefaultValue != null) {
                this.defaultValue_ = new VisuInteger(strDefaultValue);
                vi = (VisuInteger)this.defaultValue_;
            }
            VisuInteger[] params = null;
            if (vi != null && irange.m_a_Min <= vi.intValue() && vi.intValue() <= irange.m_a_Max && irange.m_a_Step > 0) {
                params = new VisuInteger[]{new VisuInteger(irange.m_a_Min), new VisuInteger(irange.m_a_Max), new VisuInteger(irange.m_a_Step)};
            }
            this.parameter_ = params;
            this.propertyType_ = VisuObjectType.INT;
        } else if (xprop instanceof XMLDoubleRange) {
            XMLDoubleRange xdrange = (XMLDoubleRange)xprop;
            VisuDouble vd = null;
            if (strDefaultValue != null) {
                this.defaultValue_ = new VisuDouble(strDefaultValue);
                vd = (VisuDouble)this.defaultValue_;
            }
            VisuDouble[] params = null;
            if (vd != null && xdrange.m_a_Min <= vd.doubleValue() && vd.doubleValue() <= xdrange.m_a_Max && xdrange.m_a_Step > 0.0) {
                params = new VisuDouble[]{new VisuDouble(xdrange.m_a_Min), new VisuDouble(xdrange.m_a_Max), new VisuDouble(xdrange.m_a_Step)};
            }
            this.parameter_ = params;
            this.propertyType_ = VisuObjectType.DOUBLE;
        } else if (xprop instanceof XMLFont) {
            XMLFont xfont = (XMLFont)xprop;
            this.parameter_ = new VisuInteger(xfont.m_a_ExtraStyle > 0 ? xfont.m_a_ExtraStyle : 0);
            if (strDefaultValue != null) {
                this.defaultValue_ = new VisuFont(strDefaultValue);
            }
            this.propertyType_ = VisuObjectType.FONT;
        } else if (xprop instanceof XMLColor) {
            XMLColor xcolor = (XMLColor)xprop;
            if (strDefaultValue != null) {
                this.defaultValue_ = new VisuColor(strDefaultValue);
            }
            VisuColorType vct = this.defaultValue_ == null ? null : ((VisuColor)this.defaultValue_).getColorType();
            ArrayList<VisuColorType> colorTypeList = null;
            if (xcolor.m_a_Filter != null) {
                String[] types = xcolor.m_a_Filter.split(";");
                colorTypeList = new ArrayList<VisuColorType>();
                for (int i = 0; i < types.length; ++i) {
                    colorTypeList.add(VisuColorType.fromString(types[i]));
                }
                if (vct != null && !colorTypeList.contains(vct)) {
                    throw new VisualizationInternalException("value:" + this.defaultValue_ + " is incompatble with color type restriction");
                }
            }
            this.parameter_ = colorTypeList;
            this.propertyType_ = VisuObjectType.COLOR;
        } else if (xprop instanceof XMLText) {
            XMLText xtext = (XMLText)xprop;
            if (strDefaultValue != null) {
                this.defaultValue_ = new VisuString(strDefaultValue);
            }
            VisuInteger param = new VisuInteger(xtext.m_a_MaxLength);
            this.propertyType_ = VisuObjectType.STRING;
            this.parameter_ = param;
        } else if (xprop instanceof XMLMultiState) {
            XMLMultiState xms = (XMLMultiState)xprop;
            this.computeMultiState(xms, loc, strDefaultValue);
        } else if (xprop instanceof XMLDynamicNode) {
            XMLDynamicNode xdn = (XMLDynamicNode)xprop;
            this.computeDynamicNode(xdn, loc, strDefaultValue);
        } else if (xprop instanceof XMLColorZones) {
            if (strDefaultValue != null) {
                this.defaultValue_ = new VisuColorZones(strDefaultValue);
            }
            this.propertyType_ = VisuObjectType.COLORZONES;
        } else if (xprop instanceof XMLCallback) {
            if (this.callback_ == null) {
                XMLCallback xmlCallbac = (XMLCallback)xprop;
                this.callback_ = new VisuCallback(xmlCallbac.m_a_ClassName);
            }
            this.computeXmlProperty(this.callback_.getSettingsCallback().getXmlProperty(loc.getLocale()), null, strDefaultValue);
        } else {
            throw new VisualizationInternalException("invalid xprop class :" + xprop.m_a_Id);
        }
    }

    private void computeMultiState(XMLMultiState xms, LocalizedEngine.Localizator loc, String strDefaultValue) {
        this.propertyType_ = VisuObjectType.STATE;
        int stateSize = xms.m_list_Item.size();
        this.stateList_ = new ArrayList();
        for (int i = 0; i < stateSize; ++i) {
            XMLStateItem xitem = (XMLStateItem)xms.m_list_Item.get(i);
            if (loc == null) {
                this.addState(xitem.m_a_Id, xitem.m_a_Name);
                continue;
            }
            this.addState(xitem.m_a_Id, loc.getValue(xitem.m_a_Name));
        }
        VisuState vs = null;
        if (strDefaultValue != null) {
            vs = new VisuState(strDefaultValue);
        }
        this.validValue_ = new VisuState(((PropertyState)this.stateList_.get(0)).getId());
        if (vs != null && !this.stateExists(vs.getId())) {
            throw new VisualizationInternalException("Invalid default value(" + vs + ") for property :" + this.getId());
        }
        this.defaultValue_ = vs;
        this.parameter_ = this.stateList_;
    }

    private void computeDynamicNode(XMLDynamicNode xdn, LocalizedEngine.Localizator loc, String strDefaultValue) {
        this.propertyType_ = VisuObjectType.DYNAMICNODE;
        this.stateList_ = new ArrayList();
        if (loc == null) {
            this.addState(xdn.m_MandatoryItem.m_a_Id, xdn.m_MandatoryItem.m_a_Name);
            this.addState(xdn.m_OptionalItem.m_a_Id, xdn.m_OptionalItem.m_a_Name);
        } else {
            this.addState(xdn.m_MandatoryItem.m_a_Id, loc.getValue(xdn.m_MandatoryItem.m_a_Name));
            this.addState(xdn.m_OptionalItem.m_a_Id, loc.getValue(xdn.m_OptionalItem.m_a_Name));
        }
        VisuDynamicNode vdn = null;
        if (strDefaultValue != null) {
            vdn = new VisuDynamicNode(strDefaultValue);
        }
        this.defaultValue_ = vdn;
        this.parameter_ = this.stateList_;
    }

    static PropertyDefVisibilityType computeVisiblility(XMLVisibilityType xvt) {
        PropertyDefVisibilityType vt = PropertyDefVisibilityType.PRIMARY;
        if (xvt.value() == 1) {
            vt = PropertyDefVisibilityType.SECONDARY;
        } else if (xvt.value() == 3) {
            vt = PropertyDefVisibilityType.NOTAVAILABLE;
        } else if (xvt.value() == 2) {
            vt = PropertyDefVisibilityType.READONLY;
        } else if (xvt.value() == 5) {
            vt = PropertyDefVisibilityType.NOTAVAILABLE;
        } else if (xvt.value() == 4) {
            vt = PropertyDefVisibilityType.READONLY;
        }
        return vt;
    }

    VisuObject getValidValue() {
        return this.validValue_;
    }

    void addState(String id) {
        this.stateIds_.add(id);
    }

    void setDefaultValue(VisuObject defaultValue) {
        this.defaultValue_ = defaultValue;
    }
}

