/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.extension.defaultimpl;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.businessobjects.visualization.graphic.xml.settingsdefinition.generated.XMLStateItem;
import com.businessobjects.visualization.internal.classloader.ClassLoaderHelper;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractMapWalker {
    private static final ILogger LOG = LoggerManager.getLogger((String)(class$com$businessobjects$visualization$extension$defaultimpl$AbstractMapWalker == null ? (class$com$businessobjects$visualization$extension$defaultimpl$AbstractMapWalker = AbstractMapWalker.class$("com.businessobjects.visualization.extension.defaultimpl.AbstractMapWalker")) : class$com$businessobjects$visualization$extension$defaultimpl$AbstractMapWalker).getName());
    private static final String MSG_LOG_DRILL_PATH_ALREADY_EXISTS = "Drill path {0} has already been defined. Only the last definition is taken into account.";
    private static final String MSG_LOG_CLASS_NOT_FOUND = "Class {0} not found.";
    private static final String MSG_LOG_METHOD_NOT_FOUND = "Method {0} not found in class {1}.";
    private HashMap objHashMapDrillPaths_ = new HashMap();
    private static final String PCXML_MAP_CLASS = "com.businessobjects.visualization.geographics.pcxml.PcxmlMap";
    private static final String PCXML_MAP_APPLY_FORMULA_METHOD = "mapLocationMatchesPathFormula";
    static /* synthetic */ Class class$com$businessobjects$visualization$extension$defaultimpl$AbstractMapWalker;

    public void defineDrillPath(String strDrillPathId, DrillPath objDrillPath) {
        if (this.objHashMapDrillPaths_.put(strDrillPathId, objDrillPath) != null && LOG.isWarnEnabled()) {
            LOG.warn((Object)MessageFormat.format(MSG_LOG_DRILL_PATH_ALREADY_EXISTS, strDrillPathId));
        }
    }

    public boolean mapLocationMatchesPathFormula(String strMapLocation, String strPathFormula) {
        block8: {
            Class objClass;
            block7: {
                objClass = null;
                try {
                    objClass = ClassLoaderHelper.loadClass(PCXML_MAP_CLASS);
                }
                catch (ClassNotFoundException objClassNotFoundException) {
                    if (!LOG.isWarnEnabled()) break block7;
                    LOG.warn((Object)MessageFormat.format(MSG_LOG_CLASS_NOT_FOUND, PCXML_MAP_CLASS), (Throwable)objClassNotFoundException);
                }
            }
            if (objClass == null) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)MessageFormat.format(MSG_LOG_CLASS_NOT_FOUND, PCXML_MAP_CLASS));
                }
                return false;
            }
            try {
                Method[] aobjMethods = objClass.getMethods();
                int iMethodCount = aobjMethods.length;
                for (int iMethodIndex = 0; iMethodIndex < iMethodCount; ++iMethodIndex) {
                    Method objMethod = aobjMethods[iMethodIndex];
                    if (!objMethod.getName().equals(PCXML_MAP_APPLY_FORMULA_METHOD)) continue;
                    return (Boolean)objMethod.invoke(null, strMapLocation, strPathFormula);
                }
            }
            catch (Throwable objThrowable) {
                if (!LOG.isWarnEnabled()) break block8;
                LOG.warn((Object)MessageFormat.format(MSG_LOG_METHOD_NOT_FOUND, PCXML_MAP_APPLY_FORMULA_METHOD, PCXML_MAP_CLASS));
            }
        }
        return false;
    }

    public String getTargetDrillPathFormula(String strSourceMapLocation, String strDrillPathId, int iDrillDirection, String strFallbackMapLocation) {
        if (strDrillPathId != null && strDrillPathId.length() != 0) {
            DrillPath objDrillPath = (DrillPath)this.objHashMapDrillPaths_.get(strDrillPathId);
            if (objDrillPath != null) {
                return objDrillPath.getTargetDrillPathFormula(strSourceMapLocation, iDrillDirection, strFallbackMapLocation);
            }
        } else {
            Iterator objIteratorDrillPaths = this.objHashMapDrillPaths_.values().iterator();
            DrillPath objDrillPath = null;
            String strTargetDrillPathFormula = null;
            while (objIteratorDrillPaths.hasNext()) {
                objDrillPath = (DrillPath)objIteratorDrillPaths.next();
                strTargetDrillPathFormula = objDrillPath.getTargetDrillPathFormula(strSourceMapLocation, iDrillDirection, null);
                if (strTargetDrillPathFormula == null) continue;
                return strTargetDrillPathFormula;
            }
        }
        return strFallbackMapLocation;
    }

    public boolean mapIsDrillable(String strSourceMapLocation, String strDrillPathId, int iDrillDirection) {
        return this.getTargetDrillPathFormula(strSourceMapLocation, strDrillPathId, iDrillDirection, null) != null;
    }

    public ArrayList getAvailableDrillPathIds(String strSourceMapLocation, int iDrillDirection) {
        ArrayList objArrayListDrillPathIds = new ArrayList();
        Iterator objIteratorEntryDrillPaths = this.objHashMapDrillPaths_.entrySet().iterator();
        DrillPath objDrillPath = null;
        Map.Entry objMapEntry = null;
        while (objIteratorEntryDrillPaths.hasNext()) {
            objMapEntry = objIteratorEntryDrillPaths.next();
            objDrillPath = (DrillPath)objMapEntry.getValue();
            if (!objDrillPath.isAvailableFor(strSourceMapLocation, iDrillDirection)) continue;
            objArrayListDrillPathIds.add(objMapEntry.getKey());
        }
        return objArrayListDrillPathIds;
    }

    protected final XMLStateItem createXmlStateItem(String strId, String strName) {
        XMLStateItem objXmlStateItem = new XMLStateItem();
        objXmlStateItem.m_a_Id = strId;
        objXmlStateItem.m_a_Name = strName;
        return objXmlStateItem;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class DrillPath {
        private HashMap[] objHashMapPathFormulas_ = new HashMap[]{new HashMap(), new HashMap()};

        public void addDrill(String strTopPathFormula, String strBottomPathFormula) {
            this.addDrillOneDirection(0, strTopPathFormula, strBottomPathFormula);
            this.addDrillOneDirection(1, strBottomPathFormula, strTopPathFormula);
        }

        private void addDrillOneDirection(int iDirectionIndex, String strSourcePathFormula, String strTargetPathFormula) {
            ArrayList<String> objArrayListTargetPathFormulas = (ArrayList<String>)this.objHashMapPathFormulas_[iDirectionIndex].get(strSourcePathFormula);
            if (objArrayListTargetPathFormulas == null) {
                objArrayListTargetPathFormulas = new ArrayList<String>();
                objArrayListTargetPathFormulas.add(strTargetPathFormula);
                this.objHashMapPathFormulas_[iDirectionIndex].put(strSourcePathFormula, objArrayListTargetPathFormulas);
            } else if (!objArrayListTargetPathFormulas.contains(strTargetPathFormula)) {
                objArrayListTargetPathFormulas.add(strTargetPathFormula);
                this.objHashMapPathFormulas_[iDirectionIndex].put(strSourcePathFormula, objArrayListTargetPathFormulas);
            }
        }

        public String getTargetDrillPathFormula(String strSourceMapLocation, int iDrillDirection, String strFallbackMapLocation) {
            String strTargetDrillPathFormula = strFallbackMapLocation;
            if (this.objHashMapPathFormulas_[iDrillDirection].containsKey(strSourceMapLocation)) {
                return (String)((ArrayList)this.objHashMapPathFormulas_[iDrillDirection].get(strSourceMapLocation)).get(0);
            }
            Iterator objIteratorEntryPathFormulas = this.objHashMapPathFormulas_[iDrillDirection].entrySet().iterator();
            Map.Entry objMapEntry = null;
            while (objIteratorEntryPathFormulas.hasNext()) {
                objMapEntry = objIteratorEntryPathFormulas.next();
                if (!AbstractMapWalker.this.mapLocationMatchesPathFormula(strSourceMapLocation, (String)objMapEntry.getKey())) continue;
                return (String)((ArrayList)objMapEntry.getValue()).get(0);
            }
            return strTargetDrillPathFormula;
        }

        public boolean isAvailableFor(String strSourceMapLocation, int iDrillDirection) {
            if (this.objHashMapPathFormulas_[iDrillDirection].containsKey(strSourceMapLocation)) {
                return true;
            }
            Iterator objIteratorKeyPathFormulas = this.objHashMapPathFormulas_[iDrillDirection].keySet().iterator();
            String strSourcePathFormula = null;
            while (objIteratorKeyPathFormulas.hasNext()) {
                strSourcePathFormula = (String)objIteratorKeyPathFormulas.next();
                if (!AbstractMapWalker.this.mapLocationMatchesPathFormula(strSourceMapLocation, strSourcePathFormula)) continue;
                return true;
            }
            return false;
        }
    }
}

